/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.ops;

import java.util.Arrays;
import org.apache.gravitino.lance.common.ops.NamespaceWrapper;
import org.apache.gravitino.lance.common.ops.gravitino.GravitinoLanceNamespaceWrapper;

public enum LanceNamespaceBackend {
    GRAVITINO("gravitino", GravitinoLanceNamespaceWrapper.class);

    private final String type;
    private final Class<? extends NamespaceWrapper> wrapperClass;

    public static LanceNamespaceBackend fromType(String type) {
        for (LanceNamespaceBackend backend : LanceNamespaceBackend.values()) {
            if (!backend.type.equalsIgnoreCase(type)) continue;
            return backend;
        }
        throw new IllegalArgumentException(String.format("Unknown backend type %s, available types: %s", type, Arrays.toString((Object[])LanceNamespaceBackend.values())));
    }

    private LanceNamespaceBackend(String type, Class<? extends NamespaceWrapper> wrapperClass) {
        this.type = type;
        this.wrapperClass = wrapperClass;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends NamespaceWrapper> getWrapperClass() {
        return this.wrapperClass;
    }
}

