/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"num_rows", "size_bytes", "num_fragments"})
public class GetTableStatsResponse {
    public static final String JSON_PROPERTY_NUM_ROWS = "num_rows";
    @Nonnull
    private Long numRows;
    public static final String JSON_PROPERTY_SIZE_BYTES = "size_bytes";
    @Nonnull
    private Long sizeBytes;
    public static final String JSON_PROPERTY_NUM_FRAGMENTS = "num_fragments";
    @Nullable
    private Long numFragments;

    public GetTableStatsResponse numRows(@Nonnull Long numRows) {
        this.numRows = numRows;
        return this;
    }

    @Nonnull
    @JsonProperty(value="num_rows")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getNumRows() {
        return this.numRows;
    }

    @JsonProperty(value="num_rows")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumRows(@Nonnull Long numRows) {
        this.numRows = numRows;
    }

    public GetTableStatsResponse sizeBytes(@Nonnull Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nonnull
    @JsonProperty(value="size_bytes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @JsonProperty(value="size_bytes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSizeBytes(@Nonnull Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public GetTableStatsResponse numFragments(@Nullable Long numFragments) {
        this.numFragments = numFragments;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_fragments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumFragments() {
        return this.numFragments;
    }

    @JsonProperty(value="num_fragments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumFragments(@Nullable Long numFragments) {
        this.numFragments = numFragments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTableStatsResponse getTableStatsResponse = (GetTableStatsResponse)o;
        return Objects.equals(this.numRows, getTableStatsResponse.numRows) && Objects.equals(this.sizeBytes, getTableStatsResponse.sizeBytes) && Objects.equals(this.numFragments, getTableStatsResponse.numFragments);
    }

    public int hashCode() {
        return Objects.hash(this.numRows, this.sizeBytes, this.numFragments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTableStatsResponse {\n");
        sb.append("    numRows: ").append(this.toIndentedString(this.numRows)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    numFragments: ").append(this.toIndentedString(this.numFragments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getNumRows() != null) {
            try {
                joiner.add(String.format("%snum_rows%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNumRows()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSizeBytes() != null) {
            try {
                joiner.add(String.format("%ssize_bytes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSizeBytes()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getNumFragments() != null) {
            try {
                joiner.add(String.format("%snum_fragments%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNumFragments()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

