/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rest;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;

public class RESTUtils {
    private static final Joiner.MapJoiner FORM_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Splitter.MapSplitter FORM_SPLITTER = Splitter.on((String)"&").withKeyValueSeparator("=");

    private RESTUtils() {
    }

    public static String stripTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String encodeFormData(Map<?, ?> formData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        formData.forEach((key, value) -> builder.put((Object)RESTUtils.encodeString(String.valueOf(key)), (Object)RESTUtils.encodeString(String.valueOf(value))));
        return FORM_JOINER.join((Map)builder.build());
    }

    public static Map<String, String> decodeFormData(String formString) {
        return (Map)FORM_SPLITTER.split((CharSequence)formString).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> RESTUtils.decodeString((String)e.getKey()), e -> RESTUtils.decodeString((String)e.getValue())));
    }

    public static String encodeString(String toEncode) {
        Preconditions.checkArgument((toEncode != null ? 1 : 0) != 0, (Object)"Invalid string to encode: null");
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new GravitinoRuntimeException("Failed to encode string: %s", new Object[]{toEncode});
        }
    }

    public static String decodeString(String encoded) {
        Preconditions.checkArgument((encoded != null ? 1 : 0) != 0, (Object)"Invalid string to decode: null");
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new GravitinoRuntimeException("Failed to decode string: %s", new Object[]{encoded});
        }
    }

    public static int findAvailablePort(int portRangeStart, int portRangeEnd) throws IOException {
        if (portRangeStart > portRangeEnd) {
            throw new IOException("Invalid port range: " + portRangeStart + ":" + portRangeEnd);
        }
        if (portRangeStart == 0 && portRangeEnd == 0) {
            int n;
            ServerSocket socket = new ServerSocket(0);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Failed to allocate a random port", e);
                }
            }
            socket.close();
            return n;
        }
        if (portRangeStart == portRangeEnd) {
            int n;
            ServerSocket socket = new ServerSocket(portRangeStart);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Failed to allocate the specified port: " + portRangeStart, e);
                }
            }
            socket.close();
            return n;
        }
        if (portRangeStart < 1024 || portRangeEnd > 65535) {
            throw new IOException("port number must be 0 or in [1024, 65535]");
        }
        Random random = new Random();
        int maxRetry = 200;
        int i = portRangeStart;
        while (i <= portRangeEnd && i < portRangeStart + 200) {
            int n;
            int randomNumber = random.nextInt(portRangeEnd - portRangeStart + 1) + portRangeStart;
            ServerSocket socket = new ServerSocket(randomNumber);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    ++i;
                }
            }
            socket.close();
            return n;
        }
        throw new IOException("No available port in the range: " + portRangeStart + ":" + portRangeEnd);
    }
}

