/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.grails.gorm.graphql

import grails.gorm.annotation.Entity
import graphql.schema.GraphQLSchema
import org.grails.datastore.gorm.GormEntity
import org.grails.gorm.graphql.entity.dsl.GraphQLMapping
import spock.lang.Ignore

class ReadOnlyOperationsSpec extends HibernateSpec {

    @Override
    List<Class> getDomainClasses() {
        [ReadOpOnlyEntity]
    }

    @Ignore
    void "test that only read operation are enabled in clean way"() {

        when:
        GraphQLSchema schema = new Schema(hibernateDatastore.mappingContext)
                .generate()

        then:
        !schema.mutationType

        and:
        schema.queryType.fieldDefinitions.size() == 3
        schema.queryType.fieldDefinitions.find {it.name == "readOpOnlyEntity"}
        schema.queryType.fieldDefinitions.find {it.name == "readOpOnlyEntityList"}
        schema.queryType.fieldDefinitions.find {it.name == "readOpOnlyEntityCount"}
    }
}

@Entity
class ReadOpOnlyEntity implements GormEntity<ReadOpOnlyEntity> {
    String prop

    static graphql = GraphQLMapping.build {
        operations.mutation.enabled false
    }
}
