/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler.grape;

import groovy.grape.GrapeEngine;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.grails.cli.compiler.grape.DependencyResolutionContext;
import org.grails.cli.compiler.grape.DependencyResolutionFailedException;
import org.grails.cli.compiler.grape.DetailedProgressReporter;
import org.grails.cli.compiler.grape.ProgressReporter;
import org.grails.cli.compiler.grape.SummaryProgressReporter;

public class MavenResolverGrapeEngine
implements GrapeEngine {
    private static final Collection<Exclusion> WILDCARD_EXCLUSION;
    private final DependencyResolutionContext resolutionContext;
    private final ProgressReporter progressReporter;
    private final GroovyClassLoader classLoader;
    private final DefaultRepositorySystemSession session;
    private final RepositorySystem repositorySystem;
    private final List<RemoteRepository> repositories;

    public MavenResolverGrapeEngine(GroovyClassLoader classLoader, RepositorySystem repositorySystem, DefaultRepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories, DependencyResolutionContext resolutionContext, boolean quiet) {
        this.classLoader = classLoader;
        this.repositorySystem = repositorySystem;
        this.session = repositorySystemSession;
        this.resolutionContext = resolutionContext;
        this.repositories = new ArrayList<RemoteRepository>();
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>(remoteRepositories);
        Collections.reverse(remotes);
        for (RemoteRepository repository : remotes) {
            this.addRepository(repository);
        }
        this.progressReporter = this.getProgressReporter(this.session, quiet);
    }

    private ProgressReporter getProgressReporter(DefaultRepositorySystemSession session, boolean quiet) {
        String progressReporter;
        String string = progressReporter = quiet ? "none" : System.getProperty("org.springframework.boot.cli.compiler.grape.ProgressReporter");
        if ("detail".equals(progressReporter) || Boolean.getBoolean("groovy.grape.report.downloads")) {
            return new DetailedProgressReporter(session, System.out);
        }
        if ("none".equals(progressReporter)) {
            return () -> {};
        }
        return new SummaryProgressReporter(session, System.out);
    }

    @Override
    public Object grab(Map args) {
        return this.grab(args, args);
    }

    @Override
    public Object grab(Map args, Map ... dependencyMaps) {
        List<Exclusion> exclusions = this.createExclusions(args);
        List<Dependency> dependencies2 = this.createDependencies(dependencyMaps, exclusions);
        try {
            List<File> files = this.resolve(dependencies2);
            GroovyClassLoader classLoader = this.getClassLoader(args);
            for (File file : files) {
                classLoader.addURL(file.toURI().toURL());
            }
        }
        catch (MalformedURLException ex) {
            throw new DependencyResolutionFailedException(ex);
        }
        return null;
    }

    private List<Exclusion> createExclusions(Map<?, ?> args) {
        List exclusionMaps;
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        if (args != null && (exclusionMaps = (List)args.get("excludes")) != null) {
            for (Map exclusionMap : exclusionMaps) {
                exclusions.add(this.createExclusion(exclusionMap));
            }
        }
        return exclusions;
    }

    private Exclusion createExclusion(Map<String, Object> exclusionMap) {
        String group = (String)exclusionMap.get("group");
        String module = (String)exclusionMap.get("module");
        return new Exclusion(group, module, "*", "*");
    }

    private List<Dependency> createDependencies(Map<?, ?>[] dependencyMaps, List<Exclusion> exclusions) {
        ArrayList<Dependency> dependencies2 = new ArrayList<Dependency>(dependencyMaps.length);
        for (Map<?, ?> dependencyMap : dependencyMaps) {
            dependencies2.add(this.createDependency(dependencyMap, exclusions));
        }
        return dependencies2;
    }

    private Dependency createDependency(Map<?, ?> dependencyMap, List<Exclusion> exclusions) {
        Artifact artifact = this.createArtifact(dependencyMap);
        if (this.isTransitive(dependencyMap)) {
            return new Dependency(artifact, "compile", false, exclusions);
        }
        return new Dependency(artifact, "compile", null, WILDCARD_EXCLUSION);
    }

    private Artifact createArtifact(Map<?, ?> dependencyMap) {
        String group = (String)dependencyMap.get("group");
        String module = (String)dependencyMap.get("module");
        String version = (String)dependencyMap.get("version");
        if (version == null) {
            version = this.resolutionContext.getManagedVersion(group, module);
        }
        String classifier = (String)dependencyMap.get("classifier");
        String type = this.determineType(dependencyMap);
        return new DefaultArtifact(group, module, classifier, type, version);
    }

    private String determineType(Map<?, ?> dependencyMap) {
        String type = (String)dependencyMap.get("type");
        String ext = (String)dependencyMap.get("ext");
        if (type == null) {
            type = ext;
            if (type == null) {
                type = "jar";
            }
        } else if (ext != null && !type.equals(ext)) {
            throw new IllegalArgumentException("If both type and ext are specified they must have the same value");
        }
        return type;
    }

    private boolean isTransitive(Map<?, ?> dependencyMap) {
        Boolean transitive = (Boolean)dependencyMap.get("transitive");
        return transitive != null ? transitive : true;
    }

    private List<Dependency> getDependencies(DependencyResult dependencyResult) {
        ArrayList<Dependency> dependencies2 = new ArrayList<Dependency>();
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            dependencies2.add(new Dependency(artifactResult.getArtifact(), "compile"));
        }
        return dependencies2;
    }

    private List<File> getFiles(DependencyResult dependencyResult) {
        ArrayList<File> files = new ArrayList<File>();
        for (ArtifactResult result : dependencyResult.getArtifactResults()) {
            files.add(result.getArtifact().getFile());
        }
        return files;
    }

    private GroovyClassLoader getClassLoader(Map args) {
        GroovyClassLoader classLoader = (GroovyClassLoader)args.get("classLoader");
        return classLoader != null ? classLoader : this.classLoader;
    }

    @Override
    public void addResolver(Map<String, Object> args) {
        String name = (String)args.get("name");
        String root = (String)args.get("root");
        RemoteRepository.Builder builder = new RemoteRepository.Builder(name, "default", root);
        RemoteRepository repository = builder.build();
        this.addRepository(repository);
    }

    protected void addRepository(RemoteRepository repository) {
        if (this.repositories.contains(repository)) {
            return;
        }
        repository = this.getPossibleMirror(repository);
        repository = this.applyProxy(repository);
        repository = this.applyAuthentication(repository);
        this.repositories.add(0, repository);
    }

    private RemoteRepository getPossibleMirror(RemoteRepository remoteRepository) {
        RemoteRepository mirror = this.session.getMirrorSelector().getMirror(remoteRepository);
        if (mirror != null) {
            return mirror;
        }
        return remoteRepository;
    }

    private RemoteRepository applyProxy(RemoteRepository repository) {
        if (repository.getProxy() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
            builder.setProxy(this.session.getProxySelector().getProxy(repository));
            repository = builder.build();
        }
        return repository;
    }

    private RemoteRepository applyAuthentication(RemoteRepository repository) {
        if (repository.getAuthentication() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
            builder.setAuthentication(this.session.getAuthenticationSelector().getAuthentication(repository));
            repository = builder.build();
        }
        return repository;
    }

    @Override
    public Map<String, Map<String, List<String>>> enumerateGrapes() {
        throw new UnsupportedOperationException("Grape enumeration is not supported");
    }

    @Override
    public URI[] resolve(Map args, Map ... dependencyMaps) {
        return this.resolve(args, (List)null, dependencyMaps);
    }

    @Override
    public URI[] resolve(Map args, List depsInfo, Map ... dependencyMaps) {
        List<Exclusion> exclusions = this.createExclusions(args);
        List<Dependency> dependencies2 = this.createDependencies(dependencyMaps, exclusions);
        try {
            List<File> files = this.resolve(dependencies2);
            ArrayList<URI> uris = new ArrayList<URI>(files.size());
            for (File file : files) {
                uris.add(file.toURI());
            }
            return uris.toArray(new URI[0]);
        }
        catch (Exception ex) {
            throw new DependencyResolutionFailedException(ex);
        }
    }

    private List<File> resolve(List<Dependency> dependencies2) {
        try {
            CollectRequest collectRequest = this.getCollectRequest(dependencies2);
            DependencyRequest dependencyRequest = this.getDependencyRequest(collectRequest);
            DependencyResult result = this.repositorySystem.resolveDependencies(this.session, dependencyRequest);
            this.addManagedDependencies(result);
            List<File> list = this.getFiles(result);
            return list;
        }
        catch (Exception ex) {
            throw new DependencyResolutionFailedException(ex);
        }
        finally {
            this.progressReporter.finished();
        }
    }

    private CollectRequest getCollectRequest(List<Dependency> dependencies2) {
        CollectRequest collectRequest = new CollectRequest((Dependency)null, dependencies2, new ArrayList<RemoteRepository>(this.repositories));
        collectRequest.setManagedDependencies(this.resolutionContext.getManagedDependencies());
        return collectRequest;
    }

    private DependencyRequest getDependencyRequest(CollectRequest collectRequest) {
        return new DependencyRequest(collectRequest, DependencyFilterUtils.classpathFilter("compile", "runtime"));
    }

    private void addManagedDependencies(DependencyResult result) {
        this.resolutionContext.addManagedDependencies(this.getDependencies(result));
    }

    @Override
    public Map[] listDependencies(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Listing dependencies is not supported");
    }

    @Override
    public Object grab(String endorsedModule) {
        throw new UnsupportedOperationException("Grabbing an endorsed module is not supported");
    }

    static {
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        exclusions.add(new Exclusion("*", "*", "*", "*"));
        WILDCARD_EXCLUSION = Collections.unmodifiableList(exclusions);
    }
}

