/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.logging;

import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.logging.LoggingFeature;
import org.grails.forge.feature.logging.template.logback;
import org.grails.forge.options.Options;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class Logback
implements LoggingFeature,
DefaultFeature {
    @Override
    public String getName() {
        return "logback";
    }

    @Override
    public String getTitle() {
        return "Logback Logging";
    }

    @Override
    public String getDescription() {
        return "Add Logback Logging library.";
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return selectedFeatures.stream().noneMatch(f -> f instanceof LoggingFeature);
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        OperatingSystem operatingSystem = generatorContext.getOperatingSystem();
        boolean jansi = false;
        if (operatingSystem != OperatingSystem.WINDOWS) {
            jansi = true;
        }
        String projectName = generatorContext.getProject().getName();
        String packageName = generatorContext.getProject().getPackageName();
        generatorContext.addTemplate("loggingConfig", new RockerTemplate("grails-app/conf/logback-spring.xml", logback.template(projectName, packageName, jansi)));
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-logging").implementation());
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }
}

