/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.device.service;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistration;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistrationRepositoryWrapper;
import org.apache.fineract.portfolio.self.device.service.DeviceRegistrationWritePlatformService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceRegistrationWritePlatformServiceImpl
implements DeviceRegistrationWritePlatformService {
    private final DeviceRegistrationRepositoryWrapper deviceRegistrationRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final PlatformSecurityContext context;

    @Autowired
    public DeviceRegistrationWritePlatformServiceImpl(DeviceRegistrationRepositoryWrapper deviceRegistrationRepository, ClientRepositoryWrapper clientRepositoryWrapper, PlatformSecurityContext context) {
        this.deviceRegistrationRepository = deviceRegistrationRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.context = context;
    }

    @Transactional
    public DeviceRegistration registerDevice(Long clientId, String registrationId) {
        this.context.authenticatedUser();
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        try {
            DeviceRegistration deviceRegistration = DeviceRegistration.instance((Client)client, (String)registrationId);
            this.deviceRegistrationRepository.save(deviceRegistration);
            return deviceRegistration;
        }
        catch (EntityExistsException dve) {
            this.handleDataIntegrityIssues(registrationId, (Throwable)dve);
            return null;
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(registrationId, dve.getMostSpecificCause());
            return null;
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(registrationId, throwable);
            return null;
        }
        catch (Exception dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(registrationId, throwable);
            return null;
        }
    }

    private void handleDataIntegrityIssues(String registrationId, Throwable realCause) {
        if (realCause.getMessage().contains("registration_key")) {
            throw new PlatformDataIntegrityException("error.msg.duplicate.device.registration.id", "Registration id : " + registrationId + " already exist.", "name", new Object[]{registrationId});
        }
        throw ErrorHandler.getMappable((Throwable)realCause, (String)"error.msg.charge.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    public DeviceRegistration updateDeviceRegistration(Long id, Long clientId, String registrationId) {
        DeviceRegistration deviceRegistration = this.deviceRegistrationRepository.findOneWithNotFoundDetection(id);
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        deviceRegistration.setClient(client);
        deviceRegistration.setRegistrationId(registrationId);
        deviceRegistration.setUpdatedOnDate(DateUtils.getLocalDateTimeOfTenant());
        return deviceRegistration;
    }

    public void deleteDeviceRegistration(Long id) {
        DeviceRegistration deviceRegistration = this.deviceRegistrationRepository.findOneWithNotFoundDetection(id);
        this.deviceRegistrationRepository.delete(deviceRegistration);
    }
}

