/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.domain;

import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepository;
import org.apache.fineract.portfolio.calendar.exception.CalendarNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalendarRepositoryWrapper {
    private final CalendarRepository repository;

    @Autowired
    public CalendarRepositoryWrapper(CalendarRepository repository) {
        this.repository = repository;
    }

    public Calendar findOneWithNotFoundDetection(Long calendarId) {
        return (Calendar)this.repository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
    }

    public void save(Calendar calendar) {
        this.repository.save((Object)calendar);
    }

    public void delete(Calendar calendar) {
        this.repository.delete((Object)calendar);
    }

    public void saveAndFlush(Calendar calendar) {
        this.repository.saveAndFlush((Object)calendar);
    }
}

