/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.command;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.domain.TFAccessToken;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CommandType(entity="TWOFACTOR_ACCESSTOKEN", action="INVALIDATE")
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
public class InvalidateTFAccessTokenCommandHandler
implements NewCommandSourceHandler {
    private final TwoFactorService twoFactorService;
    private final PlatformSecurityContext securityContext;
    private final FromJsonHelper fromJsonHelper;

    @Autowired
    public InvalidateTFAccessTokenCommandHandler(TwoFactorService twoFactorService, PlatformSecurityContext securityContext, FromJsonHelper fromJsonHelper) {
        this.twoFactorService = twoFactorService;
        this.securityContext = securityContext;
        this.fromJsonHelper = fromJsonHelper;
    }

    @Transactional
    public CommandProcessingResult processCommand(JsonCommand command) {
        this.validateJson(command.json());
        AppUser user = this.securityContext.authenticatedUser();
        TFAccessToken accessToken = this.twoFactorService.invalidateAccessToken(user, command);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withResourceIdAsString(accessToken.getToken()).build();
    }

    private void validateJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromJsonHelper.checkForUnsupportedParameters(typeOfMap, json, new HashSet<String>(Collections.singletonList("token")));
        JsonElement element = this.fromJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("TWOFACTOR_ACCESSTOKEN");
        String token = this.fromJsonHelper.extractStringNamed("token", element);
        baseDataValidator.reset().parameter("token").value((Object)token).notNull().notBlank();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

