/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluentImpl;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HPAScalingRulesFluentImpl<A extends HPAScalingRulesFluent<A>>
extends BaseFluent<A>
implements HPAScalingRulesFluent<A> {
    private List<HPAScalingPolicyBuilder> policies = new ArrayList<HPAScalingPolicyBuilder>();
    private String selectPolicy;
    private Integer stabilizationWindowSeconds;
    private Map<String, Object> additionalProperties;

    public HPAScalingRulesFluentImpl() {
    }

    public HPAScalingRulesFluentImpl(HPAScalingRules instance) {
        this.withPolicies(instance.getPolicies());
        this.withSelectPolicy(instance.getSelectPolicy());
        this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToPolicies(Integer index, HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        this._visitables.get((Object)"policies").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"policies").size(), builder);
        this.policies.add(index >= 0 ? index.intValue() : this.policies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPolicies(Integer index, HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"policies").size()) {
            this._visitables.get((Object)"policies").add(builder);
        } else {
            this._visitables.get((Object)"policies").set(index, builder);
        }
        if (index < 0 || index >= this.policies.size()) {
            this.policies.add(builder);
        } else {
            this.policies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPolicies(HPAScalingPolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicies(Collection<HPAScalingPolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicies(HPAScalingPolicy ... items) {
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").remove(builder);
            if (this.policies == null) continue;
            this.policies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicies(Collection<HPAScalingPolicy> items) {
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").remove(builder);
            if (this.policies == null) continue;
            this.policies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPolicies(Predicate<HPAScalingPolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)this;
        }
        Iterator<HPAScalingPolicyBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            HPAScalingPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HPAScalingPolicy> getPolicies() {
        return HPAScalingRulesFluentImpl.build(this.policies);
    }

    @Override
    public List<HPAScalingPolicy> buildPolicies() {
        return HPAScalingRulesFluentImpl.build(this.policies);
    }

    @Override
    public HPAScalingPolicy buildPolicy(Integer index) {
        return this.policies.get(index).build();
    }

    @Override
    public HPAScalingPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    @Override
    public HPAScalingPolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    @Override
    public HPAScalingPolicy buildMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicies(List<HPAScalingPolicy> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").removeAll(this.policies);
        }
        if (policies != null) {
            this.policies = new ArrayList<HPAScalingPolicyBuilder>();
            for (HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicies(HPAScalingPolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
        }
        if (policies != null) {
            for (HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    @Override
    public A addNewPolicy(Integer periodSeconds, String type, Integer value) {
        return this.addToPolicies(new HPAScalingPolicy(periodSeconds, type, value));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicy() {
        return new PoliciesNestedImpl();
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicyLike(HPAScalingPolicy item) {
        return new PoliciesNestedImpl(-1, item);
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> setNewPolicyLike(Integer index, HPAScalingPolicy item) {
        return new PoliciesNestedImpl(index, item);
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editPolicy(Integer index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public HPAScalingRulesFluent.PoliciesNested<A> editMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    @Override
    public A withSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasSelectPolicy() {
        return this.selectPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewSelectPolicy(String arg0) {
        return this.withSelectPolicy(new String(arg0));
    }

    @Override
    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    @Override
    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HPAScalingRulesFluentImpl that = (HPAScalingRulesFluentImpl)o;
        if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) {
            return false;
        }
        if (this.selectPolicy != null ? !this.selectPolicy.equals(that.selectPolicy) : that.selectPolicy != null) {
            return false;
        }
        if (this.stabilizationWindowSeconds != null ? !this.stabilizationWindowSeconds.equals(that.stabilizationWindowSeconds) : that.stabilizationWindowSeconds != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds, this.additionalProperties, super.hashCode());
    }

    public class PoliciesNestedImpl<N>
    extends HPAScalingPolicyFluentImpl<HPAScalingRulesFluent.PoliciesNested<N>>
    implements HPAScalingRulesFluent.PoliciesNested<N>,
    Nested<N> {
        HPAScalingPolicyBuilder builder;
        Integer index;

        PoliciesNestedImpl(Integer index, HPAScalingPolicy item) {
            this.index = index;
            this.builder = new HPAScalingPolicyBuilder(this, item);
        }

        PoliciesNestedImpl() {
            this.index = -1;
            this.builder = new HPAScalingPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)HPAScalingRulesFluentImpl.this.setToPolicies(this.index, this.builder.build());
        }

        @Override
        public N endPolicy() {
            return this.and();
        }
    }
}

