/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.resourcemanager.resources.models.ChangeAttributes;
import com.azure.resourcemanager.resources.models.ChangeBase;
import com.azure.resourcemanager.resources.models.ResourceChangeType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ChangeProperties {
    @JsonProperty(value="targetResourceId", access=JsonProperty.Access.WRITE_ONLY)
    private String targetResourceId;
    @JsonProperty(value="targetResourceType", access=JsonProperty.Access.WRITE_ONLY)
    private String targetResourceType;
    @JsonProperty(value="changeType", access=JsonProperty.Access.WRITE_ONLY)
    private ResourceChangeType changeType;
    @JsonProperty(value="changeAttributes")
    private ChangeAttributes changeAttributes;
    @JsonProperty(value="changes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, ChangeBase> changes;

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public ResourceChangeType changeType() {
        return this.changeType;
    }

    public ChangeAttributes changeAttributes() {
        return this.changeAttributes;
    }

    public ChangeProperties withChangeAttributes(ChangeAttributes changeAttributes) {
        this.changeAttributes = changeAttributes;
        return this;
    }

    public Map<String, ChangeBase> changes() {
        return this.changes;
    }

    public ChangeProperties withChanges(Map<String, ChangeBase> changes) {
        this.changes = changes;
        return this;
    }

    public void validate() {
        if (this.changeAttributes() != null) {
            this.changeAttributes().validate();
        }
        if (this.changes() != null) {
            this.changes().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

