/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1JobConditionBuilder;
import io.kubernetes.client.openapi.models.V1JobConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1JobStatus;
import io.kubernetes.client.openapi.models.V1JobStatusFluent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1JobStatusFluentImpl<A extends V1JobStatusFluent<A>>
extends BaseFluent<A>
implements V1JobStatusFluent<A> {
    private Integer active;
    private OffsetDateTime completionTime;
    private List<V1JobConditionBuilder> conditions;
    private Integer failed;
    private OffsetDateTime startTime;
    private Integer succeeded;

    public V1JobStatusFluentImpl() {
    }

    public V1JobStatusFluentImpl(V1JobStatus instance) {
        this.withActive(instance.getActive());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null;
    }

    @Override
    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(int index, V1JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobConditionBuilder>();
        }
        V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobConditionBuilder>();
        }
        V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1JobCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobConditionBuilder>();
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1JobCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobConditionBuilder>();
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1JobCondition ... items) {
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1JobCondition> items) {
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1JobConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1JobConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1JobConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1JobCondition> getConditions() {
        return V1JobStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1JobCondition> buildConditions() {
        return V1JobStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1JobCondition buildMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        for (V1JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        for (V1JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1JobCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1JobConditionBuilder>();
            for (V1JobCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1JobCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> addNewConditionLike(V1JobCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1JobCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    @Override
    public Boolean hasFailed() {
        return this.failed != null;
    }

    @Override
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    @Override
    public Boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobStatusFluentImpl that = (V1JobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.succeeded != null ? !this.succeeded.equals(that.succeeded) : that.succeeded != null);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.completionTime, this.conditions, this.failed, this.startTime, this.succeeded, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends V1JobConditionFluentImpl<V1JobStatusFluent.ConditionsNested<N>>
    implements V1JobStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1JobConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1JobCondition item) {
            this.index = index;
            this.builder = new V1JobConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1JobConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1JobStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

