/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorDescriptor;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class UserDefinedValueAggregatorDescriptor
implements ValueAggregatorDescriptor {
    private String className;
    protected ValueAggregatorDescriptor theAggregatorDescriptor = null;
    private static final Class<?>[] argArray = new Class[0];

    public static Object createInstance(String className) {
        Object retv = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> theFilterClass = Class.forName(className, true, classLoader);
            Constructor<?> meth = theFilterClass.getDeclaredConstructor(argArray);
            meth.setAccessible(true);
            retv = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retv;
    }

    private void createAggregator(Configuration conf) {
        if (this.theAggregatorDescriptor == null) {
            this.theAggregatorDescriptor = (ValueAggregatorDescriptor)UserDefinedValueAggregatorDescriptor.createInstance(this.className);
            this.theAggregatorDescriptor.configure(conf);
        }
    }

    public UserDefinedValueAggregatorDescriptor(String className, Configuration conf) {
        this.className = className;
        this.createAggregator(conf);
    }

    @Override
    public ArrayList<Map.Entry<Text, Text>> generateKeyValPairs(Object key, Object val) {
        ArrayList<Map.Entry<Text, Text>> retv = new ArrayList<Map.Entry<Text, Text>>();
        if (this.theAggregatorDescriptor != null) {
            retv = this.theAggregatorDescriptor.generateKeyValPairs(key, val);
        }
        return retv;
    }

    public String toString() {
        return "UserDefinedValueAggregatorDescriptor with class name:\t" + this.className;
    }

    @Override
    public void configure(Configuration conf) {
    }
}

