/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunPropertiesUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class TaskRunUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TaskRunUpdateParameters.class);
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private TaskRunPropertiesUpdateParameters innerProperties;
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskRunUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskRunPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public TaskRunUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public TaskRunUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public RunRequest runRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().runRequest();
    }

    public TaskRunUpdateParameters withRunRequest(RunRequest runRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withRunRequest(runRequest);
        return this;
    }

    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    public TaskRunUpdateParameters withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

