/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.options.ShareAcquireLeaseOptions;
import com.azure.storage.file.share.options.ShareBreakLeaseOptions;
import com.azure.storage.file.share.specialized.ShareLeaseAsyncClient;
import com.azure.storage.file.share.specialized.ShareLeaseClientBuilder;
import java.time.Duration;

@ServiceClient(builder=ShareLeaseClientBuilder.class)
public final class ShareLeaseClient {
    private final ShareLeaseAsyncClient client;

    ShareLeaseClient(ShareLeaseAsyncClient client) {
        this.client = client;
    }

    @Deprecated
    public String getFileUrl() {
        return this.client.getFileUrl();
    }

    public String getResourceUrl() {
        return this.client.getResourceUrl();
    }

    public String getLeaseId() {
        return this.client.getLeaseId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String acquireLease() {
        return (String)this.acquireLeaseWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(Duration timeout, Context context) {
        return this.acquireLeaseWithResponse(new ShareAcquireLeaseOptions(), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(ShareAcquireLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.acquireLeaseWithResponse(options, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease() {
        this.releaseLeaseWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.releaseLeaseWithResponse(context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void breakLease() {
        this.breakLeaseWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> breakLeaseWithResponse(Duration timeout, Context context) {
        return this.breakLeaseWithResponse(new ShareBreakLeaseOptions(), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> breakLeaseWithResponse(ShareBreakLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.breakLeaseWithResponse(options, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String changeLease(String proposedId) {
        return (String)this.changeLeaseWithResponse(proposedId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(String proposedId, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.changeLeaseWithResponse(proposedId, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String renewLease() {
        return (String)this.renewLeaseWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.renewLeaseWithResponse(context), (Duration)timeout);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }
}

