/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddInstanceGroupsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<InstanceGroupConfig> instanceGroups;
    private String jobFlowId;

    public AddInstanceGroupsRequest() {
    }

    public AddInstanceGroupsRequest(List<InstanceGroupConfig> instanceGroups, String jobFlowId) {
        this.setInstanceGroups(instanceGroups);
        this.setJobFlowId(jobFlowId);
    }

    public List<InstanceGroupConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new SdkInternalList();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        this.instanceGroups = new SdkInternalList(instanceGroups);
    }

    public AddInstanceGroupsRequest withInstanceGroups(InstanceGroupConfig ... instanceGroups) {
        if (this.instanceGroups == null) {
            this.setInstanceGroups((Collection<InstanceGroupConfig>)new SdkInternalList(instanceGroups.length));
        }
        for (InstanceGroupConfig ele : instanceGroups) {
            this.instanceGroups.add((Object)ele);
        }
        return this;
    }

    public AddInstanceGroupsRequest withInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
        return this;
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public AddInstanceGroupsRequest withJobFlowId(String jobFlowId) {
        this.setJobFlowId(jobFlowId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.getInstanceGroups()).append(",");
        }
        if (this.getJobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.getJobFlowId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest)obj;
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !other.getInstanceGroups().equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getJobFlowId() == null ^ this.getJobFlowId() == null) {
            return false;
        }
        return other.getJobFlowId() == null || other.getJobFlowId().equals(this.getJobFlowId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowId() == null ? 0 : this.getJobFlowId().hashCode());
        return hashCode;
    }

    public AddInstanceGroupsRequest clone() {
        return (AddInstanceGroupsRequest)super.clone();
    }
}

