/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class LoadBalancerBackendImpl
extends ChildResourceImpl<BackendAddressPoolInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerBackend,
LoadBalancerBackend.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerBackend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerBackend.Update {
    LoadBalancerBackendImpl(BackendAddressPoolInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public Map<String, String> backendNicIPConfigurationNames() {
        TreeMap<String, String> ipConfigNames = new TreeMap<String, String>();
        if (((BackendAddressPoolInner)((Object)this.innerModel())).backendIpConfigurations() != null) {
            for (NetworkInterfaceIpConfigurationInner inner : ((BackendAddressPoolInner)((Object)this.innerModel())).backendIpConfigurations()) {
                String nicId = ResourceUtils.parentResourceIdFromResourceId((String)inner.id());
                String ipConfigName = ResourceUtils.nameFromResourceId((String)inner.id());
                ipConfigNames.put(nicId, ipConfigName);
            }
        }
        return Collections.unmodifiableMap(ipConfigNames);
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((BackendAddressPoolInner)((Object)this.innerModel())).loadBalancingRules() != null) {
            for (SubResource inner : ((BackendAddressPoolInner)((Object)this.innerModel())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)inner.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    public String name() {
        return ((BackendAddressPoolInner)((Object)this.innerModel())).name();
    }

    @Override
    public Set<String> getVirtualMachineIds() {
        HashSet<String> vmIds = new HashSet<String>();
        Map<String, String> nicConfigs = this.backendNicIPConfigurationNames();
        for (String nicId : nicConfigs.keySet()) {
            try {
                NetworkInterface nic = (NetworkInterface)((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).networkInterfaces().getById(nicId);
                if (nic == null || nic.virtualMachineId() == null) continue;
                vmIds.add(nic.virtualMachineId());
            }
            catch (ManagementException | IllegalArgumentException e) {}
        }
        return vmIds;
    }

    public LoadBalancerImpl attach() {
        ((LoadBalancerImpl)this.parent()).withBackend(this);
        return (LoadBalancerImpl)this.parent();
    }

    public LoadBalancerBackendImpl withExistingVirtualMachines(HasNetworkInterfaces ... vms) {
        return vms != null ? this.withExistingVirtualMachines(Arrays.asList(vms)) : this;
    }

    public LoadBalancerBackendImpl withExistingVirtualMachines(Collection<HasNetworkInterfaces> vms) {
        if (vms != null) {
            for (HasNetworkInterfaces vm : vms) {
                ((LoadBalancerImpl)this.parent()).withExistingVirtualMachine(vm, this.name());
            }
        }
        return this;
    }
}

