/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.fluent.models.DscpConfigurationPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.models.ProtocolType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.QosDefinition;
import com.azure.resourcemanager.network.models.QosIpRange;
import com.azure.resourcemanager.network.models.QosPortRange;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class DscpConfigurationInner
extends Resource {
    @JsonProperty(value="properties")
    private DscpConfigurationPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private DscpConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public DscpConfigurationInner withId(String id) {
        this.id = id;
        return this;
    }

    public DscpConfigurationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DscpConfigurationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<Integer> markings() {
        return this.innerProperties() == null ? null : this.innerProperties().markings();
    }

    public DscpConfigurationInner withMarkings(List<Integer> markings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withMarkings(markings);
        return this;
    }

    public List<QosIpRange> sourceIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceIpRanges();
    }

    public DscpConfigurationInner withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withSourceIpRanges(sourceIpRanges);
        return this;
    }

    public List<QosIpRange> destinationIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationIpRanges();
    }

    public DscpConfigurationInner withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withDestinationIpRanges(destinationIpRanges);
        return this;
    }

    public List<QosPortRange> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public DscpConfigurationInner withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    public List<QosPortRange> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public DscpConfigurationInner withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public ProtocolType protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public DscpConfigurationInner withProtocol(ProtocolType protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public List<QosDefinition> qosDefinitionCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().qosDefinitionCollection();
    }

    public DscpConfigurationInner withQosDefinitionCollection(List<QosDefinition> qosDefinitionCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withQosDefinitionCollection(qosDefinitionCollection);
        return this;
    }

    public String qosCollectionId() {
        return this.innerProperties() == null ? null : this.innerProperties().qosCollectionId();
    }

    public List<NetworkInterfaceInner> associatedNetworkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedNetworkInterfaces();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

