/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.models.Factories;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.api.service.CloudService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.stereotype.Service;

@Service
public class CloudServiceImpl
extends BaseServiceImpl
implements CloudService {
    private static final String AZURE_CLIENT_ID = PropertyUtils.getString((String)"resource.azure.client.id");
    private static final String AZURE_CLIENT_SECRET = PropertyUtils.getString((String)"resource.azure.client.secret");
    private static final String AZURE_ACCESS_SUB_ID = PropertyUtils.getString((String)"resource.azure.subId");
    private static final String AZURE_SECRET_TENANT_ID = PropertyUtils.getString((String)"resource.azure.tenant.id");
    private static final AzureProfile profile = new AzureProfile(AZURE_SECRET_TENANT_ID, AZURE_ACCESS_SUB_ID, AzureEnvironment.AZURE);
    private static final ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(AZURE_CLIENT_ID)).clientSecret(AZURE_CLIENT_SECRET).tenantId(AZURE_SECRET_TENANT_ID)).authorityHost(profile.getEnvironment().getActiveDirectoryEndpoint())).build();
    private static final DataFactoryManager manager = DataFactoryManager.authenticate((TokenCredential)clientSecretCredential, (AzureProfile)profile);
    private static final AzureResourceManager azure = AzureResourceManager.authenticate((TokenCredential)clientSecretCredential, (AzureProfile)profile).withDefaultSubscription();

    @Override
    public List<String> listDataFactory(User loginUser) {
        Factories factories = manager.factories();
        ArrayList<String> names = new ArrayList<String>();
        factories.list().stream().forEach(e -> names.add(e.name()));
        return names;
    }

    @Override
    public List<String> listResourceGroup(User loginUser) {
        ResourceGroups resourceGroups = azure.resourceGroups();
        ArrayList<String> names = new ArrayList<String>();
        resourceGroups.list().stream().forEach(e -> names.add(e.name()));
        return names;
    }

    @Override
    public List<String> listPipeline(User loginUser, String factoryName, String resourceGroupName) {
        PagedIterable pipelineResources = manager.pipelines().listByFactory(resourceGroupName, factoryName);
        ArrayList<String> names = new ArrayList<String>();
        pipelineResources.stream().forEach(e -> names.add(e.name()));
        return names;
    }
}

