/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureTableDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureTable")
public final class AzureTableDataset
extends Dataset {
    @JsonProperty(value="typeProperties", required=true)
    private AzureTableDatasetTypeProperties innerTypeProperties = new AzureTableDatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureTableDataset.class);

    private AzureTableDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureTableDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureTableDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AzureTableDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AzureTableDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureTableDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureTableDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AzureTableDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object tableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tableName();
    }

    public AzureTableDataset withTableName(Object tableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureTableDatasetTypeProperties();
        }
        this.innerTypeProperties().withTableName(tableName);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureTableDataset"));
        }
        this.innerTypeProperties().validate();
    }
}

