/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.torque.templates.platform.PlatformDefaultImpl;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformMysqlImpl
extends PlatformDefaultImpl {
    private static final String DATE_FORMAT = "''yyyy-MM-dd''";

    public PlatformMysqlImpl() {
        this.initialize();
    }

    private void initialize() {
        this.setSchemaTypeToSqlTypeMapping(SchemaType.NUMERIC, new SqlType("DECIMAL"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARCHAR, new SqlType("MEDIUMTEXT"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.TIMESTAMP, new SqlType("DATETIME"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BINARY, new SqlType("BLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.VARBINARY, new SqlType("MEDIUMBLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARBINARY, new SqlType("LONGBLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BLOB, new SqlType("LONGBLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.CLOB, new SqlType("LONGTEXT"));
    }

    public String getAutoIncrement() {
        return "AUTO_INCREMENT";
    }

    public boolean hasSize(String sqlType) {
        return !"MEDIUMTEXT".equals(sqlType) && !"LONGTEXT".equals(sqlType) && !"BLOB".equals(sqlType) && !"MEDIUMBLOB".equals(sqlType) && !"LONGBLOB".equals(sqlType);
    }

    protected boolean escapeBackslashes() {
        return true;
    }

    public String getDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }
}

