/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.utils;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.text.WordUtils;

public class CasedString {
    private final String string;
    private final StringCase stringCase;
    private static final Function<String[], String> CAMEL_JOINER = a -> {
        StringBuilder sb = new StringBuilder(a[0].toLowerCase(Locale.ROOT));
        for (int i2 = 1; i2 < ((String[])a).length; ++i2) {
            sb.append(WordUtils.capitalize(a[i2].toLowerCase(Locale.ROOT)));
        }
        return sb.toString();
    };

    public CasedString(StringCase stringCase, String string) {
        this.string = string == null ? null : stringCase.assemble(stringCase.getSegments(string.trim()));
        this.stringCase = stringCase;
    }

    public String[] getSegments() {
        return this.stringCase.getSegments(this.string);
    }

    public String toCase(StringCase stringCase) {
        if (stringCase == this.stringCase) {
            return this.string;
        }
        return this.string == null ? null : (String)stringCase.joiner.apply(this.getSegments());
    }

    public String toString() {
        return this.string;
    }

    static /* synthetic */ Function access$000() {
        return CAMEL_JOINER;
    }

    public static enum StringCase {
        CAMEL(Character::isUpperCase, true, CasedString.access$000()),
        SNAKE(c -> c.charValue() == '_', false, a -> String.join((CharSequence)"_", a)),
        KEBAB(c -> c.charValue() == '-', false, a -> String.join((CharSequence)"-", a)),
        PHRASE(Character::isWhitespace, false, a -> String.join((CharSequence)" ", a)),
        DOT(c -> c.charValue() == '.', false, a -> String.join((CharSequence)".", a));

        private static final String[] NULL_SEGMENT;
        private static final String[] EMPTY_SEGMENT;
        private final Predicate<Character> splitter;
        private final boolean preserveSplit;
        private final Function<String[], String> joiner;

        private StringCase(Predicate<Character> splitter, boolean preserveSplit, Function<String[], String> joiner) {
            this.splitter = splitter;
            this.preserveSplit = preserveSplit;
            this.joiner = joiner;
        }

        public String assemble(String[] segments) {
            return segments.length == 0 ? null : this.joiner.apply(segments);
        }

        public String[] getSegments(String string) {
            if (string == null) {
                return NULL_SEGMENT;
            }
            if (string.isEmpty()) {
                return EMPTY_SEGMENT;
            }
            ArrayList<String> lst = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            for (char c : string.toCharArray()) {
                if (this.splitter.test(Character.valueOf(c))) {
                    if (sb.length() > 0) {
                        lst.add(sb.toString());
                        sb.setLength(0);
                    }
                    if (!this.preserveSplit) continue;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            if (sb.length() > 0) {
                lst.add(sb.toString());
            }
            return lst.toArray(new String[0]);
        }

        static {
            NULL_SEGMENT = new String[0];
            EMPTY_SEGMENT = new String[]{""};
        }
    }
}

