/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardDistance;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JaccardDistanceTest {
    private static JaccardDistance classBeingTested;

    JaccardDistanceTest() {
    }

    @BeforeAll
    public static void setUp() {
        classBeingTested = new JaccardDistance();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputsEquals()"})
    void testGettingJaccardDistance(Class<?> cls) {
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "left"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "right")));
        Assertions.assertEquals((double)0.25, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")));
        Assertions.assertEquals((double)0.7777777777777778, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((double)0.36363636363636365, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "ABC Corporation"), SimilarityInputTest.build(cls, "ABC Corp")));
        Assertions.assertEquals((double)0.23529411764705888, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "D N H Enterprises Inc"), SimilarityInputTest.build(cls, "D & H Enterprises, Inc.")));
        Assertions.assertEquals((double)0.11111111111111116, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "My Gym Children's Fitness Center"), SimilarityInputTest.build(cls, "My Gym. Childrens Fitness")));
        Assertions.assertEquals((double)0.09999999999999998, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "PENNSYLVANIA"), SimilarityInputTest.build(cls, "PENNCISYLVNIA")));
        Assertions.assertEquals((double)0.875, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "left"), SimilarityInputTest.build(cls, "right")));
        Assertions.assertEquals((double)0.875, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "leettteft"), SimilarityInputTest.build(cls, "ritttght")));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply(SimilarityInputTest.build(cls, "the same string"), SimilarityInputTest.build(cls, "the same string")));
    }

    @Test
    void testGettingJaccardDistanceCharSequence() {
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)""));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"));
        Assertions.assertEquals((double)0.25, (Double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((double)0.7777777777777778, (Double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((double)0.36363636363636365, (Double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((double)0.23529411764705888, (Double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((double)0.11111111111111116, (Double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((double)0.09999999999999998, (Double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((double)0.875, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"));
        Assertions.assertEquals((double)0.875, (Double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    void testGettingJaccardDistanceNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> classBeingTested.apply((CharSequence)null, null));
    }

    @Test
    void testGettingJaccardDistanceNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> classBeingTested.apply(null, (CharSequence)"right"));
    }

    @Test
    void testGettingJaccardDistanceStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> classBeingTested.apply((CharSequence)" ", null));
    }
}

