/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.cassandra.io.sstable.SSTableId;

public class SequenceBasedSSTableId
implements SSTableId,
Comparable<SequenceBasedSSTableId> {
    public final int generation;

    public SequenceBasedSSTableId(int generation) {
        assert (generation >= 0);
        this.generation = generation;
    }

    @Override
    public int compareTo(SequenceBasedSSTableId o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        return Integer.compare(this.generation, o.generation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceBasedSSTableId that = (SequenceBasedSSTableId)o;
        return this.generation == that.generation;
    }

    public int hashCode() {
        return Objects.hash(this.generation);
    }

    @Override
    public ByteBuffer asBytes() {
        ByteBuffer bytes = ByteBuffer.allocate(4);
        bytes.putInt(0, this.generation);
        return bytes;
    }

    @Override
    public String toString() {
        return String.valueOf(this.generation);
    }

    public static class Builder
    implements SSTableId.Builder<SequenceBasedSSTableId> {
        public static final Builder instance = new Builder();
        private static final Pattern PATTERN = Pattern.compile("\\d+");

        @Override
        public Supplier<SequenceBasedSSTableId> generator(Stream<SSTableId> existingIdentifiers) {
            int value = existingIdentifiers.filter(SequenceBasedSSTableId.class::isInstance).map(SequenceBasedSSTableId.class::cast).mapToInt(id -> id.generation).max().orElse(0);
            AtomicInteger fileIndexGenerator = new AtomicInteger(value);
            return () -> new SequenceBasedSSTableId(fileIndexGenerator.incrementAndGet());
        }

        @Override
        public boolean isUniqueIdentifier(String str) {
            return str != null && !str.isEmpty() && str.length() <= 10 && PATTERN.matcher(str).matches();
        }

        @Override
        public boolean isUniqueIdentifier(ByteBuffer bytes) {
            return bytes != null && bytes.remaining() == 4 && bytes.getInt(0) >= 0;
        }

        @Override
        public SequenceBasedSSTableId fromString(String token) throws IllegalArgumentException {
            return new SequenceBasedSSTableId(Integer.parseInt(token));
        }

        @Override
        public SequenceBasedSSTableId fromBytes(ByteBuffer bytes) throws IllegalArgumentException {
            Preconditions.checkArgument((bytes.remaining() == 4 ? 1 : 0) != 0, (String)"Buffer does not have a valid number of bytes remaining. Expecting: %s but was: %s", (int)4, (int)bytes.remaining());
            return new SequenceBasedSSTableId(bytes.getInt(0));
        }
    }
}

