/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.exceptions.UnknownColumnException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.AbstractTypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SerializationHeader {
    public static final Serializer serializer = new Serializer();
    private final boolean isForSSTable;
    private final AbstractType<?> keyType;
    private final List<AbstractType<?>> clusteringTypes;
    private final RegularAndStaticColumns columns;
    private final EncodingStats stats;
    private final Map<ByteBuffer, AbstractType<?>> typeMap;

    private SerializationHeader(boolean isForSSTable, AbstractType<?> keyType, List<AbstractType<?>> clusteringTypes, RegularAndStaticColumns columns, EncodingStats stats, Map<ByteBuffer, AbstractType<?>> typeMap) {
        this.isForSSTable = isForSSTable;
        this.keyType = keyType;
        this.clusteringTypes = clusteringTypes;
        this.columns = columns;
        this.stats = stats;
        this.typeMap = typeMap;
    }

    public static SerializationHeader makeWithoutStats(TableMetadata metadata) {
        return new SerializationHeader(true, metadata, metadata.regularAndStaticColumns(), EncodingStats.NO_STATS);
    }

    public static SerializationHeader make(TableMetadata metadata, Collection<SSTableReader> sstables) {
        EncodingStats.Collector stats = new EncodingStats.Collector();
        RegularAndStaticColumns.Builder columns = RegularAndStaticColumns.builder();
        for (SSTableReader sstable : SerializationHeader.orderByDescendingGeneration(sstables)) {
            stats.updateTimestamp(sstable.getMinTimestamp());
            stats.updateLocalDeletionTime(sstable.getMinLocalDeletionTime());
            stats.updateTTL(sstable.getMinTTL());
            columns.addAll(sstable.header.columns());
        }
        return new SerializationHeader(true, metadata, columns.build(), stats.get());
    }

    private static Collection<SSTableReader> orderByDescendingGeneration(Collection<SSTableReader> sstables) {
        if (sstables.size() < 2) {
            return sstables;
        }
        ArrayList<SSTableReader> readers = new ArrayList<SSTableReader>(sstables);
        readers.sort(SSTableReader.idReverseComparator);
        return readers;
    }

    public SerializationHeader(boolean isForSSTable, TableMetadata metadata, RegularAndStaticColumns columns, EncodingStats stats) {
        this(isForSSTable, metadata.partitionKeyType, metadata.comparator.subtypes(), columns, stats, null);
    }

    public RegularAndStaticColumns columns() {
        return this.columns;
    }

    public boolean hasStatic() {
        return !this.columns.statics.isEmpty();
    }

    public boolean isForSSTable() {
        return this.isForSSTable;
    }

    public EncodingStats stats() {
        return this.stats;
    }

    public AbstractType<?> keyType() {
        return this.keyType;
    }

    public List<AbstractType<?>> clusteringTypes() {
        return this.clusteringTypes;
    }

    public Columns columns(boolean isStatic) {
        return isStatic ? this.columns.statics : this.columns.regulars;
    }

    public AbstractType<?> getType(ColumnMetadata column) {
        return this.typeMap == null ? column.type : this.typeMap.get(column.name.bytes);
    }

    public void writeTimestamp(long timestamp, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(timestamp - this.stats.minTimestamp);
    }

    public void writeLocalDeletionTime(long localDeletionTime, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt32((int)(localDeletionTime - this.stats.minLocalDeletionTime));
    }

    public void writeTTL(int ttl, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt32(ttl - this.stats.minTTL);
    }

    public void writeDeletionTime(DeletionTime dt, DataOutputPlus out) throws IOException {
        this.writeTimestamp(dt.markedForDeleteAt(), out);
        this.writeLocalDeletionTime(dt.localDeletionTime(), out);
    }

    public long readTimestamp(DataInputPlus in) throws IOException {
        return in.readUnsignedVInt() + this.stats.minTimestamp;
    }

    public long readLocalDeletionTime(DataInputPlus in) throws IOException {
        return (long)in.readUnsignedVInt32() + this.stats.minLocalDeletionTime;
    }

    public int readTTL(DataInputPlus in) throws IOException {
        return in.readUnsignedVInt32() + this.stats.minTTL;
    }

    public DeletionTime readDeletionTime(DataInputPlus in) throws IOException {
        long markedAt = this.readTimestamp(in);
        long localDeletionTime = this.readLocalDeletionTime(in);
        return DeletionTime.build(markedAt, localDeletionTime);
    }

    public long timestampSerializedSize(long timestamp) {
        return TypeSizes.sizeofUnsignedVInt(timestamp - this.stats.minTimestamp);
    }

    public long localDeletionTimeSerializedSize(long localDeletionTime) {
        return TypeSizes.sizeofUnsignedVInt(localDeletionTime - this.stats.minLocalDeletionTime);
    }

    public long ttlSerializedSize(int ttl) {
        return TypeSizes.sizeofUnsignedVInt(ttl - this.stats.minTTL);
    }

    public long deletionTimeSerializedSize(DeletionTime dt) {
        return this.timestampSerializedSize(dt.markedForDeleteAt()) + this.localDeletionTimeSerializedSize(dt.localDeletionTime());
    }

    public void skipTimestamp(DataInputPlus in) throws IOException {
        in.readUnsignedVInt();
    }

    public void skipLocalDeletionTime(DataInputPlus in) throws IOException {
        in.readUnsignedVInt();
    }

    public void skipTTL(DataInputPlus in) throws IOException {
        in.readUnsignedVInt();
    }

    public void skipDeletionTime(DataInputPlus in) throws IOException {
        this.skipTimestamp(in);
        this.skipLocalDeletionTime(in);
    }

    public Component toComponent() {
        LinkedHashMap staticColumns = new LinkedHashMap();
        LinkedHashMap regularColumns = new LinkedHashMap();
        for (ColumnMetadata column : this.columns.statics) {
            staticColumns.put(column.name.bytes, column.type);
        }
        for (ColumnMetadata column : this.columns.regulars) {
            regularColumns.put(column.name.bytes, column.type);
        }
        return new Component(this.keyType, this.clusteringTypes, staticColumns, regularColumns, this.stats);
    }

    public String toString() {
        return String.format("SerializationHeader[key=%s, cks=%s, columns=%s, stats=%s, typeMap=%s]", this.keyType, this.clusteringTypes, this.columns, this.stats, this.typeMap);
    }

    public static class Serializer
    implements IMetadataComponentSerializer<Component> {
        private final AbstractTypeSerializer typeSerializer = new AbstractTypeSerializer();

        public void serializeForMessaging(SerializationHeader header, ColumnFilter selection, DataOutputPlus out, boolean hasStatic) throws IOException {
            EncodingStats.serializer.serialize(header.stats, out);
            if (selection == null) {
                if (hasStatic) {
                    Columns.serializer.serialize(header.columns.statics, out);
                }
                Columns.serializer.serialize(header.columns.regulars, out);
            } else {
                if (hasStatic) {
                    Columns.serializer.serializeSubset(header.columns.statics, selection.fetchedColumns().statics, out);
                }
                Columns.serializer.serializeSubset(header.columns.regulars, selection.fetchedColumns().regulars, out);
            }
        }

        public SerializationHeader deserializeForMessaging(DataInputPlus in, TableMetadata metadata, ColumnFilter selection, boolean hasStatic) throws IOException {
            Columns regulars;
            Columns statics;
            EncodingStats stats = EncodingStats.serializer.deserialize(in);
            AbstractType<?> keyType = metadata.partitionKeyType;
            List<AbstractType<?>> clusteringTypes = metadata.comparator.subtypes();
            if (selection == null) {
                statics = hasStatic ? Columns.serializer.deserialize(in, metadata) : Columns.NONE;
                regulars = Columns.serializer.deserialize(in, metadata);
            } else {
                statics = hasStatic ? Columns.serializer.deserializeSubset(selection.fetchedColumns().statics, in) : Columns.NONE;
                regulars = Columns.serializer.deserializeSubset(selection.fetchedColumns().regulars, in);
            }
            return new SerializationHeader(false, keyType, clusteringTypes, new RegularAndStaticColumns(statics, regulars), stats, null);
        }

        public long serializedSizeForMessaging(SerializationHeader header, ColumnFilter selection, boolean hasStatic) {
            long size = EncodingStats.serializer.serializedSize(header.stats);
            if (selection == null) {
                if (hasStatic) {
                    size += Columns.serializer.serializedSize(header.columns.statics);
                }
                size += Columns.serializer.serializedSize(header.columns.regulars);
            } else {
                if (hasStatic) {
                    size += Columns.serializer.serializedSubsetSize(header.columns.statics, selection.fetchedColumns().statics);
                }
                size += Columns.serializer.serializedSubsetSize(header.columns.regulars, selection.fetchedColumns().regulars);
            }
            return size;
        }

        @Override
        public void serialize(Version version, Component header, DataOutputPlus out) throws IOException {
            EncodingStats.serializer.serialize(header.stats, out);
            this.typeSerializer.serialize(header.keyType, out);
            this.typeSerializer.serializeList(header.clusteringTypes, out);
            this.writeColumnsWithTypes(header.staticColumns, out);
            this.writeColumnsWithTypes(header.regularColumns, out);
        }

        @Override
        public Component deserialize(Version version, DataInputPlus in) throws IOException {
            EncodingStats stats = EncodingStats.serializer.deserialize(in);
            AbstractType<?> keyType = this.typeSerializer.deserialize(in);
            List<AbstractType<?>> clusteringTypes = this.typeSerializer.deserializeList(in);
            Map<ByteBuffer, AbstractType<?>> staticColumns = this.readColumnsWithType(in);
            Map<ByteBuffer, AbstractType<?>> regularColumns = this.readColumnsWithType(in);
            return new Component(keyType, clusteringTypes, staticColumns, regularColumns, stats);
        }

        @Override
        public int serializedSize(Version version, Component header) {
            int size = EncodingStats.serializer.serializedSize(header.stats);
            size = (int)((long)size + this.typeSerializer.serializedSize(header.keyType));
            size = (int)((long)size + this.typeSerializer.serializedListSize(header.clusteringTypes));
            size = (int)((long)size + this.sizeofColumnsWithTypes(header.staticColumns));
            size = (int)((long)size + this.sizeofColumnsWithTypes(header.regularColumns));
            return size;
        }

        private void writeColumnsWithTypes(Map<ByteBuffer, AbstractType<?>> columns, DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt32(columns.size());
            for (Map.Entry<ByteBuffer, AbstractType<?>> entry : columns.entrySet()) {
                ByteBufferUtil.writeWithVIntLength(entry.getKey(), out);
                this.typeSerializer.serialize(entry.getValue(), out);
            }
        }

        private long sizeofColumnsWithTypes(Map<ByteBuffer, AbstractType<?>> columns) {
            long size = TypeSizes.sizeofUnsignedVInt(columns.size());
            for (Map.Entry<ByteBuffer, AbstractType<?>> entry : columns.entrySet()) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(entry.getKey());
                size += this.typeSerializer.serializedSize(entry.getValue());
            }
            return size;
        }

        private Map<ByteBuffer, AbstractType<?>> readColumnsWithType(DataInputPlus in) throws IOException {
            int length = in.readUnsignedVInt32();
            LinkedHashMap typeMap = new LinkedHashMap(length);
            for (int i = 0; i < length; ++i) {
                ByteBuffer name = ByteBufferUtil.readWithVIntLength(in);
                typeMap.put(name, this.typeSerializer.deserialize(in));
            }
            return typeMap;
        }
    }

    public static class Component
    extends MetadataComponent {
        private final AbstractType<?> keyType;
        private final List<AbstractType<?>> clusteringTypes;
        private final Map<ByteBuffer, AbstractType<?>> staticColumns;
        private final Map<ByteBuffer, AbstractType<?>> regularColumns;
        private final EncodingStats stats;

        private Component(AbstractType<?> keyType, List<AbstractType<?>> clusteringTypes, Map<ByteBuffer, AbstractType<?>> staticColumns, Map<ByteBuffer, AbstractType<?>> regularColumns, EncodingStats stats) {
            this.keyType = keyType;
            this.clusteringTypes = clusteringTypes;
            this.staticColumns = staticColumns;
            this.regularColumns = regularColumns;
            this.stats = stats;
        }

        @Override
        public MetadataType getType() {
            return MetadataType.HEADER;
        }

        public SerializationHeader toHeader(TableMetadata metadata) throws UnknownColumnException {
            HashMap typeMap = new HashMap(this.staticColumns.size() + this.regularColumns.size());
            RegularAndStaticColumns.Builder builder = RegularAndStaticColumns.builder();
            for (Map map : ImmutableList.of(this.staticColumns, this.regularColumns)) {
                boolean isStatic = map == this.staticColumns;
                for (Map.Entry e : map.entrySet()) {
                    ByteBuffer name = (ByteBuffer)e.getKey();
                    AbstractType other = typeMap.put(name, (AbstractType)e.getValue());
                    if (other != null && !other.equals(e.getValue())) {
                        throw new IllegalStateException("Column " + name + " occurs as both regular and static with types " + other + "and " + e.getValue());
                    }
                    ColumnMetadata column = metadata.getColumn(name);
                    if ((column == null || column.isStatic() != isStatic) && (column = metadata.getDroppedColumn(name, isStatic)) == null) {
                        throw new UnknownColumnException("Unknown column " + UTF8Type.instance.getString(name) + " during deserialization");
                    }
                    builder.add(column);
                }
            }
            return new SerializationHeader(true, this.keyType, this.clusteringTypes, builder.build(), this.stats, typeMap);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Component)) {
                return false;
            }
            Component that = (Component)o;
            return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.clusteringTypes, that.clusteringTypes) && Objects.equals(this.staticColumns, that.staticColumns) && Objects.equals(this.regularColumns, that.regularColumns) && Objects.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.keyType, this.clusteringTypes, this.staticColumns, this.regularColumns, this.stats);
        }

        public String toString() {
            return String.format("SerializationHeader.Component[key=%s, cks=%s, statics=%s, regulars=%s, stats=%s]", this.keyType, this.clusteringTypes, this.staticColumns, this.regularColumns, this.stats);
        }

        public AbstractType<?> getKeyType() {
            return this.keyType;
        }

        public List<AbstractType<?>> getClusteringTypes() {
            return this.clusteringTypes;
        }

        public Map<ByteBuffer, AbstractType<?>> getStaticColumns() {
            return this.staticColumns;
        }

        public Map<ByteBuffer, AbstractType<?>> getRegularColumns() {
            return this.regularColumns;
        }

        public EncodingStats getEncodingStats() {
            return this.stats;
        }
    }
}

