/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.resolver;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import org.apache.bookkeeper.common.util.SharedResourceManager;

public abstract class AbstractNameResolver
extends NameResolver {
    private final String authority;
    private final SharedResourceManager.Resource<ExecutorService> executorService;
    private final Runnable resolutionTask;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    @GuardedBy(value="this")
    private ExecutorService executor;

    protected AbstractNameResolver(String name, SharedResourceManager.Resource<ExecutorService> executorResource) {
        URI nameURI = URI.create("//" + name);
        this.executorService = executorResource;
        this.authority = (String)Preconditions.checkNotNull((Object)nameURI.getAuthority(), (String)"Name URI (%s) doesn't have an authority", (Object)nameURI);
        this.resolutionTask = new ResolverTask();
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((null == this.listener ? 1 : 0) != 0, (Object)"Resolver already started");
        this.executor = (ExecutorService)SharedResourceManager.shared().get(this.executorService);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"Listener is null");
        this.resolve();
    }

    public synchronized void refresh() {
        Preconditions.checkState((null != this.listener ? 1 : 0) != 0, (Object)"Resolver has not started yet.");
        this.resolve();
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionTask);
    }

    protected abstract List<EquivalentAddressGroup> getServers();

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (null != this.executor) {
            SharedResourceManager.shared().release(this.executorService, (Object)this.executor);
        }
    }

    private final class ResolverTask
    implements Runnable {
        private ResolverTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            AbstractNameResolver abstractNameResolver = AbstractNameResolver.this;
            synchronized (abstractNameResolver) {
                if (AbstractNameResolver.this.shutdown) {
                    return;
                }
                AbstractNameResolver.this.resolving = true;
                savedListener = AbstractNameResolver.this.listener;
            }
            try {
                List<EquivalentAddressGroup> servers = AbstractNameResolver.this.getServers();
                savedListener.onAddresses(servers, Attributes.EMPTY);
            }
            finally {
                abstractNameResolver = AbstractNameResolver.this;
                synchronized (abstractNameResolver) {
                    AbstractNameResolver.this.resolving = false;
                }
            }
        }
    }
}

