# coding: utf-8

"""
    Airflow API

    Airflow API. All endpoints located under ``/api/v2`` can be used safely, are stable and backward compatible. Endpoints located under ``/ui`` are dedicated to the UI and are subject to breaking change depending on the need of the frontend. Users should not rely on those but use the public ones instead.

    The version of the OpenAPI document: 2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from airflow_client.client.models.dag_tag_response import DagTagResponse
from airflow_client.client.models.dag_version_response import DagVersionResponse
from typing import Optional, Set
from typing_extensions import Self

class DAGDetailsResponse(BaseModel):
    """
    Specific serializer for DAG Details responses.
    """ # noqa: E501
    asset_expression: Optional[Dict[str, Any]] = None
    bundle_name: Optional[StrictStr] = None
    bundle_version: Optional[StrictStr] = None
    catchup: StrictBool
    concurrency: StrictInt = Field(description="Return max_active_tasks as concurrency.  Deprecated: Use max_active_tasks instead.")
    dag_display_name: StrictStr
    dag_id: StrictStr
    dag_run_timeout: Optional[StrictStr] = None
    default_args: Optional[Dict[str, Any]] = None
    description: Optional[StrictStr] = None
    doc_md: Optional[StrictStr] = None
    end_date: Optional[datetime] = None
    file_token: StrictStr = Field(description="Return file token.")
    fileloc: StrictStr
    has_import_errors: StrictBool
    has_task_concurrency_limits: StrictBool
    is_paused: StrictBool
    is_paused_upon_creation: Optional[StrictBool] = None
    is_stale: StrictBool
    last_expired: Optional[datetime] = None
    last_parse_duration: Optional[Union[StrictFloat, StrictInt]] = None
    last_parsed: Optional[datetime] = None
    last_parsed_time: Optional[datetime] = None
    latest_dag_version: Optional[DagVersionResponse] = None
    max_active_runs: Optional[StrictInt] = None
    max_active_tasks: StrictInt
    max_consecutive_failed_dag_runs: StrictInt
    next_dagrun_data_interval_end: Optional[datetime] = None
    next_dagrun_data_interval_start: Optional[datetime] = None
    next_dagrun_logical_date: Optional[datetime] = None
    next_dagrun_run_after: Optional[datetime] = None
    owner_links: Optional[Dict[str, StrictStr]] = None
    owners: List[StrictStr]
    params: Optional[Dict[str, Any]] = None
    relative_fileloc: Optional[StrictStr] = None
    render_template_as_native_obj: StrictBool
    start_date: Optional[datetime] = None
    tags: List[DagTagResponse]
    template_search_path: Optional[List[StrictStr]] = None
    timetable_description: Optional[StrictStr] = None
    timetable_summary: Optional[StrictStr] = None
    timezone: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["asset_expression", "bundle_name", "bundle_version", "catchup", "concurrency", "dag_display_name", "dag_id", "dag_run_timeout", "default_args", "description", "doc_md", "end_date", "file_token", "fileloc", "has_import_errors", "has_task_concurrency_limits", "is_paused", "is_paused_upon_creation", "is_stale", "last_expired", "last_parse_duration", "last_parsed", "last_parsed_time", "latest_dag_version", "max_active_runs", "max_active_tasks", "max_consecutive_failed_dag_runs", "next_dagrun_data_interval_end", "next_dagrun_data_interval_start", "next_dagrun_logical_date", "next_dagrun_run_after", "owner_links", "owners", "params", "relative_fileloc", "render_template_as_native_obj", "start_date", "tags", "template_search_path", "timetable_description", "timetable_summary", "timezone"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DAGDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "concurrency",
            "file_token",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of latest_dag_version
        if self.latest_dag_version:
            _dict['latest_dag_version'] = self.latest_dag_version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DAGDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asset_expression": obj.get("asset_expression"),
            "bundle_name": obj.get("bundle_name"),
            "bundle_version": obj.get("bundle_version"),
            "catchup": obj.get("catchup"),
            "concurrency": obj.get("concurrency"),
            "dag_display_name": obj.get("dag_display_name"),
            "dag_id": obj.get("dag_id"),
            "dag_run_timeout": obj.get("dag_run_timeout"),
            "default_args": obj.get("default_args"),
            "description": obj.get("description"),
            "doc_md": obj.get("doc_md"),
            "end_date": obj.get("end_date"),
            "file_token": obj.get("file_token"),
            "fileloc": obj.get("fileloc"),
            "has_import_errors": obj.get("has_import_errors"),
            "has_task_concurrency_limits": obj.get("has_task_concurrency_limits"),
            "is_paused": obj.get("is_paused"),
            "is_paused_upon_creation": obj.get("is_paused_upon_creation"),
            "is_stale": obj.get("is_stale"),
            "last_expired": obj.get("last_expired"),
            "last_parse_duration": obj.get("last_parse_duration"),
            "last_parsed": obj.get("last_parsed"),
            "last_parsed_time": obj.get("last_parsed_time"),
            "latest_dag_version": DagVersionResponse.from_dict(obj["latest_dag_version"]) if obj.get("latest_dag_version") is not None else None,
            "max_active_runs": obj.get("max_active_runs"),
            "max_active_tasks": obj.get("max_active_tasks"),
            "max_consecutive_failed_dag_runs": obj.get("max_consecutive_failed_dag_runs"),
            "next_dagrun_data_interval_end": obj.get("next_dagrun_data_interval_end"),
            "next_dagrun_data_interval_start": obj.get("next_dagrun_data_interval_start"),
            "next_dagrun_logical_date": obj.get("next_dagrun_logical_date"),
            "next_dagrun_run_after": obj.get("next_dagrun_run_after"),
            "owner_links": obj.get("owner_links"),
            "owners": obj.get("owners"),
            "params": obj.get("params"),
            "relative_fileloc": obj.get("relative_fileloc"),
            "render_template_as_native_obj": obj.get("render_template_as_native_obj"),
            "start_date": obj.get("start_date"),
            "tags": [DagTagResponse.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "template_search_path": obj.get("template_search_path"),
            "timetable_description": obj.get("timetable_description"),
            "timetable_summary": obj.get("timetable_summary"),
            "timezone": obj.get("timezone")
        })
        return _obj


