/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConsumerThread;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.factory.ConnectionFactoryClosable;
import picocli.CommandLine;

@CommandLine.Command(name="browser", description={"Browse messages on a queue."})
public class Browse
extends DestAbstract {
    @CommandLine.Option(names={"--filter"}, description={"The message filter."})
    String filter;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        context.out.println("Consumer:: filter = " + this.filter);
        ConnectionFactoryClosable factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            void object;
            ConsumerThread[] threadsArray = new ConsumerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                Session session = this.txBatchSize > 0 ? connection.createSession(true, 0) : connection.createSession(false, 1);
                Destination destination = this.getDestination(session);
                threadsArray[i] = new ConsumerThread(session, destination, i, context);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setMessageCount(this.messageCount).setFilter(this.filter).setBrowse(true);
            }
            ConsumerThread[] i = threadsArray;
            int n = i.length;
            boolean bl = false;
            while (object < n) {
                ConsumerThread thread = i[object];
                thread.start();
                ++object;
            }
            connection.start();
            long received = 0L;
            for (ConsumerThread thread : threadsArray) {
                thread.join();
                received += (long)thread.getReceived();
            }
            Long l = received;
            return l;
        }
    }
}

