/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.URISupport;

public class InterceptSendToEndpointCallback
implements EndpointStrategy {
    private final CamelContext camelContext;
    private final Predicate onWhen;
    private final Processor before;
    private final Processor after;
    private final String matchURI;
    private final boolean skip;

    public InterceptSendToEndpointCallback(CamelContext camelContext, Processor before, Processor after, String matchURI, boolean skip, Predicate onWhen) {
        this.camelContext = camelContext;
        this.before = before;
        this.after = after;
        this.matchURI = matchURI;
        this.skip = skip;
        this.onWhen = onWhen;
    }

    public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
        if (endpoint instanceof InterceptSendToEndpoint) {
            return endpoint;
        }
        if (this.matchURI == null || this.matchPattern(uri, this.matchURI)) {
            return PluginHelper.getInterceptEndpointFactory((CamelContext)this.camelContext).createInterceptSendToEndpoint(this.camelContext, endpoint, this.skip, this.onWhen, this.before, this.after);
        }
        return endpoint;
    }

    protected boolean matchPattern(String uri, String pattern) {
        boolean match = EndpointHelper.matchEndpoint((CamelContext)this.camelContext, (String)uri, (String)pattern);
        if (!match) {
            try {
                pattern = URISupport.normalizeUri((String)pattern);
                match = EndpointHelper.matchEndpoint((CamelContext)this.camelContext, (String)uri, (String)pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return match;
    }
}

