/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ResourceAdapter;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.lang.Nullable;

public class StandardJmsActivationSpecFactory
implements JmsActivationSpecFactory {
    @Nullable
    private Class<?> activationSpecClass;
    @Nullable
    private Map<String, String> defaultProperties;
    @Nullable
    private DestinationResolver destinationResolver;

    public void setActivationSpecClass(Class<?> activationSpecClass) {
        this.activationSpecClass = activationSpecClass;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setDestinationResolver(@Nullable DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    @Nullable
    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    @Override
    public ActivationSpec createActivationSpec(ResourceAdapter adapter, JmsActivationSpecConfig config) {
        Class<?> activationSpecClassToUse = this.activationSpecClass;
        if (activationSpecClassToUse == null && (activationSpecClassToUse = this.determineActivationSpecClass(adapter)) == null) {
            throw new IllegalStateException("Property 'activationSpecClass' is required");
        }
        ActivationSpec spec = (ActivationSpec)BeanUtils.instantiateClass(activationSpecClassToUse);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(spec);
        if (this.defaultProperties != null) {
            bw.setPropertyValues(this.defaultProperties);
        }
        this.populateActivationSpecProperties(bw, config);
        return spec;
    }

    @Nullable
    protected Class<?> determineActivationSpecClass(ResourceAdapter adapter) {
        return null;
    }

    protected void populateActivationSpecProperties(BeanWrapper bw, JmsActivationSpecConfig config) {
        String destinationName = config.getDestinationName();
        if (destinationName != null) {
            boolean pubSubDomain = config.isPubSubDomain();
            Object destination = destinationName;
            if (this.destinationResolver != null) {
                try {
                    destination = this.destinationResolver.resolveDestinationName(null, destinationName, pubSubDomain);
                }
                catch (JMSException ex) {
                    throw new DestinationResolutionException("Cannot resolve destination name [" + destinationName + "]", ex);
                }
            }
            bw.setPropertyValue("destination", destination);
            bw.setPropertyValue("destinationType", pubSubDomain ? Topic.class.getName() : Queue.class.getName());
        }
        if (bw.isWritableProperty("subscriptionDurability")) {
            bw.setPropertyValue("subscriptionDurability", config.isSubscriptionDurable() ? "Durable" : "NonDurable");
        } else if (config.isSubscriptionDurable()) {
            throw new IllegalArgumentException("Durable subscriptions not supported by underlying provider");
        }
        if (config.isSubscriptionShared()) {
            throw new IllegalArgumentException("Shared subscriptions not supported for JCA-driven endpoints");
        }
        if (config.getSubscriptionName() != null) {
            bw.setPropertyValue("subscriptionName", config.getSubscriptionName());
        }
        if (config.getClientId() != null) {
            bw.setPropertyValue("clientId", config.getClientId());
        }
        if (config.getMessageSelector() != null) {
            bw.setPropertyValue("messageSelector", config.getMessageSelector());
        }
        this.applyAcknowledgeMode(bw, config.getAcknowledgeMode());
    }

    protected void applyAcknowledgeMode(BeanWrapper bw, int ackMode) {
        if (ackMode == 0) {
            throw new IllegalArgumentException("No support for SESSION_TRANSACTED: Only \"Auto-acknowledge\" and \"Dups-ok-acknowledge\" supported in standard JCA 1.5");
        }
        if (ackMode == 2) {
            throw new IllegalArgumentException("No support for CLIENT_ACKNOWLEDGE: Only \"Auto-acknowledge\" and \"Dups-ok-acknowledge\" supported in standard JCA 1.5");
        }
        if (bw.isWritableProperty("acknowledgeMode")) {
            bw.setPropertyValue("acknowledgeMode", ackMode == 3 ? "Dups-ok-acknowledge" : "Auto-acknowledge");
        } else if (ackMode == 3) {
            throw new IllegalArgumentException("Dups-ok-acknowledge not supported by underlying provider");
        }
    }
}

