/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTasks;
import org.apache.camel.model.AdviceWithDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithBuilder<T extends ProcessorDefinition<?>> {
    private final AdviceWithRouteBuilder builder;
    private final String id;
    private final String toString;
    private final String toUri;
    private final Class<T> type;
    private boolean selectFirst;
    private boolean selectLast;
    private int selectFrom = -1;
    private int selectTo = -1;
    private int maxDeep = -1;

    public AdviceWithBuilder(AdviceWithRouteBuilder builder, String id, String toString, String toUri, Class<T> type) {
        this.builder = builder;
        this.id = id;
        this.toString = toString;
        this.toUri = toUri;
        this.type = type;
        if (id == null && toString == null && toUri == null && type == null) {
            throw new IllegalArgumentException("Either id, toString, toUri or type must be specified");
        }
    }

    public AdviceWithBuilder<T> selectFirst() {
        this.selectFirst = true;
        this.selectLast = false;
        return this;
    }

    public AdviceWithBuilder<T> selectLast() {
        this.selectLast = true;
        this.selectFirst = false;
        return this;
    }

    public AdviceWithBuilder<T> selectIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be a non negative number, was: " + index);
        }
        this.selectFrom = index;
        this.selectTo = index;
        return this;
    }

    public AdviceWithBuilder<T> selectRange(int from, int to) {
        if (from < 0) {
            throw new IllegalArgumentException("From must be a non negative number, was: " + from);
        }
        if (from > to) {
            throw new IllegalArgumentException("From must be equal or lower than to. from: " + from + ", to: " + to);
        }
        this.selectFrom = from;
        this.selectTo = to;
        return this;
    }

    public AdviceWithBuilder<T> maxDeep(int maxDeep) {
        this.maxDeep = maxDeep == 0 ? -1 : maxDeep;
        return this;
    }

    public ProcessorDefinition<?> replace() {
        RouteDefinition route = this.builder.getOriginalRoute();
        AdviceWithDefinition answer = new AdviceWithDefinition();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.replaceById(route, this.id, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.replaceByToString(route, this.toString, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toUri != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.replaceByToUri(route, this.toUri, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.type != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.replaceByType(route, this.type, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        }
        return answer;
    }

    public void remove() {
        RouteDefinition route = this.builder.getOriginalRoute();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.removeById(route, this.id, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.removeByToString(route, this.toString, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toUri != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.removeByToUri(route, this.toUri, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.type != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.removeByType(route, this.type, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        }
    }

    public ProcessorDefinition<?> before() {
        RouteDefinition route = this.builder.getOriginalRoute();
        AdviceWithDefinition answer = new AdviceWithDefinition();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.beforeById(route, this.id, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.beforeByToString(route, this.toString, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toUri != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.beforeByToUri(route, this.toUri, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.type != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.beforeByType(route, this.type, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        }
        return answer;
    }

    public ProcessorDefinition<?> after() {
        RouteDefinition route = this.builder.getOriginalRoute();
        AdviceWithDefinition answer = new AdviceWithDefinition();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.afterById(route, this.id, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.afterByToString(route, this.toString, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.toUri != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.afterByToUri(route, this.toUri, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        } else if (this.type != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.afterByType(route, this.type, answer, this.selectFirst, this.selectLast, this.selectFrom, this.selectTo, this.maxDeep));
        }
        return answer;
    }
}

