######################################################################
#
# 5053_cp932x_by_keis90_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xA1\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\x81\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],

        ["\xA1\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\x81\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],

        ["\xA1\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\x81\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],

        ["\xA1\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\x81\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],

        ["\xA1\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\x81\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],

        ["\xA1\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\x81\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],

        ["\xA1\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\x81\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],

        ["\xA1\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\x81\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],

        ["\xA1\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\x81\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],

        ["\xA1\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\x81\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],

        ["\xA1\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\x81\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],

        ["\xA1\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\x81\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],

        ["\xA1\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\x81\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],

        ["\xA1\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\x81\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],

        ["\xA1\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\x81\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],

        ["\xA1\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\x81\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],

        ["\xA1\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\x81\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],

        ["\xA1\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\x81\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],

        ["\xA1\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\x81\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],

        ["\xA1\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\x81\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],

        ["\xA1\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\x81\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],

        ["\xA1\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\x81\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],

        ["\xA1\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\x81\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],

        ["\xA1\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\x81\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],

        ["\xA1\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\x81\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],

        ["\xA1\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\x81\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],

        ["\xA1\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\x81\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],

        ["\xA1\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\x81\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],

        ["\xA1\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\x81\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],

        ["\xA1\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\x81\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],

        ["\xA1\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\x81\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],

        ["\xA1\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x5F"],
        ["\x81\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],

        ["\xA1\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\x81\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],

        ["\xA1\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\x81\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],

        ["\xA1\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\x81\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],

        ["\xA1\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\x81\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],

        ["\xA1\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\x81\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],

        ["\xA1\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\x81\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],

        ["\xA1\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\x81\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],

        ["\xA1\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\x81\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],

        ["\xA1\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\x81\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],

        ["\xA1\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\x81\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],

        ["\xA1\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\x81\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],

        ["\xA1\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\x81\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],

        ["\xA1\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\x81\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],

        ["\xA1\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\x81\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],

        ["\xA1\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\x81\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],

        ["\xA1\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\x81\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],

        ["\xA1\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\x81\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],

        ["\xA1\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\x81\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],

        ["\xA1\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\x81\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],

        ["\xA1\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\x81\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],

        ["\xA1\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\x81\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],

        ["\xA1\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\x81\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],

        ["\xA1\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\x81\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],

        ["\xA1\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\x81\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],

        ["\xA1\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\x81\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],

        ["\xA1\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\x81\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],

        ["\xA1\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\x81\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],

        ["\xA1\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\x81\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],

        ["\xA1\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\x81\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],

        ["\xA1\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\x81\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],

        ["\xA1\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\x81\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],

        ["\xA1\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\x81\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],

        ["\xA1\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\x81\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],

        ["\xA1\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\x81\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],

        ["\xA1\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\x81\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],

        ["\xA1\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\x81\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],

        ["\xA1\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\x81\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],

        ["\xA1\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\x81\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],

        ["\xA1\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\x81\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],

        ["\xA1\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\x81\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],

        ["\xA1\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\x81\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],

        ["\xA1\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\x81\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],

        ["\xA1\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\x81\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],

        ["\xA1\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\x81\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],

        ["\xA1\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\x81\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],

        ["\xA1\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\x81\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],

        ["\xA1\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\x81\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],

        ["\xA1\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\x81\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],

        ["\xA1\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\x81\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],

        ["\xA1\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\x81\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],

        ["\xA1\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\x81\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],

        ["\xA1\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\x81\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],

        ["\xA1\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\x81\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],

        ["\xA1\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\x81\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],

        ["\xA1\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\x81\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],

        ["\xA1\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\x81\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],

        ["\xA1\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\x81\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],

        ["\xA1\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\x81\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],

        ["\xA1\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\x81\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],

        ["\xA1\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\x81\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],

        ["\xA1\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\x81\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],

        ["\xA1\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\x81\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],

        ["\xA2\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\x81\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],

        ["\xA2\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\x81\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],

        ["\xA2\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\x81\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],

        ["\xA2\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\x81\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],

        ["\xA2\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\x81\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],

        ["\xA2\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\x81\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],

        ["\xA2\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\x81\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],

        ["\xA2\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\x81\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],

        ["\xA2\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\x81\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],

        ["\xA2\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\x81\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],

        ["\xA2\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\x81\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],

        ["\xA2\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\x81\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],

        ["\xA2\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\x81\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],

        ["\xA2\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x81\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],

        ["\xA2\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\x81\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],

        ["\xA2\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\x81\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],

        ["\xA2\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\x81\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],

        ["\xA2\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\x81\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],

        ["\xA2\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\x81\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],

        ["\xA2\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\x81\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],

        ["\xA2\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\x81\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],

        ["\xA2\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\x81\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],

        ["\xA2\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\x81\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],

        ["\xA2\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\x81\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],

        ["\xA2\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\x81\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xCC"],

        ["\xA2\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\x81\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],

        ["\xA2\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\x81\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],

        ["\xA2\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\x81\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],

        ["\xA2\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\x81\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],

        ["\xA2\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\x81\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],

        ["\xA2\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\x81\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],

        ["\xA2\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\x81\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],

        ["\xA2\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\x81\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],

        ["\xA2\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\x81\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],

        ["\xA2\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\x81\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],

        ["\xA2\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\x81\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],

        ["\xA2\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\x81\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],

        ["\xA2\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\x81\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],

        ["\xA2\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\x81\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],

        ["\xA2\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\x81\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],

        ["\xA2\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\x81\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],

        ["\xA2\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\x81\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],

        ["\xA2\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\x81\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],

        ["\xA2\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\x81\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],

        ["\xA2\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\x81\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],

        ["\xA2\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\x81\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],

        ["\xA2\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\x81\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],

        ["\xA2\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\x81\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],

        ["\xA2\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\x81\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],

        ["\xA2\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\x81\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],

        ["\xA2\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\x81\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],

        ["\xA2\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\x81\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],

        ["\xA2\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\x81\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],

        ["\xA3\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\x82\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],

        ["\xA3\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\x82\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],

        ["\xA3\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\x82\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],

        ["\xA3\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\x82\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],

        ["\xA3\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\x82\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],

        ["\xA3\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\x82\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],

        ["\xA3\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\x82\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],

        ["\xA3\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\x82\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],

        ["\xA3\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\x82\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],

        ["\xA3\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\x82\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],

        ["\xA3\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\x82\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],

        ["\xA3\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\x82\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],

        ["\xA3\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\x82\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],

        ["\xA3\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\x82\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],

        ["\xA3\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\x82\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],

        ["\xA3\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\x82\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],

        ["\xA3\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\x82\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],

        ["\xA3\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\x82\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],

        ["\xA3\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\x82\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],

        ["\xA3\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\x82\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],

        ["\xA3\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\x82\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],

        ["\xA3\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\x82\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],

        ["\xA3\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\x82\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],

        ["\xA3\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\x82\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],

        ["\xA3\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\x82\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],

        ["\xA3\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\x82\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],

        ["\xA3\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\x82\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],

        ["\xA3\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\x82\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],

        ["\xA3\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\x82\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],

        ["\xA3\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\x82\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],

        ["\xA3\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\x82\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],

        ["\xA3\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\x82\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],

        ["\xA3\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\x82\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],

        ["\xA3\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\x82\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],

        ["\xA3\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\x82\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],

        ["\xA3\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\x82\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],

        ["\xA3\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\x82\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],

        ["\xA3\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\x82\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],

        ["\xA3\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\x82\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],

        ["\xA3\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\x82\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],

        ["\xA3\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\x82\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],

        ["\xA3\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\x82\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],

        ["\xA3\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\x82\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],

        ["\xA3\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\x82\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],

        ["\xA3\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\x82\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],

        ["\xA3\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\x82\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],

        ["\xA3\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\x82\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],

        ["\xA3\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\x82\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],

        ["\xA3\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\x82\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],

        ["\xA3\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\x82\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],

        ["\xA3\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\x82\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],

        ["\xA3\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\x82\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],

        ["\xA3\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\x82\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],

        ["\xA3\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\x82\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],

        ["\xA3\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\x82\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],

        ["\xA3\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\x82\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],

        ["\xA3\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\x82\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],

        ["\xA3\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\x82\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],

        ["\xA3\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\x82\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],

        ["\xA3\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\x82\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],

        ["\xA3\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\x82\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],

        ["\xA3\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\x82\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],

        ["\xA4\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\x82\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],

        ["\xA4\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\x82\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],

        ["\xA4\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\x82\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],

        ["\xA4\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\x82\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],

        ["\xA4\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\x82\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],

        ["\xA4\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\x82\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],

        ["\xA4\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\x82\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],

        ["\xA4\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\x82\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],

        ["\xA4\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\x82\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],

        ["\xA4\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\x82\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],

        ["\xA4\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\x82\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],

        ["\xA4\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\x82\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],

        ["\xA4\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\x82\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],

        ["\xA4\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\x82\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],

        ["\xA4\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\x82\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],

        ["\xA4\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\x82\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],

        ["\xA4\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\x82\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],

        ["\xA4\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\x82\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],

        ["\xA4\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\x82\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],

        ["\xA4\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\x82\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],

        ["\xA4\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\x82\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],

        ["\xA4\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\x82\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],

        ["\xA4\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\x82\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],

        ["\xA4\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\x82\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],

        ["\xA4\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\x82\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],

        ["\xA4\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\x82\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],

        ["\xA4\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\x82\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],

        ["\xA4\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\x82\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],

        ["\xA4\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\x82\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],

        ["\xA4\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\x82\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],

        ["\xA4\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\x82\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],

        ["\xA4\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\x82\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],

        ["\xA4\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\x82\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],

        ["\xA4\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\x82\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],

        ["\xA4\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\x82\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],

        ["\xA4\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\x82\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],

        ["\xA4\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\x82\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],

        ["\xA4\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\x82\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],

        ["\xA4\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\x82\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],

        ["\xA4\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\x82\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],

        ["\xA4\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\x82\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],

        ["\xA4\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\x82\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],

        ["\xA4\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\x82\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],

        ["\xA4\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\x82\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],

        ["\xA4\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\x82\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],

        ["\xA4\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\x82\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],

        ["\xA4\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\x82\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],

        ["\xA4\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\x82\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],

        ["\xA4\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\x82\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],

        ["\xA4\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\x82\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],

        ["\xA4\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\x82\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],

        ["\xA4\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\x82\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],

        ["\xA4\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\x82\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],

        ["\xA4\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\x82\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],

        ["\xA4\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\x82\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],

        ["\xA4\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\x82\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],

        ["\xA4\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\x82\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],

        ["\xA4\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\x82\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],

        ["\xA4\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\x82\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],

        ["\xA4\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\x82\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],

        ["\xA4\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\x82\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],

        ["\xA4\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\x82\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],

        ["\xA4\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\x82\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],

        ["\xA4\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\x82\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],

        ["\xA4\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\x82\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],

        ["\xA4\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\x82\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],

        ["\xA4\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\x82\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],

        ["\xA4\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\x82\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],

        ["\xA4\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\x82\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],

        ["\xA4\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\x82\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],

        ["\xA4\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\x82\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],

        ["\xA4\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\x82\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],

        ["\xA4\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\x82\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],

        ["\xA4\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\x82\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],

        ["\xA4\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\x82\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],

        ["\xA4\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\x82\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],

        ["\xA4\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\x82\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],

        ["\xA4\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\x82\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],

        ["\xA4\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\x82\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],

        ["\xA4\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\x82\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],

        ["\xA4\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\x82\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],

        ["\xA4\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\x82\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],

        ["\xA4\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\x82\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],

        ["\xA5\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\x83\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],

        ["\xA5\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\x83\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],

        ["\xA5\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\x83\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],

        ["\xA5\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\x83\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],

        ["\xA5\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\x83\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],

        ["\xA5\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\x83\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],

        ["\xA5\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\x83\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],

        ["\xA5\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\x83\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],

        ["\xA5\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\x83\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],

        ["\xA5\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\x83\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],

        ["\xA5\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\x83\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],

        ["\xA5\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\x83\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],

        ["\xA5\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\x83\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],

        ["\xA5\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\x83\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],

        ["\xA5\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\x83\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],

        ["\xA5\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\x83\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],

        ["\xA5\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\x83\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],

        ["\xA5\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\x83\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],

        ["\xA5\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\x83\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],

        ["\xA5\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\x83\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],

        ["\xA5\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\x83\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],

        ["\xA5\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\x83\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],

        ["\xA5\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\x83\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],

        ["\xA5\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\x83\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],

        ["\xA5\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\x83\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],

        ["\xA5\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\x83\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],

        ["\xA5\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\x83\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],

        ["\xA5\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\x83\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],

        ["\xA5\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\x83\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],

        ["\xA5\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\x83\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],

        ["\xA5\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\x83\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],

        ["\xA5\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\x83\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],

        ["\xA5\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\x83\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],

        ["\xA5\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\x83\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],

        ["\xA5\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\x83\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],

        ["\xA5\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\x83\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],

        ["\xA5\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\x83\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],

        ["\xA5\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\x83\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],

        ["\xA5\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\x83\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],

        ["\xA5\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\x83\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],

        ["\xA5\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\x83\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],

        ["\xA5\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\x83\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],

        ["\xA5\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\x83\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],

        ["\xA5\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\x83\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],

        ["\xA5\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\x83\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],

        ["\xA5\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\x83\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],

        ["\xA5\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\x83\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],

        ["\xA5\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\x83\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],

        ["\xA5\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\x83\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],

        ["\xA5\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\x83\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],

        ["\xA5\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\x83\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],

        ["\xA5\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\x83\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],

        ["\xA5\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\x83\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],

        ["\xA5\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\x83\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],

        ["\xA5\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\x83\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],

        ["\xA5\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\x83\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],

        ["\xA5\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\x83\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],

        ["\xA5\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\x83\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],

        ["\xA5\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\x83\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],

        ["\xA5\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\x83\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],

        ["\xA5\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\x83\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],

        ["\xA5\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\x83\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],

        ["\xA5\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\x83\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],

        ["\xA5\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\x83\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],

        ["\xA5\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\x83\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],

        ["\xA5\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\x83\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],

        ["\xA5\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\x83\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],

        ["\xA5\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\x83\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],

        ["\xA5\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\x83\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],

        ["\xA5\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\x83\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],

        ["\xA5\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\x83\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],

        ["\xA5\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\x83\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],

        ["\xA5\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\x83\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],

        ["\xA5\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\x83\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],

        ["\xA5\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\x83\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],

        ["\xA5\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\x83\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],

        ["\xA5\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\x83\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],

        ["\xA5\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\x83\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],

        ["\xA5\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\x83\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],

        ["\xA5\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\x83\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],

        ["\xA5\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\x83\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],

        ["\xA5\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\x83\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],

        ["\xA5\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\x83\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],

        ["\xA5\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\x83\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],

        ["\xA5\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\x83\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],

        ["\xA5\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\x83\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],

        ["\xA6\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\x83\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],

        ["\xA6\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\x83\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],

        ["\xA6\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\x83\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],

        ["\xA6\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\x83\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],

        ["\xA6\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\x83\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],

        ["\xA6\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\x83\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],

        ["\xA6\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\x83\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],

        ["\xA6\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\x83\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],

        ["\xA6\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\x83\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],

        ["\xA6\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\x83\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],

        ["\xA6\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\x83\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],

        ["\xA6\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\x83\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],

        ["\xA6\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\x83\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],

        ["\xA6\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\x83\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],

        ["\xA6\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\x83\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],

        ["\xA6\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\x83\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],

        ["\xA6\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\x83\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],

        ["\xA6\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\x83\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],

        ["\xA6\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\x83\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],

        ["\xA6\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\x83\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],

        ["\xA6\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\x83\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],

        ["\xA6\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\x83\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],

        ["\xA6\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\x83\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],

        ["\xA6\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\x83\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],

        ["\xA6\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\x83\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],

        ["\xA6\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\x83\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],

        ["\xA6\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\x83\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],

        ["\xA6\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\x83\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],

        ["\xA6\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\x83\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],

        ["\xA6\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\x83\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],

        ["\xA6\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\x83\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],

        ["\xA6\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\x83\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],

        ["\xA6\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\x83\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],

        ["\xA6\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\x83\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],

        ["\xA6\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\x83\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],

        ["\xA6\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\x83\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],

        ["\xA6\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\x83\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],

        ["\xA6\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\x83\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],

        ["\xA6\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\x83\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],

        ["\xA6\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\x83\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],

        ["\xA6\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\x83\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],

        ["\xA6\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\x83\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],

        ["\xA6\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\x83\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],

        ["\xA6\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\x83\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],

        ["\xA6\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\x83\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],

        ["\xA6\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\x83\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],

        ["\xA6\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\x83\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],

        ["\xA6\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\x83\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],

        ["\xA7\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\x84\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],

        ["\xA7\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\x84\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],

        ["\xA7\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\x84\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],

        ["\xA7\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\x84\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],

        ["\xA7\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\x84\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],

        ["\xA7\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\x84\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],

        ["\xA7\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\x84\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],

        ["\xA7\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\x84\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],

        ["\xA7\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\x84\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],

        ["\xA7\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\x84\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],

        ["\xA7\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\x84\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],

        ["\xA7\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\x84\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],

        ["\xA7\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\x84\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],

        ["\xA7\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\x84\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],

        ["\xA7\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\x84\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],

        ["\xA7\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\x84\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],

        ["\xA7\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\x84\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],

        ["\xA7\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\x84\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],

        ["\xA7\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\x84\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],

        ["\xA7\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\x84\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],

        ["\xA7\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\x84\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],

        ["\xA7\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\x84\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],

        ["\xA7\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\x84\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],

        ["\xA7\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\x84\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],

        ["\xA7\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\x84\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],

        ["\xA7\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\x84\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],

        ["\xA7\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\x84\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],

        ["\xA7\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\x84\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],

        ["\xA7\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\x84\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],

        ["\xA7\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\x84\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],

        ["\xA7\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\x84\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],

        ["\xA7\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\x84\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],

        ["\xA7\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\x84\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],

        ["\xA7\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\x84\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],

        ["\xA7\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\x84\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],

        ["\xA7\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\x84\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],

        ["\xA7\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\x84\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],

        ["\xA7\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\x84\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],

        ["\xA7\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\x84\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],

        ["\xA7\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\x84\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],

        ["\xA7\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\x84\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],

        ["\xA7\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\x84\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],

        ["\xA7\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\x84\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],

        ["\xA7\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\x84\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],

        ["\xA7\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\x84\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],

        ["\xA7\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\x84\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],

        ["\xA7\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\x84\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],

        ["\xA7\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\x84\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],

        ["\xA7\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\x84\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],

        ["\xA7\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\x84\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],

        ["\xA7\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\x84\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],

        ["\xA7\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\x84\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],

        ["\xA7\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\x84\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],

        ["\xA7\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\x84\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],

        ["\xA7\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\x84\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],

        ["\xA7\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\x84\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],

        ["\xA7\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\x84\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],

        ["\xA7\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\x84\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],

        ["\xA7\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\x84\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],

        ["\xA7\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\x84\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],

        ["\xA7\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\x84\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],

        ["\xA7\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\x84\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],

        ["\xA7\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\x84\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],

        ["\xA7\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\x84\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],

        ["\xA7\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\x84\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],

        ["\xA7\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\x84\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],

        ["\xA8\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\x84\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],

        ["\xA8\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\x84\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],

        ["\xA8\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\x84\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],

        ["\xA8\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\x84\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],

        ["\xA8\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\x84\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],

        ["\xA8\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\x84\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],

        ["\xA8\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\x84\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],

        ["\xA8\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\x84\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],

        ["\xA8\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\x84\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],

        ["\xA8\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\x84\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],

        ["\xA8\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\x84\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],

        ["\xA8\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\x84\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],

        ["\xA8\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\x84\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],

        ["\xA8\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\x84\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],

        ["\xA8\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\x84\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],

        ["\xA8\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\x84\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],

        ["\xA8\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\x84\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],

        ["\xA8\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\x84\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],

        ["\xA8\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\x84\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],

        ["\xA8\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\x84\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],

        ["\xA8\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\x84\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],

        ["\xA8\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\x84\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],

        ["\xA8\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\x84\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],

        ["\xA8\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\x84\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],

        ["\xA8\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\x84\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],

        ["\xA8\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\x84\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],

        ["\xA8\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\x84\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],

        ["\xA8\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\x84\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],

        ["\xA8\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\x84\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],

        ["\xA8\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\x84\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],

        ["\xA8\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\x84\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],

        ["\xA8\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\x84\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],

        ["\x76\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\x87\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB1"],

        ["\x76\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\x87\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB2"],

        ["\x76\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\x87\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB3"],

        ["\x76\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\x87\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB4"],

        ["\x76\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\x87\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB5"],

        ["\x76\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\x87\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB6"],

        ["\x76\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\x87\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB7"],

        ["\x76\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\x87\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB8"],

        ["\x76\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\x87\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xB9"],

        ["\x76\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\x87\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x76\xBA"],

        ["\x77\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\x87\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"],

        ["\x77\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\x87\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA2"],

        ["\x77\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\x87\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA3"],

        ["\x77\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\x87\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA4"],

        ["\x77\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\x87\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA5"],

        ["\x77\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\x87\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA6"],

        ["\x77\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\x87\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA7"],

        ["\x77\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\x87\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA8"],

        ["\x77\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\x87\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xA9"],

        ["\x77\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\x87\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x77\xAA"],

        ["\x74\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\x87\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB1"],

        ["\x74\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\x87\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB2"],

        ["\x74\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\x87\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB3"],

        ["\x74\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\x87\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB4"],

        ["\x74\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\x87\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB5"],

        ["\x74\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\x87\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB6"],

        ["\x74\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\x87\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB7"],

        ["\x74\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\x87\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB8"],

        ["\x74\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\x87\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xB9"],

        ["\x74\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\x87\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\xBA"],

        ["\x70\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\x87\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"],

        ["\x70\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\x87\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],

        ["\x70\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\x87\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],

        ["\x70\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\x87\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],

        ["\x70\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\x87\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],

        ["\x70\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\x87\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],

        ["\x70\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\x87\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],

        ["\x70\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\x87\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],

        ["\x7D\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\x87\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x7D\xA1"],

        ["\x70\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\x87\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xDB"],

        ["\x70\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\x87\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xDC"],

        ["\x70\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\x87\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],

        ["\x70\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\x87\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"],

        ["\x70\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\x87\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],

        ["\x70\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\x87\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xDA"],

        ["\x70\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\x87\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"],

        ["\x6F\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\x87\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xCC"],

        ["\x6F\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\x87\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xCB"],

        ["\x6F\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\x87\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xCA"],

        ["\x6F\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\x87\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xDA"],

        ["\x6F\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\x87\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],

        ["\x6F\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\x87\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xFA"],

        ["\x6F\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\x87\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],

        ["\x73\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\x87\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],

        ["\x7D\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\x87\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x7D\xA2"],

        ["\x7D\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\x87\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x7D\xA3"],

        ["\x72\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\x87\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\xBE"],

        ["\x72\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\x87\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\xB6"],

        ["\x72\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\x87\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\xB8"],

        ["\x73\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\x87\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xEA"],

        ["\x73\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\x87\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xEB"],

        ["\x73\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\x87\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xEC"],

        ["\x73\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\x87\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xED"],

        ["\x73\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\x87\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xEE"],

        ["\x73\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\x87\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],

        ["\x73\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\x87\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xB1"],

        ["\x73\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\x87\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\xBD"],

        ["\x72\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\x87\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],

        ["\x72\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\x87\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],

        ["\x72\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\x87\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],

        ["\x6F\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\x87\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xB8"],

        ["\x6F\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x94"],
        ["\x87\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xA2"],

        ["\x6F\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\x87\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xB7"],

        ["\x6F\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\x87\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\xBA"],

        ["\xB0\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\x88\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],

        ["\xB0\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\x88\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],

        ["\xB0\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\x88\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],

        ["\xB0\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\x88\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],

        ["\xB0\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\x88\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],

        ["\xB0\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\x88\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],

        ["\xB0\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\x88\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],

        ["\xB0\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\x88\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],

        ["\xB0\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\x88\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],

        ["\xB0\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\x88\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],

        ["\xB0\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\x88\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],

        ["\xB0\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\x88\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],

        ["\xB0\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\x88\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],

        ["\xB0\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\x88\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],

        ["\xB0\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\x88\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],

        ["\xB0\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\x88\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],

        ["\xB0\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\x88\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],

        ["\xB0\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\x88\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],

        ["\xB0\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\x88\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],

        ["\xB0\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\x88\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],

        ["\xB0\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\x88\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],

        ["\xB0\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\x88\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],

        ["\xB0\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\x88\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],

        ["\xB0\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\x88\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],

        ["\xB0\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\x88\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],

        ["\xB0\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\x88\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],

        ["\xB0\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\x88\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],

        ["\xB0\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\x88\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],

        ["\xB0\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\x88\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],

        ["\xB0\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\x88\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],

        ["\xB0\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\x88\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],

        ["\xB0\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\x88\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],

        ["\xB0\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\x88\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],

        ["\xB0\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\x88\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],

        ["\xB0\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\x88\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],

        ["\xB0\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\x88\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],

        ["\xB0\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\x88\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],

        ["\xB0\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\x88\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],

        ["\xB0\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\x88\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],

        ["\xB0\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\x88\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],

        ["\xB0\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\x88\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],

        ["\xB0\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\x88\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],

        ["\xB0\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\x88\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],

        ["\xB0\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\x88\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],

        ["\xB0\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\x88\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],

        ["\xB0\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\x88\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],

        ["\xB0\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\x88\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],

        ["\xB0\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\x88\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],

        ["\xB0\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\x88\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],

        ["\xB0\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\x88\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],

        ["\xB0\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\x88\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],

        ["\xB0\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\x88\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],

        ["\xB0\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\x88\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],

        ["\xB0\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\x88\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],

        ["\xB0\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\x88\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],

        ["\xB0\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\x88\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],

        ["\xB0\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\x88\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],

        ["\xB0\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\x88\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],

        ["\xB0\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\x88\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],

        ["\xB0\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\x88\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],

        ["\xB0\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\x88\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],

        ["\xB0\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\x88\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],

        ["\xB0\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\x88\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],

        ["\xB0\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\x88\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],

        ["\xB0\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\x88\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],

        ["\xB0\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\x88\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],

        ["\xB0\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\x88\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],

        ["\xB0\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\x88\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],

        ["\xB0\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\x88\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],

        ["\xB0\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\x88\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],

        ["\xB0\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\x88\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],

        ["\xB0\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\x88\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],

        ["\xB0\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\x88\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],

        ["\xB0\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\x88\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],

        ["\xB0\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\x88\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],

        ["\xB0\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\x88\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],

        ["\xB0\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\x88\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],

        ["\xB0\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\x88\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],

        ["\xB0\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\x88\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],

        ["\xB0\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\x88\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],

        ["\xB0\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\x88\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],

        ["\xB0\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\x88\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],

        ["\xB0\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\x88\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],

        ["\xB0\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\x88\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],

        ["\xB0\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\x88\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],

        ["\xB0\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\x88\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],

        ["\xB0\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\x88\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],

        ["\xB0\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\x88\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],

        ["\xB0\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\x88\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],

        ["\xB0\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\x88\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],

        ["\xB0\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\x88\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],

        ["\xB0\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\x88\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],

        ["\xB0\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\x88\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],

        ["\xB0\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\x88\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],

        ["\xB1\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\x89\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],

        ["\xB1\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\x89\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],

        ["\xB1\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\x89\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],

        ["\xB1\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\x89\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],

        ["\xB1\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\x89\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],

        ["\xB1\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\x89\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],

        ["\xB1\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\x89\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],

        ["\xB1\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\x89\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],

        ["\xB1\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\x89\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],

        ["\xB1\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\x89\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],

        ["\xB1\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\x89\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],

        ["\xB1\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\x89\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],

        ["\xB1\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\x89\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],

        ["\xB1\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\x89\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],

        ["\xB1\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\x89\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],

        ["\xB1\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\x89\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],

        ["\xB1\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\x89\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],

        ["\xB1\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\x89\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],

        ["\xB1\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\x89\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],

        ["\xB1\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\x89\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],

        ["\xB1\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\x89\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],

        ["\xB1\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\x89\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],

        ["\xB1\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\x89\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],

        ["\xB1\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\x89\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],

        ["\xB1\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\x89\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],

        ["\xB1\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\x89\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],

        ["\xB1\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\x89\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],

        ["\xB1\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\x89\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],

        ["\xB1\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\x89\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],

        ["\xB1\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\x89\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],

        ["\xB1\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\x89\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],

        ["\xB1\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\x89\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],

        ["\xB1\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\x89\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],

        ["\xB1\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\x89\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],

        ["\xB1\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\x89\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],

        ["\xB1\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\x89\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],

        ["\xB1\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\x89\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],

        ["\xB1\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\x89\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],

        ["\xB1\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\x89\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],

        ["\xB1\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\x89\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],

        ["\xB1\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\x89\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],

        ["\xB1\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\x89\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],

        ["\xB1\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\x89\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],

        ["\xB1\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\x89\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],

        ["\xB1\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\x89\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],

        ["\xB1\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\x89\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],

        ["\xB1\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\x89\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],

        ["\xB1\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\x89\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],

        ["\xB1\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\x89\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],

        ["\xB1\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\x89\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],

        ["\xB1\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\x89\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],

        ["\xB1\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\x89\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],

        ["\xB1\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\x89\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],

        ["\xB1\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\x89\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],

        ["\xB1\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\x89\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],

        ["\xB1\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\x89\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],

        ["\xB1\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\x89\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],

        ["\xB1\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\x89\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],

        ["\xB1\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\x89\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],

        ["\xB1\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\x89\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],

        ["\xB1\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\x89\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],

        ["\xB1\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\x89\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],

        ["\xB1\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\x89\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],

        ["\xB1\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\x89\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],

        ["\xB1\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\x89\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],

        ["\xB1\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\x89\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],

        ["\xB1\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\x89\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],

        ["\xB1\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\x89\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],

        ["\xB1\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\x89\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],

        ["\xB1\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\x89\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],

        ["\xB1\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\x89\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],

        ["\xB1\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\x89\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],

        ["\xB1\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\x89\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],

        ["\xB1\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\x89\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],

        ["\xB1\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\x89\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],

        ["\xB1\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\x89\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],

        ["\xB1\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\x89\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],

        ["\xB1\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\x89\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],

        ["\xB1\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\x89\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],

        ["\xB1\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\x89\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],

        ["\xB1\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\x89\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],

        ["\xB1\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\x89\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],

        ["\xB1\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\x89\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],

        ["\xB1\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\x89\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],

        ["\xB1\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\x89\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],

        ["\xB1\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\x89\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],

        ["\xB1\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\x89\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],

        ["\xB1\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\x89\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],

        ["\xB1\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\x89\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],

        ["\xB1\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\x89\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],

        ["\xB1\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\x89\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],

        ["\xB1\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\x89\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],

        ["\xB1\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\x89\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],

        ["\xB1\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\x89\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],

        ["\xB2\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\x89\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],

        ["\xB2\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\x89\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],

        ["\xB2\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\x89\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],

        ["\xB2\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\x89\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],

        ["\xB2\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\x89\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],

        ["\xB2\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\x89\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],

        ["\xB2\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\x89\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],

        ["\xB2\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\x89\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],

        ["\xB2\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\x89\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],

        ["\xB2\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\x89\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],

        ["\xB2\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\x89\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],

        ["\xB2\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\x89\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],

        ["\xB2\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\x89\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],

        ["\xB2\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\x89\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],

        ["\xB2\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\x89\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],

        ["\xB2\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\x89\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],

        ["\xB2\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\x89\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],

        ["\xB2\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\x89\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],

        ["\xB2\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\x89\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],

        ["\xB2\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\x89\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],

        ["\xB2\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\x89\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],

        ["\xB2\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\x89\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],

        ["\xB2\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\x89\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],

        ["\xB2\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\x89\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],

        ["\xB2\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\x89\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],

        ["\xB2\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\x89\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],

        ["\xB2\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\x89\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],

        ["\xB2\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\x89\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],

        ["\xB2\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\x89\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],

        ["\xB2\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\x89\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],

        ["\xB2\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\x89\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],

        ["\xB2\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\x89\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],

        ["\xB2\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\x89\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],

        ["\xB2\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\x89\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],

        ["\xB2\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\x89\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],

        ["\xB2\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\x89\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],

        ["\xB2\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\x89\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],

        ["\xB2\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\x89\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],

        ["\xB2\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\x89\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],

        ["\xB2\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\x89\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],

        ["\xB2\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\x89\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],

        ["\xB2\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\x89\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],

        ["\xB2\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\x89\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],

        ["\xB2\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\x89\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],

        ["\xB2\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\x89\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],

        ["\xB2\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\x89\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],

        ["\xB2\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\x89\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],

        ["\xB2\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\x89\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],

        ["\xB2\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\x89\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],

        ["\xB2\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\x89\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],

        ["\xB2\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\x89\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],

        ["\xB2\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\x89\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],

        ["\xB2\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\x89\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],

        ["\xB2\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\x89\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],

        ["\xB2\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\x89\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],

        ["\xB2\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\x89\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],

        ["\xB2\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\x89\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],

        ["\xB2\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\x89\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],

        ["\xB2\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\x89\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],

        ["\xB2\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\x89\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],

        ["\xB2\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\x89\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],

        ["\xB2\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\x89\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],

        ["\xB2\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\x89\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],

        ["\xB2\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\x89\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],

        ["\xB2\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\x89\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],

        ["\xB2\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\x89\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],

        ["\xB2\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\x89\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],

        ["\xB2\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\x89\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],

        ["\xB2\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\x89\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],

        ["\xB2\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\x89\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],

        ["\xB2\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\x89\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],

        ["\xB2\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\x89\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],

        ["\xB2\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\x89\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],

        ["\xB2\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\x89\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],

        ["\xB2\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\x89\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],

        ["\xB2\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\x89\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],

        ["\xB2\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\x89\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],

        ["\xB2\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\x89\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],

        ["\xB2\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\x89\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],

        ["\xB2\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\x89\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],

        ["\xB2\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\x89\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],

        ["\xB2\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\x89\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],

        ["\xB2\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\x89\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],

        ["\xB2\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\x89\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],

        ["\xB2\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\x89\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],

        ["\xB2\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\x89\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],

        ["\xB2\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\x89\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],

        ["\xB2\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\x89\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],

        ["\xB2\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\x89\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],

        ["\xB2\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\x89\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],

        ["\xB2\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\x89\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],

        ["\xB2\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\x89\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],

        ["\xB2\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\x89\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],

        ["\xB2\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\x89\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],

        ["\xB3\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\x8A\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],

        ["\xB3\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\x8A\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],

        ["\xB3\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\x8A\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],

        ["\xB3\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\x8A\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],

        ["\xB3\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\x8A\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],

        ["\xB3\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\x8A\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],

        ["\xB3\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\x8A\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],

        ["\xB3\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\x8A\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],

        ["\xB3\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\x8A\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],

        ["\xB3\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\x8A\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],

        ["\xB3\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\x8A\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],

        ["\xB3\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\x8A\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],

        ["\xB3\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\x8A\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],

        ["\xB3\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\x8A\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],

        ["\xB3\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\x8A\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],

        ["\xB3\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\x8A\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],

        ["\xB3\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\x8A\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],

        ["\xB3\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\x8A\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],

        ["\xB3\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\x8A\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],

        ["\xB3\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\x8A\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],

        ["\xB3\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\x8A\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],

        ["\xB3\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\x8A\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],

        ["\xB3\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\x8A\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],

        ["\xB3\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\x8A\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],

        ["\xB3\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\x8A\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],

        ["\xB3\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\x8A\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],

        ["\xB3\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\x8A\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],

        ["\xB3\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\x8A\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],

        ["\xB3\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\x8A\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],

        ["\xB3\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\x8A\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],

        ["\xB3\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\x8A\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],

        ["\xB3\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\x8A\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],

        ["\xB3\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\x8A\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],

        ["\xB3\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\x8A\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],

        ["\xB3\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\x8A\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],

        ["\xB3\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\x8A\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],

        ["\xB3\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\x8A\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],

        ["\xB3\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\x8A\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],

        ["\xB3\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\x8A\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],

        ["\xB3\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\x8A\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],

        ["\xB3\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\x8A\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],

        ["\xB3\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\x8A\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],

        ["\xB3\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\x8A\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],

        ["\xB3\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\x8A\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],

        ["\xB3\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\x8A\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],

        ["\xB3\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\x8A\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],

        ["\xB3\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\x8A\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],

        ["\xB3\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\x8A\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],

        ["\xB3\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\x8A\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],

        ["\xB3\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\x8A\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],

        ["\xB3\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\x8A\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],

        ["\xB3\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\x8A\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],

        ["\xB3\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\x8A\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],

        ["\xB3\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\x8A\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],

        ["\xB3\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\x8A\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],

        ["\xB3\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\x8A\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],

        ["\xB3\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\x8A\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],

        ["\xB3\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\x8A\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],

        ["\xB3\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\x8A\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],

        ["\xB3\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\x8A\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],

        ["\xB3\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\x8A\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],

        ["\xB3\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\x8A\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],

        ["\xB3\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\x8A\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],

        ["\xB3\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\x8A\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],

        ["\xB3\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\x8A\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],

        ["\xB3\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\x8A\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],

        ["\xB3\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\x8A\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],

        ["\xB3\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\x8A\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],

        ["\xB3\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\x8A\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],

        ["\xB3\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\x8A\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],

        ["\xB3\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\x8A\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],

        ["\xB3\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\x8A\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],

        ["\xB3\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\x8A\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],

        ["\xB3\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\x8A\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],

        ["\xB3\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\x8A\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],

        ["\xB3\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\x8A\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],

        ["\xB3\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\x8A\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],

        ["\xB3\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\x8A\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],

        ["\xB3\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\x8A\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],

        ["\xB3\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\x8A\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],

        ["\xB3\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\x8A\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],

        ["\xB3\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\x8A\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],

        ["\xB3\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\x8A\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],

        ["\xB3\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\x8A\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],

        ["\xB3\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\x8A\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],

        ["\xB3\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\x8A\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],

        ["\xB3\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\x8A\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],

        ["\xB3\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\x8A\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],

        ["\xB3\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\x8A\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],

        ["\xB3\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\x8A\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],

        ["\xB3\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\x8A\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],

        ["\xB3\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\x8A\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],

        ["\xB3\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\x8A\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],

        ["\xB3\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\x8A\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],

        ["\xB4\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\x8A\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],

        ["\xB4\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\x8A\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],

        ["\xB4\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\x8A\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],

        ["\xB4\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\x8A\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],

        ["\xB4\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\x8A\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],

        ["\xB4\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\x8A\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],

        ["\xB4\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\x8A\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],

        ["\xB4\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\x8A\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],

        ["\xB4\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\x8A\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],

        ["\xB4\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\x8A\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],

        ["\xB4\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\x8A\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],

        ["\xB4\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\x8A\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],

        ["\xB4\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\x8A\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],

        ["\xB4\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\x8A\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],

        ["\xB4\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\x8A\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],

        ["\xB4\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\x8A\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],

        ["\xB4\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\x8A\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],

        ["\xB4\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\x8A\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],

        ["\xB4\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\x8A\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],

        ["\xB4\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\x8A\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],

        ["\xB4\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\x8A\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],

        ["\xB4\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\x8A\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],

        ["\xB4\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\x8A\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],

        ["\xB4\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\x8A\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],

        ["\xB4\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\x8A\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],

        ["\xB4\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\x8A\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],

        ["\xB4\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\x8A\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],

        ["\xB4\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\x8A\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],

        ["\xB4\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\x8A\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],

        ["\xB4\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\x8A\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],

        ["\xB4\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\x8A\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],

        ["\xB4\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\x8A\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],

        ["\xB4\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\x8A\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],

        ["\xB4\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\x8A\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],

        ["\xB4\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\x8A\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],

        ["\xB4\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\x8A\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],

        ["\xB4\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\x8A\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],

        ["\xB4\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\x8A\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],

        ["\xB4\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\x8A\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],

        ["\xB4\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\x8A\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],

        ["\xB4\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\x8A\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],

        ["\xB4\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\x8A\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],

        ["\xB4\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\x8A\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],

        ["\xB4\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\x8A\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],

        ["\xB4\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\x8A\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],

        ["\xB4\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\x8A\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],

        ["\xB4\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\x8A\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],

        ["\xB4\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\x8A\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],

        ["\xB4\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\x8A\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],

        ["\xB4\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\x8A\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],

        ["\xB4\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\x8A\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],

        ["\xB4\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\x8A\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],

        ["\xB4\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\x8A\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],

        ["\xB4\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\x8A\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],

        ["\xB4\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\x8A\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],

        ["\xB4\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\x8A\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],

        ["\xB4\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\x8A\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],

        ["\xB4\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\x8A\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],

        ["\xB4\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\x8A\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],

        ["\xB4\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\x8A\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],

        ["\xB4\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\x8A\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],

        ["\xB4\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\x8A\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],

        ["\xB4\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\x8A\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],

        ["\xB4\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\x8A\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],

        ["\xB4\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\x8A\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],

        ["\xB4\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\x8A\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],

        ["\xB4\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\x8A\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],

        ["\xB4\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\x8A\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],

        ["\xB4\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\x8A\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],

        ["\xB4\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\x8A\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],

        ["\xB4\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\x8A\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],

        ["\xB4\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\x8A\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],

        ["\xB4\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\x8A\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],

        ["\xB4\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\x8A\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],

        ["\xB4\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\x8A\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],

        ["\xB4\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\x8A\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],

        ["\xB4\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\x8A\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],

        ["\xB4\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\x8A\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],

        ["\xB4\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\x8A\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],

        ["\xB4\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\x8A\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],

        ["\xB4\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\x8A\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],

        ["\xB4\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\x8A\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],

        ["\xB4\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\x8A\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],

        ["\xB4\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\x8A\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],

        ["\xB4\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\x8A\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],

        ["\xB4\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\x8A\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],

        ["\xB4\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\x8A\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],

        ["\xB4\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\x8A\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],

        ["\xB4\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\x8A\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],

        ["\xB4\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\x8A\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],

        ["\xB4\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\x8A\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],

        ["\xB4\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\x8A\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],

        ["\xB4\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\x8A\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],

        ["\xB4\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\x8A\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],

        ["\xB5\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\x8B\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],

        ["\xB5\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\x8B\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],

        ["\xB5\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\x8B\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],

        ["\xB5\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\x8B\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],

        ["\xB5\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\x8B\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],

        ["\xB5\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\x8B\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],

        ["\xB5\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\x8B\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],

        ["\xB5\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\x8B\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],

        ["\xB5\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\x8B\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],

        ["\xB5\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\x8B\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],

        ["\xB5\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\x8B\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],

        ["\xB5\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\x8B\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],

        ["\xB5\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\x8B\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],

        ["\xB5\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\x8B\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],

        ["\xB5\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\x8B\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],

        ["\xB5\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\x8B\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],

        ["\xB5\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\x8B\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],

        ["\xB5\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\x8B\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],

        ["\xB5\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\x8B\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],

        ["\xB5\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\x8B\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],

        ["\xB5\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\x8B\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],

        ["\xB5\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\x8B\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],

        ["\xB5\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\x8B\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],

        ["\xB5\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\x8B\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],

        ["\xB5\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\x8B\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],

        ["\xB5\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\x8B\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],

        ["\xB5\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\x8B\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],

        ["\xB5\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\x8B\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],

        ["\xB5\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\x8B\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],

        ["\xB5\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\x8B\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],

        ["\xB5\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\x8B\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],

        ["\xB5\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\x8B\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],

        ["\xB5\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\x8B\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],

        ["\xB5\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\x8B\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],

        ["\xB5\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\x8B\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],

        ["\xB5\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\x8B\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],

        ["\xB5\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\x8B\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],

        ["\xB5\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\x8B\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],

        ["\xB5\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\x8B\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],

        ["\xB5\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\x8B\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],

        ["\xB5\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\x8B\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],

        ["\xB5\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\x8B\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],

        ["\xB5\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\x8B\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],

        ["\xB5\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\x8B\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],

        ["\xB5\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\x8B\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],

        ["\xB5\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\x8B\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],

        ["\xB5\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\x8B\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],

        ["\xB5\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\x8B\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],

        ["\xB5\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\x8B\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],

        ["\xB5\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\x8B\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],

        ["\xB5\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\x8B\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],

        ["\xB5\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\x8B\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],

        ["\xB5\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\x8B\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],

        ["\xB5\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\x8B\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],

        ["\xB5\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\x8B\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],

        ["\xB5\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\x8B\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],

        ["\xB5\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\x8B\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],

        ["\xB5\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\x8B\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],

        ["\xB5\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\x8B\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],

        ["\xB5\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\x8B\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],

        ["\xB5\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\x8B\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],

        ["\xB5\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\x8B\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],

        ["\xB5\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\x8B\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],

        ["\xB5\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\x8B\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],

        ["\xB5\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\x8B\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],

        ["\xB5\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\x8B\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],

        ["\xB5\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\x8B\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],

        ["\xB5\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\x8B\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],

        ["\xB5\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\x8B\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],

        ["\xB5\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\x8B\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],

        ["\xB5\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\x8B\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],

        ["\xB5\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\x8B\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],

        ["\xB5\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\x8B\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],

        ["\xB5\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\x8B\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],

        ["\xB5\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\x8B\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],

        ["\xB5\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\x8B\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],

        ["\xB5\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\x8B\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],

        ["\xB5\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\x8B\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],

        ["\xB5\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\x8B\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],

        ["\xB5\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\x8B\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],

        ["\xB5\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\x8B\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],

        ["\xB5\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\x8B\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],

        ["\xB5\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\x8B\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],

        ["\xB5\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\x8B\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],

        ["\xB5\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\x8B\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],

        ["\xB5\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\x8B\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],

        ["\xB5\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\x8B\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],

        ["\xB5\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\x8B\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],

        ["\xB5\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\x8B\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],

        ["\xB5\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\x8B\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],

        ["\xB5\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\x8B\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],

        ["\xB5\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\x8B\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],

        ["\xB5\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\x8B\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],

        ["\xB5\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\x8B\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],

        ["\xB6\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\x8B\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],

        ["\xB6\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\x8B\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],

        ["\xB6\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\x8B\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],

        ["\xB6\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\x8B\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],

        ["\xB6\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\x8B\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],

        ["\xB6\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\x8B\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],

        ["\xB6\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\x8B\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],

        ["\xB6\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\x8B\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],

        ["\xB6\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\x8B\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],

        ["\xB6\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\x8B\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],

        ["\xB6\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\x8B\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],

        ["\xB6\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\x8B\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],

        ["\xB6\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\x8B\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],

        ["\xB6\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\x8B\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],

        ["\xB6\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\x8B\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],

        ["\xB6\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\x8B\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],

        ["\xB6\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\x8B\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],

        ["\xB6\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\x8B\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],

        ["\xB6\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\x8B\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],

        ["\xB6\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\x8B\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],

        ["\xB6\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\x8B\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],

        ["\xB6\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\x8B\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],

        ["\xB6\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\x8B\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],

        ["\xB6\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\x8B\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],

        ["\xB6\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\x8B\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],

        ["\xB6\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\x8B\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],

        ["\xB6\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\x8B\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],

        ["\xB6\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\x8B\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],

        ["\xB6\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\x8B\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],

        ["\xB6\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\x8B\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],

        ["\xB6\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\x8B\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],

        ["\xB6\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\x8B\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],

        ["\xB6\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\x8B\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],

        ["\xB6\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\x8B\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],

        ["\xB6\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\x8B\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],

        ["\xB6\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\x8B\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],

        ["\xB6\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\x8B\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],

        ["\xB6\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\x8B\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],

        ["\xB6\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\x8B\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],

        ["\xB6\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\x8B\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],

        ["\xB6\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\x8B\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],

        ["\xB6\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\x8B\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],

        ["\xB6\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\x8B\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],

        ["\xB6\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\x8B\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],

        ["\xB6\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\x8B\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],

        ["\xB6\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\x8B\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],

        ["\xB6\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\x8B\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],

        ["\xB6\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\x8B\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],

        ["\xB6\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\x8B\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],

        ["\xB6\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\x8B\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],

        ["\xB6\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\x8B\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],

        ["\xB6\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\x8B\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],

        ["\xB6\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\x8B\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],

        ["\xB6\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\x8B\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],

        ["\xB6\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\x8B\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],

        ["\xB6\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\x8B\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],

        ["\xB6\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\x8B\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],

        ["\xB6\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\x8B\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],

        ["\xB6\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\x8B\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],

        ["\xB6\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\x8B\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],

        ["\xB6\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\x8B\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],

        ["\xB6\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\x8B\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],

        ["\xB6\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\x8B\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],

        ["\xB6\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\x8B\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],

        ["\xB6\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\x8B\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],

        ["\xB6\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\x8B\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],

        ["\xB6\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\x8B\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],

        ["\xB6\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\x8B\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],

        ["\xB6\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\x8B\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],

        ["\xB6\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\x8B\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],

        ["\xB6\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\x8B\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],

        ["\xB6\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\x8B\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],

        ["\xB6\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\x8B\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],

        ["\xB6\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\x8B\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],

        ["\xB6\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\x8B\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],

        ["\xB6\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\x8B\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],

        ["\xB6\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\x8B\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],

        ["\xB6\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\x8B\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],

        ["\xB6\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\x8B\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],

        ["\xB6\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\x8B\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],

        ["\xB6\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\x8B\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],

        ["\xB6\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\x8B\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],

        ["\xB6\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\x8B\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],

        ["\xB6\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\x8B\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],

        ["\xB6\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\x8B\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],

        ["\xB6\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\x8B\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],

        ["\xB6\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\x8B\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],

        ["\xB6\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\x8B\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],

        ["\xB6\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\x8B\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],

        ["\xB6\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\x8B\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],

        ["\xB6\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\x8B\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],

        ["\xB6\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\x8B\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],

        ["\xB6\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\x8B\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],

        ["\xB6\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\x8B\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],

        ["\xB7\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\x8C\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],

        ["\xB7\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\x8C\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],

        ["\xB7\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\x8C\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],

        ["\xB7\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\x8C\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],

        ["\xB7\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\x8C\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],

        ["\xB7\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\x8C\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],

        ["\xB7\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\x8C\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],

        ["\xB7\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\x8C\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],

        ["\xB7\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\x8C\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],

        ["\xB7\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\x8C\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],

        ["\xB7\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\x8C\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],

        ["\xB7\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\x8C\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],

        ["\xB7\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\x8C\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],

        ["\xB7\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\x8C\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],

        ["\xB7\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\x8C\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],

        ["\xB7\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\x8C\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],

        ["\xB7\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\x8C\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],

        ["\xB7\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\x8C\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],

        ["\xB7\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\x8C\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],

        ["\xB7\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\x8C\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],

        ["\xB7\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\x8C\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],

        ["\xB7\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\x8C\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],

        ["\xB7\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\x8C\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],

        ["\xB7\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\x8C\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],

        ["\xB7\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\x8C\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],

        ["\xB7\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\x8C\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],

        ["\xB7\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\x8C\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],

        ["\xB7\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\x8C\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],

        ["\xB7\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\x8C\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],

        ["\xB7\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\x8C\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],

        ["\xB7\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\x8C\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],

        ["\xB7\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\x8C\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],

        ["\xB7\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\x8C\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],

        ["\xB7\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\x8C\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],

        ["\xB7\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\x8C\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],

        ["\xB7\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\x8C\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],

        ["\xB7\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\x8C\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],

        ["\xB7\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\x8C\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],

        ["\xB7\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\x8C\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],

        ["\xB7\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\x8C\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],

        ["\xB7\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\x8C\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],

        ["\xB7\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\x8C\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],

        ["\xB7\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\x8C\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],

        ["\xB7\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\x8C\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],

        ["\xB7\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\x8C\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],

        ["\xB7\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\x8C\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],

        ["\xB7\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\x8C\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],

        ["\xB7\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\x8C\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],

        ["\xB7\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\x8C\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],

        ["\xB7\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\x8C\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],

        ["\xB7\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\x8C\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],

        ["\xB7\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\x8C\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],

        ["\xB7\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\x8C\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],

        ["\xB7\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\x8C\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],

        ["\xB7\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\x8C\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],

        ["\xB7\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\x8C\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],

        ["\xB7\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\x8C\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],

        ["\xB7\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\x8C\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],

        ["\xB7\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\x8C\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],

        ["\xB7\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\x8C\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],

        ["\xB7\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\x8C\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],

        ["\xB7\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\x8C\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],

        ["\xB7\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\x8C\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],

        ["\xB7\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\x8C\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],

        ["\xB7\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\x8C\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],

        ["\xB7\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\x8C\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],

        ["\xB7\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\x8C\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],

        ["\xB7\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\x8C\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],

        ["\xB7\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\x8C\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],

        ["\xB7\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\x8C\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],

        ["\xB7\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\x8C\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],

        ["\xB7\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\x8C\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],

        ["\xB7\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\x8C\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],

        ["\xB7\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\x8C\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],

        ["\xB7\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\x8C\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],

        ["\xB7\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\x8C\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],

        ["\xB7\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\x8C\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],

        ["\xB7\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\x8C\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],

        ["\xB7\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\x8C\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],

        ["\xB7\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\x8C\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],

        ["\xB7\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\x8C\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],

        ["\xB7\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\x8C\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],

        ["\xB7\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\x8C\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],

        ["\xB7\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\x8C\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],

        ["\xB7\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\x8C\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],

        ["\xB7\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\x8C\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],

        ["\xB7\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\x8C\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],

        ["\xB7\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\x8C\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],

        ["\xB7\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\x8C\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],

        ["\xB7\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\x8C\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],

        ["\xB7\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\x8C\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],

        ["\xB7\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\x8C\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],

        ["\xB7\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\x8C\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],

        ["\xB7\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\x8C\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],

        ["\xB8\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\x8C\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],

        ["\xB8\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\x8C\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],

        ["\xB8\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\x8C\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],

        ["\xB8\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\x8C\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],

        ["\xB8\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\x8C\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],

        ["\xB8\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\x8C\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],

        ["\xB8\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\x8C\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],

        ["\xB8\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\x8C\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],

        ["\xB8\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\x8C\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],

        ["\xB8\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\x8C\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],

        ["\xB8\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\x8C\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],

        ["\xB8\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\x8C\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],

        ["\xB8\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\x8C\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],

        ["\xB8\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\x8C\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],

        ["\xB8\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\x8C\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],

        ["\xB8\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\x8C\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],

        ["\xB8\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\x8C\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],

        ["\xB8\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\x8C\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],

        ["\xB8\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\x8C\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],

        ["\xB8\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\x8C\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],

        ["\xB8\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\x8C\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],

        ["\xB8\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\x8C\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],

        ["\xB8\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\x8C\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],

        ["\xB8\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\x8C\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],

        ["\xB8\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\x8C\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],

        ["\xB8\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\x8C\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],

        ["\xB8\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\x8C\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],

        ["\xB8\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\x8C\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],

        ["\xB8\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\x8C\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],

        ["\xB8\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\x8C\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],

        ["\xB8\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\x8C\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],

        ["\xB8\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\x8C\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],

        ["\xB8\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\x8C\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],

        ["\xB8\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\x8C\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],

        ["\xB8\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\x8C\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],

        ["\xB8\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\x8C\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],

        ["\xB8\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\x8C\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],

        ["\xB8\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\x8C\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],

        ["\xB8\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\x8C\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],

        ["\xB8\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\x8C\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],

        ["\xB8\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\x8C\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],

        ["\xB8\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\x8C\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],

        ["\xB8\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\x8C\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],

        ["\xB8\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\x8C\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],

        ["\xB8\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\x8C\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],

        ["\xB8\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\x8C\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],

        ["\xB8\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\x8C\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],

        ["\xB8\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\x8C\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],

        ["\xB8\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\x8C\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],

        ["\xB8\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\x8C\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],

        ["\xB8\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\x8C\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],

        ["\xB8\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\x8C\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],

        ["\xB8\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\x8C\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],

        ["\xB8\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\x8C\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],

        ["\xB8\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\x8C\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],

        ["\xB8\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\x8C\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],

        ["\xB8\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\x8C\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],

        ["\xB8\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\x8C\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],

        ["\xB8\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\x8C\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],

        ["\xB8\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\x8C\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],

        ["\xB8\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\x8C\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],

        ["\xB8\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\x8C\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],

        ["\xB8\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\x8C\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],

        ["\xB8\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\x8C\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],

        ["\xB8\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\x8C\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],

        ["\xB8\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\x8C\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],

        ["\xB8\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\x8C\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],

        ["\xB8\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\x8C\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],

        ["\xB8\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\x8C\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],

        ["\xB8\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\x8C\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],

        ["\xB8\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\x8C\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],

        ["\xB8\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\x8C\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],

        ["\xB8\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\x8C\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],

        ["\xB8\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\x8C\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],

        ["\xB8\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\x8C\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],

        ["\xB8\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\x8C\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],

        ["\xB8\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\x8C\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],

        ["\xB8\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\x8C\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],

        ["\xB8\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\x8C\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],

        ["\xB8\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\x8C\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],

        ["\xB8\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\x8C\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],

        ["\xB8\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\x8C\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],

        ["\xB8\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\x8C\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],

        ["\xB8\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\x8C\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],

        ["\xB8\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\x8C\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],

        ["\xB8\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\x8C\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],

        ["\xB8\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\x8C\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],

        ["\xB8\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\x8C\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],

        ["\xB8\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\x8C\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],

        ["\xB8\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\x8C\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],

        ["\xB8\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\x8C\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],

        ["\xB8\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\x8C\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],

        ["\xB8\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\x8C\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],

        ["\xB8\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\x8C\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],

        ["\xB9\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\x8D\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],

        ["\xB9\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\x8D\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],

        ["\xB9\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\x8D\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],

        ["\xB9\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\x8D\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],

        ["\xB9\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\x8D\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],

        ["\xB9\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\x8D\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],

        ["\xB9\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\x8D\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],

        ["\xB9\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\x8D\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],

        ["\xB9\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\x8D\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],

        ["\xB9\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\x8D\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],

        ["\xB9\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\x8D\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],

        ["\xB9\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\x8D\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],

        ["\xB9\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\x8D\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],

        ["\xB9\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\x8D\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],

        ["\xB9\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\x8D\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],

        ["\xB9\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\x8D\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],

        ["\xB9\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\x8D\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],

        ["\xB9\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\x8D\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],

        ["\xB9\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\x8D\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],

        ["\xB9\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\x8D\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],

        ["\xB9\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\x8D\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],

        ["\xB9\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\x8D\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],

        ["\xB9\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\x8D\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],

        ["\xB9\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\x8D\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],

        ["\xB9\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\x8D\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],

        ["\xB9\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\x8D\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],

        ["\xB9\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\x8D\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],

        ["\xB9\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\x8D\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],

        ["\xB9\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\x8D\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],

        ["\xB9\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\x8D\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],

        ["\xB9\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\x8D\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],

        ["\xB9\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\x8D\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],

        ["\xB9\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\x8D\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],

        ["\xB9\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\x8D\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],

        ["\xB9\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\x8D\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],

        ["\xB9\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\x8D\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],

        ["\xB9\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\x8D\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],

        ["\xB9\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\x8D\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],

        ["\xB9\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\x8D\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],

        ["\xB9\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\x8D\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],

        ["\xB9\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\x8D\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],

        ["\xB9\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\x8D\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],

        ["\xB9\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\x8D\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],

        ["\xB9\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\x8D\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],

        ["\xB9\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\x8D\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],

        ["\xB9\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\x8D\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],

        ["\xB9\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\x8D\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],

        ["\xB9\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\x8D\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],

        ["\xB9\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\x8D\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],

        ["\xB9\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\x8D\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],

        ["\xB9\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\x8D\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],

        ["\xB9\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\x8D\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],

        ["\xB9\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\x8D\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],

        ["\xB9\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\x8D\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],

        ["\xB9\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\x8D\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],

        ["\xB9\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\x8D\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],

        ["\xB9\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\x8D\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],

        ["\xB9\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\x8D\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],

        ["\xB9\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\x8D\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],

        ["\xB9\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\x8D\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],

        ["\xB9\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\x8D\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],

        ["\xB9\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\x8D\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],

        ["\xB9\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\x8D\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],

        ["\xB9\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\x8D\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],

        ["\xB9\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\x8D\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],

        ["\xB9\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\x8D\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],

        ["\xB9\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\x8D\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],

        ["\xB9\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\x8D\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],

        ["\xB9\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\x8D\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],

        ["\xB9\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\x8D\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],

        ["\xB9\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\x8D\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],

        ["\xB9\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\x8D\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],

        ["\xB9\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\x8D\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],

        ["\xB9\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\x8D\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],

        ["\xB9\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\x8D\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],

        ["\xB9\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\x8D\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],

        ["\xB9\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\x8D\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],

        ["\xB9\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\x8D\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],

        ["\xB9\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\x8D\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],

        ["\xB9\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\x8D\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],

        ["\xB9\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\x8D\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],

        ["\xB9\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\x8D\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],

        ["\xB9\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\x8D\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],

        ["\xB9\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\x8D\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],

        ["\xB9\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\x8D\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],

        ["\xB9\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\x8D\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],

        ["\xB9\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\x8D\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],

        ["\xB9\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\x8D\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],

        ["\xB9\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\x8D\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],

        ["\xB9\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\x8D\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],

        ["\xB9\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\x8D\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],

        ["\xB9\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\x8D\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],

        ["\xB9\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\x8D\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],

        ["\xB9\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\x8D\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],

        ["\xBA\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\x8D\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],

        ["\xBA\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\x8D\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],

        ["\xBA\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\x8D\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],

        ["\xBA\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\x8D\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],

        ["\xBA\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\x8D\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],

        ["\xBA\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\x8D\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],

        ["\xBA\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\x8D\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],

        ["\xBA\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\x8D\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],

        ["\xBA\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\x8D\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],

        ["\xBA\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\x8D\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],

        ["\xBA\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\x8D\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],

        ["\xBA\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\x8D\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],

        ["\xBA\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\x8D\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],

        ["\xBA\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\x8D\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],

        ["\xBA\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\x8D\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],

        ["\xBA\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\x8D\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],

        ["\xBA\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\x8D\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],

        ["\xBA\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\x8D\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],

        ["\xBA\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\x8D\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],

        ["\xBA\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\x8D\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],

        ["\xBA\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\x8D\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],

        ["\xBA\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\x8D\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],

        ["\xBA\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\x8D\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],

        ["\xBA\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\x8D\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],

        ["\xBA\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\x8D\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],

        ["\xBA\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\x8D\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],

        ["\xBA\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\x8D\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],

        ["\xBA\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\x8D\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],

        ["\xBA\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\x8D\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],

        ["\xBA\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\x8D\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],

        ["\xBA\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\x8D\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],

        ["\xBA\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\x8D\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],

        ["\xBA\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\x8D\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],

        ["\xBA\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\x8D\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],

        ["\xBA\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\x8D\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],

        ["\xBA\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\x8D\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],

        ["\xBA\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\x8D\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],

        ["\xBA\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\x8D\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],

        ["\xBA\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\x8D\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],

        ["\xBA\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\x8D\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],

        ["\xBA\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\x8D\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],

        ["\xBA\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\x8D\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],

        ["\xBA\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\x8D\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],

        ["\xBA\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\x8D\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],

        ["\xBA\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\x8D\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],

        ["\xBA\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\x8D\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],

        ["\xBA\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\x8D\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],

        ["\xBA\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\x8D\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],

        ["\xBA\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\x8D\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],

        ["\xBA\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\x8D\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],

        ["\xBA\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\x8D\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],

        ["\xBA\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\x8D\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],

        ["\xBA\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\x8D\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],

        ["\xBA\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\x8D\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],

        ["\xBA\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\x8D\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],

        ["\xBA\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\x8D\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],

        ["\xBA\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\x8D\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],

        ["\xBA\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\x8D\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],

        ["\xBA\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\x8D\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],

        ["\xBA\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\x8D\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],

        ["\xBA\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\x8D\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],

        ["\xBA\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\x8D\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],

        ["\xBA\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\x8D\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],

        ["\xBA\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\x8D\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],

        ["\xBA\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\x8D\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],

        ["\xBA\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\x8D\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],

        ["\xBA\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\x8D\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],

        ["\xBA\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\x8D\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],

        ["\xBA\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\x8D\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],

        ["\xBA\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\x8D\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],

        ["\xBA\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\x8D\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],

        ["\xBA\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\x8D\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],

        ["\xBA\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\x8D\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],

        ["\xBA\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\x8D\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],

        ["\xBA\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\x8D\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],

        ["\xBA\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\x8D\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],

        ["\xBA\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\x8D\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],

        ["\xBA\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\x8D\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],

        ["\xBA\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\x8D\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],

        ["\xBA\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\x8D\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],

        ["\xBA\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\x8D\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],

        ["\xBA\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\x8D\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],

        ["\xBA\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\x8D\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],

        ["\xBA\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\x8D\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],

        ["\xBA\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\x8D\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],

        ["\xBA\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\x8D\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],

        ["\xBA\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\x8D\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],

        ["\xBA\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\x8D\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],

        ["\xBA\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\x8D\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],

        ["\xBA\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\x8D\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],

        ["\xBA\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\x8D\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],

        ["\xBA\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\x8D\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],

        ["\xBA\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\x8D\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],

        ["\xBA\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\x8D\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],

        ["\xBB\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\x8E\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],

        ["\xBB\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\x8E\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],

        ["\xBB\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\x8E\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],

        ["\xBB\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\x8E\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],

        ["\xBB\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\x8E\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],

        ["\xBB\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\x8E\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],

        ["\xBB\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\x8E\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],

        ["\xBB\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\x8E\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],

        ["\xBB\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\x8E\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],

        ["\xBB\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\x8E\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],

        ["\xBB\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\x8E\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],

        ["\xBB\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\x8E\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],

        ["\xBB\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\x8E\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],

        ["\xBB\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\x8E\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],

        ["\xBB\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\x8E\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],

        ["\xBB\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\x8E\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],

        ["\xBB\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\x8E\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],

        ["\xBB\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\x8E\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],

        ["\xBB\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\x8E\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],

        ["\xBB\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\x8E\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],

        ["\xBB\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\x8E\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],

        ["\xBB\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\x8E\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],

        ["\xBB\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\x8E\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],

        ["\xBB\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\x8E\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],

        ["\xBB\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\x8E\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],

        ["\xBB\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\x8E\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],

        ["\xBB\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\x8E\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],

        ["\xBB\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\x8E\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],

        ["\xBB\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\x8E\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],

        ["\xBB\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\x8E\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],

        ["\xBB\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\x8E\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],

        ["\xBB\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\x8E\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],

        ["\xBB\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\x8E\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],

        ["\xBB\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\x8E\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],

        ["\xBB\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\x8E\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],

        ["\xBB\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\x8E\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],

        ["\xBB\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\x8E\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],

        ["\xBB\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\x8E\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],

        ["\xBB\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\x8E\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],

        ["\xBB\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\x8E\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],

        ["\xBB\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\x8E\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],

        ["\xBB\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\x8E\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],

        ["\xBB\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\x8E\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],

        ["\xBB\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\x8E\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],

        ["\xBB\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\x8E\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],

        ["\xBB\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\x8E\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],

        ["\xBB\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\x8E\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],

        ["\xBB\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\x8E\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],

        ["\xBB\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\x8E\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],

        ["\xBB\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\x8E\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],

        ["\xBB\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\x8E\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],

        ["\xBB\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\x8E\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],

        ["\xBB\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\x8E\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],

        ["\xBB\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\x8E\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],

        ["\xBB\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\x8E\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],

        ["\xBB\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\x8E\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],

        ["\xBB\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\x8E\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],

        ["\xBB\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\x8E\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],

        ["\xBB\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\x8E\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],

        ["\xBB\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\x8E\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],

        ["\xBB\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\x8E\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],

        ["\xBB\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\x8E\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],

        ["\xBB\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\x8E\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],

        ["\xBB\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\x8E\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],

        ["\xBB\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\x8E\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],

        ["\xBB\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\x8E\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],

        ["\xBB\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\x8E\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],

        ["\xBB\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\x8E\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],

        ["\xBB\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\x8E\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],

        ["\xBB\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\x8E\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],

        ["\xBB\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\x8E\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],

        ["\xBB\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\x8E\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],

        ["\xBB\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\x8E\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],

        ["\xBB\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\x8E\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],

        ["\xBB\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\x8E\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],

        ["\xBB\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\x8E\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],

        ["\xBB\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\x8E\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],

        ["\xBB\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\x8E\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],

        ["\xBB\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\x8E\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],

        ["\xBB\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\x8E\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],

        ["\xBB\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\x8E\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],

        ["\xBB\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\x8E\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],

        ["\xBB\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\x8E\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],

        ["\xBB\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\x8E\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],

        ["\xBB\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\x8E\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],

        ["\xBB\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\x8E\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],

        ["\xBB\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\x8E\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],

        ["\xBB\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\x8E\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],

        ["\xBB\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\x8E\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],

        ["\xBB\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\x8E\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],

        ["\xBB\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\x8E\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],

        ["\xBB\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\x8E\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],

        ["\xBB\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\x8E\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],

        ["\xBB\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\x8E\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],

        ["\xBC\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\x8E\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],

        ["\xBC\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\x8E\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],

        ["\xBC\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\x8E\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],

        ["\xBC\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\x8E\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],

        ["\xBC\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\x8E\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],

        ["\xBC\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\x8E\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],

        ["\xBC\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\x8E\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],

        ["\xBC\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\x8E\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],

        ["\xBC\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\x8E\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],

        ["\xBC\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\x8E\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],

        ["\xBC\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\x8E\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],

        ["\xBC\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\x8E\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],

        ["\xBC\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\x8E\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],

        ["\xBC\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\x8E\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],

        ["\xBC\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\x8E\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],

        ["\xBC\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\x8E\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],

        ["\xBC\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\x8E\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],

        ["\xBC\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\x8E\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],

        ["\xBC\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\x8E\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],

        ["\xBC\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\x8E\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],

        ["\xBC\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\x8E\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],

        ["\xBC\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\x8E\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],

        ["\xBC\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\x8E\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],

        ["\xBC\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\x8E\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],

        ["\xBC\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\x8E\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],

        ["\xBC\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\x8E\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],

        ["\xBC\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\x8E\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],

        ["\xBC\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\x8E\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],

        ["\xBC\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\x8E\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],

        ["\xBC\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\x8E\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],

        ["\xBC\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\x8E\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],

        ["\xBC\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\x8E\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],

        ["\xBC\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\x8E\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],

        ["\xBC\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\x8E\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],

        ["\xBC\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\x8E\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],

        ["\xBC\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\x8E\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],

        ["\xBC\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\x8E\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],

        ["\xBC\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\x8E\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],

        ["\xBC\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\x8E\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],

        ["\xBC\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\x8E\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],

        ["\xBC\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\x8E\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],

        ["\xBC\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\x8E\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],

        ["\xBC\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\x8E\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],

        ["\xBC\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\x8E\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],

        ["\xBC\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\x8E\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],

        ["\xBC\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\x8E\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],

        ["\xBC\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\x8E\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],

        ["\xBC\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\x8E\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],

        ["\xBC\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\x8E\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],

        ["\xBC\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\x8E\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],

        ["\xBC\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\x8E\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],

        ["\xBC\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\x8E\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],

        ["\xBC\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\x8E\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],

        ["\xBC\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\x8E\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],

        ["\xBC\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\x8E\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],

        ["\xBC\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\x8E\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],

        ["\xBC\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\x8E\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],

        ["\xBC\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\x8E\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],

        ["\xBC\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\x8E\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],

        ["\xBC\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\x8E\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],

        ["\xBC\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\x8E\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],

        ["\xBC\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\x8E\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],

        ["\xBC\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\x8E\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],

        ["\xBC\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\x8E\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],

        ["\xBC\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\x8E\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],

        ["\xBC\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\x8E\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],

        ["\xBC\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\x8E\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],

        ["\xBC\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\x8E\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],

        ["\xBC\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\x8E\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],

        ["\xBC\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\x8E\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],

        ["\xBC\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\x8E\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],

        ["\xBC\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\x8E\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],

        ["\xBC\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\x8E\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],

        ["\xBC\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\x8E\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],

        ["\xBC\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\x8E\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],

        ["\xBC\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\x8E\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],

        ["\xBC\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\x8E\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],

        ["\xBC\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\x8E\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],

        ["\xBC\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\x8E\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],

        ["\xBC\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\x8E\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],

        ["\xBC\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\x8E\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],

        ["\xBC\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\x8E\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],

        ["\xBC\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\x8E\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],

        ["\xBC\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\x8E\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],

        ["\xBC\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\x8E\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],

        ["\xBC\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\x8E\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],

        ["\xBC\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\x8E\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],

        ["\xBC\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\x8E\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],

        ["\xBC\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\x8E\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],

        ["\xBC\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\x8E\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],

        ["\xBC\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\x8E\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],

        ["\xBC\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\x8E\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],

        ["\xBC\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\x8E\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],

        ["\xBC\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\x8E\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],

        ["\xBD\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\x8F\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],

        ["\xBD\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\x8F\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],

        ["\xBD\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\x8F\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],

        ["\xBD\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\x8F\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],

        ["\xBD\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\x8F\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],

        ["\xBD\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\x8F\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],

        ["\xBD\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\x8F\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],

        ["\xBD\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\x8F\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],

        ["\xBD\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\x8F\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],

        ["\xBD\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\x8F\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],

        ["\xBD\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\x8F\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],

        ["\xBD\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\x8F\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],

        ["\xBD\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\x8F\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],

        ["\xBD\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\x8F\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],

        ["\xBD\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\x8F\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],

        ["\xBD\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\x8F\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],

        ["\xBD\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\x8F\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],

        ["\xBD\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\x8F\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],

        ["\xBD\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\x8F\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],

        ["\xBD\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\x8F\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],

        ["\xBD\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\x8F\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],

        ["\xBD\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\x8F\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],

        ["\xBD\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\x8F\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],

        ["\xBD\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\x8F\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],

        ["\xBD\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\x8F\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],

        ["\xBD\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\x8F\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],

        ["\xBD\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\x8F\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],

        ["\xBD\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\x8F\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],

        ["\xBD\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\x8F\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],

        ["\xBD\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\x8F\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],

        ["\xBD\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\x8F\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],

        ["\xBD\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\x8F\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],

        ["\xBD\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\x8F\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],

        ["\xBD\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\x8F\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],

        ["\xBD\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\x8F\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],

        ["\xBD\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\x8F\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],

        ["\xBD\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\x8F\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],

        ["\xBD\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\x8F\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],

        ["\xBD\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\x8F\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],

        ["\xBD\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\x8F\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],

        ["\xBD\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\x8F\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],

        ["\xBD\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\x8F\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],

        ["\xBD\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\x8F\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],

        ["\xBD\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\x8F\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],

        ["\xBD\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\x8F\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],

        ["\xBD\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\x8F\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],

        ["\xBD\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\x8F\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],

        ["\xBD\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\x8F\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],

        ["\xBD\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\x8F\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],

        ["\xBD\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\x8F\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],

        ["\xBD\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\x8F\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],

        ["\xBD\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\x8F\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],

        ["\xBD\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\x8F\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],

        ["\xBD\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\x8F\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],

        ["\xBD\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\x8F\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],

        ["\xBD\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\x8F\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],

        ["\xBD\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\x8F\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],

        ["\xBD\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\x8F\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],

        ["\xBD\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\x8F\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],

        ["\xBD\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\x8F\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],

        ["\xBD\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\x8F\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],

        ["\xBD\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\x8F\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],

        ["\xBD\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\x8F\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],

        ["\xBD\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\x8F\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],

        ["\xBD\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\x8F\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],

        ["\xBD\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\x8F\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],

        ["\xBD\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\x8F\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],

        ["\xBD\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\x8F\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],

        ["\xBD\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\x8F\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],

        ["\xBD\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\x8F\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],

        ["\xBD\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\x8F\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],

        ["\xBD\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\x8F\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],

        ["\xBD\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\x8F\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],

        ["\xBD\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\x8F\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],

        ["\xBD\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\x8F\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],

        ["\xBD\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\x8F\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],

        ["\xBD\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\x8F\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],

        ["\xBD\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\x8F\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],

        ["\xBD\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\x8F\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],

        ["\xBD\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\x8F\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],

        ["\xBD\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\x8F\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],

        ["\xBD\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\x8F\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],

        ["\xBD\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\x8F\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],

        ["\xBD\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\x8F\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],

        ["\xBD\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\x8F\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],

        ["\xBD\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\x8F\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],

        ["\xBD\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\x8F\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],

        ["\xBD\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\x8F\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],

        ["\xBD\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\x8F\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],

        ["\xBD\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\x8F\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],

        ["\xBD\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\x8F\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],

        ["\xBD\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\x8F\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],

        ["\xBD\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\x8F\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],

        ["\xBD\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\x8F\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],

        ["\xBE\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\x8F\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],

        ["\xBE\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\x8F\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],

        ["\xBE\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\x8F\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],

        ["\xBE\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\x8F\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],

        ["\xBE\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\x8F\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],

        ["\xBE\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\x8F\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],

        ["\xBE\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\x8F\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],

        ["\xBE\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\x8F\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],

        ["\xBE\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\x8F\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],

        ["\xBE\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\x8F\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],

        ["\xBE\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\x8F\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],

        ["\xBE\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\x8F\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],

        ["\xBE\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\x8F\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],

        ["\xBE\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\x8F\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],

        ["\xBE\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\x8F\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],

        ["\xBE\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\x8F\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],

        ["\xBE\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\x8F\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],

        ["\xBE\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\x8F\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],

        ["\xBE\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\x8F\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],

        ["\xBE\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\x8F\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],

        ["\xBE\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\x8F\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],

        ["\xBE\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\x8F\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],

        ["\xBE\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\x8F\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],

        ["\xBE\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\x8F\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],

        ["\xBE\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\x8F\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],

        ["\xBE\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\x8F\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],

        ["\xBE\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\x8F\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],

        ["\xBE\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\x8F\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],

        ["\xBE\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\x8F\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],

        ["\xBE\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\x8F\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],

        ["\xBE\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\x8F\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],

        ["\xBE\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\x8F\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],

        ["\xBE\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\x8F\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],

        ["\xBE\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\x8F\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],

        ["\xBE\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\x8F\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],

        ["\xBE\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\x8F\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],

        ["\xBE\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\x8F\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],

        ["\xBE\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\x8F\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],

        ["\xBE\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\x8F\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],

        ["\xBE\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\x8F\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],

        ["\xBE\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\x8F\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],

        ["\xBE\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\x8F\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],

        ["\xBE\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\x8F\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],

        ["\xBE\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\x8F\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],

        ["\xBE\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\x8F\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],

        ["\xBE\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\x8F\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],

        ["\xBE\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\x8F\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],

        ["\xBE\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\x8F\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],

        ["\xBE\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\x8F\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],

        ["\xBE\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\x8F\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],

        ["\xBE\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\x8F\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],

        ["\xBE\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\x8F\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],

        ["\xBE\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\x8F\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],

        ["\xBE\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\x8F\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],

        ["\xBE\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\x8F\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],

        ["\xBE\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\x8F\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],

        ["\xBE\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\x8F\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],

        ["\xBE\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\x8F\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],

        ["\xBE\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\x8F\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],

        ["\xBE\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\x8F\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],

        ["\xBE\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\x8F\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],

        ["\xBE\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\x8F\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],

        ["\xBE\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\x8F\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],

        ["\xBE\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\x8F\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],

        ["\xBE\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\x8F\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],

        ["\xBE\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\x8F\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],

        ["\xBE\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\x8F\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],

        ["\xBE\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\x8F\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],

        ["\xBE\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\x8F\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],

        ["\xBE\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\x8F\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],

        ["\xBE\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\x8F\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],

        ["\xBE\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\x8F\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],

        ["\xBE\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\x8F\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],

        ["\xBE\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\x8F\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],

        ["\xBE\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\x8F\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],

        ["\xBE\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\x8F\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],

        ["\xBE\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\x8F\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],

        ["\xBE\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\x8F\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],

        ["\xBE\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\x8F\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],

        ["\xBE\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\x8F\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],

        ["\xBE\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\x8F\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],

        ["\xBE\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\x8F\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],

        ["\xBE\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\x8F\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],

        ["\xBE\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\x8F\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],

        ["\xBE\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\x8F\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],

        ["\xBE\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\x8F\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],

        ["\xBE\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\x8F\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],

        ["\xBE\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\x8F\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],

        ["\xBE\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\x8F\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],

        ["\xBE\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\x8F\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],

        ["\xBE\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\x8F\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],

        ["\xBE\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\x8F\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],

        ["\xBE\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\x8F\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],

        ["\xBE\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\x8F\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],

        ["\xBF\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\x90\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],

        ["\xBF\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\x90\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],

        ["\xBF\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\x90\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],

        ["\xBF\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\x90\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],

        ["\xBF\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\x90\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],

        ["\xBF\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\x90\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],

        ["\xBF\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\x90\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],

        ["\xBF\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\x90\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],

        ["\xBF\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\x90\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],

        ["\xBF\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\x90\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],

        ["\xBF\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\x90\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],

        ["\xBF\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\x90\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],

        ["\xBF\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\x90\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],

        ["\xBF\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\x90\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],

        ["\xBF\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\x90\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],

        ["\xBF\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\x90\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],

        ["\xBF\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\x90\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],

        ["\xBF\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\x90\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],

        ["\xBF\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\x90\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],

        ["\xBF\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\x90\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],

        ["\xBF\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\x90\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],

        ["\xBF\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\x90\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],

        ["\xBF\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\x90\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],

        ["\xBF\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\x90\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],

        ["\xBF\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\x90\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],

        ["\xBF\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\x90\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],

        ["\xBF\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\x90\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],

        ["\xBF\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\x90\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],

        ["\xBF\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\x90\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],

        ["\xBF\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\x90\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],

        ["\xBF\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\x90\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],

        ["\xBF\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\x90\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],

        ["\xBF\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\x90\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],

        ["\xBF\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\x90\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],

        ["\xBF\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\x90\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],

        ["\xBF\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\x90\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],

        ["\xBF\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\x90\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],

        ["\xBF\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\x90\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],

        ["\xBF\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\x90\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],

        ["\xBF\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\x90\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],

        ["\xBF\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\x90\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],

        ["\xBF\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\x90\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],

        ["\xBF\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\x90\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],

        ["\xBF\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\x90\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],

        ["\xBF\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\x90\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],

        ["\xBF\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\x90\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],

        ["\xBF\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\x90\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],

        ["\xBF\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\x90\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],

        ["\xBF\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\x90\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],

        ["\xBF\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\x90\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],

        ["\xBF\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\x90\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],

        ["\xBF\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\x90\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],

        ["\xBF\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\x90\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],

        ["\xBF\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\x90\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],

        ["\xBF\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\x90\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],

        ["\xBF\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\x90\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],

        ["\xBF\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\x90\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],

        ["\xBF\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\x90\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],

        ["\xBF\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\x90\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],

        ["\xBF\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\x90\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],

        ["\xBF\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\x90\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],

        ["\xBF\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\x90\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],

        ["\xBF\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\x90\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],

        ["\xBF\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\x90\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],

        ["\xBF\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\x90\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],

        ["\xBF\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\x90\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],

        ["\xBF\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\x90\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],

        ["\xBF\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\x90\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],

        ["\xBF\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\x90\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],

        ["\xBF\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\x90\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],

        ["\xBF\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\x90\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],

        ["\xBF\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\x90\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],

        ["\xBF\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\x90\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],

        ["\xBF\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\x90\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],

        ["\xBF\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\x90\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],

        ["\xBF\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\x90\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],

        ["\xBF\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\x90\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],

        ["\xBF\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\x90\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],

        ["\xBF\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\x90\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],

        ["\xBF\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\x90\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],

        ["\xBF\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\x90\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],

        ["\xBF\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\x90\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],

        ["\xBF\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\x90\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],

        ["\xBF\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\x90\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],

        ["\xBF\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\x90\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],

        ["\xBF\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\x90\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],

        ["\xBF\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\x90\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],

        ["\xBF\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\x90\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],

        ["\xBF\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\x90\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],

        ["\xBF\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\x90\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],

        ["\xBF\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\x90\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],

        ["\xBF\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\x90\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],

        ["\xBF\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\x90\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],

        ["\xBF\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\x90\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],

        ["\xC0\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\x90\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],

        ["\xC0\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\x90\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],

        ["\xC0\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\x90\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],

        ["\xC0\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\x90\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],

        ["\xC0\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\x90\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],

        ["\xC0\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\x90\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],

        ["\xC0\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\x90\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],

        ["\xC0\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\x90\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],

        ["\xC0\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\x90\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],

        ["\xC0\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\x90\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],

        ["\xC0\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\x90\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],

        ["\xC0\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\x90\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],

        ["\xC0\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\x90\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],

        ["\xC0\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\x90\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],

        ["\xC0\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\x90\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],

        ["\xC0\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\x90\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],

        ["\xC0\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\x90\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],

        ["\xC0\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\x90\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],

        ["\xC0\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\x90\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],

        ["\xC0\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\x90\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],

        ["\xC0\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\x90\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],

        ["\xC0\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\x90\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],

        ["\xC0\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\x90\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],

        ["\xC0\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\x90\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],

        ["\xC0\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\x90\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],

        ["\xC0\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\x90\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],

        ["\xC0\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\x90\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],

        ["\xC0\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\x90\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],

        ["\xC0\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\x90\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],

        ["\xC0\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\x90\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],

        ["\xC0\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\x90\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],

        ["\xC0\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\x90\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],

        ["\xC0\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\x90\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],

        ["\xC0\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\x90\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],

        ["\xC0\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\x90\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],

        ["\xC0\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\x90\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],

        ["\xC0\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\x90\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],

        ["\xC0\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\x90\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],

        ["\xC0\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\x90\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],

        ["\xC0\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\x90\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],

        ["\xC0\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\x90\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],

        ["\xC0\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\x90\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],

        ["\xC0\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\x90\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],

        ["\xC0\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\x90\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],

        ["\xC0\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\x90\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],

        ["\xC0\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\x90\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],

        ["\xC0\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\x90\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],

        ["\xC0\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\x90\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],

        ["\xC0\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\x90\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],

        ["\xC0\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\x90\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],

        ["\xC0\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\x90\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],

        ["\xC0\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\x90\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],

        ["\xC0\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\x90\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],

        ["\xC0\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\x90\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],

        ["\xC0\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\x90\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],

        ["\xC0\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\x90\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],

        ["\xC0\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\x90\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],

        ["\xC0\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\x90\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],

        ["\xC0\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\x90\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],

        ["\xC0\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\x90\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],

        ["\xC0\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\x90\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],

        ["\xC0\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\x90\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],

        ["\xC0\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\x90\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],

        ["\xC0\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\x90\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],

        ["\xC0\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\x90\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],

        ["\xC0\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\x90\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],

        ["\xC0\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\x90\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],

        ["\xC0\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\x90\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],

        ["\xC0\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\x90\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],

        ["\xC0\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\x90\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],

        ["\xC0\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\x90\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],

        ["\xC0\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\x90\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],

        ["\xC0\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\x90\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],

        ["\xC0\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\x90\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],

        ["\xC0\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\x90\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],

        ["\xC0\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\x90\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],

        ["\xC0\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\x90\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],

        ["\xC0\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\x90\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],

        ["\xC0\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\x90\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],

        ["\xC0\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\x90\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],

        ["\xC0\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\x90\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],

        ["\xC0\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\x90\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],

        ["\xC0\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\x90\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],

        ["\xC0\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\x90\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],

        ["\xC0\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\x90\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],

        ["\xC0\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\x90\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],

        ["\xC0\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\x90\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],

        ["\xC0\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\x90\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],

        ["\xC0\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\x90\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],

        ["\xC0\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\x90\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],

        ["\xC0\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\x90\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],

        ["\xC0\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\x90\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],

        ["\xC0\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\x90\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],

        ["\xC0\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\x90\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],

        ["\xC1\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\x91\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],

        ["\xC1\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\x91\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],

        ["\xC1\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\x91\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],

        ["\xC1\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\x91\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],

        ["\xC1\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\x91\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],

        ["\xC1\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\x91\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],

        ["\xC1\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\x91\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],

        ["\xC1\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\x91\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],

        ["\xC1\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\x91\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],

        ["\xC1\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\x91\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],

        ["\xC1\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\x91\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],

        ["\xC1\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\x91\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],

        ["\xC1\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\x91\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],

        ["\xC1\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\x91\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],

        ["\xC1\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\x91\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],

        ["\xC1\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\x91\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],

        ["\xC1\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\x91\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],

        ["\xC1\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\x91\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],

        ["\xC1\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\x91\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],

        ["\xC1\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\x91\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],

        ["\xC1\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\x91\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],

        ["\xC1\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\x91\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],

        ["\xC1\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\x91\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],

        ["\xC1\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\x91\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],

        ["\xC1\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\x91\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],

        ["\xC1\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\x91\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],

        ["\xC1\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\x91\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],

        ["\xC1\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\x91\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],

        ["\xC1\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\x91\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],

        ["\xC1\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\x91\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],

        ["\xC1\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\x91\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],

        ["\xC1\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\x91\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],

        ["\xC1\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\x91\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],

        ["\xC1\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\x91\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],

        ["\xC1\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\x91\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],

        ["\xC1\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\x91\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],

        ["\xC1\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\x91\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],

        ["\xC1\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\x91\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],

        ["\xC1\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\x91\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],

        ["\xC1\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\x91\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],

        ["\xC1\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\x91\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],

        ["\xC1\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\x91\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],

        ["\xC1\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\x91\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],

        ["\xC1\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\x91\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],

        ["\xC1\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\x91\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],

        ["\xC1\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\x91\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],

        ["\xC1\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\x91\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],

        ["\xC1\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\x91\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],

        ["\xC1\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\x91\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],

        ["\xC1\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\x91\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],

        ["\xC1\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\x91\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],

        ["\xC1\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\x91\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],

        ["\xC1\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\x91\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],

        ["\xC1\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\x91\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],

        ["\xC1\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\x91\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],

        ["\xC1\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\x91\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],

        ["\xC1\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\x91\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],

        ["\xC1\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\x91\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],

        ["\xC1\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\x91\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],

        ["\xC1\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\x91\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],

        ["\xC1\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\x91\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],

        ["\xC1\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\x91\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],

        ["\xC1\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\x91\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],

        ["\xC1\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\x91\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],

        ["\xC1\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\x91\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],

        ["\xC1\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\x91\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],

        ["\xC1\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\x91\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],

        ["\xC1\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\x91\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],

        ["\xC1\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\x91\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],

        ["\xC1\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\x91\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],

        ["\xC1\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\x91\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],

        ["\xC1\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\x91\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],

        ["\xC1\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\x91\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],

        ["\xC1\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\x91\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],

        ["\xC1\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\x91\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],

        ["\xC1\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\x91\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],

        ["\xC1\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\x91\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],

        ["\xC1\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\x91\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],

        ["\xC1\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\x91\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],

        ["\xC1\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\x91\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],

        ["\xC1\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\x91\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],

        ["\xC1\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\x91\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],

        ["\xC1\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\x91\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],

        ["\xC1\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\x91\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],

        ["\xC1\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\x91\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],

        ["\xC1\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\x91\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],

        ["\xC1\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\x91\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],

        ["\xC1\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\x91\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],

        ["\xC1\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\x91\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],

        ["\xC1\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\x91\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],

        ["\xC1\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\x91\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],

        ["\xC1\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\x91\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],

        ["\xC1\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\x91\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],

        ["\xC1\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\x91\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],

        ["\xC2\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\x91\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],

        ["\xC2\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\x91\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],

        ["\xC2\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\x91\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],

        ["\xC2\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\x91\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],

        ["\xC2\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\x91\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],

        ["\xC2\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\x91\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],

        ["\xC2\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\x91\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xC2\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\x91\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xC2\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\x91\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],

        ["\xC2\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\x91\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],

        ["\xC2\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\x91\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],

        ["\xC2\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\x91\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],

        ["\xC2\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\x91\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],

        ["\xC2\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\x91\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],

        ["\xC2\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\x91\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],

        ["\xC2\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\x91\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xC2\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\x91\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC2\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\x91\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],

        ["\xC2\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\x91\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],

        ["\xC2\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\x91\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xC2\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\x91\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],

        ["\xC2\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\x91\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xC2\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\x91\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],

        ["\xC2\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\x91\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],

        ["\xC2\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\x91\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],

        ["\xC2\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\x91\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],

        ["\xC2\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\x91\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],

        ["\xC2\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\x91\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],

        ["\xC2\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\x91\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],

        ["\xC2\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\x91\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],

        ["\xC2\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\x91\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],

        ["\xC2\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\x91\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],

        ["\xC2\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\x91\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],

        ["\xC2\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\x91\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],

        ["\xC2\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\x91\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],

        ["\xC2\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\x91\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],

        ["\xC2\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\x91\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],

        ["\xC2\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\x91\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],

        ["\xC2\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\x91\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],

        ["\xC2\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\x91\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],

        ["\xC2\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\x91\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],

        ["\xC2\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\x91\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],

        ["\xC2\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\x91\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],

        ["\xC2\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\x91\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],

        ["\xC2\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\x91\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],

        ["\xC2\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\x91\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],

        ["\xC2\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\x91\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],

        ["\xC2\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\x91\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],

        ["\xC2\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\x91\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],

        ["\xC2\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\x91\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],

        ["\xC2\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\x91\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],

        ["\xC2\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\x91\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],

        ["\xC2\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\x91\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],

        ["\xC2\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\x91\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],

        ["\xC2\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\x91\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],

        ["\xC2\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\x91\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],

        ["\xC2\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\x91\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],

        ["\xC2\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\x91\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],

        ["\xC2\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\x91\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],

        ["\xC2\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\x91\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],

        ["\xC2\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\x91\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],

        ["\xC2\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\x91\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],

        ["\xC2\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\x91\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],

        ["\xC2\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\x91\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],

        ["\xC2\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\x91\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],

        ["\xC2\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\x91\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],

        ["\xC2\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\x91\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],

        ["\xC2\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\x91\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],

        ["\xC2\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\x91\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],

        ["\xC2\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\x91\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],

        ["\xC2\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\x91\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],

        ["\xC2\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\x91\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],

        ["\xC2\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\x91\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],

        ["\xC2\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\x91\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],

        ["\xC2\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\x91\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],

        ["\xC2\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\x91\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],

        ["\xC2\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\x91\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],

        ["\xC2\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\x91\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],

        ["\xC2\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\x91\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],

        ["\xC2\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\x91\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],

        ["\xC2\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\x91\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],

        ["\xC2\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\x91\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],

        ["\xC2\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\x91\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],

        ["\xC2\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\x91\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],

        ["\xC2\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\x91\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],

        ["\xC2\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\x91\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],

        ["\xC2\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\x91\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],

        ["\xC2\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\x91\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],

        ["\xC2\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\x91\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],

        ["\xC2\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\x91\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],

        ["\xC2\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\x91\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],

        ["\xC2\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\x91\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],

        ["\xC2\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\x91\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],

        ["\xC2\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\x91\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],

        ["\xC3\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\x92\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],

        ["\xC3\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\x92\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],

        ["\xC3\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\x92\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],

        ["\xC3\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\x92\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],

        ["\xC3\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\x92\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],

        ["\xC3\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\x92\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],

        ["\xC3\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\x92\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],

        ["\xC3\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\x92\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],

        ["\xC3\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\x92\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],

        ["\xC3\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\x92\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],

        ["\xC3\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\x92\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],

        ["\xC3\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\x92\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],

        ["\xC3\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\x92\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],

        ["\xC3\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\x92\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],

        ["\xC3\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\x92\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],

        ["\xC3\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\x92\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],

        ["\xC3\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\x92\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],

        ["\xC3\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\x92\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],

        ["\xC3\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\x92\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],

        ["\xC3\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\x92\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],

        ["\xC3\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\x92\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],

        ["\xC3\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\x92\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],

        ["\xC3\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\x92\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xC3\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\x92\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],

        ["\xC3\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\x92\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],

        ["\xC3\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\x92\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],

        ["\xC3\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\x92\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],

        ["\xC3\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\x92\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],

        ["\xC3\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\x92\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],

        ["\xC3\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\x92\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],

        ["\xC3\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\x92\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],

        ["\xC3\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\x92\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],

        ["\xC3\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\x92\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],

        ["\xC3\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\x92\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],

        ["\xC3\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\x92\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],

        ["\xC3\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\x92\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],

        ["\xC3\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\x92\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],

        ["\xC3\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\x92\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],

        ["\xC3\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\x92\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],

        ["\xC3\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\x92\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],

        ["\xC3\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\x92\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],

        ["\xC3\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\x92\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],

        ["\xC3\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\x92\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],

        ["\xC3\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\x92\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],

        ["\xC3\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\x92\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],

        ["\xC3\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\x92\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],

        ["\xC3\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\x92\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],

        ["\xC3\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\x92\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],

        ["\xC3\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\x92\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],

        ["\xC3\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\x92\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],

        ["\xC3\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\x92\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],

        ["\xC3\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\x92\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],

        ["\xC3\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\x92\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],

        ["\xC3\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\x92\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],

        ["\xC3\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\x92\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],

        ["\xC3\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\x92\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],

        ["\xC3\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\x92\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],

        ["\xC3\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\x92\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],

        ["\xC3\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\x92\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],

        ["\xC3\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\x92\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],

        ["\xC3\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\x92\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],

        ["\xC3\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\x92\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],

        ["\xC3\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\x92\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],

        ["\xC3\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\x92\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],

        ["\xC3\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\x92\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],

        ["\xC3\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\x92\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],

        ["\xC3\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\x92\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],

        ["\xC3\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\x92\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],

        ["\xC3\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\x92\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],

        ["\xC3\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\x92\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],

        ["\xC3\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\x92\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],

        ["\xC3\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\x92\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],

        ["\xC3\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\x92\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],

        ["\xC3\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\x92\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],

        ["\xC3\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\x92\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],

        ["\xC3\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\x92\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],

        ["\xC3\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\x92\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],

        ["\xC3\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\x92\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],

        ["\xC3\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\x92\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],

        ["\xC3\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\x92\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],

        ["\xC3\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\x92\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],

        ["\xC3\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\x92\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],

        ["\xC3\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\x92\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],

        ["\xC3\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\x92\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],

        ["\xC3\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\x92\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],

        ["\xC3\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\x92\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],

        ["\xC3\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\x92\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],

        ["\xC3\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\x92\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],

        ["\xC3\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\x92\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],

        ["\xC3\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\x92\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],

        ["\xC3\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\x92\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],

        ["\xC3\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\x92\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],

        ["\xC3\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\x92\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],

        ["\xC3\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\x92\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],

        ["\xC4\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\x92\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],

        ["\xC4\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\x92\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],

        ["\xC4\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\x92\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],

        ["\xC4\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\x92\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],

        ["\xC4\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\x92\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],

        ["\xC4\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\x92\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],

        ["\xC4\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\x92\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],

        ["\xC4\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\x92\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],

        ["\xC4\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\x92\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],

        ["\xC4\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\x92\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],

        ["\xC4\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\x92\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],

        ["\xC4\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\x92\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],

        ["\xC4\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\x92\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],

        ["\xC4\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\x92\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],

        ["\xC4\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\x92\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],

        ["\xC4\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\x92\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],

        ["\xC4\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\x92\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],

        ["\xC4\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\x92\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],

        ["\xC4\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\x92\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],

        ["\xC4\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\x92\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],

        ["\xC4\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\x92\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],

        ["\xC4\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\x92\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],

        ["\xC4\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\x92\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],

        ["\xC4\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\x92\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],

        ["\xC4\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\x92\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],

        ["\xC4\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\x92\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],

        ["\xC4\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\x92\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],

        ["\xC4\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\x92\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],

        ["\xC4\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\x92\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],

        ["\xC4\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\x92\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],

        ["\xC4\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\x92\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],

        ["\xC4\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\x92\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],

        ["\xC4\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\x92\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],

        ["\xC4\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\x92\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],

        ["\xC4\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\x92\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],

        ["\xC4\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\x92\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],

        ["\xC4\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\x92\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],

        ["\xC4\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\x92\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],

        ["\xC4\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\x92\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],

        ["\xC4\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\x92\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],

        ["\xC4\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\x92\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],

        ["\xC4\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\x92\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],

        ["\xC4\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\x92\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],

        ["\xC4\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\x92\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],

        ["\xC4\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\x92\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],

        ["\xC4\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\x92\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],

        ["\xC4\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\x92\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],

        ["\xC4\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\x92\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],

        ["\xC4\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\x92\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],

        ["\xC4\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\x92\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],

        ["\xC4\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\x92\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],

        ["\xC4\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\x92\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],

        ["\xC4\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\x92\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],

        ["\xC4\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\x92\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],

        ["\xC4\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\x92\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],

        ["\xC4\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\x92\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],

        ["\xC4\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\x92\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],

        ["\xC4\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\x92\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],

        ["\xC4\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\x92\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],

        ["\xC4\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\x92\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],

        ["\xC4\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\x92\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],

        ["\xC4\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\x92\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],

        ["\xC4\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\x92\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],

        ["\xC4\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\x92\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],

        ["\xC4\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\x92\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],

        ["\xC4\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\x92\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],

        ["\xC4\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\x92\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],

        ["\xC4\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\x92\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],

        ["\xC4\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\x92\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],

        ["\xC4\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\x92\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],

        ["\xC4\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\x92\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],

        ["\xC4\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\x92\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\xC4\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\x92\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],

        ["\xC4\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\x92\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],

        ["\xC4\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\x92\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],

        ["\xC4\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\x92\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],

        ["\xC4\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\x92\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],

        ["\xC4\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\x92\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],

        ["\xC4\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\x92\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],

        ["\xC4\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\x92\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],

        ["\xC4\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\x92\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],

        ["\xC4\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\x92\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],

        ["\xC4\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\x92\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],

        ["\xC4\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\x92\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],

        ["\xC4\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\x92\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],

        ["\xC4\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\x92\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],

        ["\xC4\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\x92\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],

        ["\xC4\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\x92\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],

        ["\xC4\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\x92\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],

        ["\xC4\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\x92\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],

        ["\xC4\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\x92\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],

        ["\xC4\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\x92\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],

        ["\xC4\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\x92\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],

        ["\xC4\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\x92\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],

        ["\xC5\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\x93\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],

        ["\xC5\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\x93\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],

        ["\xC5\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\x93\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],

        ["\xC5\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\x93\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],

        ["\xC5\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\x93\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],

        ["\xC5\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\x93\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],

        ["\xC5\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\x93\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],

        ["\xC5\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\x93\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],

        ["\xC5\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\x93\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],

        ["\xC5\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\x93\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],

        ["\xC5\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\x93\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],

        ["\xC5\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\x93\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],

        ["\xC5\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\x93\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],

        ["\xC5\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\x93\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],

        ["\xC5\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\x93\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],

        ["\xC5\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\x93\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],

        ["\xC5\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\x93\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],

        ["\xC5\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\x93\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],

        ["\xC5\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\x93\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],

        ["\xC5\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\x93\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],

        ["\xC5\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\x93\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],

        ["\xC5\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\x93\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],

        ["\xC5\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\x93\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],

        ["\xC5\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\x93\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],

        ["\xC5\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\x93\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],

        ["\xC5\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\x93\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],

        ["\xC5\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\x93\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],

        ["\xC5\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\x93\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],

        ["\xC5\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\x93\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],

        ["\xC5\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\x93\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],

        ["\xC5\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\x93\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],

        ["\xC5\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\x93\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],

        ["\xC5\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\x93\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],

        ["\xC5\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\x93\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],

        ["\xC5\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\x93\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],

        ["\xC5\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\x93\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],

        ["\xC5\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\x93\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],

        ["\xC5\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\x93\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],

        ["\xC5\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\x93\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],

        ["\xC5\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\x93\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],

        ["\xC5\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\x93\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],

        ["\xC5\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\x93\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],

        ["\xC5\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\x93\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],

        ["\xC5\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\x93\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],

        ["\xC5\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\x93\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],

        ["\xC5\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\x93\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],

        ["\xC5\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\x93\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],

        ["\xC5\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\x93\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],

        ["\xC5\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\x93\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],

        ["\xC5\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\x93\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],

        ["\xC5\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\x93\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],

        ["\xC5\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\x93\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],

        ["\xC5\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\x93\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],

        ["\xC5\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\x93\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],

        ["\xC5\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\x93\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],

        ["\xC5\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\x93\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],

        ["\xC5\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\x93\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],

        ["\xC5\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\x93\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],

        ["\xC5\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\x93\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],

        ["\xC5\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\x93\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],

        ["\xC5\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\x93\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],

        ["\xC5\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\x93\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],

        ["\xC5\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\x93\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],

        ["\xC5\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\x93\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],

        ["\xC5\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\x93\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],

        ["\xC5\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\x93\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],

        ["\xC5\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\x93\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],

        ["\xC5\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\x93\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],

        ["\xC5\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\x93\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],

        ["\xC5\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\x93\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],

        ["\xC5\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\x93\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],

        ["\xC5\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\x93\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],

        ["\xC5\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\x93\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],

        ["\xC5\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\x93\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],

        ["\xC5\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\x93\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],

        ["\xC5\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\x93\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],

        ["\xC5\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\x93\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],

        ["\xC5\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\x93\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],

        ["\xC5\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\x93\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],

        ["\xC5\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\x93\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],

        ["\xC5\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\x93\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],

        ["\xC5\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\x93\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],

        ["\xC5\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\x93\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],

        ["\xC5\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\x93\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],

        ["\xC5\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\x93\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],

        ["\xC5\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\x93\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],

        ["\xC5\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\x93\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],

        ["\xC5\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\x93\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],

        ["\xC5\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\x93\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],

        ["\xC5\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\x93\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],

        ["\xC5\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\x93\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],

        ["\xC5\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\x93\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],

        ["\xC5\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\x93\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],

        ["\xC5\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\x93\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],

        ["\xC6\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\x93\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],

        ["\xC6\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\x93\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],

        ["\xC6\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\x93\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],

        ["\xC6\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\x93\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],

        ["\xC6\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\x93\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],

        ["\xC6\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\x93\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],

        ["\xC6\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\x93\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],

        ["\xC6\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\x93\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],

        ["\xC6\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\x93\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],

        ["\xC6\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\x93\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],

        ["\xC6\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\x93\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],

        ["\xC6\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\x93\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],

        ["\xC6\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\x93\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],

        ["\xC6\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\x93\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],

        ["\xC6\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\x93\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],

        ["\xC6\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\x93\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],

        ["\xC6\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\x93\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],

        ["\xC6\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\x93\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],

        ["\xC6\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\x93\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],

        ["\xC6\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\x93\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],

        ["\xC6\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\x93\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],

        ["\xC6\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\x93\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],

        ["\xC6\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\x93\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],

        ["\xC6\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\x93\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],

        ["\xC6\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\x93\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],

        ["\xC6\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\x93\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],

        ["\xC6\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\x93\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],

        ["\xC6\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\x93\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],

        ["\xC6\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\x93\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],

        ["\xC6\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\x93\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],

        ["\xC6\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\x93\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],

        ["\xC6\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\x93\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],

        ["\xC6\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\x93\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],

        ["\xC6\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\x93\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],

        ["\xC6\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\x93\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],

        ["\xC6\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\x93\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],

        ["\xC6\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\x93\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],

        ["\xC6\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\x93\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],

        ["\xC6\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\x93\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],

        ["\xC6\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\x93\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],

        ["\xC6\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\x93\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],

        ["\xC6\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\x93\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],

        ["\xC6\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\x93\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],

        ["\xC6\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\x93\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],

        ["\xC6\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\x93\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],

        ["\xC6\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\x93\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],

        ["\xC6\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\x93\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],

        ["\xC6\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\x93\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],

        ["\xC6\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\x93\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],

        ["\xC6\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\x93\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],

        ["\xC6\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\x93\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],

        ["\xC6\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\x93\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],

        ["\xC6\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\x93\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],

        ["\xC6\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\x93\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],

        ["\xC6\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\x93\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],

        ["\xC6\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\x93\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],

        ["\xC6\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\x93\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],

        ["\xC6\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\x93\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],

        ["\xC6\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\x93\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],

        ["\xC6\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\x93\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],

        ["\xC6\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\x93\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],

        ["\xC6\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\x93\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],

        ["\xC6\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\x93\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],

        ["\xC6\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\x93\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],

        ["\xC6\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\x93\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],

        ["\xC6\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\x93\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],

        ["\xC6\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\x93\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],

        ["\xC6\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\x93\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],

        ["\xC6\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\x93\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],

        ["\xC6\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\x93\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],

        ["\xC6\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\x93\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],

        ["\xC6\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\x93\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],

        ["\xC6\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\x93\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],

        ["\xC6\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\x93\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],

        ["\xC6\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\x93\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],

        ["\xC6\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\x93\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],

        ["\xC6\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\x93\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],

        ["\xC6\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\x93\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],

        ["\xC6\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\x93\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],

        ["\xC6\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\x93\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],

        ["\xC6\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\x93\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],

        ["\xC6\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\x93\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],

        ["\xC6\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\x93\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],

        ["\xC6\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\x93\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],

        ["\xC6\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\x93\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],

        ["\xC6\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\x93\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],

        ["\xC6\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\x93\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],

        ["\xC6\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\x93\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],

        ["\xC6\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\x93\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],

        ["\xC6\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\x93\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],

        ["\xC6\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\x93\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],

        ["\xC6\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\x93\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],

        ["\xC6\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\x93\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],

        ["\xC6\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\x93\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],

        ["\xC7\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\x94\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],

        ["\xC7\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\x94\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],

        ["\xC7\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\x94\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],

        ["\xC7\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\x94\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],

        ["\xC7\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\x94\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],

        ["\xC7\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\x94\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],

        ["\xC7\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\x94\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],

        ["\xC7\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\x94\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],

        ["\xC7\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\x94\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],

        ["\xC7\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\x94\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],

        ["\xC7\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\x94\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],

        ["\xC7\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\x94\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],

        ["\xC7\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\x94\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],

        ["\xC7\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\x94\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],

        ["\xC7\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\x94\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],

        ["\xC7\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\x94\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],

        ["\xC7\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\x94\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],

        ["\xC7\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\x94\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],

        ["\xC7\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\x94\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],

        ["\xC7\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\x94\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],

        ["\xC7\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\x94\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],

        ["\xC7\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\x94\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],

        ["\xC7\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\x94\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],

        ["\xC7\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\x94\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],

        ["\xC7\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\x94\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],

        ["\xC7\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\x94\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],

        ["\xC7\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\x94\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],

        ["\xC7\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\x94\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],

        ["\xC7\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\x94\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],

        ["\xC7\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\x94\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],

        ["\xC7\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\x94\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],

        ["\xC7\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\x94\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],

        ["\xC7\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\x94\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],

        ["\xC7\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\x94\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],

        ["\xC7\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\x94\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],

        ["\xC7\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\x94\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],

        ["\xC7\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\x94\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],

        ["\xC7\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\x94\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],

        ["\xC7\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\x94\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],

        ["\xC7\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\x94\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],

        ["\xC7\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\x94\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],

        ["\xC7\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\x94\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],

        ["\xC7\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\x94\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],

        ["\xC7\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\x94\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],

        ["\xC7\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\x94\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],

        ["\xC7\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\x94\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],

        ["\xC7\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\x94\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],

        ["\xC7\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\x94\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],

        ["\xC7\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\x94\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],

        ["\xC7\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\x94\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],

        ["\xC7\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\x94\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],

        ["\xC7\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\x94\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],

        ["\xC7\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\x94\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],

        ["\xC7\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\x94\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],

        ["\xC7\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\x94\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],

        ["\xC7\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\x94\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],

        ["\xC7\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\x94\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],

        ["\xC7\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\x94\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],

        ["\xC7\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\x94\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],

        ["\xC7\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\x94\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],

        ["\xC7\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\x94\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],

        ["\xC7\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\x94\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],

        ["\xC7\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\x94\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],

        ["\xC7\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\x94\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],

        ["\xC7\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\x94\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],

        ["\xC7\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\x94\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],

        ["\xC7\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\x94\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],

        ["\xC7\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\x94\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],

        ["\xC7\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\x94\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],

        ["\xC7\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\x94\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],

        ["\xC7\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\x94\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],

        ["\xC7\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\x94\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],

        ["\xC7\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\x94\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],

        ["\xC7\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\x94\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],

        ["\xC7\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\x94\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],

        ["\xC7\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\x94\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],

        ["\xC7\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\x94\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],

        ["\xC7\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\x94\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],

        ["\xC7\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\x94\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],

        ["\xC7\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\x94\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],

        ["\xC7\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\x94\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],

        ["\xC7\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\x94\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],

        ["\xC7\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\x94\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],

        ["\xC7\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\x94\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],

        ["\xC7\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\x94\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],

        ["\xC7\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\x94\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],

        ["\xC7\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\x94\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],

        ["\xC7\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\x94\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],

        ["\xC7\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\x94\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],

        ["\xC7\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\x94\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],

        ["\xC7\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\x94\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],

        ["\xC7\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\x94\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],

        ["\xC7\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\x94\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],

        ["\xC7\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\x94\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],

        ["\xC8\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\x94\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],

        ["\xC8\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\x94\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],

        ["\xC8\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\x94\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],

        ["\xC8\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\x94\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],

        ["\xC8\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\x94\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],

        ["\xC8\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\x94\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],

        ["\xC8\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\x94\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],

        ["\xC8\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\x94\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],

        ["\xC8\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\x94\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],

        ["\xC8\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\x94\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],

        ["\xC8\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\x94\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],

        ["\xC8\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\x94\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],

        ["\xC8\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\x94\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],

        ["\xC8\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\x94\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],

        ["\xC8\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\x94\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],

        ["\xC8\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\x94\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],

        ["\xC8\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\x94\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],

        ["\xC8\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\x94\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],

        ["\xC8\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\x94\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],

        ["\xC8\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\x94\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],

        ["\xC8\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\x94\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],

        ["\xC8\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\x94\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],

        ["\xC8\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\x94\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],

        ["\xC8\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\x94\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],

        ["\xC8\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\x94\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],

        ["\xC8\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\x94\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],

        ["\xC8\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\x94\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],

        ["\xC8\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\x94\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],

        ["\xC8\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\x94\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],

        ["\xC8\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\x94\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],

        ["\xC8\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\x94\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],

        ["\xC8\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\x94\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],

        ["\xC8\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\x94\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],

        ["\xC8\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\x94\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],

        ["\xC8\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\x94\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],

        ["\xC8\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\x94\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],

        ["\xC8\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\x94\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],

        ["\xC8\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\x94\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],

        ["\xC8\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\x94\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],

        ["\xC8\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\x94\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],

        ["\xC8\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\x94\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],

        ["\xC8\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\x94\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],

        ["\xC8\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\x94\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],

        ["\xC8\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\x94\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],

        ["\xC8\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\x94\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],

        ["\xC8\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\x94\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],

        ["\xC8\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\x94\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],

        ["\xC8\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\x94\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],

        ["\xC8\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\x94\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],

        ["\xC8\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\x94\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],

        ["\xC8\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\x94\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],

        ["\xC8\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\x94\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],

        ["\xC8\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\x94\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],

        ["\xC8\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\x94\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],

        ["\xC8\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\x94\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],

        ["\xC8\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\x94\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],

        ["\xC8\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\x94\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],

        ["\xC8\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\x94\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],

        ["\xC8\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\x94\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],

        ["\xC8\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\x94\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],

        ["\xC8\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\x94\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],

        ["\xC8\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\x94\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],

        ["\xC8\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\x94\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],

        ["\xC8\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\x94\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],

        ["\xC8\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\x94\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],

        ["\xC8\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\x94\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],

        ["\xC8\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\x94\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],

        ["\xC8\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\x94\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],

        ["\xC8\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\x94\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],

        ["\xC8\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\x94\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],

        ["\xC8\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\x94\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],

        ["\xC8\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\x94\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],

        ["\xC8\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\x94\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],

        ["\xC8\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\x94\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],

        ["\xC8\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\x94\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],

        ["\xC8\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\x94\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],

        ["\xC8\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\x94\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],

        ["\xC8\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\x94\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],

        ["\xC8\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\x94\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],

        ["\xC8\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\x94\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],

        ["\xC8\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\x94\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],

        ["\xC8\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\x94\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],

        ["\xC8\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\x94\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],

        ["\xC8\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\x94\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],

        ["\xC8\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\x94\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],

        ["\xC8\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\x94\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],

        ["\xC8\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\x94\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],

        ["\xC8\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\x94\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],

        ["\xC8\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\x94\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],

        ["\xC8\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\x94\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],

        ["\xC8\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\x94\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],

        ["\xC8\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\x94\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],

        ["\xC8\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\x94\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],

        ["\xC8\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\x94\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],

        ["\xC9\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\x95\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],

        ["\xC9\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\x95\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],

        ["\xC9\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\x95\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],

        ["\xC9\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\x95\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],

        ["\xC9\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\x95\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],

        ["\xC9\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\x95\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],

        ["\xC9\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\x95\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],

        ["\xC9\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\x95\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],

        ["\xC9\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\x95\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],

        ["\xC9\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\x95\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],

        ["\xC9\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\x95\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],

        ["\xC9\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\x95\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],

        ["\xC9\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\x95\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],

        ["\xC9\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\x95\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],

        ["\xC9\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\x95\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],

        ["\xC9\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\x95\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],

        ["\xC9\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\x95\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],

        ["\xC9\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\x95\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],

        ["\xC9\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\x95\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],

        ["\xC9\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\x95\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],

        ["\xC9\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\x95\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],

        ["\xC9\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\x95\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],

        ["\xC9\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\x95\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],

        ["\xC9\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\x95\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],

        ["\xC9\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\x95\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],

        ["\xC9\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\x95\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],

        ["\xC9\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\x95\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],

        ["\xC9\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\x95\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],

        ["\xC9\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\x95\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],

        ["\xC9\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\x95\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],

        ["\xC9\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\x95\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],

        ["\xC9\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\x95\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],

        ["\xC9\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\x95\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],

        ["\xC9\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\x95\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],

        ["\xC9\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\x95\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],

        ["\xC9\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\x95\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],

        ["\xC9\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\x95\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],

        ["\xC9\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\x95\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],

        ["\xC9\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\x95\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],

        ["\xC9\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\x95\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],

        ["\xC9\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\x95\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],

        ["\xC9\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\x95\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],

        ["\xC9\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\x95\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],

        ["\xC9\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\x95\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],

        ["\xC9\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\x95\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],

        ["\xC9\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\x95\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],

        ["\xC9\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\x95\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],

        ["\xC9\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\x95\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],

        ["\xC9\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\x95\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],

        ["\xC9\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\x95\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],

        ["\xC9\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\x95\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],

        ["\xC9\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\x95\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],

        ["\xC9\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\x95\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],

        ["\xC9\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\x95\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],

        ["\xC9\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\x95\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],

        ["\xC9\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\x95\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],

        ["\xC9\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\x95\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],

        ["\xC9\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\x95\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],

        ["\xC9\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\x95\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],

        ["\xC9\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\x95\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],

        ["\xC9\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\x95\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],

        ["\xC9\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\x95\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],

        ["\xC9\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\x95\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],

        ["\xC9\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\x95\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],

        ["\xC9\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\x95\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],

        ["\xC9\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\x95\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],

        ["\xC9\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\x95\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],

        ["\xC9\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\x95\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],

        ["\xC9\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\x95\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],

        ["\xC9\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\x95\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],

        ["\xC9\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\x95\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],

        ["\xC9\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\x95\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],

        ["\xC9\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\x95\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],

        ["\xC9\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\x95\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],

        ["\xC9\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\x95\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],

        ["\xC9\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\x95\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],

        ["\xC9\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\x95\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],

        ["\xC9\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\x95\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],

        ["\xC9\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\x95\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],

        ["\xC9\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\x95\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],

        ["\xC9\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\x95\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],

        ["\xC9\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\x95\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],

        ["\xC9\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\x95\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],

        ["\xC9\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\x95\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],

        ["\xC9\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\x95\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],

        ["\xC9\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\x95\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],

        ["\xC9\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\x95\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],

        ["\xC9\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\x95\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],

        ["\xC9\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\x95\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],

        ["\xC9\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\x95\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],

        ["\xC9\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\x95\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],

        ["\xC9\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\x95\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],

        ["\xC9\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\x95\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],

        ["\xC9\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\x95\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],

        ["\xCA\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\x95\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],

        ["\xCA\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\x95\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],

        ["\xCA\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\x95\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],

        ["\xCA\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\x95\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],

        ["\xCA\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\x95\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],

        ["\xCA\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\x95\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],

        ["\xCA\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\x95\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],

        ["\xCA\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\x95\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],

        ["\xCA\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\x95\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],

        ["\xCA\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\x95\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],

        ["\xCA\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\x95\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],

        ["\xCA\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\x95\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],

        ["\xCA\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\x95\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],

        ["\xCA\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\x95\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],

        ["\xCA\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\x95\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],

        ["\xCA\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\x95\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],

        ["\xCA\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\x95\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],

        ["\xCA\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\x95\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],

        ["\xCA\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\x95\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],

        ["\xCA\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\x95\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],

        ["\xCA\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\x95\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],

        ["\xCA\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\x95\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],

        ["\xCA\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\x95\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],

        ["\xCA\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\x95\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],

        ["\xCA\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\x95\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],

        ["\xCA\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\x95\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],

        ["\xCA\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\x95\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],

        ["\xCA\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\x95\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],

        ["\xCA\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\x95\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],

        ["\xCA\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\x95\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],

        ["\xCA\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\x95\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],

        ["\xCA\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\x95\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],

        ["\xCA\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\x95\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],

        ["\xCA\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\x95\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],

        ["\xCA\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\x95\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],

        ["\xCA\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\x95\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],

        ["\xCA\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\x95\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],

        ["\xCA\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\x95\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],

        ["\xCA\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\x95\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],

        ["\xCA\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\x95\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],

        ["\xCA\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\x95\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],

        ["\xCA\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\x95\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],

        ["\xCA\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\x95\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],

        ["\xCA\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\x95\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],

        ["\xCA\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\x95\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],

        ["\xCA\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\x95\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],

        ["\xCA\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\x95\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],

        ["\xCA\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\x95\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],

        ["\xCA\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\x95\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],

        ["\xCA\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\x95\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],

        ["\xCA\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\x95\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],

        ["\xCA\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\x95\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],

        ["\xCA\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\x95\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],

        ["\xCA\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\x95\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],

        ["\xCA\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\x95\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],

        ["\xCA\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\x95\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],

        ["\xCA\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\x95\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],

        ["\xCA\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\x95\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],

        ["\xCA\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\x95\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],

        ["\xCA\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\x95\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],

        ["\xCA\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\x95\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],

        ["\xCA\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\x95\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],

        ["\xCA\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\x95\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],

        ["\xCA\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\x95\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],

        ["\xCA\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\x95\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],

        ["\xCA\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\x95\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],

        ["\xCA\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\x95\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],

        ["\xCA\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\x95\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],

        ["\xCA\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\x95\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],

        ["\xCA\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\x95\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],

        ["\xCA\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\x95\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],

        ["\xCA\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\x95\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],

        ["\xCA\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\x95\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],

        ["\xCA\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\x95\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],

        ["\xCA\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\x95\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],

        ["\xCA\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\x95\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],

        ["\xCA\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\x95\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],

        ["\xCA\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\x95\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],

        ["\xCA\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\x95\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],

        ["\xCA\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\x95\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],

        ["\xCA\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\x95\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],

        ["\xCA\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\x95\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],

        ["\xCA\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\x95\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],

        ["\xCA\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\x95\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],

        ["\xCA\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\x95\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],

        ["\xCA\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\x95\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],

        ["\xCA\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\x95\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],

        ["\xCA\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\x95\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],

        ["\xCA\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\x95\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],

        ["\xCA\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\x95\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],

        ["\xCA\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\x95\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],

        ["\xCA\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\x95\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],

        ["\xCA\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\x95\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],

        ["\xCA\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\x95\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],

        ["\xCB\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\x96\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],

        ["\xCB\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\x96\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],

        ["\xCB\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\x96\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],

        ["\xCB\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\x96\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],

        ["\xCB\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\x96\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],

        ["\xCB\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\x96\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],

        ["\xCB\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\x96\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],

        ["\xCB\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\x96\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],

        ["\xCB\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\x96\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],

        ["\xCB\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\x96\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],

        ["\xCB\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\x96\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],

        ["\xCB\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\x96\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],

        ["\xCB\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\x96\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],

        ["\xCB\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\x96\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],

        ["\xCB\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\x96\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],

        ["\xCB\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\x96\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],

        ["\xCB\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\x96\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],

        ["\xCB\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\x96\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],

        ["\xCB\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\x96\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],

        ["\xCB\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\x96\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],

        ["\xCB\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\x96\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],

        ["\xCB\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\x96\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],

        ["\xCB\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\x96\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],

        ["\xCB\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\x96\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],

        ["\xCB\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\x96\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],

        ["\xCB\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\x96\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],

        ["\xCB\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\x96\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],

        ["\xCB\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\x96\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],

        ["\xCB\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\x96\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],

        ["\xCB\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\x96\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],

        ["\xCB\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\x96\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],

        ["\xCB\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\x96\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],

        ["\xCB\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\x96\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],

        ["\xCB\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\x96\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],

        ["\xCB\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\x96\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],

        ["\xCB\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\x96\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],

        ["\xCB\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\x96\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],

        ["\xCB\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\x96\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],

        ["\xCB\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\x96\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],

        ["\xCB\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\x96\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],

        ["\xCB\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\x96\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],

        ["\xCB\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\x96\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],

        ["\xCB\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\x96\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],

        ["\xCB\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\x96\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],

        ["\xCB\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\x96\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],

        ["\xCB\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\x96\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],

        ["\xCB\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\x96\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],

        ["\xCB\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\x96\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],

        ["\xCB\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\x96\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],

        ["\xCB\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\x96\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],

        ["\xCB\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\x96\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],

        ["\xCB\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\x96\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],

        ["\xCB\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\x96\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],

        ["\xCB\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\x96\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],

        ["\xCB\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\x96\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],

        ["\xCB\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\x96\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],

        ["\xCB\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\x96\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],

        ["\xCB\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\x96\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],

        ["\xCB\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\x96\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],

        ["\xCB\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\x96\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],

        ["\xCB\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\x96\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],

        ["\xCB\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\x96\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],

        ["\xCB\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\x96\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],

        ["\xCB\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\x96\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],

        ["\xCB\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\x96\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],

        ["\xCB\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\x96\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],

        ["\xCB\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\x96\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],

        ["\xCB\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\x96\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],

        ["\xCB\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\x96\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],

        ["\xCB\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\x96\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],

        ["\xCB\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\x96\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],

        ["\xCB\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\x96\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],

        ["\xCB\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\x96\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],

        ["\xCB\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\x96\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],

        ["\xCB\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\x96\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],

        ["\xCB\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\x96\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],

        ["\xCB\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\x96\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],

        ["\xCB\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\x96\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],

        ["\xCB\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\x96\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],

        ["\xCB\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\x96\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],

        ["\xCB\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\x96\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],

        ["\xCB\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\x96\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],

        ["\xCB\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\x96\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],

        ["\xCB\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\x96\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],

        ["\xCB\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\x96\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],

        ["\xCB\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\x96\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],

        ["\xCB\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\x96\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],

        ["\xCB\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\x96\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],

        ["\xCB\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\x96\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],

        ["\xCB\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\x96\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],

        ["\xCB\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\x96\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],

        ["\xCB\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\x96\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],

        ["\xCB\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\x96\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],

        ["\xCB\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\x96\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],

        ["\xCC\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\x96\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],

        ["\xCC\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\x96\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],

        ["\xCC\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\x96\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],

        ["\xCC\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\x96\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],

        ["\xCC\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\x96\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],

        ["\xCC\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\x96\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],

        ["\xCC\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\x96\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],

        ["\xCC\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\x96\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],

        ["\xCC\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\x96\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],

        ["\xCC\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\x96\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],

        ["\xCC\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\x96\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],

        ["\xCC\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\x96\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],

        ["\xCC\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\x96\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],

        ["\xCC\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\x96\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],

        ["\xCC\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\x96\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],

        ["\xCC\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\x96\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],

        ["\xCC\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\x96\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],

        ["\xCC\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\x96\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],

        ["\xCC\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\x96\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],

        ["\xCC\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\x96\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],

        ["\xCC\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\x96\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],

        ["\xCC\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\x96\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],

        ["\xCC\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\x96\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],

        ["\xCC\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\x96\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],

        ["\xCC\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\x96\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],

        ["\xCC\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\x96\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],

        ["\xCC\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\x96\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],

        ["\xCC\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\x96\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],

        ["\xCC\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\x96\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],

        ["\xCC\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\x96\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],

        ["\xCC\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\x96\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],

        ["\xCC\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\x96\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],

        ["\xCC\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\x96\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],

        ["\xCC\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\x96\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],

        ["\xCC\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\x96\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],

        ["\xCC\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\x96\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],

        ["\xCC\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\x96\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],

        ["\xCC\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\x96\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],

        ["\xCC\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\x96\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],

        ["\xCC\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\x96\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],

        ["\xCC\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\x96\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],

        ["\xCC\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\x96\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],

        ["\xCC\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\x96\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],

        ["\xCC\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\x96\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],

        ["\xCC\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\x96\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],

        ["\xCC\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\x96\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],

        ["\xCC\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\x96\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],

        ["\xCC\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\x96\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],

        ["\xCC\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\x96\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],

        ["\xCC\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\x96\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],

        ["\xCC\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\x96\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],

        ["\xCC\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\x96\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],

        ["\xCC\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\x96\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],

        ["\xCC\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\x96\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],

        ["\xCC\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\x96\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],

        ["\xCC\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\x96\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],

        ["\xCC\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\x96\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],

        ["\xCC\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\x96\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],

        ["\xCC\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\x96\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],

        ["\xCC\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\x96\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],

        ["\xCC\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\x96\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],

        ["\xCC\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\x96\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],

        ["\xCC\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\x96\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],

        ["\xCC\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\x96\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],

        ["\xCC\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\x96\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],

        ["\xCC\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\x96\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],

        ["\xCC\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\x96\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],

        ["\xCC\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\x96\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],

        ["\xCC\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\x96\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],

        ["\xCC\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\x96\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],

        ["\xCC\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\x96\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],

        ["\xCC\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\x96\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],

        ["\xCC\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\x96\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],

        ["\xCC\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\x96\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],

        ["\xCC\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\x96\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],

        ["\xCC\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\x96\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],

        ["\xCC\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\x96\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],

        ["\xCC\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\x96\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],

        ["\xCC\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\x96\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],

        ["\xCC\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\x96\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],

        ["\xCC\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\x96\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],

        ["\xCC\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\x96\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],

        ["\xCC\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\x96\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],

        ["\xCC\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\x96\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],

        ["\xCC\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\x96\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],

        ["\xCC\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\x96\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],

        ["\xCC\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\x96\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],

        ["\xCC\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\x96\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],

        ["\xCC\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\x96\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],

        ["\xCC\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\x96\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],

        ["\xCC\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\x96\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],

        ["\xCC\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\x96\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],

        ["\xCC\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\x96\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],

        ["\xCC\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\x96\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],

        ["\xCD\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\x97\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],

        ["\xCD\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\x97\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],

        ["\xCD\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\x97\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],

        ["\xCD\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\x97\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],

        ["\xCD\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\x97\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],

        ["\xCD\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\x97\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],

        ["\xCD\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\x97\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],

        ["\xCD\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\x97\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],

        ["\xCD\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\x97\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],

        ["\xCD\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\x97\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],

        ["\xCD\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\x97\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],

        ["\xCD\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\x97\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],

        ["\xCD\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\x97\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],

        ["\xCD\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\x97\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],

        ["\xCD\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\x97\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],

        ["\xCD\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\x97\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],

        ["\xCD\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\x97\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],

        ["\xCD\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\x97\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],

        ["\xCD\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\x97\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],

        ["\xCD\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\x97\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],

        ["\xCD\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\x97\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],

        ["\xCD\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\x97\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],

        ["\xCD\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\x97\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],

        ["\xCD\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\x97\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],

        ["\xCD\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\x97\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],

        ["\xCD\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\x97\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],

        ["\xCD\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\x97\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],

        ["\xCD\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\x97\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],

        ["\xCD\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\x97\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],

        ["\xCD\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\x97\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],

        ["\xCD\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\x97\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],

        ["\xCD\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\x97\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],

        ["\xCD\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\x97\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],

        ["\xCD\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\x97\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],

        ["\xCD\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\x97\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],

        ["\xCD\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\x97\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],

        ["\xCD\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\x97\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],

        ["\xCD\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\x97\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],

        ["\xCD\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\x97\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],

        ["\xCD\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\x97\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],

        ["\xCD\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\x97\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],

        ["\xCD\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\x97\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],

        ["\xCD\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\x97\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],

        ["\xCD\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\x97\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],

        ["\xCD\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\x97\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],

        ["\xCD\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\x97\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],

        ["\xCD\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\x97\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],

        ["\xCD\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\x97\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],

        ["\xCD\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\x97\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],

        ["\xCD\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\x97\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],

        ["\xCD\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\x97\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],

        ["\xCD\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\x97\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],

        ["\xCD\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\x97\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],

        ["\xCD\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\x97\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],

        ["\xCD\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\x97\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],

        ["\xCD\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\x97\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],

        ["\xCD\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\x97\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],

        ["\xCD\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\x97\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],

        ["\xCD\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\x97\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],

        ["\xCD\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\x97\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],

        ["\xCD\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\x97\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],

        ["\xCD\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\x97\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],

        ["\xCD\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\x97\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],

        ["\xCD\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\x97\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],

        ["\xCD\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\x97\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],

        ["\xCD\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\x97\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],

        ["\xCD\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\x97\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],

        ["\xCD\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\x97\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],

        ["\xCD\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\x97\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],

        ["\xCD\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\x97\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],

        ["\xCD\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\x97\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],

        ["\xCD\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\x97\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],

        ["\xCD\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\x97\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],

        ["\xCD\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\x97\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],

        ["\xCD\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\x97\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],

        ["\xCD\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\x97\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],

        ["\xCD\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\x97\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],

        ["\xCD\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\x97\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],

        ["\xCD\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\x97\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],

        ["\xCD\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\x97\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],

        ["\xCD\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\x97\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],

        ["\xCD\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\x97\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],

        ["\xCD\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\x97\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],

        ["\xCD\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\x97\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],

        ["\xCD\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\x97\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],

        ["\xCD\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\x97\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],

        ["\xCD\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\x97\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],

        ["\xCD\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\x97\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],

        ["\xCD\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\x97\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],

        ["\xCD\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\x97\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],

        ["\xCD\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\x97\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],

        ["\xCD\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\x97\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],

        ["\xCD\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\x97\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],

        ["\xCD\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\x97\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],

        ["\xCE\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\x97\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\x97\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],

        ["\xCE\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\x97\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\x97\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\x97\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\x97\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\x97\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\x97\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\x97\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\x97\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],

        ["\xCE\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\x97\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],

        ["\xCE\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\x97\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],

        ["\xCE\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\x97\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],

        ["\xCE\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\x97\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],

        ["\xCE\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\x97\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],

        ["\xCE\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\x97\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],

        ["\xCE\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\x97\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\x97\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\x97\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\x97\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\x97\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\x97\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\x97\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\x97\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\x97\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\x97\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\x97\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\x97\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\x97\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\x97\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\x97\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCE\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\x97\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],

        ["\xCE\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\x97\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],

        ["\xCE\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\x97\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],

        ["\xCE\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\x97\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],

        ["\xCE\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\x97\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],

        ["\xCE\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\x97\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],

        ["\xCE\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\x97\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],

        ["\xCE\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\x97\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],

        ["\xCE\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\x97\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],

        ["\xCE\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\x97\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],

        ["\xCE\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\x97\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],

        ["\xCE\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\x97\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],

        ["\xCE\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\x97\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],

        ["\xCE\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\x97\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],

        ["\xCE\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\x97\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],

        ["\xCE\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\x97\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],

        ["\xCE\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\x97\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],

        ["\xCE\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\x97\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],

        ["\xCE\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\x97\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],

        ["\xCE\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\x97\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],

        ["\xCE\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\x97\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],

        ["\xCE\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\x97\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],

        ["\xCE\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\x97\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],

        ["\xCE\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\x97\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],

        ["\xCE\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\x97\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],

        ["\xCE\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\x97\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],

        ["\xCE\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\x97\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],

        ["\xCE\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\x97\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],

        ["\xCE\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\x97\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],

        ["\xCE\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\x97\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],

        ["\xCE\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\x97\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],

        ["\xCE\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\x97\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],

        ["\xCE\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\x97\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],

        ["\xCE\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\x97\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],

        ["\xCE\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\x97\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],

        ["\xCE\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\x97\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],

        ["\xCE\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\x97\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],

        ["\xCE\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\x97\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],

        ["\xCE\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\x97\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],

        ["\xCE\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\x97\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],

        ["\xCE\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\x97\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],

        ["\xCE\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\x97\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],

        ["\xCE\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\x97\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],

        ["\xCE\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\x97\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],

        ["\xCE\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\x97\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],

        ["\xCE\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\x97\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],

        ["\xCE\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\x97\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],

        ["\xCE\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\x97\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],

        ["\xCE\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\x97\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],

        ["\xCE\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\x97\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],

        ["\xCE\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\x97\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],

        ["\xCE\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\x97\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],

        ["\xCE\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\x97\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],

        ["\xCE\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\x97\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],

        ["\xCE\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\x97\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],

        ["\xCE\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\x97\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],

        ["\xCE\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\x97\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],

        ["\xCE\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\x97\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],

        ["\xCE\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\x97\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],

        ["\xCE\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\x97\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],

        ["\xCE\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\x97\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],

        ["\xCE\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\x97\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],

        ["\xCE\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\x97\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],

        ["\xCF\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\x98\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],

        ["\xCF\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\x98\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],

        ["\xCF\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\x98\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],

        ["\xCF\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\x98\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],

        ["\xCF\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\x98\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],

        ["\xCF\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\x98\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],

        ["\xCF\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\x98\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],

        ["\xCF\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\x98\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],

        ["\xCF\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\x98\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],

        ["\xCF\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\x98\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],

        ["\xCF\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\x98\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],

        ["\xCF\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\x98\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],

        ["\xCF\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\x98\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],

        ["\xCF\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\x98\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],

        ["\xCF\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\x98\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],

        ["\xCF\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\x98\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],

        ["\xCF\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\x98\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],

        ["\xCF\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\x98\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],

        ["\xCF\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\x98\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],

        ["\xCF\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\x98\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],

        ["\xCF\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\x98\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],

        ["\xCF\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\x98\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],

        ["\xCF\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\x98\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],

        ["\xCF\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\x98\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],

        ["\xCF\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\x98\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],

        ["\xCF\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\x98\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],

        ["\xCF\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\x98\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],

        ["\xCF\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\x98\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],

        ["\xCF\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\x98\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],

        ["\xCF\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\x98\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],

        ["\xCF\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\x98\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],

        ["\xCF\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\x98\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],

        ["\xCF\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\x98\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],

        ["\xCF\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\x98\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],

        ["\xCF\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\x98\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],

        ["\xCF\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\x98\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],

        ["\xCF\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\x98\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],

        ["\xCF\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\x98\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],

        ["\xCF\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\x98\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],

        ["\xCF\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\x98\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],

        ["\xCF\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\x98\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],

        ["\xCF\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\x98\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],

        ["\xCF\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\x98\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],

        ["\xCF\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\x98\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],

        ["\xCF\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\x98\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],

        ["\xCF\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\x98\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],

        ["\xCF\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\x98\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],

        ["\xCF\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\x98\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],

        ["\xCF\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\x98\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],

        ["\xCF\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\x98\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],

        ["\xCF\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\x98\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],

        ["\xD0\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\x98\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\x98\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\x98\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\x98\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\x98\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\x98\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\x98\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\x98\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\x98\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\x98\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\x98\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\x98\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\x98\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\x98\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\x98\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\x98\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\x98\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\x98\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\x98\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\x98\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\x98\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD0\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\x98\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\x98\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\x98\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\x98\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\x98\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\x98\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\x98\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\x98\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\x98\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\x98\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD0\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\x98\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],

        ["\xD0\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\x98\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],

        ["\xD0\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\x98\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],

        ["\xD0\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\x98\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],

        ["\xD0\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\x98\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],

        ["\xD0\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\x98\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],

        ["\xD0\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\x98\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],

        ["\xD0\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\x98\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],

        ["\xD0\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\x98\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],

        ["\xD0\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\x98\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],

        ["\xD0\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\x98\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],

        ["\xD0\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\x98\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],

        ["\xD0\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\x98\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],

        ["\xD0\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\x98\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],

        ["\xD0\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\x98\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],

        ["\xD0\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\x98\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],

        ["\xD0\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\x98\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],

        ["\xD0\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\x98\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],

        ["\xD0\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\x98\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],

        ["\xD0\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\x98\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],

        ["\xD0\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\x98\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],

        ["\xD0\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\x98\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],

        ["\xD0\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\x98\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],

        ["\xD0\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\x98\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],

        ["\xD0\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\x98\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],

        ["\xD0\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\x98\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],

        ["\xD0\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\x98\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],

        ["\xD0\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\x98\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],

        ["\xD0\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\x98\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],

        ["\xD0\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\x98\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],

        ["\xD0\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\x98\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],

        ["\xD0\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\x98\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],

        ["\xD0\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\x98\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],

        ["\xD0\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\x98\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],

        ["\xD0\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\x98\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],

        ["\xD0\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\x98\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],

        ["\xD0\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\x98\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],

        ["\xD0\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\x98\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],

        ["\xD0\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\x98\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],

        ["\xD0\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\x98\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],

        ["\xD0\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\x98\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],

        ["\xD0\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\x98\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],

        ["\xD0\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\x98\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],

        ["\xD0\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\x98\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],

        ["\xD0\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\x98\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],

        ["\xD0\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\x98\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],

        ["\xD0\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\x98\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],

        ["\xD0\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\x98\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],

        ["\xD0\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\x98\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],

        ["\xD0\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\x98\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],

        ["\xD0\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\x98\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],

        ["\xD0\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\x98\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],

        ["\xD0\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\x98\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],

        ["\xD0\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\x98\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],

        ["\xD0\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\x98\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],

        ["\xD0\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\x98\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],

        ["\xD0\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\x98\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],

        ["\xD0\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\x98\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],

        ["\xD0\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\x98\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],

        ["\xD0\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\x98\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],

        ["\xD0\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\x98\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],

        ["\xD0\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\x98\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],

        ["\xD0\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\x98\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],

        ["\xD1\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\x99\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],

        ["\xD1\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\x99\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],

        ["\xD1\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\x99\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],

        ["\xD1\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\x99\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],

        ["\xD1\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\x99\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],

        ["\xD1\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\x99\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],

        ["\xD1\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\x99\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],

        ["\xD1\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\x99\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],

        ["\xD1\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\x99\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],

        ["\xD1\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\x99\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],

        ["\xD1\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\x99\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],

        ["\xD1\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\x99\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],

        ["\xD1\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\x99\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],

        ["\xD1\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\x99\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],

        ["\xD1\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\x99\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],

        ["\xD1\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\x99\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],

        ["\xD1\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\x99\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],

        ["\xD1\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\x99\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],

        ["\xD1\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\x99\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],

        ["\xD1\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\x99\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],

        ["\xD1\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\x99\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],

        ["\xD1\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\x99\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],

        ["\xD1\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\x99\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],

        ["\xD1\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\x99\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],

        ["\xD1\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\x99\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],

        ["\xD1\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\x99\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],

        ["\xD1\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\x99\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],

        ["\xD1\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\x99\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],

        ["\xD1\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\x99\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],

        ["\xD1\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\x99\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],

        ["\xD1\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\x99\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],

        ["\xD1\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\x99\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],

        ["\xD1\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\x99\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],

        ["\xD1\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\x99\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],

        ["\xD1\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\x99\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],

        ["\xD1\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\x99\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],

        ["\xD1\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\x99\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],

        ["\xD1\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\x99\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],

        ["\xD1\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\x99\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],

        ["\xD1\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\x99\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],

        ["\xD1\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\x99\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],

        ["\xD1\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\x99\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],

        ["\xD1\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\x99\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],

        ["\xD1\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\x99\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],

        ["\xD1\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\x99\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],

        ["\xD1\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\x99\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],

        ["\xD1\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\x99\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],

        ["\xD1\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\x99\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],

        ["\xD1\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\x99\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],

        ["\xD1\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\x99\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],

        ["\xD1\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\x99\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],

        ["\xD1\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\x99\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],

        ["\xD1\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\x99\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],

        ["\xD1\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\x99\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],

        ["\xD1\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\x99\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],

        ["\xD1\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\x99\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],

        ["\xD1\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\x99\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],

        ["\xD1\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\x99\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],

        ["\xD1\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\x99\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],

        ["\xD1\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\x99\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],

        ["\xD1\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\x99\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],

        ["\xD1\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\x99\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],

        ["\xD1\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\x99\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],

        ["\xD1\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\x99\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],

        ["\xD1\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\x99\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],

        ["\xD1\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\x99\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],

        ["\xD1\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\x99\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],

        ["\xD1\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\x99\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],

        ["\xD1\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\x99\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],

        ["\xD1\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\x99\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],

        ["\xD1\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\x99\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],

        ["\xD1\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\x99\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],

        ["\xD1\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\x99\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],

        ["\xD1\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\x99\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],

        ["\xD1\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\x99\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],

        ["\xD1\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\x99\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],

        ["\xD1\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\x99\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],

        ["\xD1\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\x99\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],

        ["\xD1\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\x99\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],

        ["\xD1\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\x99\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],

        ["\xD1\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\x99\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],

        ["\xD1\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\x99\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],

        ["\xD1\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\x99\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],

        ["\xD1\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\x99\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],

        ["\xD1\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\x99\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],

        ["\xD1\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\x99\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],

        ["\xD1\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\x99\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],

        ["\xD1\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\x99\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],

        ["\xD1\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\x99\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],

        ["\xD1\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\x99\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],

        ["\xD1\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\x99\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],

        ["\xD1\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\x99\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],

        ["\xD1\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\x99\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],

        ["\xD1\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\x99\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],

        ["\xD2\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\x99\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],

        ["\xD2\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\x99\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],

        ["\xD2\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\x99\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],

        ["\xD2\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\x99\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],

        ["\xD2\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\x99\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],

        ["\xD2\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\x99\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],

        ["\xD2\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\x99\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],

        ["\xD2\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\x99\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],

        ["\xD2\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\x99\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],

        ["\xD2\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\x99\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],

        ["\xD2\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\x99\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],

        ["\xD2\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\x99\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],

        ["\xD2\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\x99\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],

        ["\xD2\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\x99\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],

        ["\xD2\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\x99\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],

        ["\xD2\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\x99\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],

        ["\xD2\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\x99\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],

        ["\xD2\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\x99\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],

        ["\xD2\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\x99\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],

        ["\xD2\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\x99\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],

        ["\xD2\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\x99\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],

        ["\xD2\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\x99\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],

        ["\xD2\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\x99\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],

        ["\xD2\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\x99\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],

        ["\xD2\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\x99\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],

        ["\xD2\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\x99\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],

        ["\xD2\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\x99\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],

        ["\xD2\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\x99\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],

        ["\xD2\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\x99\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],

        ["\xD2\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\x99\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],

        ["\xD2\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\x99\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],

        ["\xD2\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\x99\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],

        ["\xD2\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\x99\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],

        ["\xD2\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\x99\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],

        ["\xD2\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\x99\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],

        ["\xD2\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\x99\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],

        ["\xD2\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\x99\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],

        ["\xD2\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\x99\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],

        ["\xD2\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\x99\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],

        ["\xD2\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\x99\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],

        ["\xD2\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\x99\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],

        ["\xD2\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\x99\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],

        ["\xD2\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\x99\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],

        ["\xD2\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\x99\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],

        ["\xD2\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\x99\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],

        ["\xD2\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\x99\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],

        ["\xD2\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\x99\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],

        ["\xD2\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\x99\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],

        ["\xD2\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\x99\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],

        ["\xD2\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\x99\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],

        ["\xD2\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\x99\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],

        ["\xD2\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\x99\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],

        ["\xD2\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\x99\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],

        ["\xD2\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\x99\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],

        ["\xD2\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\x99\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],

        ["\xD2\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\x99\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],

        ["\xD2\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\x99\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],

        ["\xD2\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\x99\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],

        ["\xD2\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\x99\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],

        ["\xD2\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\x99\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],

        ["\xD2\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\x99\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],

        ["\xD2\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\x99\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],

        ["\xD2\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\x99\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],

        ["\xD2\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\x99\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],

        ["\xD2\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\x99\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],

        ["\xD2\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\x99\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],

        ["\xD2\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\x99\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],

        ["\xD2\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\x99\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],

        ["\xD2\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\x99\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],

        ["\xD2\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\x99\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],

        ["\xD2\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\x99\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],

        ["\xD2\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\x99\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],

        ["\xD2\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\x99\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],

        ["\xD2\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\x99\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],

        ["\xD2\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\x99\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],

        ["\xD2\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\x99\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],

        ["\xD2\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\x99\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],

        ["\xD2\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\x99\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],

        ["\xD2\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\x99\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],

        ["\xD2\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\x99\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],

        ["\xD2\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\x99\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],

        ["\xD2\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\x99\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],

        ["\xD2\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\x99\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],

        ["\xD2\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\x99\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],

        ["\xD2\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\x99\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],

        ["\xD2\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\x99\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],

        ["\xD2\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\x99\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],

        ["\xD2\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\x99\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],

        ["\xD2\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\x99\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],

        ["\xD2\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\x99\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],

        ["\xD2\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\x99\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],

        ["\xD2\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\x99\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],

        ["\xD2\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\x99\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],

        ["\xD2\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\x99\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],

        ["\xD3\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\x9A\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],

        ["\xD3\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\x9A\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],

        ["\xD3\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\x9A\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],

        ["\xD3\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\x9A\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],

        ["\xD3\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\x9A\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],

        ["\xD3\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\x9A\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],

        ["\xD3\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\x9A\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],

        ["\xD3\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\x9A\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],

        ["\xD3\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\x9A\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],

        ["\xD3\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\x9A\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],

        ["\xD3\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\x9A\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],

        ["\xD3\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\x9A\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],

        ["\xD3\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\x9A\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],

        ["\xD3\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\x9A\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],

        ["\xD3\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\x9A\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],

        ["\xD3\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\x9A\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],

        ["\xD3\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\x9A\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],

        ["\xD3\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\x9A\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],

        ["\xD3\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\x9A\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],

        ["\xD3\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\x9A\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],

        ["\xD3\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\x9A\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],

        ["\xD3\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\x9A\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],

        ["\xD3\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\x9A\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],

        ["\xD3\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\x9A\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],

        ["\xD3\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\x9A\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],

        ["\xD3\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\x9A\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],

        ["\xD3\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\x9A\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],

        ["\xD3\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\x9A\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],

        ["\xD3\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\x9A\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],

        ["\xD3\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\x9A\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],

        ["\xD3\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\x9A\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],

        ["\xD3\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\x9A\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],

        ["\xD3\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\x9A\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],

        ["\xD3\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\x9A\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],

        ["\xD3\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\x9A\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],

        ["\xD3\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\x9A\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],

        ["\xD3\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\x9A\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],

        ["\xD3\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\x9A\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],

        ["\xD3\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\x9A\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],

        ["\xD3\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\x9A\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],

        ["\xD3\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\x9A\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],

        ["\xD3\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\x9A\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],

        ["\xD3\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\x9A\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],

        ["\xD3\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\x9A\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],

        ["\xD3\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\x9A\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],

        ["\xD3\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\x9A\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],

        ["\xD3\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\x9A\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],

        ["\xD3\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\x9A\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],

        ["\xD3\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\x9A\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],

        ["\xD3\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\x9A\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],

        ["\xD3\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\x9A\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],

        ["\xD3\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\x9A\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],

        ["\xD3\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\x9A\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],

        ["\xD3\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\x9A\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],

        ["\xD3\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\x9A\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],

        ["\xD3\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\x9A\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],

        ["\xD3\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\x9A\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],

        ["\xD3\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\x9A\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],

        ["\xD3\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\x9A\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],

        ["\xD3\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\x9A\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],

        ["\xD3\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\x9A\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],

        ["\xD3\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\x9A\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],

        ["\xD3\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\x9A\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],

        ["\xD3\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\x9A\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],

        ["\xD3\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\x9A\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],

        ["\xD3\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\x9A\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],

        ["\xD3\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\x9A\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],

        ["\xD3\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\x9A\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],

        ["\xD3\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\x9A\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],

        ["\xD3\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\x9A\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],

        ["\xD3\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\x9A\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],

        ["\xD3\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\x9A\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],

        ["\xD3\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\x9A\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],

        ["\xD3\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\x9A\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],

        ["\xD3\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\x9A\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],

        ["\xD3\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\x9A\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],

        ["\xD3\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\x9A\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],

        ["\xD3\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\x9A\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],

        ["\xD3\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\x9A\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],

        ["\xD3\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\x9A\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],

        ["\xD3\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\x9A\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],

        ["\xD3\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\x9A\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],

        ["\xD3\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\x9A\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],

        ["\xD3\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\x9A\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],

        ["\xD3\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\x9A\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],

        ["\xD3\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\x9A\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],

        ["\xD3\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\x9A\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],

        ["\xD3\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\x9A\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],

        ["\xD3\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\x9A\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],

        ["\xD3\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\x9A\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],

        ["\xD3\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\x9A\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],

        ["\xD3\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\x9A\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],

        ["\xD3\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\x9A\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],

        ["\xD3\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\x9A\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],

        ["\xD4\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\x9A\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],

        ["\xD4\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\x9A\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],

        ["\xD4\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\x9A\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],

        ["\xD4\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\x9A\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],

        ["\xD4\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\x9A\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],

        ["\xD4\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\x9A\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],

        ["\xD4\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\x9A\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],

        ["\xD4\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\x9A\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],

        ["\xD4\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\x9A\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],

        ["\xD4\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\x9A\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],

        ["\xD4\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\x9A\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],

        ["\xD4\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\x9A\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],

        ["\xD4\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\x9A\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],

        ["\xD4\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\x9A\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],

        ["\xD4\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\x9A\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],

        ["\xD4\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\x9A\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],

        ["\xD4\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\x9A\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],

        ["\xD4\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\x9A\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],

        ["\xD4\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\x9A\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],

        ["\xD4\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\x9A\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],

        ["\xD4\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\x9A\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],

        ["\xD4\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\x9A\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],

        ["\xD4\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\x9A\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],

        ["\xD4\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\x9A\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],

        ["\xD4\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\x9A\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],

        ["\xD4\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\x9A\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],

        ["\xD4\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\x9A\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],

        ["\xD4\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\x9A\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],

        ["\xD4\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\x9A\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],

        ["\xD4\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\x9A\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],

        ["\xD4\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\x9A\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],

        ["\xD4\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\x9A\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],

        ["\xD4\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\x9A\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],

        ["\xD4\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\x9A\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],

        ["\xD4\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\x9A\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],

        ["\xD4\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\x9A\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],

        ["\xD4\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\x9A\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],

        ["\xD4\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\x9A\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],

        ["\xD4\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\x9A\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],

        ["\xD4\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\x9A\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],

        ["\xD4\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\x9A\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],

        ["\xD4\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\x9A\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],

        ["\xD4\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\x9A\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],

        ["\xD4\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\x9A\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],

        ["\xD4\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\x9A\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],

        ["\xD4\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\x9A\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],

        ["\xD4\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\x9A\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],

        ["\xD4\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\x9A\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],

        ["\xD4\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\x9A\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],

        ["\xD4\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\x9A\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],

        ["\xD4\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\x9A\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],

        ["\xD4\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\x9A\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],

        ["\xD4\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\x9A\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],

        ["\xD4\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\x9A\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],

        ["\xD4\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\x9A\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],

        ["\xD4\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\x9A\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],

        ["\xD4\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\x9A\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],

        ["\xD4\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\x9A\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],

        ["\xD4\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\x9A\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],

        ["\xD4\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\x9A\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],

        ["\xD4\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\x9A\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],

        ["\xD4\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\x9A\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],

        ["\xD4\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\x9A\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],

        ["\xD4\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\x9A\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],

        ["\xD4\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\x9A\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],

        ["\xD4\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\x9A\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],

        ["\xD4\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\x9A\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],

        ["\xD4\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\x9A\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],

        ["\xD4\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\x9A\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],

        ["\xD4\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\x9A\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],

        ["\xD4\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\x9A\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],

        ["\xD4\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\x9A\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],

        ["\xD4\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\x9A\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],

        ["\xD4\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\x9A\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],

        ["\xD4\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\x9A\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],

        ["\xD4\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\x9A\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],

        ["\xD4\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\x9A\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],

        ["\xD4\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\x9A\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],

        ["\xD4\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\x9A\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],

        ["\xD4\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\x9A\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],

        ["\xD4\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\x9A\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],

        ["\xD4\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\x9A\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],

        ["\xD4\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\x9A\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],

        ["\xD4\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\x9A\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],

        ["\xD4\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\x9A\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],

        ["\xD4\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\x9A\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],

        ["\xD4\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\x9A\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],

        ["\xD4\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\x9A\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],

        ["\xD4\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\x9A\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],

        ["\xD4\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\x9A\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],

        ["\xD4\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\x9A\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],

        ["\xD4\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\x9A\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],

        ["\xD4\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\x9A\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],

        ["\xD4\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\x9A\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],

        ["\xD5\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\x9B\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],

        ["\xD5\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\x9B\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],

        ["\xD5\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\x9B\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],

        ["\xD5\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\x9B\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],

        ["\xD5\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\x9B\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],

        ["\xD5\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\x9B\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],

        ["\xD5\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\x9B\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],

        ["\xD5\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\x9B\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],

        ["\xD5\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\x9B\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],

        ["\xD5\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\x9B\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],

        ["\xD5\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\x9B\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],

        ["\xD5\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\x9B\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],

        ["\xD5\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\x9B\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],

        ["\xD5\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\x9B\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],

        ["\xD5\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\x9B\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],

        ["\xD5\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\x9B\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],

        ["\xD5\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\x9B\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],

        ["\xD5\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\x9B\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],

        ["\xD5\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\x9B\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],

        ["\xD5\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\x9B\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],

        ["\xD5\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\x9B\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],

        ["\xD5\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\x9B\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],

        ["\xD5\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\x9B\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],

        ["\xD5\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\x9B\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],

        ["\xD5\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\x9B\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],

        ["\xD5\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\x9B\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],

        ["\xD5\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\x9B\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],

        ["\xD5\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\x9B\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],

        ["\xD5\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\x9B\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],

        ["\xD5\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\x9B\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],

        ["\xD5\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\x9B\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],

        ["\xD5\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\x9B\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],

        ["\xD5\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\x9B\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],

        ["\xD5\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\x9B\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],

        ["\xD5\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\x9B\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],

        ["\xD5\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\x9B\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],

        ["\xD5\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\x9B\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],

        ["\xD5\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\x9B\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],

        ["\xD5\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\x9B\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],

        ["\xD5\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\x9B\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],

        ["\xD5\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\x9B\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],

        ["\xD5\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\x9B\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],

        ["\xD5\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\x9B\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],

        ["\xD5\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\x9B\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],

        ["\xD5\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\x9B\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],

        ["\xD5\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\x9B\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],

        ["\xD5\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\x9B\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],

        ["\xD5\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\x9B\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],

        ["\xD5\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\x9B\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],

        ["\xD5\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\x9B\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],

        ["\xD5\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\x9B\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],

        ["\xD5\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\x9B\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],

        ["\xD5\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\x9B\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],

        ["\xD5\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\x9B\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],

        ["\xD5\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\x9B\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],

        ["\xD5\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\x9B\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],

        ["\xD5\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\x9B\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],

        ["\xD5\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\x9B\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],

        ["\xD5\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\x9B\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],

        ["\xD5\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\x9B\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],

        ["\xD5\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\x9B\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],

        ["\xD5\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\x9B\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],

        ["\xD5\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\x9B\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],

        ["\xD5\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\x9B\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],

        ["\xD5\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\x9B\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],

        ["\xD5\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\x9B\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],

        ["\xD5\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\x9B\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],

        ["\xD5\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\x9B\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],

        ["\xD5\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\x9B\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],

        ["\xD5\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\x9B\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],

        ["\xD5\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\x9B\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],

        ["\xD5\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\x9B\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],

        ["\xD5\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\x9B\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],

        ["\xD5\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\x9B\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],

        ["\xD5\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\x9B\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],

        ["\xD5\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\x9B\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],

        ["\xD5\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\x9B\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],

        ["\xD5\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\x9B\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],

        ["\xD5\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\x9B\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],

        ["\xD5\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\x9B\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],

        ["\xD5\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\x9B\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],

        ["\xD5\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\x9B\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],

        ["\xD5\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\x9B\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],

        ["\xD5\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\x9B\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],

        ["\xD5\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\x9B\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],

        ["\xD5\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\x9B\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],

        ["\xD5\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\x9B\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],

        ["\xD5\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\x9B\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],

        ["\xD5\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\x9B\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],

        ["\xD5\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\x9B\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],

        ["\xD5\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\x9B\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],

        ["\xD5\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\x9B\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],

        ["\xD5\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\x9B\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],

        ["\xD5\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\x9B\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],

        ["\xD6\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\x9B\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],

        ["\xD6\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\x9B\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],

        ["\xD6\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\x9B\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],

        ["\xD6\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\x9B\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],

        ["\xD6\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\x9B\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],

        ["\xD6\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\x9B\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],

        ["\xD6\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\x9B\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],

        ["\xD6\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\x9B\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],

        ["\xD6\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\x9B\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],

        ["\xD6\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\x9B\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],

        ["\xD6\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\x9B\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],

        ["\xD6\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\x9B\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],

        ["\xD6\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\x9B\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],

        ["\xD6\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\x9B\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],

        ["\xD6\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\x9B\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],

        ["\xD6\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\x9B\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],

        ["\xD6\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\x9B\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],

        ["\xD6\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\x9B\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],

        ["\xD6\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\x9B\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],

        ["\xD6\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\x9B\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],

        ["\xD6\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\x9B\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],

        ["\xD6\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\x9B\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],

        ["\xD6\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\x9B\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],

        ["\xD6\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\x9B\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],

        ["\xD6\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\x9B\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],

        ["\xD6\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\x9B\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],

        ["\xD6\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\x9B\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],

        ["\xD6\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\x9B\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],

        ["\xD6\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\x9B\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],

        ["\xD6\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\x9B\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],

        ["\xD6\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\x9B\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],

        ["\xD6\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\x9B\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],

        ["\xD6\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\x9B\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],

        ["\xD6\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\x9B\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],

        ["\xD6\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\x9B\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],

        ["\xD6\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\x9B\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],

        ["\xD6\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\x9B\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],

        ["\xD6\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\x9B\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],

        ["\xD6\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\x9B\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],

        ["\xD6\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\x9B\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],

        ["\xD6\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\x9B\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],

        ["\xD6\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\x9B\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],

        ["\xD6\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\x9B\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],

        ["\xD6\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\x9B\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],

        ["\xD6\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\x9B\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],

        ["\xD6\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\x9B\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],

        ["\xD6\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\x9B\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],

        ["\xD6\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\x9B\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],

        ["\xD6\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\x9B\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],

        ["\xD6\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\x9B\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],

        ["\xD6\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\x9B\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],

        ["\xD6\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\x9B\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],

        ["\xD6\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\x9B\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],

        ["\xD6\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\x9B\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],

        ["\xD6\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\x9B\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],

        ["\xD6\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\x9B\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],

        ["\xD6\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\x9B\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],

        ["\xD6\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\x9B\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],

        ["\xD6\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\x9B\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],

        ["\xD6\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\x9B\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],

        ["\xD6\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\x9B\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],

        ["\xD6\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\x9B\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],

        ["\xD6\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\x9B\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],

        ["\xD6\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\x9B\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],

        ["\xD6\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\x9B\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],

        ["\xD6\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\x9B\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],

        ["\xD6\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\x9B\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],

        ["\xD6\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\x9B\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],

        ["\xD6\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\x9B\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],

        ["\xD6\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\x9B\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],

        ["\xD6\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\x9B\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],

        ["\xD6\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\x9B\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],

        ["\xD6\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\x9B\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],

        ["\xD6\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\x9B\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],

        ["\xD6\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\x9B\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],

        ["\xD6\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\x9B\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],

        ["\xD6\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\x9B\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],

        ["\xD6\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\x9B\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],

        ["\xD6\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\x9B\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],

        ["\xD6\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\x9B\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],

        ["\xD6\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\x9B\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],

        ["\xD6\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\x9B\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],

        ["\xD6\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\x9B\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],

        ["\xD6\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\x9B\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],

        ["\xD6\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\x9B\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],

        ["\xD6\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\x9B\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],

        ["\xD6\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\x9B\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],

        ["\xD6\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\x9B\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],

        ["\xD6\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\x9B\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],

        ["\xD6\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\x9B\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],

        ["\xD6\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\x9B\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],

        ["\xD6\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\x9B\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],

        ["\xD6\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\x9B\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],

        ["\xD6\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\x9B\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],

        ["\xD7\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\x9C\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],

        ["\xD7\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\x9C\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],

        ["\xD7\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\x9C\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],

        ["\xD7\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\x9C\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],

        ["\xD7\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\x9C\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],

        ["\xD7\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\x9C\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],

        ["\xD7\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\x9C\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],

        ["\xD7\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\x9C\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],

        ["\xD7\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\x9C\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],

        ["\xD7\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\x9C\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],

        ["\xD7\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\x9C\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],

        ["\xD7\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\x9C\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],

        ["\xD7\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\x9C\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],

        ["\xD7\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\x9C\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],

        ["\xD7\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\x9C\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],

        ["\xD7\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\x9C\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],

        ["\xD7\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\x9C\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],

        ["\xD7\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\x9C\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],

        ["\xD7\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\x9C\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],

        ["\xD7\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\x9C\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],

        ["\xD7\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\x9C\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],

        ["\xD7\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\x9C\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],

        ["\xD7\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\x9C\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],

        ["\xD7\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\x9C\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],

        ["\xD7\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\x9C\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],

        ["\xD7\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\x9C\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],

        ["\xD7\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\x9C\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],

        ["\xD7\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\x9C\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],

        ["\xD7\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\x9C\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],

        ["\xD7\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\x9C\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],

        ["\xD7\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\x9C\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],

        ["\xD7\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\x9C\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],

        ["\xD7\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\x9C\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],

        ["\xD7\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\x9C\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],

        ["\xD7\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\x9C\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],

        ["\xD7\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\x9C\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],

        ["\xD7\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\x9C\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],

        ["\xD7\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\x9C\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],

        ["\xD7\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\x9C\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],

        ["\xD7\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\x9C\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],

        ["\xD7\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\x9C\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],

        ["\xD7\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\x9C\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],

        ["\xD7\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\x9C\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],

        ["\xD7\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\x9C\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],

        ["\xD7\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\x9C\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],

        ["\xD7\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\x9C\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],

        ["\xD7\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\x9C\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],

        ["\xD7\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\x9C\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],

        ["\xD7\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\x9C\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],

        ["\xD7\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\x9C\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],

        ["\xD7\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\x9C\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],

        ["\xD7\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\x9C\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],

        ["\xD7\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\x9C\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],

        ["\xD7\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\x9C\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],

        ["\xD7\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\x9C\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],

        ["\xD7\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\x9C\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],

        ["\xD7\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\x9C\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],

        ["\xD7\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\x9C\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],

        ["\xD7\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\x9C\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],

        ["\xD7\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\x9C\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],

        ["\xD7\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\x9C\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],

        ["\xD7\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\x9C\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],

        ["\xD7\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\x9C\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],

        ["\xD7\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\x9C\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],

        ["\xD7\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\x9C\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],

        ["\xD7\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\x9C\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],

        ["\xD7\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\x9C\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],

        ["\xD7\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\x9C\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],

        ["\xD7\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\x9C\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],

        ["\xD7\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\x9C\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],

        ["\xD7\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\x9C\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],

        ["\xD7\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\x9C\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],

        ["\xD7\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\x9C\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],

        ["\xD7\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\x9C\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],

        ["\xD7\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\x9C\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],

        ["\xD7\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\x9C\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],

        ["\xD7\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\x9C\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],

        ["\xD7\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\x9C\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],

        ["\xD7\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\x9C\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],

        ["\xD7\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\x9C\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],

        ["\xD7\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\x9C\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],

        ["\xD7\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\x9C\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],

        ["\xD7\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\x9C\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],

        ["\xD7\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\x9C\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],

        ["\xD7\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\x9C\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],

        ["\xD7\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\x9C\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],

        ["\xD7\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\x9C\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],

        ["\xD7\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\x9C\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],

        ["\xD7\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\x9C\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],

        ["\xD7\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\x9C\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],

        ["\xD7\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\x9C\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],

        ["\xD7\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\x9C\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],

        ["\xD7\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\x9C\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],

        ["\xD8\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\x9C\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],

        ["\xD8\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\x9C\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],

        ["\xD8\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\x9C\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],

        ["\xD8\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\x9C\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],

        ["\xD8\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\x9C\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],

        ["\xD8\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\x9C\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],

        ["\xD8\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\x9C\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],

        ["\xD8\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\x9C\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],

        ["\xD8\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\x9C\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],

        ["\xD8\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\x9C\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],

        ["\xD8\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\x9C\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],

        ["\xD8\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\x9C\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],

        ["\xD8\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\x9C\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],

        ["\xD8\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\x9C\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],

        ["\xD8\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\x9C\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],

        ["\xD8\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\x9C\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],

        ["\xD8\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\x9C\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],

        ["\xD8\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\x9C\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],

        ["\xD8\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\x9C\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],

        ["\xD8\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\x9C\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],

        ["\xD8\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\x9C\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],

        ["\xD8\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\x9C\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],

        ["\xD8\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\x9C\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],

        ["\xD8\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\x9C\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],

        ["\xD8\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\x9C\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],

        ["\xD8\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\x9C\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],

        ["\xD8\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\x9C\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],

        ["\xD8\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\x9C\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],

        ["\xD8\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\x9C\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],

        ["\xD8\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\x9C\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],

        ["\xD8\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\x9C\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],

        ["\xD8\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\x9C\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],

        ["\xD8\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\x9C\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],

        ["\xD8\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\x9C\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],

        ["\xD8\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\x9C\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],

        ["\xD8\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\x9C\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],

        ["\xD8\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\x9C\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],

        ["\xD8\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\x9C\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],

        ["\xD8\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\x9C\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],

        ["\xD8\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\x9C\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],

        ["\xD8\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\x9C\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],

        ["\xD8\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\x9C\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],

        ["\xD8\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\x9C\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],

        ["\xD8\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\x9C\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],

        ["\xD8\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\x9C\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],

        ["\xD8\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\x9C\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],

        ["\xD8\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\x9C\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],

        ["\xD8\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\x9C\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],

        ["\xD8\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\x9C\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],

        ["\xD8\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\x9C\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],

        ["\xD8\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\x9C\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],

        ["\xD8\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\x9C\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],

        ["\xD8\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\x9C\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],

        ["\xD8\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\x9C\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],

        ["\xD8\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\x9C\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],

        ["\xD8\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\x9C\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],

        ["\xD8\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\x9C\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],

        ["\xD8\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\x9C\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],

        ["\xD8\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\x9C\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],

        ["\xD8\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\x9C\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],

        ["\xD8\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\x9C\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],

        ["\xD8\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\x9C\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],

        ["\xD8\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\x9C\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],

        ["\xD8\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\x9C\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],

        ["\xD8\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\x9C\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],

        ["\xD8\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\x9C\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],

        ["\xD8\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\x9C\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],

        ["\xD8\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\x9C\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],

        ["\xD8\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\x9C\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],

        ["\xD8\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\x9C\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],

        ["\xD8\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\x9C\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],

        ["\xD8\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\x9C\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],

        ["\xD8\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\x9C\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],

        ["\xD8\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\x9C\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],

        ["\xD8\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\x9C\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],

        ["\xD8\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\x9C\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],

        ["\xD8\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\x9C\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],

        ["\xD8\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\x9C\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],

        ["\xD8\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\x9C\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],

        ["\xD8\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\x9C\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],

        ["\xD8\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\x9C\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],

        ["\xD8\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\x9C\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],

        ["\xD8\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\x9C\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],

        ["\xD8\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\x9C\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],

        ["\xD8\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\x9C\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],

        ["\xD8\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\x9C\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],

        ["\xD8\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\x9C\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],

        ["\xD8\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\x9C\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],

        ["\xD8\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\x9C\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],

        ["\xD8\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\x9C\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],

        ["\xD8\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\x9C\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],

        ["\xD8\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\x9C\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],

        ["\xD8\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\x9C\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],

        ["\xD8\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\x9C\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],

        ["\xD9\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\x9D\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],

        ["\xD9\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\x9D\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],

        ["\xD9\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\x9D\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],

        ["\xD9\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\x9D\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],

        ["\xD9\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\x9D\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],

        ["\xD9\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\x9D\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],

        ["\xD9\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\x9D\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],

        ["\xD9\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\x9D\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],

        ["\xD9\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\x9D\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],

        ["\xD9\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\x9D\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],

        ["\xD9\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\x9D\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],

        ["\xD9\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\x9D\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],

        ["\xD9\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\x9D\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],

        ["\xD9\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\x9D\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],

        ["\xD9\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\x9D\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],

        ["\xD9\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\x9D\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],

        ["\xD9\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\x9D\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],

        ["\xD9\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\x9D\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],

        ["\xD9\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\x9D\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],

        ["\xD9\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\x9D\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],

        ["\xD9\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\x9D\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],

        ["\xD9\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\x9D\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],

        ["\xD9\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\x9D\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],

        ["\xD9\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\x9D\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],

        ["\xD9\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\x9D\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],

        ["\xD9\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\x9D\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],

        ["\xD9\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\x9D\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],

        ["\xD9\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\x9D\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],

        ["\xD9\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\x9D\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],

        ["\xD9\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\x9D\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],

        ["\xD9\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\x9D\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],

        ["\xD9\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\x9D\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],

        ["\xD9\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\x9D\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],

        ["\xD9\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\x9D\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],

        ["\xD9\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\x9D\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],

        ["\xD9\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\x9D\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],

        ["\xD9\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\x9D\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],

        ["\xD9\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\x9D\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],

        ["\xD9\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\x9D\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],

        ["\xD9\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\x9D\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],

        ["\xD9\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\x9D\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],

        ["\xD9\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\x9D\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],

        ["\xD9\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\x9D\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],

        ["\xD9\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\x9D\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],

        ["\xD9\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\x9D\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],

        ["\xD9\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\x9D\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],

        ["\xD9\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\x9D\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],

        ["\xD9\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\x9D\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],

        ["\xD9\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\x9D\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],

        ["\xD9\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\x9D\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],

        ["\xD9\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\x9D\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],

        ["\xD9\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\x9D\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],

        ["\xD9\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\x9D\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],

        ["\xD9\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\x9D\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],

        ["\xD9\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\x9D\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],

        ["\xD9\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\x9D\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],

        ["\xD9\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\x9D\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],

        ["\xD9\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\x9D\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],

        ["\xD9\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\x9D\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],

        ["\xD9\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\x9D\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],

        ["\xD9\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\x9D\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],

        ["\xD9\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\x9D\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],

        ["\xD9\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\x9D\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],

        ["\xD9\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\x9D\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],

        ["\xD9\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\x9D\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],

        ["\xD9\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\x9D\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],

        ["\xD9\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\x9D\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],

        ["\xD9\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\x9D\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],

        ["\xD9\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\x9D\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],

        ["\xD9\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\x9D\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],

        ["\xD9\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\x9D\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],

        ["\xD9\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\x9D\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],

        ["\xD9\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\x9D\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],

        ["\xD9\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\x9D\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],

        ["\xD9\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\x9D\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],

        ["\xD9\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\x9D\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],

        ["\xD9\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\x9D\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],

        ["\xD9\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\x9D\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],

        ["\xD9\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\x9D\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],

        ["\xD9\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\x9D\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],

        ["\xD9\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\x9D\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],

        ["\xD9\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\x9D\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],

        ["\xD9\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\x9D\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],

        ["\xD9\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\x9D\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],

        ["\xD9\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\x9D\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],

        ["\xD9\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\x9D\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],

        ["\xD9\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\x9D\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],

        ["\xD9\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\x9D\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],

        ["\xD9\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\x9D\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],

        ["\xD9\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\x9D\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],

        ["\xD9\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\x9D\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],

        ["\xD9\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\x9D\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],

        ["\xD9\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\x9D\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],

        ["\xD9\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\x9D\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],

        ["\xDA\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\x9D\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],

        ["\xDA\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\x9D\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],

        ["\xDA\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\x9D\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],

        ["\xDA\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\x9D\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],

        ["\xDA\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\x9D\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],

        ["\xDA\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\x9D\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],

        ["\xDA\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\x9D\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],

        ["\xDA\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\x9D\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],

        ["\xDA\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\x9D\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],

        ["\xDA\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\x9D\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],

        ["\xDA\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\x9D\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],

        ["\xDA\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\x9D\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],

        ["\xDA\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\x9D\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],

        ["\xDA\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\x9D\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],

        ["\xDA\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\x9D\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],

        ["\xDA\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\x9D\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],

        ["\xDA\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\x9D\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],

        ["\xDA\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\x9D\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],

        ["\xDA\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\x9D\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],

        ["\xDA\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\x9D\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],

        ["\xDA\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\x9D\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],

        ["\xDA\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\x9D\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],

        ["\xDA\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\x9D\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],

        ["\xDA\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\x9D\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],

        ["\xDA\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\x9D\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],

        ["\xDA\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\x9D\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],

        ["\xDA\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\x9D\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],

        ["\xDA\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\x9D\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],

        ["\xDA\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\x9D\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],

        ["\xDA\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\x9D\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],

        ["\xDA\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\x9D\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],

        ["\xDA\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\x9D\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],

        ["\xDA\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\x9D\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],

        ["\xDA\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\x9D\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],

        ["\xDA\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\x9D\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],

        ["\xDA\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\x9D\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],

        ["\xDA\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\x9D\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],

        ["\xDA\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\x9D\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],

        ["\xDA\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\x9D\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],

        ["\xDA\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\x9D\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],

        ["\xDA\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\x9D\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],

        ["\xDA\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\x9D\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],

        ["\xDA\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\x9D\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],

        ["\xDA\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\x9D\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],

        ["\xDA\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\x9D\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],

        ["\xDA\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\x9D\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],

        ["\xDA\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\x9D\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],

        ["\xDA\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\x9D\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],

        ["\xDA\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\x9D\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],

        ["\xDA\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\x9D\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],

        ["\xDA\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\x9D\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],

        ["\xDA\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\x9D\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],

        ["\xDA\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\x9D\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],

        ["\xDA\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\x9D\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],

        ["\xDA\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\x9D\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],

        ["\xDA\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\x9D\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],

        ["\xDA\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\x9D\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],

        ["\xDA\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\x9D\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],

        ["\xDA\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\x9D\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],

        ["\xDA\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\x9D\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],

        ["\xDA\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\x9D\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],

        ["\xDA\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\x9D\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],

        ["\xDA\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\x9D\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],

        ["\xDA\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\x9D\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],

        ["\xDA\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\x9D\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],

        ["\xDA\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\x9D\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],

        ["\xDA\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\x9D\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],

        ["\xDA\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\x9D\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],

        ["\xDA\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\x9D\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],

        ["\xDA\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\x9D\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],

        ["\xDA\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\x9D\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],

        ["\xDA\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\x9D\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],

        ["\xDA\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\x9D\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],

        ["\xDA\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\x9D\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],

        ["\xDA\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\x9D\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],

        ["\xDA\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\x9D\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],

        ["\xDA\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\x9D\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],

        ["\xDA\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\x9D\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],

        ["\xDA\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\x9D\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],

        ["\xDA\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\x9D\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],

        ["\xDA\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\x9D\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],

        ["\xDA\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\x9D\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],

        ["\xDA\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\x9D\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],

        ["\xDA\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\x9D\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],

        ["\xDA\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\x9D\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],

        ["\xDA\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\x9D\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],

        ["\xDA\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\x9D\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],

        ["\xDA\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\x9D\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],

        ["\xDA\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\x9D\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],

        ["\xDA\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\x9D\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],

        ["\xDA\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\x9D\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],

        ["\xDA\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\x9D\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],

        ["\xDA\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\x9D\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],

        ["\xDA\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\x9D\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],

        ["\xDB\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\x9E\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],

        ["\xDB\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\x9E\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],

        ["\xDB\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\x9E\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],

        ["\xDB\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\x9E\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],

        ["\xDB\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\x9E\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],

        ["\xDB\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\x9E\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],

        ["\xDB\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\x9E\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],

        ["\xDB\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\x9E\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],

        ["\xDB\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\x9E\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],

        ["\xDB\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\x9E\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],

        ["\xDB\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\x9E\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],

        ["\xDB\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\x9E\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],

        ["\xDB\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\x9E\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],

        ["\xDB\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\x9E\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],

        ["\xDB\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\x9E\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],

        ["\xDB\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\x9E\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],

        ["\xDB\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\x9E\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],

        ["\xDB\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\x9E\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],

        ["\xDB\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\x9E\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],

        ["\xDB\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\x9E\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],

        ["\xDB\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\x9E\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],

        ["\xDB\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\x9E\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],

        ["\xDB\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\x9E\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],

        ["\xDB\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\x9E\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],

        ["\xDB\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\x9E\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],

        ["\xDB\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\x9E\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],

        ["\xDB\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\x9E\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],

        ["\xDB\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\x9E\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],

        ["\xDB\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\x9E\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],

        ["\xDB\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\x9E\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],

        ["\xDB\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\x9E\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],

        ["\xDB\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\x9E\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],

        ["\xDB\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\x9E\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],

        ["\xDB\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\x9E\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],

        ["\xDB\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\x9E\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],

        ["\xDB\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\x9E\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],

        ["\xDB\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\x9E\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],

        ["\xDB\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\x9E\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],

        ["\xDB\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\x9E\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],

        ["\xDB\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\x9E\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],

        ["\xDB\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\x9E\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],

        ["\xDB\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\x9E\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],

        ["\xDB\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\x9E\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],

        ["\xDB\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\x9E\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],

        ["\xDB\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\x9E\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],

        ["\xDB\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\x9E\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],

        ["\xDB\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\x9E\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],

        ["\xDB\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\x9E\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],

        ["\xDB\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\x9E\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],

        ["\xDB\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\x9E\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],

        ["\xDB\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\x9E\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],

        ["\xDB\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\x9E\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],

        ["\xDB\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\x9E\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],

        ["\xDB\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\x9E\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],

        ["\xDB\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\x9E\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],

        ["\xDB\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\x9E\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],

        ["\xDB\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\x9E\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],

        ["\xDB\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\x9E\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],

        ["\xDB\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\x9E\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],

        ["\xDB\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\x9E\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],

        ["\xDB\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\x9E\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],

        ["\xDB\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\x9E\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],

        ["\xDB\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\x9E\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],

        ["\xDB\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\x9E\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],

        ["\xDB\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\x9E\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],

        ["\xDB\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\x9E\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],

        ["\xDB\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\x9E\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],

        ["\xDB\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\x9E\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],

        ["\xDB\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\x9E\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],

        ["\xDB\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\x9E\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],

        ["\xDB\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\x9E\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],

        ["\xDB\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\x9E\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],

        ["\xDB\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\x9E\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],

        ["\xDB\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\x9E\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],

        ["\xDB\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\x9E\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],

        ["\xDB\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\x9E\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],

        ["\xDB\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\x9E\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],

        ["\xDB\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\x9E\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],

        ["\xDB\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\x9E\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],

        ["\xDB\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\x9E\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],

        ["\xDB\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\x9E\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],

        ["\xDB\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\x9E\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],

        ["\xDB\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\x9E\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],

        ["\xDB\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\x9E\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],

        ["\xDB\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\x9E\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],

        ["\xDB\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\x9E\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],

        ["\xDB\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\x9E\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],

        ["\xDB\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\x9E\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],

        ["\xDB\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\x9E\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],

        ["\xDB\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\x9E\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],

        ["\xDB\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\x9E\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],

        ["\xDB\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\x9E\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],

        ["\xDB\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\x9E\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],

        ["\xDB\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\x9E\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],

        ["\xDC\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\x9E\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],

        ["\xDC\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\x9E\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],

        ["\xDC\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\x9E\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],

        ["\xDC\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\x9E\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],

        ["\xDC\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\x9E\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],

        ["\xDC\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\x9E\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],

        ["\xDC\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\x9E\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],

        ["\xDC\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\x9E\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],

        ["\xDC\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\x9E\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],

        ["\xDC\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\x9E\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],

        ["\xDC\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\x9E\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],

        ["\xDC\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\x9E\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],

        ["\xDC\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\x9E\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],

        ["\xDC\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\x9E\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],

        ["\xDC\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\x9E\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],

        ["\xDC\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\x9E\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],

        ["\xDC\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\x9E\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],

        ["\xDC\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\x9E\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],

        ["\xDC\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\x9E\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],

        ["\xDC\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\x9E\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],

        ["\xDC\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\x9E\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],

        ["\xDC\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\x9E\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],

        ["\xDC\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\x9E\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],

        ["\xDC\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\x9E\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],

        ["\xDC\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\x9E\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],

        ["\xDC\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\x9E\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],

        ["\xDC\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\x9E\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],

        ["\xDC\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\x9E\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],

        ["\xDC\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\x9E\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],

        ["\xDC\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\x9E\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],

        ["\xDC\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\x9E\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],

        ["\xDC\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\x9E\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],

        ["\xDC\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\x9E\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],

        ["\xDC\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\x9E\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],

        ["\xDC\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\x9E\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],

        ["\xDC\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\x9E\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],

        ["\xDC\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\x9E\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],

        ["\xDC\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\x9E\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],

        ["\xDC\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\x9E\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],

        ["\xDC\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\x9E\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],

        ["\xDC\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\x9E\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],

        ["\xDC\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\x9E\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],

        ["\xDC\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\x9E\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],

        ["\xDC\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\x9E\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],

        ["\xDC\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\x9E\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],

        ["\xDC\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\x9E\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],

        ["\xDC\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\x9E\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],

        ["\xDC\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\x9E\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],

        ["\xDC\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\x9E\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],

        ["\xDC\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\x9E\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],

        ["\xDC\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\x9E\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],

        ["\xDC\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\x9E\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],

        ["\xDC\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\x9E\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],

        ["\xDC\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\x9E\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],

        ["\xDC\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\x9E\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],

        ["\xDC\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\x9E\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],

        ["\xDC\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\x9E\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],

        ["\xDC\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\x9E\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],

        ["\xDC\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\x9E\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],

        ["\xDC\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\x9E\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],

        ["\xDC\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\x9E\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],

        ["\xDC\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\x9E\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],

        ["\xDC\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\x9E\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],

        ["\xDC\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\x9E\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],

        ["\xDC\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\x9E\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],

        ["\xDC\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\x9E\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],

        ["\xDC\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\x9E\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],

        ["\xDC\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\x9E\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],

        ["\xDC\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\x9E\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],

        ["\xDC\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\x9E\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],

        ["\xDC\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\x9E\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],

        ["\xDC\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\x9E\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],

        ["\xDC\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\x9E\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],

        ["\xDC\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\x9E\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],

        ["\xDC\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\x9E\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],

        ["\xDC\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\x9E\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],

        ["\xDC\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\x9E\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],

        ["\xDC\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\x9E\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],

        ["\xDC\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\x9E\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],

        ["\xDC\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\x9E\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],

        ["\xDC\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\x9E\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],

        ["\xDC\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\x9E\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],

        ["\xDC\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\x9E\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],

        ["\xDC\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\x9E\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],

        ["\xDC\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\x9E\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],

        ["\xDC\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\x9E\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],

        ["\xDC\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\x9E\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],

        ["\xDC\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\x9E\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],

        ["\xDC\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\x9E\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],

        ["\xDC\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\x9E\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],

        ["\xDC\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\x9E\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],

        ["\xDC\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\x9E\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],

        ["\xDC\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\x9E\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],

        ["\xDC\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\x9E\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],

        ["\xDD\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\x9F\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],

        ["\xDD\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\x9F\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],

        ["\xDD\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\x9F\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],

        ["\xDD\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\x9F\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],

        ["\xDD\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\x9F\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],

        ["\xDD\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\x9F\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],

        ["\xDD\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\x9F\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],

        ["\xDD\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\x9F\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],

        ["\xDD\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\x9F\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],

        ["\xDD\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\x9F\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],

        ["\xDD\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\x9F\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],

        ["\xDD\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\x9F\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],

        ["\xDD\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\x9F\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],

        ["\xDD\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\x9F\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],

        ["\xDD\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\x9F\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],

        ["\xDD\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\x9F\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],

        ["\xDD\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\x9F\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],

        ["\xDD\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\x9F\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],

        ["\xDD\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\x9F\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],

        ["\xDD\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\x9F\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],

        ["\xDD\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\x9F\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],

        ["\xDD\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\x9F\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],

        ["\xDD\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\x9F\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],

        ["\xDD\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\x9F\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],

        ["\xDD\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\x9F\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],

        ["\xDD\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\x9F\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],

        ["\xDD\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\x9F\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],

        ["\xDD\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\x9F\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],

        ["\xDD\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\x9F\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],

        ["\xDD\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\x9F\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],

        ["\xDD\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\x9F\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],

        ["\xDD\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\x9F\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],

        ["\xDD\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\x9F\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],

        ["\xDD\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\x9F\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],

        ["\xDD\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\x9F\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],

        ["\xDD\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\x9F\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],

        ["\xDD\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\x9F\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],

        ["\xDD\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\x9F\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],

        ["\xDD\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\x9F\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],

        ["\xDD\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\x9F\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],

        ["\xDD\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\x9F\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],

        ["\xDD\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\x9F\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],

        ["\xDD\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\x9F\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],

        ["\xDD\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\x9F\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],

        ["\xDD\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\x9F\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],

        ["\xDD\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\x9F\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],

        ["\xDD\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\x9F\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],

        ["\xDD\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\x9F\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],

        ["\xDD\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\x9F\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],

        ["\xDD\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\x9F\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],

        ["\xDD\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\x9F\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],

        ["\xDD\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\x9F\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],

        ["\xDD\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\x9F\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],

        ["\xDD\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\x9F\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],

        ["\xDD\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\x9F\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],

        ["\xDD\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\x9F\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],

        ["\xDD\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\x9F\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],

        ["\xDD\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\x9F\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],

        ["\xDD\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\x9F\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],

        ["\xDD\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\x9F\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],

        ["\xDD\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\x9F\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],

        ["\xDD\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\x9F\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],

        ["\xDD\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\x9F\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],

        ["\xDD\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\x9F\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],

        ["\xDD\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\x9F\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],

        ["\xDD\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\x9F\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],

        ["\xDD\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\x9F\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],

        ["\xDD\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\x9F\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],

        ["\xDD\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\x9F\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],

        ["\xDD\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\x9F\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],

        ["\xDD\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\x9F\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],

        ["\xDD\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\x9F\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],

        ["\xDD\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\x9F\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],

        ["\xDD\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\x9F\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],

        ["\xDD\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\x9F\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],

        ["\xDD\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\x9F\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],

        ["\xDD\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\x9F\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],

        ["\xDD\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\x9F\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],

        ["\xDD\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\x9F\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],

        ["\xDD\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\x9F\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],

        ["\xDD\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\x9F\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],

        ["\xDD\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\x9F\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],

        ["\xDD\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\x9F\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],

        ["\xDD\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\x9F\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],

        ["\xDD\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\x9F\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],

        ["\xDD\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\x9F\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],

        ["\xDD\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\x9F\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],

        ["\xDD\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\x9F\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],

        ["\xDD\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\x9F\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],

        ["\xDD\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\x9F\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],

        ["\xDD\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\x9F\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],

        ["\xDD\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\x9F\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],

        ["\xDD\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\x9F\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],

        ["\xDD\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\x9F\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],

        ["\xDE\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\x9F\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],

        ["\xDE\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\x9F\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],

        ["\xDE\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\x9F\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],

        ["\xDE\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\x9F\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],

        ["\xDE\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\x9F\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],

        ["\xDE\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\x9F\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],

        ["\xDE\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\x9F\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],

        ["\xDE\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\x9F\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],

        ["\xDE\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\x9F\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],

        ["\xDE\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\x9F\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],

        ["\xDE\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\x9F\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],

        ["\xDE\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\x9F\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],

        ["\xDE\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\x9F\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],

        ["\xDE\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\x9F\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],

        ["\xDE\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\x9F\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],

        ["\xDE\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\x9F\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],

        ["\xDE\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\x9F\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],

        ["\xDE\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\x9F\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],

        ["\xDE\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\x9F\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],

        ["\xDE\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\x9F\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],

        ["\xDE\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\x9F\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],

        ["\xDE\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\x9F\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],

        ["\xDE\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\x9F\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],

        ["\xDE\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\x9F\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],

        ["\xDE\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\x9F\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],

        ["\xDE\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\x9F\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],

        ["\xDE\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\x9F\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],

        ["\xDE\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\x9F\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],

        ["\xDE\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\x9F\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],

        ["\xDE\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\x9F\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],

        ["\xDE\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\x9F\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],

        ["\xDE\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\x9F\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],

        ["\xDE\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\x9F\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],

        ["\xDE\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\x9F\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],

        ["\xDE\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\x9F\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],

        ["\xDE\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\x9F\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],

        ["\xDE\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\x9F\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],

        ["\xDE\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\x9F\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],

        ["\xDE\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\x9F\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],

        ["\xDE\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\x9F\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],

        ["\xDE\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\x9F\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],

        ["\xDE\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\x9F\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],

        ["\xDE\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\x9F\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],

        ["\xDE\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\x9F\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],

        ["\xDE\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\x9F\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],

        ["\xDE\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\x9F\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],

        ["\xDE\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\x9F\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],

        ["\xDE\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\x9F\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],

        ["\xDE\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\x9F\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],

        ["\xDE\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\x9F\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],

        ["\xDE\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\x9F\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],

        ["\xDE\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\x9F\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],

        ["\xDE\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\x9F\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],

        ["\xDE\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\x9F\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],

        ["\xDE\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\x9F\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],

        ["\xDE\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\x9F\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],

        ["\xDE\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\x9F\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],

        ["\xDE\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\x9F\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],

        ["\xDE\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\x9F\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],

        ["\xDE\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\x9F\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],

        ["\xDE\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\x9F\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],

        ["\xDE\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\x9F\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],

        ["\xDE\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\x9F\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],

        ["\xDE\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\x9F\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],

        ["\xDE\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\x9F\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],

        ["\xDE\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\x9F\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],

        ["\xDE\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\x9F\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],

        ["\xDE\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\x9F\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],

        ["\xDE\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\x9F\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],

        ["\xDE\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\x9F\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],

        ["\xDE\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\x9F\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],

        ["\xDE\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\x9F\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],

        ["\xDE\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\x9F\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],

        ["\xDE\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\x9F\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],

        ["\xDE\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\x9F\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],

        ["\xDE\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\x9F\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],

        ["\xDE\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\x9F\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],

        ["\xDE\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\x9F\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],

        ["\xDE\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\x9F\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],

        ["\xDE\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\x9F\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],

        ["\xDE\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\x9F\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],

        ["\xDE\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\x9F\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],

        ["\xDE\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\x9F\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],

        ["\xDE\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\x9F\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],

        ["\xDE\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\x9F\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],

        ["\xDE\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\x9F\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],

        ["\xDE\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\x9F\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],

        ["\xDE\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\x9F\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],

        ["\xDE\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\x9F\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],

        ["\xDE\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\x9F\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],

        ["\xDE\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\x9F\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],

        ["\xDE\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\x9F\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],

        ["\xDE\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\x9F\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],

        ["\xDE\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\x9F\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],

        ["\xDF\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xE0\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],

        ["\xDF\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xE0\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],

        ["\xDF\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xE0\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],

        ["\xDF\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xE0\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],

        ["\xDF\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xE0\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],

        ["\xDF\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xE0\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],

        ["\xDF\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xE0\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],

        ["\xDF\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xE0\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],

        ["\xDF\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xE0\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],

        ["\xDF\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xE0\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],

        ["\xDF\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xE0\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],

        ["\xDF\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xE0\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],

        ["\xDF\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xE0\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],

        ["\xDF\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xE0\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],

        ["\xDF\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xE0\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],

        ["\xDF\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xE0\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],

        ["\xDF\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xE0\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],

        ["\xDF\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xE0\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],

        ["\xDF\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xE0\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],

        ["\xDF\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xE0\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],

        ["\xDF\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xE0\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],

        ["\xDF\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xE0\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],

        ["\xDF\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xE0\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],

        ["\xDF\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xE0\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],

        ["\xDF\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xE0\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],

        ["\xDF\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xE0\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],

        ["\xDF\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xE0\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],

        ["\xDF\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xE0\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],

        ["\xDF\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xE0\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],

        ["\xDF\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xE0\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],

        ["\xDF\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xE0\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],

        ["\xDF\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xE0\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],

        ["\xDF\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xE0\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],

        ["\xDF\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xE0\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],

        ["\xDF\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xE0\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],

        ["\xDF\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xE0\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],

        ["\xDF\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xE0\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],

        ["\xDF\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xE0\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],

        ["\xDF\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xE0\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],

        ["\xDF\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xE0\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],

        ["\xDF\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE0\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],

        ["\xDF\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE0\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],

        ["\xDF\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xE0\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],

        ["\xDF\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xE0\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],

        ["\xDF\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xE0\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],

        ["\xDF\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xE0\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],

        ["\xDF\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xE0\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],

        ["\xDF\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xE0\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],

        ["\xDF\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xE0\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],

        ["\xDF\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xE0\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],

        ["\xDF\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xE0\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],

        ["\xDF\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xE0\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],

        ["\xDF\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE0\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],

        ["\xDF\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE0\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],

        ["\xDF\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xE0\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],

        ["\xDF\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xE0\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],

        ["\xDF\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE0\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],

        ["\xDF\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE0\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],

        ["\xDF\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xE0\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],

        ["\xDF\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xE0\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],

        ["\xDF\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xE0\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],

        ["\xDF\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xE0\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],

        ["\xDF\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xE0\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],

        ["\xDF\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xE0\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],

        ["\xDF\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xE0\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],

        ["\xDF\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xE0\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],

        ["\xDF\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xE0\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],

        ["\xDF\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xE0\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],

        ["\xDF\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xE0\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],

        ["\xDF\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xE0\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],

        ["\xDF\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xE0\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],

        ["\xDF\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xE0\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],

        ["\xDF\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xE0\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],

        ["\xDF\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xE0\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],

        ["\xDF\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xE0\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],

        ["\xDF\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xE0\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],

        ["\xDF\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xE0\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],

        ["\xDF\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xE0\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],

        ["\xDF\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xE0\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],

        ["\xDF\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xE0\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],

        ["\xDF\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xE0\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],

        ["\xDF\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xE0\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],

        ["\xDF\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xE0\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],

        ["\xDF\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xE0\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],

        ["\xDF\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xE0\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],

        ["\xDF\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xE0\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],

        ["\xDF\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xE0\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],

        ["\xDF\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xE0\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],

        ["\xDF\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xE0\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],

        ["\xDF\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xE0\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],

        ["\xDF\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xE0\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],

        ["\xDF\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xE0\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],

        ["\xDF\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xE0\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],

        ["\xDF\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xE0\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],

        ["\xE0\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xE0\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],

        ["\xE0\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xE0\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],

        ["\xE0\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],

        ["\xE0\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],

        ["\xE0\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],

        ["\xE0\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],

        ["\xE0\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],

        ["\xE0\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],

        ["\xE0\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],

        ["\xE0\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],

        ["\xE0\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],

        ["\xE0\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],

        ["\xE0\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],

        ["\xE0\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],

        ["\xE0\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],

        ["\xE0\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],

        ["\xE0\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],

        ["\xE0\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],

        ["\xE0\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],

        ["\xE0\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],

        ["\xE0\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],

        ["\xE0\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],

        ["\xE0\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],

        ["\xE0\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],

        ["\xE0\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],

        ["\xE0\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],

        ["\xE0\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],

        ["\xE0\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],

        ["\xE0\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],

        ["\xE0\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],

        ["\xE0\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],

        ["\xE0\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],

        ["\xE0\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],

        ["\xE0\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],

        ["\xE0\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],

        ["\xE0\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],

        ["\xE0\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],

        ["\xE0\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],

        ["\xE0\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],

        ["\xE0\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],

        ["\xE0\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],

        ["\xE0\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],

        ["\xE0\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],

        ["\xE0\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],

        ["\xE0\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],

        ["\xE0\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],

        ["\xE0\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],

        ["\xE0\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],

        ["\xE0\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],

        ["\xE0\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],

        ["\xE0\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],

        ["\xE0\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],

        ["\xE0\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],

        ["\xE0\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],

        ["\xE0\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],

        ["\xE0\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],

        ["\xE0\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],

        ["\xE0\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],

        ["\xE0\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],

        ["\xE0\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],

        ["\xE0\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],

        ["\xE0\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],

        ["\xE0\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],

        ["\xE0\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],

        ["\xE0\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],

        ["\xE0\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],

        ["\xE0\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],

        ["\xE0\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],

        ["\xE0\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],

        ["\xE0\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],

        ["\xE0\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],

        ["\xE0\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],

        ["\xE0\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],

        ["\xE0\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],

        ["\xE0\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],

        ["\xE0\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],

        ["\xE0\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],

        ["\xE0\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],

        ["\xE0\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],

        ["\xE0\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],

        ["\xE0\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],

        ["\xE0\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],

        ["\xE0\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],

        ["\xE0\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],

        ["\xE0\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],

        ["\xE0\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],

        ["\xE0\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],

        ["\xE0\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],

        ["\xE0\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],

        ["\xE0\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],

        ["\xE0\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],

        ["\xE0\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],

        ["\xE0\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],

        ["\xE0\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE0\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],

        ["\xE1\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xE1\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],

        ["\xE1\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE1\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],

        ["\xE1\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE1\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],

        ["\xE1\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE1\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],

        ["\xE1\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE1\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],

        ["\xE1\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE1\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],

        ["\xE1\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE1\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],

        ["\xE1\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xE1\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],

        ["\xE1\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xE1\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],

        ["\xE1\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xE1\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],

        ["\xE1\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xE1\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],

        ["\xE1\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xE1\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],

        ["\xE1\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xE1\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],

        ["\xE1\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xE1\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],

        ["\xE1\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xE1\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],

        ["\xE1\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xE1\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],

        ["\xE1\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xE1\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],

        ["\xE1\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xE1\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],

        ["\xE1\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xE1\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],

        ["\xE1\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xE1\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],

        ["\xE1\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xE1\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],

        ["\xE1\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xE1\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],

        ["\xE1\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xE1\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],

        ["\xE1\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xE1\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],

        ["\xE1\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xE1\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],

        ["\xE1\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xE1\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],

        ["\xE1\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xE1\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],

        ["\xE1\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xE1\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],

        ["\xE1\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xE1\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],

        ["\xE1\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xE1\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],

        ["\xE1\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xE1\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],

        ["\xE1\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xE1\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],

        ["\xE1\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xE1\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],

        ["\xE1\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xE1\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],

        ["\xE1\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xE1\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],

        ["\xE1\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xE1\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],

        ["\xE1\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xE1\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],

        ["\xE1\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xE1\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],

        ["\xE1\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xE1\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],

        ["\xE1\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xE1\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],

        ["\xE1\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xE1\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],

        ["\xE1\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xE1\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],

        ["\xE1\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xE1\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],

        ["\xE1\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xE1\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],

        ["\xE1\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xE1\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],

        ["\xE1\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xE1\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],

        ["\xE1\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xE1\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],

        ["\xE1\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xE1\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],

        ["\xE1\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xE1\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],

        ["\xE1\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xE1\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],

        ["\xE1\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xE1\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],

        ["\xE1\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xE1\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],

        ["\xE1\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xE1\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],

        ["\xE1\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xE1\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],

        ["\xE1\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xE1\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],

        ["\xE1\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xE1\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],

        ["\xE1\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xE1\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],

        ["\xE1\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xE1\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],

        ["\xE1\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xE1\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],

        ["\xE1\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xE1\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],

        ["\xE1\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xE1\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],

        ["\xE1\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xE1\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],

        ["\xE1\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xE1\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],

        ["\xE1\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xE1\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],

        ["\xE1\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xE1\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],

        ["\xE1\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xE1\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],

        ["\xE1\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xE1\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],

        ["\xE1\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xE1\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],

        ["\xE1\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xE1\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],

        ["\xE1\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xE1\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],

        ["\xE1\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xE1\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],

        ["\xE1\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xE1\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],

        ["\xE1\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xE1\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],

        ["\xE1\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xE1\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],

        ["\xE1\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xE1\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],

        ["\xE1\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xE1\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],

        ["\xE1\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xE1\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],

        ["\xE1\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xE1\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],

        ["\xE1\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xE1\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],

        ["\xE1\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xE1\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],

        ["\xE1\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xE1\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],

        ["\xE1\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xE1\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],

        ["\xE1\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xE1\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],

        ["\xE1\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xE1\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],

        ["\xE1\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xE1\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],

        ["\xE1\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xE1\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],

        ["\xE1\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xE1\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],

        ["\xE1\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xE1\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],

        ["\xE1\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xE1\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],

        ["\xE1\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xE1\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],

        ["\xE1\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xE1\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],

        ["\xE1\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xE1\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],

        ["\xE1\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xE1\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],

        ["\xE1\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xE1\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],

        ["\xE2\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xE1\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],

        ["\xE2\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xE1\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],

        ["\xE2\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE1\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],

        ["\xE2\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE1\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],

        ["\xE2\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE1\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],

        ["\xE2\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE1\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],

        ["\xE2\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE1\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],

        ["\xE2\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE1\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],

        ["\xE2\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE1\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],

        ["\xE2\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE1\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],

        ["\xE2\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE1\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],

        ["\xE2\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE1\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],

        ["\xE2\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE1\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],

        ["\xE2\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE1\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],

        ["\xE2\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE1\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],

        ["\xE2\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE1\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],

        ["\xE2\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE1\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],

        ["\xE2\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE1\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],

        ["\xE2\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE1\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],

        ["\xE2\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE1\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],

        ["\xE2\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE1\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],

        ["\xE2\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE1\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],

        ["\xE2\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE1\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],

        ["\xE2\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE1\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],

        ["\xE2\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE1\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],

        ["\xE2\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE1\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],

        ["\xE2\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE1\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],

        ["\xE2\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE1\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],

        ["\xE2\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE1\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],

        ["\xE2\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE1\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],

        ["\xE2\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE1\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],

        ["\xE2\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE1\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],

        ["\xE2\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE1\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],

        ["\xE2\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE1\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],

        ["\xE2\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE1\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],

        ["\xE2\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE1\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],

        ["\xE2\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE1\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],

        ["\xE2\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE1\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],

        ["\xE2\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE1\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],

        ["\xE2\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE1\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],

        ["\xE2\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE1\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],

        ["\xE2\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE1\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],

        ["\xE2\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE1\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],

        ["\xE2\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE1\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],

        ["\xE2\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE1\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],

        ["\xE2\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE1\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],

        ["\xE2\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE1\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],

        ["\xE2\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE1\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],

        ["\xE2\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE1\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],

        ["\xE2\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE1\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],

        ["\xE2\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE1\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],

        ["\xE2\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE1\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],

        ["\xE2\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE1\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],

        ["\xE2\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE1\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],

        ["\xE2\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE1\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],

        ["\xE2\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE1\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],

        ["\xE2\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE1\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],

        ["\xE2\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE1\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],

        ["\xE2\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE1\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],

        ["\xE2\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE1\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],

        ["\xE2\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE1\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],

        ["\xE2\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE1\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],

        ["\xE2\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE1\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],

        ["\xE2\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE1\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],

        ["\xE2\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE1\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],

        ["\xE2\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE1\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],

        ["\xE2\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE1\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],

        ["\xE2\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE1\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],

        ["\xE2\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE1\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],

        ["\xE2\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE1\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],

        ["\xE2\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE1\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],

        ["\xE2\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE1\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],

        ["\xE2\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE1\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],

        ["\xE2\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE1\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],

        ["\xE2\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE1\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],

        ["\xE2\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE1\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],

        ["\xE2\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE1\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],

        ["\xE2\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE1\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],

        ["\xE2\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE1\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],

        ["\xE2\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE1\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],

        ["\xE2\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE1\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],

        ["\xE2\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE1\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],

        ["\xE2\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE1\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],

        ["\xE2\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE1\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],

        ["\xE2\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE1\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],

        ["\xE2\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE1\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],

        ["\xE2\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE1\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],

        ["\xE2\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE1\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],

        ["\xE2\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE1\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],

        ["\xE2\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE1\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],

        ["\xE2\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE1\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],

        ["\xE2\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE1\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],

        ["\xE2\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE1\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],

        ["\xE2\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE1\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],

        ["\xE3\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xE2\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],

        ["\xE3\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xE2\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],

        ["\xE3\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xE2\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],

        ["\xE3\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xE2\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],

        ["\xE3\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xE2\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],

        ["\xE3\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xE2\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],

        ["\xE3\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xE2\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],

        ["\xE3\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xE2\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],

        ["\xE3\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xE2\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],

        ["\xE3\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xE2\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],

        ["\xE3\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE2\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],

        ["\xE3\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE2\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],

        ["\xE3\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE2\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],

        ["\xE3\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE2\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],

        ["\xE3\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE2\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],

        ["\xE3\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE2\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],

        ["\xE3\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE2\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],

        ["\xE3\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xE2\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],

        ["\xE3\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xE2\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],

        ["\xE3\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xE2\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],

        ["\xE3\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xE2\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],

        ["\xE3\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xE2\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],

        ["\xE3\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xE2\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],

        ["\xE3\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE2\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],

        ["\xE3\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xE2\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],

        ["\xE3\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE2\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],

        ["\xE3\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE2\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],

        ["\xE3\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE2\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],

        ["\xE3\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE2\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],

        ["\xE3\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE2\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],

        ["\xE3\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE2\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],

        ["\xE3\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE2\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],

        ["\xE3\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE2\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],

        ["\xE3\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE2\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],

        ["\xE3\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE2\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],

        ["\xE3\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE2\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],

        ["\xE3\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE2\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],

        ["\xE3\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE2\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],

        ["\xE3\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE2\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],

        ["\xE3\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE2\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],

        ["\xE3\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE2\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],

        ["\xE3\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE2\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],

        ["\xE3\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE2\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],

        ["\xE3\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE2\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],

        ["\xE3\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE2\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],

        ["\xE3\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE2\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],

        ["\xE3\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE2\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],

        ["\xE3\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE2\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],

        ["\xE3\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],

        ["\xE3\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],

        ["\xE3\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],

        ["\xE3\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],

        ["\xE3\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],

        ["\xE3\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],

        ["\xE3\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],

        ["\xE3\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],

        ["\xE3\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],

        ["\xE3\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],

        ["\xE3\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],

        ["\xE3\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],

        ["\xE3\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],

        ["\xE3\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],

        ["\xE3\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],

        ["\xE3\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],

        ["\xE3\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE2\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],

        ["\xE3\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE2\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],

        ["\xE3\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE2\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],

        ["\xE3\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xE2\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],

        ["\xE3\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xE2\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],

        ["\xE3\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xE2\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],

        ["\xE3\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xE2\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],

        ["\xE3\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xE2\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],

        ["\xE3\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xE2\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],

        ["\xE3\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xE2\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],

        ["\xE3\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE2\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],

        ["\xE3\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xE2\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],

        ["\xE3\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xE2\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],

        ["\xE3\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xE2\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],

        ["\xE3\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xE2\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],

        ["\xE3\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xE2\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],

        ["\xE3\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xE2\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],

        ["\xE3\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xE2\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],

        ["\xE3\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xE2\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],

        ["\xE3\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xE2\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],

        ["\xE3\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xE2\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],

        ["\xE3\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xE2\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],

        ["\xE3\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xE2\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],

        ["\xE3\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xE2\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],

        ["\xE3\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xE2\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],

        ["\xE3\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xE2\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],

        ["\xE3\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE2\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],

        ["\xE3\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE2\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],

        ["\xE3\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xE2\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],

        ["\xE3\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xE2\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],

        ["\xE4\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xE2\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],

        ["\xE4\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE2\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],

        ["\xE4\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],

        ["\xE4\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE2\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],

        ["\xE4\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE2\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],

        ["\xE4\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE2\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],

        ["\xE4\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE2\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],

        ["\xE4\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE2\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],

        ["\xE4\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE2\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],

        ["\xE4\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE2\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],

        ["\xE4\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE2\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],

        ["\xE4\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE2\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],

        ["\xE4\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],

        ["\xE4\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE2\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],

        ["\xE4\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE2\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],

        ["\xE4\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE2\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],

        ["\xE4\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE2\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],

        ["\xE4\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],

        ["\xE4\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE2\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],

        ["\xE4\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE2\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],

        ["\xE4\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE2\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],

        ["\xE4\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE2\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],

        ["\xE4\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE2\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],

        ["\xE4\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE2\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],

        ["\xE4\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE2\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],

        ["\xE4\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE2\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],

        ["\xE4\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE2\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],

        ["\xE4\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE2\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],

        ["\xE4\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE2\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],

        ["\xE4\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE2\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],

        ["\xE4\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE2\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],

        ["\xE4\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE2\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],

        ["\xE4\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE2\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],

        ["\xE4\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],

        ["\xE4\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],

        ["\xE4\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],

        ["\xE4\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],

        ["\xE4\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],

        ["\xE4\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],

        ["\xE4\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],

        ["\xE4\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],

        ["\xE4\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],

        ["\xE4\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],

        ["\xE4\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE2\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],

        ["\xE4\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE2\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],

        ["\xE4\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE2\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],

        ["\xE4\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE2\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],

        ["\xE4\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE2\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],

        ["\xE4\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE2\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],

        ["\xE4\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],

        ["\xE4\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],

        ["\xE4\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],

        ["\xE4\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],

        ["\xE4\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],

        ["\xE4\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],

        ["\xE4\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],

        ["\xE4\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],

        ["\xE4\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],

        ["\xE4\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],

        ["\xE4\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE2\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],

        ["\xE4\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE2\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],

        ["\xE4\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE2\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],

        ["\xE4\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE2\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],

        ["\xE4\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE2\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],

        ["\xE4\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE2\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],

        ["\xE4\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],

        ["\xE4\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],

        ["\xE4\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],

        ["\xE4\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],

        ["\xE4\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],

        ["\xE4\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],

        ["\xE4\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],

        ["\xE4\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],

        ["\xE4\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],

        ["\xE4\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],

        ["\xE4\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],

        ["\xE4\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],

        ["\xE4\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],

        ["\xE4\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],

        ["\xE4\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],

        ["\xE4\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],

        ["\xE4\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],

        ["\xE4\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],

        ["\xE4\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],

        ["\xE4\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],

        ["\xE4\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],

        ["\xE4\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],

        ["\xE4\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],

        ["\xE4\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],

        ["\xE4\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],

        ["\xE4\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],

        ["\xE4\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE2\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],

        ["\xE4\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],

        ["\xE4\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],

        ["\xE5\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xE3\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],

        ["\xE5\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE3\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],

        ["\xE5\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE3\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],

        ["\xE5\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE3\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],

        ["\xE5\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE3\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],

        ["\xE5\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE3\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],

        ["\xE5\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE3\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],

        ["\xE5\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE3\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],

        ["\xE5\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE3\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],

        ["\xE5\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE3\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],

        ["\xE5\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE3\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],

        ["\xE5\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE3\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],

        ["\xE5\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE3\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],

        ["\xE5\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE3\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],

        ["\xE5\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE3\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],

        ["\xE5\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE3\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],

        ["\xE5\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE3\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],

        ["\xE5\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xE3\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],

        ["\xE5\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xE3\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],

        ["\xE5\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xE3\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],

        ["\xE5\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xE3\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],

        ["\xE5\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xE3\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],

        ["\xE5\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xE3\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],

        ["\xE5\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE3\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],

        ["\xE5\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xE3\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],

        ["\xE5\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE3\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],

        ["\xE5\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE3\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],

        ["\xE5\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE3\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],

        ["\xE5\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE3\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],

        ["\xE5\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE3\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],

        ["\xE5\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE3\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],

        ["\xE5\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE3\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],

        ["\xE5\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE3\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],

        ["\xE5\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE3\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],

        ["\xE5\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE3\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],

        ["\xE5\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE3\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],

        ["\xE5\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE3\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],

        ["\xE5\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE3\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],

        ["\xE5\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE3\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],

        ["\xE5\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE3\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],

        ["\xE5\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE3\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],

        ["\xE5\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE3\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],

        ["\xE5\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE3\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],

        ["\xE5\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE3\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],

        ["\xE5\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE3\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],

        ["\xE5\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE3\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],

        ["\xE5\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE3\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],

        ["\xE5\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE3\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],

        ["\xE5\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE3\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],

        ["\xE5\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE3\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],

        ["\xE5\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE3\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],

        ["\xE5\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE3\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],

        ["\xE5\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE3\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],

        ["\xE5\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE3\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],

        ["\xE5\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE3\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],

        ["\xE5\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE3\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],

        ["\xE5\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE3\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],

        ["\xE5\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE3\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],

        ["\xE5\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE3\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],

        ["\xE5\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE3\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],

        ["\xE5\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE3\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],

        ["\xE5\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE3\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],

        ["\xE5\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE3\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],

        ["\xE5\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE3\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],

        ["\xE5\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xE3\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],

        ["\xE5\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xE3\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],

        ["\xE5\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xE3\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],

        ["\xE5\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xE3\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],

        ["\xE5\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xE3\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],

        ["\xE5\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xE3\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],

        ["\xE5\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xE3\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],

        ["\xE5\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xE3\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],

        ["\xE5\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xE3\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],

        ["\xE5\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xE3\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],

        ["\xE5\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE3\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],

        ["\xE5\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xE3\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],

        ["\xE5\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xE3\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],

        ["\xE5\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xE3\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],

        ["\xE5\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xE3\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],

        ["\xE5\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xE3\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],

        ["\xE5\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xE3\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],

        ["\xE5\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xE3\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],

        ["\xE5\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xE3\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],

        ["\xE5\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xE3\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],

        ["\xE5\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xE3\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],

        ["\xE5\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xE3\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],

        ["\xE5\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xE3\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],

        ["\xE5\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xE3\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],

        ["\xE5\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xE3\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],

        ["\xE5\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xE3\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],

        ["\xE5\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE3\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],

        ["\xE5\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE3\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],

        ["\xE5\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xE3\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],

        ["\xE5\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xE3\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],

        ["\xE6\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xE3\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],

        ["\xE6\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE3\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],

        ["\xE6\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],

        ["\xE6\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE3\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],

        ["\xE6\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE3\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],

        ["\xE6\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE3\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],

        ["\xE6\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE3\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],

        ["\xE6\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE3\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],

        ["\xE6\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE3\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],

        ["\xE6\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE3\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],

        ["\xE6\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE3\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],

        ["\xE6\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE3\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],

        ["\xE6\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],

        ["\xE6\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE3\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],

        ["\xE6\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE3\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],

        ["\xE6\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE3\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],

        ["\xE6\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE3\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],

        ["\xE6\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],

        ["\xE6\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE3\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],

        ["\xE6\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE3\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],

        ["\xE6\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE3\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],

        ["\xE6\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE3\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],

        ["\xE6\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE3\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],

        ["\xE6\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE3\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],

        ["\xE6\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE3\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],

        ["\xE6\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE3\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],

        ["\xE6\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE3\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],

        ["\xE6\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE3\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],

        ["\xE6\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE3\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],

        ["\xE6\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE3\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],

        ["\xE6\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE3\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],

        ["\xE6\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE3\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],

        ["\xE6\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE3\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],

        ["\xE6\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],

        ["\xE6\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],

        ["\xE6\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],

        ["\xE6\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],

        ["\xE6\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],

        ["\xE6\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],

        ["\xE6\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],

        ["\xE6\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],

        ["\xE6\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],

        ["\xE6\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],

        ["\xE6\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE3\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],

        ["\xE6\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE3\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],

        ["\xE6\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE3\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],

        ["\xE6\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE3\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],

        ["\xE6\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE3\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],

        ["\xE6\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE3\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],

        ["\xE6\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],

        ["\xE6\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],

        ["\xE6\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],

        ["\xE6\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],

        ["\xE6\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],

        ["\xE6\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],

        ["\xE6\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],

        ["\xE6\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],

        ["\xE6\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],

        ["\xE6\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],

        ["\xE6\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE3\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],

        ["\xE6\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE3\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],

        ["\xE6\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE3\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],

        ["\xE6\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE3\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],

        ["\xE6\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE3\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],

        ["\xE6\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE3\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],

        ["\xE6\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],

        ["\xE6\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],

        ["\xE6\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],

        ["\xE6\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],

        ["\xE6\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],

        ["\xE6\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],

        ["\xE6\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],

        ["\xE6\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],

        ["\xE6\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],

        ["\xE6\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],

        ["\xE6\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE3\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],

        ["\xE6\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE3\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],

        ["\xE6\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE3\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],

        ["\xE6\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE3\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],

        ["\xE6\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE3\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],

        ["\xE6\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE3\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],

        ["\xE6\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],

        ["\xE6\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],

        ["\xE6\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],

        ["\xE6\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],

        ["\xE6\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],

        ["\xE6\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],

        ["\xE6\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],

        ["\xE6\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],

        ["\xE6\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],

        ["\xE6\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],

        ["\xE6\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE3\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],

        ["\xE6\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE3\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],

        ["\xE6\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE3\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],

        ["\xE7\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xE4\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],

        ["\xE7\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xE4\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],

        ["\xE7\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xE4\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],

        ["\xE7\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xE4\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],

        ["\xE7\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xE4\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],

        ["\xE7\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xE4\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],

        ["\xE7\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xE4\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],

        ["\xE7\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xE4\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],

        ["\xE7\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xE4\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],

        ["\xE7\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xE4\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],

        ["\xE7\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE4\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],

        ["\xE7\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE4\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],

        ["\xE7\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE4\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],

        ["\xE7\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE4\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],

        ["\xE7\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE4\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],

        ["\xE7\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE4\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],

        ["\xE7\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE4\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],

        ["\xE7\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xE4\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],

        ["\xE7\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xE4\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],

        ["\xE7\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xE4\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],

        ["\xE7\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xE4\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],

        ["\xE7\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xE4\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],

        ["\xE7\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xE4\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],

        ["\xE7\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE4\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],

        ["\xE7\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xE4\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],

        ["\xE7\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE4\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],

        ["\xE7\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE4\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],

        ["\xE7\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE4\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],

        ["\xE7\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE4\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],

        ["\xE7\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE4\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],

        ["\xE7\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE4\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],

        ["\xE7\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE4\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],

        ["\xE7\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE4\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],

        ["\xE7\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE4\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],

        ["\xE7\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE4\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],

        ["\xE7\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE4\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],

        ["\xE7\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE4\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],

        ["\xE7\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE4\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],

        ["\xE7\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE4\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],

        ["\xE7\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE4\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],

        ["\xE7\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE4\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],

        ["\xE7\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE4\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],

        ["\xE7\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE4\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],

        ["\xE7\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE4\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],

        ["\xE7\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE4\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],

        ["\xE7\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE4\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],

        ["\xE7\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE4\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],

        ["\xE7\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE4\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],

        ["\xE7\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE4\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],

        ["\xE7\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE4\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],

        ["\xE7\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE4\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],

        ["\xE7\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE4\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],

        ["\xE7\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE4\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],

        ["\xE7\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE4\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],

        ["\xE7\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE4\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],

        ["\xE7\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE4\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],

        ["\xE7\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE4\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],

        ["\xE7\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE4\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],

        ["\xE7\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE4\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],

        ["\xE7\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE4\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],

        ["\xE7\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE4\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],

        ["\xE7\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE4\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],

        ["\xE7\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE4\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],

        ["\xE7\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE4\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],

        ["\xE7\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xE4\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],

        ["\xE7\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xE4\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],

        ["\xE7\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xE4\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],

        ["\xE7\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xE4\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],

        ["\xE7\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xE4\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],

        ["\xE7\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xE4\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],

        ["\xE7\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xE4\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],

        ["\xE7\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xE4\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],

        ["\xE7\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xE4\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],

        ["\xE7\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xE4\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],

        ["\xE7\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE4\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],

        ["\xE7\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xE4\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],

        ["\xE7\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xE4\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],

        ["\xE7\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xE4\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],

        ["\xE7\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xE4\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],

        ["\xE7\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xE4\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],

        ["\xE7\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xE4\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],

        ["\xE7\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xE4\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],

        ["\xE7\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xE4\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],

        ["\xE7\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xE4\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],

        ["\xE7\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xE4\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],

        ["\xE7\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xE4\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],

        ["\xE7\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xE4\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],

        ["\xE7\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xE4\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],

        ["\xE7\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xE4\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],

        ["\xE7\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xE4\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],

        ["\xE7\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE4\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],

        ["\xE7\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE4\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],

        ["\xE7\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xE4\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],

        ["\xE7\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xE4\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],

        ["\xE8\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xE4\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],

        ["\xE8\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE4\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],

        ["\xE8\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],

        ["\xE8\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE4\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],

        ["\xE8\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE4\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],

        ["\xE8\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE4\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],

        ["\xE8\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE4\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],

        ["\xE8\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE4\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],

        ["\xE8\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE4\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],

        ["\xE8\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE4\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],

        ["\xE8\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE4\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],

        ["\xE8\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE4\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],

        ["\xE8\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],

        ["\xE8\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE4\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],

        ["\xE8\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE4\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],

        ["\xE8\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE4\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],

        ["\xE8\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE4\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],

        ["\xE8\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],

        ["\xE8\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE4\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],

        ["\xE8\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE4\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],

        ["\xE8\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE4\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],

        ["\xE8\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE4\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],

        ["\xE8\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE4\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],

        ["\xE8\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE4\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],

        ["\xE8\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE4\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],

        ["\xE8\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE4\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],

        ["\xE8\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE4\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],

        ["\xE8\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE4\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],

        ["\xE8\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE4\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],

        ["\xE8\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE4\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],

        ["\xE8\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE4\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],

        ["\xE8\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE4\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],

        ["\xE8\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE4\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],

        ["\xE8\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],

        ["\xE8\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],

        ["\xE8\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],

        ["\xE8\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],

        ["\xE8\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],

        ["\xE8\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],

        ["\xE8\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],

        ["\xE8\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],

        ["\xE8\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],

        ["\xE8\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],

        ["\xE8\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE4\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],

        ["\xE8\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE4\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],

        ["\xE8\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE4\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],

        ["\xE8\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE4\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],

        ["\xE8\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE4\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],

        ["\xE8\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE4\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],

        ["\xE8\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],

        ["\xE8\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],

        ["\xE8\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],

        ["\xE8\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],

        ["\xE8\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],

        ["\xE8\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],

        ["\xE8\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],

        ["\xE8\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],

        ["\xE8\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],

        ["\xE8\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],

        ["\xE8\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE4\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],

        ["\xE8\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE4\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],

        ["\xE8\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE4\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],

        ["\xE8\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE4\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],

        ["\xE8\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE4\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],

        ["\xE8\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE4\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],

        ["\xE8\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],

        ["\xE8\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE4\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],

        ["\xE8\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],

        ["\xE8\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],

        ["\xE8\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],

        ["\xE8\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],

        ["\xE8\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],

        ["\xE8\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],

        ["\xE8\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],

        ["\xE8\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],

        ["\xE8\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE4\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],

        ["\xE8\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE4\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],

        ["\xE8\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE4\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],

        ["\xE8\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE4\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],

        ["\xE8\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE4\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],

        ["\xE8\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE4\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],

        ["\xE8\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],

        ["\xE8\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],

        ["\xE8\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],

        ["\xE8\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],

        ["\xE8\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],

        ["\xE8\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],

        ["\xE8\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],

        ["\xE8\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],

        ["\xE8\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],

        ["\xE8\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],

        ["\xE8\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE4\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],

        ["\xE8\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE4\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],

        ["\xE8\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE4\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],

        ["\xE9\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xE5\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],

        ["\xE9\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xE5\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],

        ["\xE9\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xE5\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],

        ["\xE9\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xE5\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],

        ["\xE9\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xE5\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],

        ["\xE9\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xE5\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],

        ["\xE9\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xE5\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],

        ["\xE9\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xE5\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],

        ["\xE9\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xE5\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],

        ["\xE9\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xE5\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],

        ["\xE9\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE5\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],

        ["\xE9\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE5\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],

        ["\xE9\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xE5\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],

        ["\xE9\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE5\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],

        ["\xE9\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE5\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],

        ["\xE9\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE5\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],

        ["\xE9\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE5\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],

        ["\xE9\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xE5\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],

        ["\xE9\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xE5\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],

        ["\xE9\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xE5\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],

        ["\xE9\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xE5\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],

        ["\xE9\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xE5\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],

        ["\xE9\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xE5\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],

        ["\xE9\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE5\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],

        ["\xE9\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xE5\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],

        ["\xE9\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE5\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],

        ["\xE9\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE5\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],

        ["\xE9\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE5\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],

        ["\xE9\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE5\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],

        ["\xE9\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE5\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],

        ["\xE9\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE5\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],

        ["\xE9\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE5\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],

        ["\xE9\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE5\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],

        ["\xE9\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE5\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],

        ["\xE9\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE5\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],

        ["\xE9\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE5\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],

        ["\xE9\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE5\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],

        ["\xE9\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE5\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],

        ["\xE9\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE5\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],

        ["\xE9\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE5\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],

        ["\xE9\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE5\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],

        ["\xE9\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE5\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],

        ["\xE9\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE5\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],

        ["\xE9\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE5\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],

        ["\xE9\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE5\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],

        ["\xE9\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE5\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],

        ["\xE9\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE5\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],

        ["\xE9\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE5\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],

        ["\xE9\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE5\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],

        ["\xE9\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE5\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],

        ["\xE9\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE5\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],

        ["\xE9\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE5\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],

        ["\xE9\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE5\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],

        ["\xE9\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE5\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],

        ["\xE9\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE5\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],

        ["\xE9\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE5\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],

        ["\xE9\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xE5\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],

        ["\xE9\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE5\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],

        ["\xE9\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE5\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],

        ["\xE9\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE5\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],

        ["\xE9\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE5\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],

        ["\xE9\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE5\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],

        ["\xE9\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE5\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],

        ["\xE9\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE5\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],

        ["\xE9\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xE5\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],

        ["\xE9\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xE5\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],

        ["\xE9\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xE5\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],

        ["\xE9\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xE5\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],

        ["\xE9\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xE5\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],

        ["\xE9\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xE5\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],

        ["\xE9\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xE5\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],

        ["\xE9\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xE5\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],

        ["\xE9\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xE5\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],

        ["\xE9\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xE5\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],

        ["\xE9\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE5\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],

        ["\xE9\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xE5\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],

        ["\xE9\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xE5\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],

        ["\xE9\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xE5\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],

        ["\xE9\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xE5\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],

        ["\xE9\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xE5\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],

        ["\xE9\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xE5\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],

        ["\xE9\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xE5\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],

        ["\xE9\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xE5\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],

        ["\xE9\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xE5\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],

        ["\xE9\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xE5\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],

        ["\xE9\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xE5\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],

        ["\xE9\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xE5\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],

        ["\xE9\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xE5\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],

        ["\xE9\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xE5\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],

        ["\xE9\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xE5\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],

        ["\xE9\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE5\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],

        ["\xE9\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE5\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],

        ["\xE9\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xE5\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],

        ["\xE9\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xE5\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],

        ["\xEA\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xE5\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],

        ["\xEA\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xE5\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],

        ["\xEA\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],

        ["\xEA\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE5\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],

        ["\xEA\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE5\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],

        ["\xEA\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE5\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],

        ["\xEA\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE5\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],

        ["\xEA\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE5\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],

        ["\xEA\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE5\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],

        ["\xEA\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE5\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],

        ["\xEA\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE5\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],

        ["\xEA\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE5\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],

        ["\xEA\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],

        ["\xEA\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE5\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],

        ["\xEA\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE5\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],

        ["\xEA\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE5\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],

        ["\xEA\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE5\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],

        ["\xEA\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],

        ["\xEA\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE5\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],

        ["\xEA\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE5\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],

        ["\xEA\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE5\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],

        ["\xEA\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE5\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],

        ["\xEA\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE5\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],

        ["\xEA\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE5\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],

        ["\xEA\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE5\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],

        ["\xEA\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE5\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],

        ["\xEA\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE5\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],

        ["\xEA\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE5\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],

        ["\xEA\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE5\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],

        ["\xEA\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE5\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],

        ["\xEA\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE5\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],

        ["\xEA\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE5\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],

        ["\xEA\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE5\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],

        ["\xEA\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],

        ["\xEA\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],

        ["\xEA\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],

        ["\xEA\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],

        ["\xEA\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],

        ["\xEA\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],

        ["\xEA\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],

        ["\xEA\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],

        ["\xEA\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],

        ["\xEA\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],

        ["\xEA\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE5\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],

        ["\xEA\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE5\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],

        ["\xEA\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE5\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],

        ["\xEA\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE5\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],

        ["\xEA\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE5\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],

        ["\xEA\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE5\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],

        ["\xEA\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],

        ["\xEA\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],

        ["\xEA\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],

        ["\xEA\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],

        ["\xEA\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],

        ["\xEA\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],

        ["\xEA\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],

        ["\xEA\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],

        ["\xEA\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],

        ["\xEA\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],

        ["\xEA\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE5\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],

        ["\xEA\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE5\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],

        ["\xEA\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE5\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],

        ["\xEA\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE5\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],

        ["\xEA\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE5\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],

        ["\xEA\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE5\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],

        ["\xEA\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],

        ["\xEA\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE5\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],

        ["\xEA\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],

        ["\xEA\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],

        ["\xEA\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],

        ["\xEA\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],

        ["\xEA\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],

        ["\xEA\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],

        ["\xEA\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],

        ["\xEA\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],

        ["\xEA\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE5\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],

        ["\xEA\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE5\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],

        ["\xEA\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE5\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],

        ["\xEA\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE5\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],

        ["\xEA\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE5\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],

        ["\xEA\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE5\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],

        ["\xEA\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],

        ["\xEA\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],

        ["\xEA\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],

        ["\xEA\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],

        ["\xEA\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],

        ["\xEA\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],

        ["\xEA\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],

        ["\xEA\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],

        ["\xEA\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],

        ["\xEA\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],

        ["\xEA\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE5\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],

        ["\xEA\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE5\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],

        ["\xEA\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE5\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],

        ["\xEB\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xE6\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],

        ["\xEB\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xE6\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],

        ["\xEB\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xE6\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],

        ["\xEB\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xE6\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],

        ["\xEB\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xE6\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],

        ["\xEB\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xE6\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],

        ["\xEB\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xE6\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],

        ["\xEB\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xE6\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],

        ["\xEB\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xE6\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],

        ["\xEB\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xE6\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],

        ["\xEB\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xE6\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],

        ["\xEB\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xE6\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],

        ["\xEB\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xE6\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],

        ["\xEB\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xE6\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],

        ["\xEB\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xE6\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],

        ["\xEB\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xE6\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],

        ["\xEB\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xE6\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],

        ["\xEB\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xE6\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],

        ["\xEB\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xE6\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],

        ["\xEB\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xE6\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],

        ["\xEB\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xE6\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],

        ["\xEB\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xE6\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],

        ["\xEB\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xE6\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],

        ["\xEB\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xE6\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],

        ["\xEB\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xE6\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],

        ["\xEB\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xE6\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],

        ["\xEB\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xE6\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],

        ["\xEB\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xE6\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],

        ["\xEB\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xE6\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],

        ["\xEB\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xE6\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],

        ["\xEB\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xE6\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],

        ["\xEB\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xE6\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],

        ["\xEB\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xE6\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],

        ["\xEB\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xE6\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],

        ["\xEB\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xE6\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],

        ["\xEB\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xE6\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],

        ["\xEB\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xE6\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],

        ["\xEB\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xE6\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],

        ["\xEB\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xE6\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],

        ["\xEB\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xE6\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],

        ["\xEB\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xE6\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],

        ["\xEB\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xE6\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],

        ["\xEB\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xE6\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],

        ["\xEB\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xE6\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],

        ["\xEB\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xE6\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],

        ["\xEB\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xE6\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],

        ["\xEB\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xE6\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],

        ["\xEB\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xE6\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],

        ["\xEB\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xE6\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],

        ["\xEB\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xE6\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],

        ["\xEB\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xE6\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],

        ["\xEB\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xE6\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],

        ["\xEB\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xE6\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],

        ["\xEB\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xE6\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],

        ["\xEB\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xE6\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],

        ["\xEB\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xE6\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],

        ["\xEB\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xE6\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],

        ["\xEB\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xE6\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],

        ["\xEB\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xE6\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],

        ["\xEB\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xE6\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],

        ["\xEB\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xE6\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],

        ["\xEB\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xE6\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],

        ["\xEB\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xE6\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],

        ["\xEB\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xE6\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],

        ["\xEB\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\xE6\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],

        ["\xEB\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\xE6\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],

        ["\xEB\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\xE6\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],

        ["\xEB\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\xE6\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],

        ["\xEB\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\xE6\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],

        ["\xEB\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\xE6\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],

        ["\xEB\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\xE6\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],

        ["\xEB\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\xE6\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],

        ["\xEB\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\xE6\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],

        ["\xEB\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\xE6\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],

        ["\xEB\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xE6\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],

        ["\xEB\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\xE6\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],

        ["\xEB\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\xE6\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],

        ["\xEB\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\xE6\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],

        ["\xEB\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\xE6\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],

        ["\xEB\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\xE6\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],

        ["\xEB\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\xE6\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],

        ["\xEB\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\xE6\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],

        ["\xEB\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\xE6\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],

        ["\xEB\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\xE6\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],

        ["\xEB\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\xE6\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],

        ["\xEB\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\xE6\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],

        ["\xEB\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\xE6\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],

        ["\xEB\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\xE6\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],

        ["\xEB\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\xE6\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],

        ["\xEB\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\xE6\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],

        ["\xEB\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xE6\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],

        ["\xEB\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xE6\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],

        ["\xEB\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\xE6\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],

        ["\xEB\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\xE6\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],

        ["\xEC\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\xE6\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],

        ["\xEC\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xE6\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],

        ["\xEC\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE6\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],

        ["\xEC\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE6\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],

        ["\xEC\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE6\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],

        ["\xEC\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE6\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],

        ["\xEC\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE6\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],

        ["\xEC\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE6\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],

        ["\xEC\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE6\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],

        ["\xEC\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE6\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],

        ["\xEC\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE6\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],

        ["\xEC\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE6\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],

        ["\xEC\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE6\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],

        ["\xEC\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],

        ["\xEC\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE6\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],

        ["\xEC\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],

        ["\xEC\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE6\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],

        ["\xEC\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE6\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],

        ["\xEC\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE6\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],

        ["\xEC\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE6\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],

        ["\xEC\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE6\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],

        ["\xEC\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE6\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],

        ["\xEC\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE6\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],

        ["\xEC\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE6\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],

        ["\xEC\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE6\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],

        ["\xEC\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE6\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],

        ["\xEC\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE6\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],

        ["\xEC\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE6\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],

        ["\xEC\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE6\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],

        ["\xEC\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE6\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],

        ["\xEC\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE6\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],

        ["\xEC\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE6\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],

        ["\xEC\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE6\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],

        ["\xEC\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],

        ["\xEC\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE6\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],

        ["\xEC\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE6\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],

        ["\xEC\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE6\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],

        ["\xEC\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE6\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],

        ["\xEC\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE6\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],

        ["\xEC\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE6\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],

        ["\xEC\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE6\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],

        ["\xEC\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE6\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],

        ["\xEC\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE6\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],

        ["\xEC\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE6\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],

        ["\xEC\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE6\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],

        ["\xEC\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE6\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],

        ["\xEC\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE6\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],

        ["\xEC\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE6\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],

        ["\xEC\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE6\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],

        ["\xEC\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE6\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],

        ["\xEC\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE6\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],

        ["\xEC\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE6\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],

        ["\xEC\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE6\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],

        ["\xEC\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE6\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],

        ["\xEC\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE6\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],

        ["\xEC\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE6\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],

        ["\xEC\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE6\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],

        ["\xEC\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE6\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],

        ["\xEC\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE6\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],

        ["\xEC\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE6\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],

        ["\xEC\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE6\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],

        ["\xEC\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE6\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],

        ["\xEC\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE6\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],

        ["\xEC\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE6\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],

        ["\xEC\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE6\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],

        ["\xEC\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE6\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],

        ["\xEC\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE6\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],

        ["\xEC\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE6\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],

        ["\xEC\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE6\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],

        ["\xEC\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE6\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],

        ["\xEC\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE6\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],

        ["\xEC\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE6\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],

        ["\xEC\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE6\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],

        ["\xEC\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE6\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],

        ["\xEC\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE6\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],

        ["\xEC\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE6\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],

        ["\xEC\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE6\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],

        ["\xEC\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE6\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],

        ["\xEC\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE6\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],

        ["\xEC\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE6\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],

        ["\xEC\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],

        ["\xEC\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE6\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],

        ["\xEC\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE6\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],

        ["\xEC\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE6\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],

        ["\xEC\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE6\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],

        ["\xEC\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE6\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],

        ["\xEC\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE6\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],

        ["\xEC\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],

        ["\xEC\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE6\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],

        ["\xEC\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE6\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],

        ["\xEC\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE6\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],

        ["\xEC\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE6\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],

        ["\xEC\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE6\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],

        ["\xEC\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE6\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],

        ["\xED\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\xE7\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],

        ["\xED\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\xE7\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],

        ["\xED\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\xE7\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],

        ["\xED\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\xE7\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],

        ["\xED\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\xE7\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],

        ["\xED\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\xE7\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],

        ["\xED\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\xE7\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],

        ["\xED\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\xE7\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],

        ["\xED\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\xE7\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],

        ["\xED\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\xE7\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],

        ["\xED\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xE7\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],

        ["\xED\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xE7\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],

        ["\xED\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xE7\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],

        ["\xED\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xE7\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],

        ["\xED\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xE7\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],

        ["\xED\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xE7\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],

        ["\xED\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xE7\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],

        ["\xED\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\xE7\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],

        ["\xED\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\xE7\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],

        ["\xED\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\xE7\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],

        ["\xED\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xE7\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],

        ["\xED\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\xE7\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],

        ["\xED\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\xE7\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],

        ["\xED\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xE7\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],

        ["\xED\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xE7\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],

        ["\xED\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xE7\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],

        ["\xED\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xE7\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],

        ["\xED\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xE7\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],

        ["\xED\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xE7\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],

        ["\xED\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xE7\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],

        ["\xED\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xE7\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],

        ["\xED\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xE7\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],

        ["\xED\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xE7\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],

        ["\xED\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xE7\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],

        ["\xED\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xE7\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],

        ["\xED\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xE7\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],

        ["\xED\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xE7\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],

        ["\xED\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xE7\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],

        ["\xED\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xE7\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],

        ["\xED\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE7\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],

        ["\xED\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE7\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],

        ["\xED\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE7\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],

        ["\xED\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE7\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],

        ["\xED\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE7\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],

        ["\xED\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xE7\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],

        ["\xED\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xE7\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],

        ["\xED\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xE7\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],

        ["\xED\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xE7\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],

        ["\xED\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xE7\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],

        ["\xED\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xE7\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],

        ["\xED\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xE7\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],

        ["\xED\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xE7\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],

        ["\xED\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xE7\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],

        ["\xED\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xE7\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],

        ["\xED\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xE7\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],

        ["\xED\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xE7\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],

        ["\xED\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xE7\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],

        ["\xED\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xE7\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],

        ["\xED\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xE7\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],

        ["\xED\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xE7\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],

        ["\xED\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xE7\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],

        ["\xED\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xE7\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],

        ["\xED\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xE7\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],

        ["\xED\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xE7\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],

        ["\xED\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xE7\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],

        ["\xED\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xE7\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],

        ["\xED\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xE7\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],

        ["\xED\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xE7\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],

        ["\xED\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xE7\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],

        ["\xED\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xE7\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],

        ["\xED\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xE7\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],

        ["\xED\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xE7\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],

        ["\xED\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xE7\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],

        ["\xED\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xE7\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],

        ["\xED\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xE7\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],

        ["\xED\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xE7\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],

        ["\xED\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xE7\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],

        ["\xED\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xE7\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],

        ["\xED\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xE7\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],

        ["\xED\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xE7\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],

        ["\xED\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xE7\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],

        ["\xED\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xE7\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],

        ["\xED\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xE7\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],

        ["\xED\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\xE7\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],

        ["\xED\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xE7\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],

        ["\xED\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\xE7\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],

        ["\xED\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\xE7\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],

        ["\xED\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\xE7\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],

        ["\xED\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xE7\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],

        ["\xED\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\xE7\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],

        ["\xED\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xE7\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],

        ["\xED\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xE7\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],

        ["\xED\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xE7\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],

        ["\xED\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\xE7\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],

        ["\xEE\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\xE7\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],

        ["\xEE\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xE7\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],

        ["\xEE\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE7\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],

        ["\xEE\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE7\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],

        ["\xEE\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE7\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],

        ["\xEE\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE7\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],

        ["\xEE\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE7\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],

        ["\xEE\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE7\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],

        ["\xEE\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE7\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],

        ["\xEE\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE7\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],

        ["\xEE\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE7\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],

        ["\xEE\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE7\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],

        ["\xEE\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE7\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],

        ["\xEE\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE7\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],

        ["\xEE\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE7\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],

        ["\xEE\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE7\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],

        ["\xEE\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE7\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],

        ["\xEE\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE7\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],

        ["\xEE\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE7\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],

        ["\xEE\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE7\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],

        ["\xEE\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE7\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],

        ["\xEE\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE7\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],

        ["\xEE\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE7\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],

        ["\xEE\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE7\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],

        ["\xEE\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE7\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],

        ["\xEE\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE7\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],

        ["\xEE\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE7\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],

        ["\xEE\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE7\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],

        ["\xEE\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE7\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],

        ["\xEE\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE7\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],

        ["\xEE\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE7\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],

        ["\xEE\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE7\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],

        ["\xEE\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE7\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],

        ["\xEE\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE7\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],

        ["\xEE\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE7\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],

        ["\xEE\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE7\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],

        ["\xEE\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE7\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],

        ["\xEE\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE7\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],

        ["\xEE\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE7\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],

        ["\xEE\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE7\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],

        ["\xEE\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE7\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],

        ["\xEE\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE7\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],

        ["\xEE\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE7\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],

        ["\xEE\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE7\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],

        ["\xEE\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE7\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],

        ["\xEE\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE7\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],

        ["\xEE\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE7\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],

        ["\xEE\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE7\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],

        ["\xEE\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE7\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],

        ["\xEE\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE7\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],

        ["\xEE\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE7\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],

        ["\xEE\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE7\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],

        ["\xEE\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE7\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],

        ["\xEE\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE7\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],

        ["\xEE\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE7\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],

        ["\xEE\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE7\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],

        ["\xEE\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE7\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],

        ["\xEE\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE7\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],

        ["\xEE\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE7\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],

        ["\xEE\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE7\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],

        ["\xEE\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE7\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],

        ["\xEE\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE7\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],

        ["\xEE\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE7\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],

        ["\xEE\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE7\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],

        ["\xEE\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE7\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],

        ["\xEE\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE7\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],

        ["\xEE\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE7\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],

        ["\xEE\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE7\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],

        ["\xEE\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE7\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],

        ["\xEE\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE7\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],

        ["\xEE\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE7\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],

        ["\xEE\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE7\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],

        ["\xEE\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE7\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],

        ["\xEE\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE7\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],

        ["\xEE\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE7\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],

        ["\xEE\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE7\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],

        ["\xEE\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE7\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],

        ["\xEE\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE7\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],

        ["\xEE\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE7\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],

        ["\xEE\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE7\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],

        ["\xEE\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE7\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],

        ["\xEE\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE7\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],

        ["\xEE\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE7\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],

        ["\xEE\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE7\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],

        ["\xEE\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE7\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],

        ["\xEE\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE7\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],

        ["\xEE\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE7\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],

        ["\xEE\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE7\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],

        ["\xEE\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE7\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],

        ["\xEE\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE7\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],

        ["\xEE\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE7\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],

        ["\xEE\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE7\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],

        ["\xEE\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE7\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],

        ["\xEE\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE7\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],

        ["\xEF\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\xE8\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],

        ["\xEF\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xE8\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],

        ["\xEF\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\xE8\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],

        ["\xEF\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\xE8\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],

        ["\xEF\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\xE8\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],

        ["\xEF\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\xE8\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],

        ["\xEF\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xE8\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],

        ["\xEF\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\xE8\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],

        ["\xEF\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\xE8\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],

        ["\xEF\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\xE8\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],

        ["\xEF\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xE8\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],

        ["\xEF\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xE8\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],

        ["\xEF\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xE8\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],

        ["\xEF\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xE8\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],

        ["\xEF\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xE8\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],

        ["\xEF\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xE8\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],

        ["\xEF\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xE8\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],

        ["\xEF\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\xE8\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],

        ["\xEF\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\xE8\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],

        ["\xEF\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\xE8\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],

        ["\xEF\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\xE8\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],

        ["\xEF\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\xE8\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],

        ["\xEF\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\xE8\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],

        ["\xEF\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xE8\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],

        ["\xEF\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\xE8\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],

        ["\xEF\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xE8\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],

        ["\xEF\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xE8\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],

        ["\xEF\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xE8\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],

        ["\xEF\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xE8\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],

        ["\xEF\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xE8\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],

        ["\xEF\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xE8\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],

        ["\xEF\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xE8\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],

        ["\xEF\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xE8\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],

        ["\xEF\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xE8\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],

        ["\xEF\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xE8\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],

        ["\xEF\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xE8\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],

        ["\xEF\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE8\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],

        ["\xEF\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xE8\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],

        ["\xEF\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xE8\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],

        ["\xEF\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xE8\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],

        ["\xEF\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xE8\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],

        ["\xEF\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xE8\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],

        ["\xEF\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xE8\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],

        ["\xEF\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xE8\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],

        ["\xEF\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xE8\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],

        ["\xEF\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xE8\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],

        ["\xEF\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE8\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],

        ["\xEF\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xE8\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],

        ["\xEF\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xE8\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],

        ["\xEF\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xE8\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],

        ["\xEF\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xE8\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],

        ["\xEF\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xE8\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],

        ["\xEF\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xE8\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],

        ["\xEF\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE8\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],

        ["\xEF\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xE8\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],

        ["\xEF\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xE8\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],

        ["\xEF\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xE8\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],

        ["\xEF\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE8\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],

        ["\xEF\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xE8\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],

        ["\xEF\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xE8\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],

        ["\xEF\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xE8\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],

        ["\xEF\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xE8\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],

        ["\xEF\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xE8\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],

        ["\xEF\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xE8\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],

        ["\xEF\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\xE8\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],

        ["\xEF\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\xE8\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],

        ["\xEF\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE8\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],

        ["\xEF\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE8\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],

        ["\xEF\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\xE8\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],

        ["\xEF\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\xE8\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],

        ["\xEF\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE8\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],

        ["\xEF\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE8\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],

        ["\xEF\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\xE8\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],

        ["\xEF\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\xE8\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],

        ["\xEF\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xE8\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],

        ["\xEF\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE8\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],

        ["\xEF\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\xE8\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],

        ["\xEF\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\xE8\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],

        ["\xEF\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\xE8\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],

        ["\xEF\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\xE8\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],

        ["\xEF\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\xE8\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],

        ["\xEF\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\xE8\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],

        ["\xEF\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\xE8\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],

        ["\xEF\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\xE8\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],

        ["\xEF\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\xE8\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],

        ["\xEF\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\xE8\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],

        ["\xEF\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE8\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],

        ["\xEF\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\xE8\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],

        ["\xEF\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\xE8\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],

        ["\xEF\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\xE8\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],

        ["\xEF\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xE8\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],

        ["\xEF\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE8\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],

        ["\xEF\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\xE8\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],

        ["\xEF\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\xE8\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],

        ["\xF0\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\xE8\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],

        ["\xF0\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xE8\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],

        ["\xF0\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],

        ["\xF0\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE8\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],

        ["\xF0\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE8\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],

        ["\xF0\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE8\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],

        ["\xF0\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE8\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],

        ["\xF0\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE8\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],

        ["\xF0\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE8\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],

        ["\xF0\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE8\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],

        ["\xF0\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE8\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],

        ["\xF0\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],

        ["\xF0\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],

        ["\xF0\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE8\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],

        ["\xF0\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE8\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],

        ["\xF0\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],

        ["\xF0\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE8\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],

        ["\xF0\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],

        ["\xF0\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE8\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],

        ["\xF0\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],

        ["\xF0\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE8\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],

        ["\xF0\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],

        ["\xF0\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE8\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],

        ["\xF0\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE8\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],

        ["\xF0\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE8\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],

        ["\xF0\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],

        ["\xF0\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE8\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],

        ["\xF0\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE8\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],

        ["\xF0\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE8\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],

        ["\xF0\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE8\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],

        ["\xF0\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE8\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],

        ["\xF0\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE8\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],

        ["\xF0\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE8\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],

        ["\xF0\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],

        ["\xF0\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],

        ["\xF0\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],

        ["\xF0\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],

        ["\xF0\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],

        ["\xF0\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],

        ["\xF0\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],

        ["\xF0\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],

        ["\xF0\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],

        ["\xF0\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\xC9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],

        ["\xF0\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE8\xCA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],

        ["\xF0\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE8\xCB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],

        ["\xF0\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE8\xCC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],

        ["\xF0\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE8\xCD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],

        ["\xF0\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE8\xCE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],

        ["\xF0\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE8\xCF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],

        ["\xF0\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\xD0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],

        ["\xF0\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\xD1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],

        ["\xF0\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\xD2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],

        ["\xF0\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\xD3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],

        ["\xF0\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\xD4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],

        ["\xF0\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\xD5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],

        ["\xF0\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\xD6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],

        ["\xF0\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\xD7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],

        ["\xF0\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],

        ["\xF0\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],

        ["\xF0\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],

        ["\xF0\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],

        ["\xF0\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE8\xDC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],

        ["\xF0\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE8\xDD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],

        ["\xF0\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE8\xDE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],

        ["\xF0\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE8\xDF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],

        ["\xF0\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\xE0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],

        ["\xF0\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE8\xE1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],

        ["\xF0\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\xE2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],

        ["\xF0\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\xE3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],

        ["\xF0\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\xE4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],

        ["\xF0\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\xE5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],

        ["\xF0\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\xE6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],

        ["\xF0\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\xE7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],

        ["\xF0\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\xE8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],

        ["\xF0\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\xE9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],

        ["\xF0\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE8\xEA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],

        ["\xF0\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],

        ["\xF0\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],

        ["\xF0\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE8\xED",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],

        ["\xF0\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE8\xEE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],

        ["\xF0\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE8\xEF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],

        ["\xF0\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\xF0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],

        ["\xF0\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\xF1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],

        ["\xF0\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\xF2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],

        ["\xF0\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\xF3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],

        ["\xF0\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\xF4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],

        ["\xF0\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\xF5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],

        ["\xF0\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\xF6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],

        ["\xF0\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\xF7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],

        ["\xF0\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\xF8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],

        ["\xF0\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],

        ["\xF0\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],

        ["\xF0\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],

        ["\xF0\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE8\xFC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],

        ["\xF1\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\xE9\x40",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],

        ["\xF1\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\xE9\x41",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],

        ["\xF1\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\xE9\x42",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],

        ["\xF1\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\xE9\x43",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],

        ["\xF1\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\xE9\x44",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],

        ["\xF1\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\xE9\x45",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],

        ["\xF1\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xE9\x46",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],

        ["\xF1\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\xE9\x47",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],

        ["\xF1\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\xE9\x48",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],

        ["\xF1\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\xE9\x49",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],

        ["\xF1\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xE9\x4A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],

        ["\xF1\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xE9\x4B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],

        ["\xF1\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xE9\x4C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],

        ["\xF1\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xE9\x4D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],

        ["\xF1\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xE9\x4E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],

        ["\xF1\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xE9\x4F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],

        ["\xF1\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xE9\x50",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],

        ["\xF1\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xE9\x51",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],

        ["\xF1\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\xE9\x52",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],

        ["\xF1\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\xE9\x53",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],

        ["\xF1\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\xE9\x54",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],

        ["\xF1\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\xE9\x55",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],

        ["\xF1\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\xE9\x56",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],

        ["\xF1\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xE9\x57",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],

        ["\xF1\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\xE9\x58",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],

        ["\xF1\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xE9\x59",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],

        ["\xF1\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xE9\x5A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],

        ["\xF1\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xE9\x5B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],

        ["\xF1\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xE9\x5C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],

        ["\xF1\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xE9\x5D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],

        ["\xF1\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xE9\x5E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],

        ["\xF1\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xE9\x5F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],

        ["\xF1\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xE9\x60",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],

        ["\xF1\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xE9\x61",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],

        ["\xF1\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xE9\x62",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],

        ["\xF1\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\x63",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],

        ["\xF1\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xE9\x64",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],

        ["\xF1\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xE9\x65",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],

        ["\xF1\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xE9\x66",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],

        ["\xF1\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xE9\x67",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],

        ["\xF1\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xE9\x68",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],

        ["\xF1\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xE9\x69",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],

        ["\xF1\xCB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xE9\x6A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],

        ["\xF1\xCC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xE9\x6B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],

        ["\xF1\xCD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\x6C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],

        ["\xF1\xCE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xE9\x6D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],

        ["\xF1\xCF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xE9\x6E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],

        ["\xF1\xD0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xE9\x6F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],

        ["\xF1\xD1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xE9\x70",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],

        ["\xF1\xD2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xE9\x71",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],

        ["\xF1\xD3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xE9\x72",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],

        ["\xF1\xD4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xE9\x73",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],

        ["\xF1\xD5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xE9\x74",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],

        ["\xF1\xD6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xE9\x75",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],

        ["\xF1\xD7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xE9\x76",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],

        ["\xF1\xD8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xE9\x77",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],

        ["\xF1\xD9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xE9\x78",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],

        ["\xF1\xDA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xE9\x79",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],

        ["\xF1\xDB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xE9\x7A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],

        ["\xF1\xDC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xE9\x7B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],

        ["\xF1\xDD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xE9\x7C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],

        ["\xF1\xDE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xE9\x7D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],

        ["\xF1\xDF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xE9\x7E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],

        ["\xF1\xE0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xE9\x80",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],

        ["\xF1\xE1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\xE9\x81",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],

        ["\xF1\xE2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\xE9\x82",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],

        ["\xF1\xE3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\xE9\x83",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],

        ["\xF1\xE4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\xE9\x84",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],

        ["\xF1\xE5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\xE9\x85",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],

        ["\xF1\xE6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\xE9\x86",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],

        ["\xF1\xE7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\xE9\x87",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],

        ["\xF1\xE8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\xE9\x88",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],

        ["\xF1\xE9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\xE9\x89",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],

        ["\xF1\xEA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\xE9\x8A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],

        ["\xF1\xEB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xE9\x8B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],

        ["\xF1\xEC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\xE9\x8C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],

        ["\xF1\xED",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\xE9\x8D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],

        ["\xF1\xEE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\xE9\x8E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],

        ["\xF1\xEF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\xE9\x8F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],

        ["\xF1\xF0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\xE9\x90",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],

        ["\xF1\xF1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\xE9\x91",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],

        ["\xF1\xF2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\xE9\x92",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],

        ["\xF1\xF3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\xE9\x93",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],

        ["\xF1\xF4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\xE9\x94",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],

        ["\xF1\xF5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\xE9\x95",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],

        ["\xF1\xF6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\xE9\x96",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],

        ["\xF1\xF7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\xE9\x97",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],

        ["\xF1\xF8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\xE9\x98",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],

        ["\xF1\xF9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\xE9\x99",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],

        ["\xF1\xFA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\xE9\x9A",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],

        ["\xF1\xFB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xE9\x9B",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],

        ["\xF1\xFC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xE9\x9C",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],

        ["\xF1\xFD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\xE9\x9D",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],

        ["\xF1\xFE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\xE9\x9E",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],

        ["\xF2\xA1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\xE9\x9F",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],

        ["\xF2\xA2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xE9\xA0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],

        ["\xF2\xA3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xA1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],

        ["\xF2\xA4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xA2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],

        ["\xF2\xA5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xA3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],

        ["\xF2\xA6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xA4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],

        ["\xF2\xA7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xA5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],

        ["\xF2\xA8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xA6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],

        ["\xF2\xA9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xA7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],

        ["\xF2\xAA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xA8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],

        ["\xF2\xAB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xA9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],

        ["\xF2\xAC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],

        ["\xF2\xAD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],

        ["\xF2\xAE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],

        ["\xF2\xAF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],

        ["\xF2\xB0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],

        ["\xF2\xB1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],

        ["\xF2\xB2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xB0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],

        ["\xF2\xB3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xB1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],

        ["\xF2\xB4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xB2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],

        ["\xF2\xB5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xB3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],

        ["\xF2\xB6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xB4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],

        ["\xF2\xB7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xB5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],

        ["\xF2\xB8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xB6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],

        ["\xF2\xB9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xB7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],

        ["\xF2\xBA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xB8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],

        ["\xF2\xBB",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xB9",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],

        ["\xF2\xBC",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xBA",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],

        ["\xF2\xBD",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xBB",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],

        ["\xF2\xBE",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xBC",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],

        ["\xF2\xBF",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xBD",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],

        ["\xF2\xC0",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xBE",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],

        ["\xF2\xC1",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xBF",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],

        ["\xF2\xC2",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xC0",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],

        ["\xF2\xC3",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xC1",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],

        ["\xF2\xC4",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xC2",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],

        ["\xF2\xC5",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xC3",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],

        ["\xF2\xC6",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xC4",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],

        ["\xF2\xC7",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xC5",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],

        ["\xF2\xC8",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xC6",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],

        ["\xF2\xC9",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xC7",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],

        ["\xF2\xCA",'cp932x','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xC8",'keis90','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],

        ["\xF2\xCB",'cp932x','keis90',{'INPUT_LAY