package Acme::MetaSyntactic::pooh;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=encoding iso-8859-1

=head1 NAME

Acme::MetaSyntactic::pooh - The characters from I<Winnie-the-Pooh> theme

=head1 DESCRIPTION

Characters from the classics I<Winnie-the-Pooh> (1926)
and I<The House at Pooh Corner> (1928), by A. A. Milne.

=head1 BUGS

Disney shouldn't have touched Pooh.

=head1 NOT A BUG

I<Winnie-the-Pooh> is the correct spelling, no matter what Disney says.

=head1 CONTRIBUTORS

Abigail, Lon Brocard.

=head1 CHANGES

=over 4

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-03-06

Updated in Acme-MetaSyntactic version 0.64.

=item *

2006-02-16

Abigail sent a patch with a few additions.

=item *

2006-02-13

Introduced in Acme-MetaSyntactic version 0.61.

=item *

2005-11-03

Submitted independently by Leon Brocard, with a few additions.

=item *

2005-10-27

Submitted by Abigail.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
Winnie_the_Pooh Christopher_Robin Piglet
Eeyore Owl Rabbit Kanga Roo Tigger
Small Heffalump Woozle
Wizzle Alexander_Beetle Hunny_Bee Jagular
Backson Henry_Pootel Henry_Rush Smallest_of_all Uncle_Robert
