package WWW::Hetzner::Robot::Key;
our $VERSION = '0.001';
our $AUTHORITY = 'cpan:GETTY';

# ABSTRACT: Hetzner Robot SSH Key entity

use Moo;
use namespace::clean;

has client => (
    is       => 'ro',
    required => 1,
    weak_ref => 1,
);

has name        => ( is => 'rw', required => 1 );
has fingerprint => ( is => 'ro', required => 1 );
has type        => ( is => 'ro' );
has size        => ( is => 'ro' );
has data        => ( is => 'ro' );

sub delete {
    my ($self) = @_;
    return $self->client->delete("/key/" . $self->fingerprint);
}

sub update {
    my ($self) = @_;
    return $self->client->post("/key/" . $self->fingerprint, {
        name => $self->name,
    });
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Hetzner::Robot::Key - Hetzner Robot SSH Key entity

=head1 VERSION

version 0.001

=head1 NAME

WWW::Hetzner::Robot::Key - Hetzner Robot SSH Key entity

=head1 ATTRIBUTES

=over 4

=item * name - Key name

=item * fingerprint - Key fingerprint (unique ID)

=item * type - Key type (e.g. ED25519, RSA)

=item * size - Key size in bits

=item * data - Public key data

=back

=head1 METHODS

=head2 delete

    $key->delete;

=head2 update

    $key->name('new-name');
    $key->update;

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/Getty/p5-www-hetzner>

  git clone https://github.com/Getty/p5-www-hetzner.git

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
