/* pam_login_alert module */

#ifndef _PAM_ALERT_H
#define _PAM_ALERT_H

#define OFF 0
#define ON 1

#define MAX_EMAIL 255
#define MAX_WORD 255
#define MAX_LINE 255
#define MAX_FILENAME 255
#define MAX_USER 255
#define MAX_HOSTNAME 255
#define MAX_DOMAINNAME 255
#define MAX_FQDN MAX_HOSTNAME+MAX_DOMAINNAME
#define MAX_EMAIL_SUBJECT 255
#define MAX_EMAIL_BODY 255
#define MAX_PROGRAMCALL 255

typedef struct _alert_parms_t
{
	int mail;                   /* mail alert       */
	char email[MAX_EMAIL];   	/* mail recipient   */
	int syslog;                 /* log alert        */
	int syslog_facility;		/* syslog facility	*/ 
	int syslog_priority;		/* syslog priority	*/
	char users_fname[MAX_FILENAME];	/* users list	*/
} alert_parms_t;    

extern int read_conf(char *fname, alert_parms_t *parms);
extern int getline(char *buf, int n, FILE *fp);
extern int printerr(char *format, ...);
extern char *safe_strncpy(char *dest, char *src, int n);

#undef strncpy
#define strncpy(a, b, c) safe_strncpy(a, b, c)

#endif /* _PAM_ALERT_H */

