
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KF6XmlGuiConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
if (1)
  find_dependency(Qt6DBus 6.6.0)
endif()
find_dependency(Qt6Widgets 6.6.0)
find_dependency(Qt6Xml 6.6.0)

find_dependency(KF6Config "6.13.0")
find_dependency(KF6ConfigWidgets "6.13.0")
find_dependency(KF6GuiAddons "6.13.0")

if (NOT TRUE) 
    find_dependency(Qt6Network "6.6.0")
    find_dependency(Qt6PrintSupport "6.6.0")

    if (1)
        find_dependency(KF6GlobalAccel "6.13.0")
    endif()

    find_dependency(KF6CoreAddons "6.13.0") 
    find_dependency(KF6WidgetsAddons "6.13.0")
    find_dependency(KF6ItemViews "6.13.0")
    find_dependency(KF6I18n "6.13.0")
    find_dependency(KF6IconThemes "6.13.0")
endif()

include("${CMAKE_CURRENT_LIST_DIR}/KF6XmlGuiTargets.cmake")

