/**
The CanvasRenderingContext2D interface, part of the Canvas API, provides the 2D rendering context for the drawing surface of a <canvas> element. It is used for drawing shapes, text, images, and other objects.

@returns {CanvasRenderingContext2D}
*/
CanvasRenderingContext2D = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCanvasElement}
**/
CanvasRenderingContext2D.prototype.canvas = new HTMLCanvasElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {CanvasRenderingContext2DSettings}
**/
CanvasRenderingContext2D.prototype.getContextAttributes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.globalAlpha = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("color" | "color-burn" | "color-dodge" | "copy" | "darken" | "destination-atop" | "destination-in" | "destination-out" | "destination-over" | "difference" | "exclusion" | "hard-light" | "hue" | "lighten" | "lighter" | "luminosity" | "multiply" | "overlay" | "saturation" | "screen" | "soft-light" | "source-atop" | "source-in" | "source-out" | "source-over" | "xor")} GlobalCompositeOperation
**/
CanvasRenderingContext2D.prototype.globalCompositeOperation = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(HTMLImageElement | SVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap)} image CanvasImageSource
@param {Number} sx
@param {Number} sy
@param {Number} sw
@param {Number} sh
@param {Number} dx
@param {Number} dy
@param {Number} dw
@param {Number} dh
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.drawImage = function(image, sx, sy, sw, sh, dx, dy, dw, dh) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
CanvasRenderingContext2D.prototype.beginPath = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Path2D} path Path2D
@param {("evenodd" | "nonzero")} [fillRule] CanvasFillRule
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.clip = function(path) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Path2D} path Path2D
@param {("evenodd" | "nonzero")} [fillRule] CanvasFillRule
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.fill = function(path) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Path2D} path Path2D
@param {Number} x
@param {Number} y
@param {("evenodd" | "nonzero")} [fillRule] CanvasFillRule
@returns {Boolean}
**/
CanvasRenderingContext2D.prototype.isPointInPath = function(path, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Path2D} path Path2D
@param {Number} x
@param {Number} y
@returns {Boolean}
**/
CanvasRenderingContext2D.prototype.isPointInStroke = function(path, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Path2D} path Path2D
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.stroke = function(path) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | CanvasGradient | CanvasPattern)} string | CanvasGradient | CanvasPattern
**/
CanvasRenderingContext2D.prototype.fillStyle = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | CanvasGradient | CanvasPattern)} string | CanvasGradient | CanvasPattern
**/
CanvasRenderingContext2D.prototype.strokeStyle = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} startAngle
@param {Number} x
@param {Number} y
@returns {CanvasGradient}
**/
CanvasRenderingContext2D.prototype.createConicGradient = function(startAngle, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x0
@param {Number} y0
@param {Number} x1
@param {Number} y1
@returns {CanvasGradient}
**/
CanvasRenderingContext2D.prototype.createLinearGradient = function(x0, y0, x1, y1) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(HTMLImageElement | SVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap)} image CanvasImageSource
@param {(String | null)} repetition string | null
@returns {(CanvasPattern | null)} CanvasPattern | null
**/
CanvasRenderingContext2D.prototype.createPattern = function(image, repetition) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x0
@param {Number} y0
@param {Number} r0
@param {Number} x1
@param {Number} y1
@param {Number} r1
@returns {CanvasGradient}
**/
CanvasRenderingContext2D.prototype.createRadialGradient = function(x0, y0, r0, x1, y1, r1) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
CanvasRenderingContext2D.prototype.filter = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {ImageData} imagedata ImageData
@returns {ImageData}
**/
CanvasRenderingContext2D.prototype.createImageData = function(imagedata) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} sx
@param {Number} sy
@param {Number} sw
@param {Number} sh
@param {ImageDataSettings} [settings] ImageDataSettings
@returns {ImageData}
**/
CanvasRenderingContext2D.prototype.getImageData = function(sx, sy, sw, sh) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {ImageData} imagedata ImageData
@param {Number} dx
@param {Number} dy
@param {Number} dirtyX
@param {Number} dirtyY
@param {Number} dirtyWidth
@param {Number} dirtyHeight
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.putImageData = function(imagedata, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
CanvasRenderingContext2D.prototype.imageSmoothingEnabled = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("high" | "low" | "medium")} ImageSmoothingQuality
**/
CanvasRenderingContext2D.prototype.imageSmoothingQuality = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@param {Number} radius
@param {Number} startAngle
@param {Number} endAngle
@param {Boolean} [counterclockwise]
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.arc = function(x, y, radius, startAngle, endAngle) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x1
@param {Number} y1
@param {Number} x2
@param {Number} y2
@param {Number} radius
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.arcTo = function(x1, y1, x2, y2, radius) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} cp1x
@param {Number} cp1y
@param {Number} cp2x
@param {Number} cp2y
@param {Number} x
@param {Number} y
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.bezierCurveTo = function(cp1x, cp1y, cp2x, cp2y, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
CanvasRenderingContext2D.prototype.closePath = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@param {Number} radiusX
@param {Number} radiusY
@param {Number} rotation
@param {Number} startAngle
@param {Number} endAngle
@param {Boolean} [counterclockwise]
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.ellipse = function(x, y, radiusX, radiusY, rotation, startAngle, endAngle) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.lineTo = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.moveTo = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} cpx
@param {Number} cpy
@param {Number} x
@param {Number} y
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.quadraticCurveTo = function(cpx, cpy, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@param {Number} w
@param {Number} h
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.rect = function(x, y, w, h) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("butt" | "round" | "square")} CanvasLineCap
**/
CanvasRenderingContext2D.prototype.lineCap = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.lineDashOffset = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("bevel" | "miter" | "round")} CanvasLineJoin
**/
CanvasRenderingContext2D.prototype.lineJoin = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.lineWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.miterLimit = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.getLineDash = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Iterable} segments Iterable
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.setLineDash = function(segments) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@param {Number} w
@param {Number} h
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.clearRect = function(x, y, w, h) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@param {Number} w
@param {Number} h
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.fillRect = function(x, y, w, h) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@param {Number} w
@param {Number} h
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.strokeRect = function(x, y, w, h) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.shadowBlur = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
CanvasRenderingContext2D.prototype.shadowColor = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.shadowOffsetX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
CanvasRenderingContext2D.prototype.shadowOffsetY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
CanvasRenderingContext2D.prototype.restore = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
CanvasRenderingContext2D.prototype.save = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} text
@param {Number} x
@param {Number} y
@param {Number} [maxWidth]
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.fillText = function(text, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} text
@returns {TextMetrics}
**/
CanvasRenderingContext2D.prototype.measureText = function(text) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} text
@param {Number} x
@param {Number} y
@param {Number} [maxWidth]
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.strokeText = function(text, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("inherit" | "ltr" | "rtl")} CanvasDirection
**/
CanvasRenderingContext2D.prototype.direction = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
CanvasRenderingContext2D.prototype.font = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("center" | "end" | "left" | "right" | "start")} CanvasTextAlign
**/
CanvasRenderingContext2D.prototype.textAlign = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("alphabetic" | "bottom" | "hanging" | "ideographic" | "middle" | "top")} CanvasTextBaseline
**/
CanvasRenderingContext2D.prototype.textBaseline = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMMatrix}
**/
CanvasRenderingContext2D.prototype.getTransform = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
CanvasRenderingContext2D.prototype.resetTransform = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} angle
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.rotate = function(angle) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.scale = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {DOMMatrix2DInit} [transform] DOMMatrix2DInit
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.setTransform = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} a
@param {Number} b
@param {Number} c
@param {Number} d
@param {Number} e
@param {Number} f
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.transform = function(a, b, c, d, e, f) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.translate = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Path2D} path Path2D
@param {Element} element Element
@returns {undefined}
**/
CanvasRenderingContext2D.prototype.drawFocusIfNeeded = function(path, element) {};

