<?php

namespace {

	/**
	 * Checks if variable of specified type exists
	 * @param int $input_type <p>One of <b><code>INPUT_GET</code></b>, <b><code>INPUT_POST</code></b>, <b><code>INPUT_COOKIE</code></b>, <b><code>INPUT_SERVER</code></b>, or <b><code>INPUT_ENV</code></b>.</p>
	 * @param string $var_name <p>Name of a variable to check.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.filter-has-var.php
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_has_var(int $input_type, string $var_name): bool {}

	/**
	 * Returns the filter ID belonging to a named filter
	 * @param string $name <p>Name of a filter to get.</p>
	 * @return int|false <p>ID of a filter on success or <b><code>false</code></b> if filter doesn't exist.</p>
	 * @link https://php.net/manual/en/function.filter-id.php
	 * @see filter_list()
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_id(string $name): int|false {}

	/**
	 * Gets a specific external variable by name and optionally filters it
	 * @param int $type One of the <b><code>INPUT_&#42;</code></b> constants.  <p><b>Warning</b></p> <p>The content of the superglobal that is being filtered is the original "raw" content provided by the SAPI, prior to any user modification to the superglobal. To filter a modified superglobal use <code>filter_var()</code> instead.</p>
	 * @param string $var_name Name of a variable to filter inside the corresponding <code>type</code> superglobal.
	 * @param int $filter The filter to apply. Can be a validation filter by using one of the <b><code>FILTER_VALIDATE_&#42;</code></b> constants, a sanitization filter by using one of the <b><code>FILTER_SANITIZE_&#42;</code></b> or <b><code>FILTER_UNSAFE_RAW</code></b>, or a custom filter by using <b><code>FILTER_CALLBACK</code></b>.  <p><b>Note</b>:  The default is <b><code>FILTER_DEFAULT</code></b>, which is an alias of <b><code>FILTER_UNSAFE_RAW</code></b>. This will result in no filtering taking place by default. </p>
	 * @param array|int $options Either an associative <code>array</code> of options, or a bitmask of filter flag constants <b><code>FILTER_FLAG_&#42;</code></b>.   If the <code>filter</code> accepts options, flags can be provided by using the <code>"flags"</code> field of array.
	 * @return mixed <p>On success returns the filtered variable. If the variable is not set <b><code>false</code></b> is returned. On failure <b><code>false</code></b> is returned, unless the <b><code>FILTER_NULL_ON_FAILURE</code></b> flag is used, in which case <b><code>null</code></b> is returned.</p>
	 * @link https://php.net/manual/en/function.filter-input.php
	 * @see filter_input_array(), filter_var(), filter_var_array()
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_input(int $type, string $var_name, int $filter = FILTER_DEFAULT, array|int $options = 0): mixed {}

	/**
	 * Gets external variables and optionally filters them
	 * <p>This function is useful for retrieving many values without repetitively calling <code>filter_input()</code>.</p>
	 * @param int $type One of the <b><code>INPUT_&#42;</code></b> constants.  <p><b>Warning</b></p> <p>The content of the superglobal that is being filtered is the original "raw" content provided by the SAPI, prior to any user modification to the superglobal. To filter a modified superglobal use <code>filter_var_array()</code> instead.</p>
	 * @param array|int $options Either an associative <code>array</code> of options, or the filter to apply to each entry, which can either be a validation filter by using one of the <b><code>FILTER_VALIDATE_&#42;</code></b> constants, or a sanitization filter by using one of the <b><code>FILTER_SANITIZE_&#42;</code></b> constants.   The option array is an associative array where the key corresponds to a key in the data <code>array</code> and the associated value is either the filter to apply to this entry, or an associative array describing how and which filter should be applied to this entry.   The associative array describing how a filter should be applied must contain the <code>'filter'</code> key whose associated value is the filter to apply, which can be one of the <b><code>FILTER_VALIDATE_&#42;</code></b>, <b><code>FILTER_SANITIZE_&#42;</code></b>, <b><code>FILTER_UNSAFE_RAW</code></b>, or <b><code>FILTER_CALLBACK</code></b> constants. It can optionally contain the <code>'flags'</code> key which specifies and flags that apply to the filter, and the <code>'options'</code> key which specifies any options that apply to the filter.
	 * @param bool $add_empty <p>Add missing keys as <b><code>null</code></b> to the return value.</p>
	 * @return array|false|null <p>On success, an <code>array</code> containing the values of the requested variables.</p><p>On failure, <b><code>false</code></b> is returned. Except if the failure is that the input array designated by <code>type</code> is not populated where <b><code>null</code></b> is returned if the <b><code>FILTER_NULL_ON_FAILURE</code></b> flag is used.</p><p>Missing entries from the input array will be populated into the returned <code>array</code> if <code>add_empty</code> is <b><code>true</code></b>. In which case, missing entries will be set to <b><code>null</code></b>, unless the <b><code>FILTER_NULL_ON_FAILURE</code></b> flag is used, in which case it will be <b><code>false</code></b>.</p><p>An entry of the returned <code>array</code> will be <b><code>false</code></b> if the filter fails, unless the <b><code>FILTER_NULL_ON_FAILURE</code></b> flag is used, in which case it will be <b><code>null</code></b>.</p>
	 * @link https://php.net/manual/en/function.filter-input-array.php
	 * @see filter_input(), filter_var(), filter_var_array()
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_input_array(int $type, array|int $options = FILTER_DEFAULT, bool $add_empty = true): array|false|null {}

	/**
	 * Returns a list of all supported filters
	 * @return array <p>Returns an array of names of all supported filters, empty array if there are no such filters. Indexes of this array are not filter IDs, they can be obtained with <code>filter_id()</code> from a name instead.</p>
	 * @link https://php.net/manual/en/function.filter-list.php
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_list(): array {}

	/**
	 * Filters a variable with a specified filter
	 * <p>Filter a variable using a <b><code>FILTER_VALIDATE_&#42;</code></b> validation filters, a <b><code>FILTER_SANITIZE_&#42;</code></b> sanitization filters, or a custom filter.</p>
	 * @param mixed $value Value to filter.  <p><b>Warning</b></p> <p>Scalar values are converted to string internally before they are filtered.</p>
	 * @param int $filter The filter to apply. Can be a validation filter by using one of the <b><code>FILTER_VALIDATE_&#42;</code></b> constants, a sanitization filter by using one of the <b><code>FILTER_SANITIZE_&#42;</code></b> or <b><code>FILTER_UNSAFE_RAW</code></b>, or a custom filter by using <b><code>FILTER_CALLBACK</code></b>.  <p><b>Note</b>:  The default is <b><code>FILTER_DEFAULT</code></b>, which is an alias of <b><code>FILTER_UNSAFE_RAW</code></b>. This will result in no filtering taking place by default. </p>
	 * @param array|int $options Either an associative <code>array</code> of options, or a bitmask of filter flag constants <b><code>FILTER_FLAG_&#42;</code></b>.   If the <code>filter</code> accepts options, flags can be provided by using the <code>"flags"</code> field of array.
	 * @return mixed <p>On success returns the filtered data. On failure <b><code>false</code></b> is returned, unless the <b><code>FILTER_NULL_ON_FAILURE</code></b> flag is used, in which case <b><code>null</code></b> is returned.</p>
	 * @link https://php.net/manual/en/function.filter-var.php
	 * @see filter_var_array(), filter_input(), filter_input_array()
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_var(mixed $value, int $filter = FILTER_DEFAULT, array|int $options = 0): mixed {}

	/**
	 * Gets multiple variables and optionally filters them
	 * <p>Filter an associative <code>array</code> of values using <b><code>FILTER_VALIDATE_&#42;</code></b> validation filters, <b><code>FILTER_SANITIZE_&#42;</code></b> sanitization filters, or custom filters.</p>
	 * @param array $array An associative <code>array</code> containing the data to filter.
	 * @param array|int $options Either an associative <code>array</code> of options, or the filter to apply to each entry, which can either be a validation filter by using one of the <b><code>FILTER_VALIDATE_&#42;</code></b> constants, or a sanitization filter by using one of the <b><code>FILTER_SANITIZE_&#42;</code></b> constants.   The option array is an associative array where the key corresponds to a key in the data <code>array</code> and the associated value is either the filter to apply to this entry, or an associative array describing how and which filter should be applied to this entry.   The associative array describing how a filter should be applied must contain the <code>'filter'</code> key whose associated value is the filter to apply, which can be one of the <b><code>FILTER_VALIDATE_&#42;</code></b>, <b><code>FILTER_SANITIZE_&#42;</code></b>, <b><code>FILTER_UNSAFE_RAW</code></b>, or <b><code>FILTER_CALLBACK</code></b> constants. It can optionally contain the <code>'flags'</code> key which specifies and flags that apply to the filter, and the <code>'options'</code> key which specifies any options that apply to the filter.
	 * @param bool $add_empty <p>Add missing keys as <b><code>null</code></b> to the return value.</p>
	 * @return array|false|null <p>An array containing the values of the requested variables on success, or <b><code>false</code></b> on failure. An array value will be <b><code>false</code></b> if the filter fails, or <b><code>null</code></b> if the variable is not set.</p>
	 * @link https://php.net/manual/en/function.filter-var-array.php
	 * @see filter_input_array(), filter_var(), filter_input()
	 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
	 */
	function filter_var_array(array $array, array|int $options = FILTER_DEFAULT, bool $add_empty = true): array|false|null {}

	/**
	 * This filter delegates the filtering to a user defined function. The <code>callable</code> is passed via the <code>options</code> parameter as the value associated to the <code>'options'</code> key.  <p>The callback should have the following signature:</p> callback(<code>string</code> <code>$value</code>): <code>mixed</code>  <code>value</code>   The value that is being filtered.    <p><b>Note</b>:  The value returned by the callback will be the value returned by the invoked filter function. </p>  <p><b>Example #1 Example of using <b><code>FILTER_CALLBACK</code></b> to validate a login name </b></p>  <code>&lt;&#63;php<br>function validate_login($value): &#63;string<br>{<br> if (strlen($value) &gt;= 5 &amp;&amp; ctype_alnum($value)) {<br> return $value;<br> }<br> return null;<br>}<br><br>$login = "val1dL0gin";<br>$filtered_login = filter_var($login, FILTER_CALLBACK, ['options' =&gt; 'validate_login']);<br>var_dump($filtered_login);<br><br>$login = "f&amp;ke login";<br>$filtered_login = filter_var($login, FILTER_CALLBACK, ['options' =&gt; 'validate_login']);<br>var_dump($filtered_login);<br>&#63;&gt;</code>  <p>The above example will output:</p>  <pre> string(10) "val1dL0gin" NULL </pre>   <p><b>Warning</b></p> <p>This filter cannot be used with any other filter flags, e.g. <b><code>FILTER_NULL_ON_FAILURE</code></b>.</p>
	 */
	define('FILTER_CALLBACK', 1024);

	/**
	 * Alias of <b><code>FILTER_UNSAFE_RAW</code></b>.
	 */
	define('FILTER_DEFAULT', 516);

	/**
	 * Accept dot (<code>.</code>) character, which usually represents the separator between the integer and fractional parts.
	 */
	define('FILTER_FLAG_ALLOW_FRACTION', 4096);

	/**
	 * Allow integers in hexadecimal notation (<code>0x[0-9a-fA-F]+</code>).
	 */
	define('FILTER_FLAG_ALLOW_HEX', 2);

	/**
	 * Allow integers in octal notation (<code>0[0-7]+</code>).
	 */
	define('FILTER_FLAG_ALLOW_OCTAL', 1);

	/**
	 * Accept numbers in scientific notation by allowing the <code>e</code> and <code>E</code> characters.
	 */
	define('FILTER_FLAG_ALLOW_SCIENTIFIC', 16384);

	/**
	 * Accept commas (<code>,</code>) character, which usually represents the thousand separator.
	 */
	define('FILTER_FLAG_ALLOW_THOUSAND', 8192);

	/**
	 * Accepts Unicode characters in the local part. Available as of PHP 7.1.0.
	 */
	define('FILTER_FLAG_EMAIL_UNICODE', 1048576);

	/**
	 * If sanitizing a string results in an empty string, convert the value to <b><code>null</code></b>
	 */
	define('FILTER_FLAG_EMPTY_STRING_NULL', 256);

	/**
	 * Encode <code>&amp;</code>.
	 */
	define('FILTER_FLAG_ENCODE_AMP', 64);

	/**
	 * Encode characters with ASCII value greater than 127.
	 */
	define('FILTER_FLAG_ENCODE_HIGH', 32);

	/**
	 * Encode characters with ASCII value less than 32.
	 */
	define('FILTER_FLAG_ENCODE_LOW', 16);

	/**
	 * Only allow global addresses. These can be found in &#xBB;&#xA0;RFC 6890 where the <code>Global</code> attribute is <code>True</code>. Available as of PHP 8.2.0.
	 */
	define('FILTER_FLAG_GLOBAL_RANGE', 268435456);

	/**
	 * Requires the URL to contain a host part.  <p><b>Warning</b></p> <p><i>DEPRECATED</i> as of PHP 7.3.0 and <i>REMOVED</i> as of PHP 8.0.0. This is because it is always implied by the <b><code>FILTER_VALIDATE_URL</code></b> filter.</p>
	 */
	define('FILTER_FLAG_HOST_REQUIRED', null);

	/**
	 * Require hostnames to start with an alphanumeric character and contain only alphanumerics or hyphens.
	 */
	define('FILTER_FLAG_HOSTNAME', 1048576);

	/**
	 * Allow IPv4 address.
	 */
	define('FILTER_FLAG_IPV4', 1048576);

	/**
	 * Allow IPv6 address.
	 */
	define('FILTER_FLAG_IPV6', 2097152);

	/**
	 * Singe and double quotes (<code>'</code> and <code>"</code>) will not be encoded.
	 */
	define('FILTER_FLAG_NO_ENCODE_QUOTES', 128);

	/**
	 * Deny private addresses.  <p>These are IPv4 addresses which are in the following ranges: <code>10.0.0.0/8</code>, <code>172.16.0.0/12</code>, <code>192.168.0.0/16</code>.</p>  These are IPv6 addresses starting with <code>FD</code> or <code>FC</code>.
	 */
	define('FILTER_FLAG_NO_PRIV_RANGE', 8388608);

	/**
	 * Deny reserved addresses.   These are the ranges that are marked as <code>Reserved-By-Protocol</code> in &#xBB;&#xA0;RFC 6890.  <p>Which for IPv4 corresponds to the following ranges: <code>0.0.0.0/8</code>, <code>169.254.0.0/16</code>, <code>127.0.0.0/8</code>, <code>240.0.0.0/4</code>.</p> <p>And for IPv6 corresponds to the following ranges: <code>::1/128</code>, <code>::/128</code>, <code>::FFFF:0:0/96</code>, <code>FE80::/10</code>.</p>
	 */
	define('FILTER_FLAG_NO_RES_RANGE', 4194304);

	/**
	 * No flags.
	 */
	define('FILTER_FLAG_NONE', 0);

	/**
	 * Requires the URL to contain a path part.
	 */
	define('FILTER_FLAG_PATH_REQUIRED', 262144);

	/**
	 * Requires the URL to contain a query part.
	 */
	define('FILTER_FLAG_QUERY_REQUIRED', 524288);

	/**
	 * Requires the URL to contain a scheme part.  <p><b>Warning</b></p> <p><i>DEPRECATED</i> as of PHP 7.3.0 and <i>REMOVED</i> as of PHP 8.0.0. This is because it is always implied by the <b><code>FILTER_VALIDATE_URL</code></b> filter.</p>
	 */
	define('FILTER_FLAG_SCHEME_REQUIRED', null);

	/**
	 * Strips backtick (<code>`</code>) characters.
	 */
	define('FILTER_FLAG_STRIP_BACKTICK', 512);

	/**
	 * Strip characters with ASCII value greater than 127.
	 */
	define('FILTER_FLAG_STRIP_HIGH', 8);

	/**
	 * Strip characters with ASCII value less than 32.
	 */
	define('FILTER_FLAG_STRIP_LOW', 4);

	/**
	 * This flags wraps scalar inputs into a one element <code>array</code> for filters which operate on arrays.
	 */
	define('FILTER_FORCE_ARRAY', 67108864);

	/**
	 * Use <b><code>null</code></b> instead of <b><code>false</code></b> on failure.   Usable with any validation <b><code>FILTER_VALIDATE_&#42;</code></b> filter.
	 */
	define('FILTER_NULL_ON_FAILURE', 134217728);

	/**
	 * Flag used to require the input of the filter to be an <code>array</code>.
	 */
	define('FILTER_REQUIRE_ARRAY', 16777216);

	/**
	 * Flag used to require the input of the filter to be a scalar.
	 */
	define('FILTER_REQUIRE_SCALAR', 33554432);

	/**
	 * Apply <code>addslashes()</code> to the input. Available as of PHP 7.3.0.
	 */
	define('FILTER_SANITIZE_ADD_SLASHES', 523);

	/**
	 * Sanitize the string by remove all characters except latin letters (<code>[a-zA-Z]</code>), digits (<code>[0-9]</code>), and the special characters <code>!#$%&amp;'&#42;+-=&#63;^_`{|}~@.[]</code>.
	 */
	define('FILTER_SANITIZE_EMAIL', 517);

	/**
	 * This filter URL-encodes a string.   Optionally it can strip or encode specified characters if used together with the <b><code>FILTER_FLAG_STRIP_&#42;</code></b> and <b><code>FILTER_FLAG_ENCODE_&#42;</code></b> filter sanitization flags.
	 */
	define('FILTER_SANITIZE_ENCODED', 514);

	/**
	 * This filter is equivalent to calling <code>htmlspecialchars()</code> with <b><code>ENT_QUOTES</code></b> set.   The behaviour of encoding quotes can be disabled by using the <b><code>FILTER_FLAG_NO_ENCODE_QUOTES</code></b> filter flag.  <p><b>Warning</b></p> <p>Like <code>htmlspecialchars()</code>, this filter is aware of the default_charset INI setting. If a sequence of bytes is detected that makes up an invalid character in the current character set then the entire string is rejected resulting in a empty string being returned.</p>
	 */
	define('FILTER_SANITIZE_FULL_SPECIAL_CHARS', 522);

	/**
	 * Alias of <b><code>FILTER_SANITIZE_ADD_SLASHES</code></b>.  <p><b>Warning</b></p> <p><i>DEPRECATED</i> as of PHP 7.3.0 and <i>REMOVED</i> as of PHP 8.0.0.</p>
	 */
	define('FILTER_SANITIZE_MAGIC_QUOTES', null);

	/**
	 * Sanitize the string by remove all characters except digits (<code>[0-9]</code>), plus sign (<code>+</code>), and minus sign (<code>-</code>).   <b>Optional Flags</b>  <b><code>FILTER_FLAG_ALLOW_FRACTION</code></b> (<code>int</code>)    Accept dot (<code>.</code>) character, which usually represents the separator between the integer and fractional parts.    <b><code>FILTER_FLAG_ALLOW_THOUSAND</code></b> (<code>int</code>)    Accept commas (<code>,</code>) character, which usually represents the thousand separator.    <b><code>FILTER_FLAG_ALLOW_SCIENTIFIC</code></b> (<code>int</code>)    Accept numbers in scientific notation by allowing the <code>e</code> and <code>E</code> characters.    <p><b>Warning</b></p> <p>If the <b><code>FILTER_FLAG_ALLOW_FRACTION</code></b> flag is not used, then the decimal separator is removed, altering the value received.</p>   <code>&lt;&#63;php<br>$number = '12.34';<br><br>var_dump(filter_var($number, FILTER_SANITIZE_NUMBER_FLOAT));<br>var_dump(filter_var($number, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION));<br>&#63;&gt;</code>  <p>The above example will output:</p>  <pre> string(4) "1234" string(5) "12.34" </pre>
	 */
	define('FILTER_SANITIZE_NUMBER_FLOAT', 520);

	/**
	 * Sanitize the string by remove all characters except digits (<code>[0-9]</code>), plus sign (<code>+</code>), and minus sign (<code>-</code>).
	 */
	define('FILTER_SANITIZE_NUMBER_INT', 519);

	/**
	 * <p>This filter HTML-encodes <code>'</code>, <code>"</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&amp;</code> and characters with an ASCII value less than 32.</p>  Optionally it can strip specified characters if used together with the <b><code>FILTER_FLAG_STRIP_&#42;</code></b> filter sanitization flags, and it can encode characters with ASCII value greater than 127 using <b><code>FILTER_FLAG_ENCODE_HIGH</code></b>.
	 */
	define('FILTER_SANITIZE_SPECIAL_CHARS', 515);

	/**
	 * This filter strips tags and HTML-encodes double and single quotes.   Optionally it can strip or encode specified characters if used together with the <b><code>FILTER_FLAG_STRIP_&#42;</code></b> and <b><code>FILTER_FLAG_ENCODE_&#42;</code></b> filter sanitization flags.   The behaviour of encoding quotes can be disabled by using the <b><code>FILTER_FLAG_NO_ENCODE_QUOTES</code></b> filter flag.  <p><b>Warning</b></p> <p><i>Deprecated</i> as of PHP 8.1.0, use <code>htmlspecialchars()</code> instead.</p>  <p><b>Warning</b></p> <p>The way this filter strips tags is not equivalent to <code>strip_tags()</code>.</p>
	 */
	define('FILTER_SANITIZE_STRING', 513);

	/**
	 * Alias of <b><code>FILTER_SANITIZE_STRING</code></b>.  <p><b>Warning</b></p> <p><i>Deprecated</i> as of PHP 8.1.0, use <code>htmlspecialchars()</code> instead.</p>
	 */
	define('FILTER_SANITIZE_STRIPPED', 513);

	/**
	 * Sanitize the string by remove all characters except latin letters (<code>[a-zA-Z]</code>), digits (<code>[0-9]</code>), and the special characters <code>$-_.+!&#42;'(),{}|\\^~[]`&lt;&gt;#%";/&#63;:@&amp;=</code>.
	 */
	define('FILTER_SANITIZE_URL', 518);

	/**
	 * This filter does nothing.   However, it can strip or encode special characters if used together with the <b><code>FILTER_FLAG_STRIP_&#42;</code></b> and <b><code>FILTER_FLAG_ENCODE_&#42;</code></b> filter sanitization flags.
	 */
	define('FILTER_UNSAFE_RAW', 516);

	/**
	 * Returns <b><code>true</code></b> for <code>"1"</code>, <code>"true"</code>, <code>"on"</code>, and <code>"yes"</code>.   Returns <b><code>false</code></b> for <code>"0"</code>, <code>"false"</code>, <code>"off"</code>, <code>"no"</code>, and <code>""</code>.   The return value for non-boolean values depends on the <b><code>FILTER_NULL_ON_FAILURE</code></b>. If it is set, <b><code>null</code></b> is returned, otherwise <b><code>false</code></b> is returned.   <b>Available options</b> <code>default</code>   Value to return in case the filter fails.     Available as of PHP 8.0.0.
	 */
	define('FILTER_VALIDATE_BOOL', 258);

	/**
	 * Alias of <b><code>FILTER_VALIDATE_BOOL</code></b>. The alias was available prior to the introduction of its canonical name in PHP 8.0.0.
	 */
	define('FILTER_VALIDATE_BOOLEAN', 258);

	/**
	 * Validates whether the domain name is valid according to &#xBB;&#xA0;RFC 952, &#xBB;&#xA0;RFC 1034, &#xBB;&#xA0;RFC 1035, &#xBB;&#xA0;RFC 1123, &#xBB;&#xA0;RFC 2732, and &#xBB;&#xA0;RFC 2181.   <b>Available options</b> <code>default</code>   Value to return in case the filter fails.     <b>Optional Flags</b>  <b><code>FILTER_FLAG_HOSTNAME</code></b> (<code>int</code>)    Require hostnames to start with an alphanumeric character and contain only alphanumerics or hyphens.
	 */
	define('FILTER_VALIDATE_DOMAIN', 277);

	/**
	 * Validates whether the value is a "valid" e-mail address.   The validation is performed against the <code>addr-spec</code> syntax in &#xBB;&#xA0;RFC 822. However, comments, whitespace folding, and dotless domain names are not supported, and thus will be rejected.   <b>Available options</b> <code>default</code>   Value to return in case the filter fails.     <b>Optional Flags</b>  <b><code>FILTER_FLAG_EMAIL_UNICODE</code></b> (<code>int</code>)    Accepts Unicode characters in the local part. Available as of PHP 7.1.0.    <p><b>Warning</b></p> <p>Email validation is complex and the only true way to confirm an email is valid and exists is to send an email to the address.</p>
	 */
	define('FILTER_VALIDATE_EMAIL', 274);

	/**
	 * Validates whether the value is a float, on success it is converted to type <code>float</code>.  <p><b>Note</b>:  String values are trimmed using <code>trim()</code> before validation. </p>  <b>Available options</b> <code>default</code>   Value to return in case the filter fails.   <code>decimal</code>     <code>min_range</code>   Value is only valid if it is greater than or equal to the provided value. Available as of PHP 7.4.0.   <code>max_range</code>   Value is only valid if it is less than or equal to the provided value. Available as of PHP 7.4.0.     <b>Optional Flags</b>  <b><code>FILTER_FLAG_ALLOW_THOUSAND</code></b> (<code>int</code>)    Accept commas (<code>,</code>), which usually represent the thousand separator.
	 */
	define('FILTER_VALIDATE_FLOAT', 259);

	/**
	 * Validates whether the value is an integer, on success it is converted to type <code>int</code>.  <p><b>Note</b>:  String values are trimmed using <code>trim()</code> before validation. </p>  <b>Available options</b> <code>default</code>   Value to return in case the filter fails.   <code>min_range</code>   Value is only valid if it is greater than or equal to the provided value.   <code>max_range</code>   Value is only valid if it is less than or equal to the provided value.     <b>Optional Flags</b>  <b><code>FILTER_FLAG_ALLOW_OCTAL</code></b> (<code>int</code>)    Allow integers in octal notation (<code>0[0-7]+</code>).    <b><code>FILTER_FLAG_ALLOW_HEX</code></b> (<code>int</code>)    Allow integers in hexadecimal notation (<code>0x[0-9a-fA-F]+</code>).
	 */
	define('FILTER_VALIDATE_INT', 257);

	/**
	 * <p>Validates value as IP address.</p>  <b>Available options</b> <code>default</code>   Value to return in case the filter fails.     <b>Optional Flags</b>  <b><code>FILTER_FLAG_IPV4</code></b> (<code>int</code>)    Allow IPv4 address.    <b><code>FILTER_FLAG_IPV6</code></b> (<code>int</code>)    Allow IPv6 address.    <b><code>FILTER_FLAG_NO_RES_RANGE</code></b> (<code>int</code>)    Deny reserved addresses.   These are the ranges that are marked as <code>Reserved-By-Protocol</code> in &#xBB;&#xA0;RFC 6890.  <p>Which for IPv4 corresponds to the following ranges: <code>0.0.0.0/8</code>, <code>169.254.0.0/16</code>, <code>127.0.0.0/8</code>, <code>240.0.0.0/4</code>.</p> <p>And for IPv6 corresponds to the following ranges: <code>::1/128</code>, <code>::/128</code>, <code>::FFFF:0:0/96</code>, <code>FE80::/10</code>.</p>   <b><code>FILTER_FLAG_NO_PRIV_RANGE</code></b> (<code>int</code>)    Deny private addresses.  <p>These are IPv4 addresses which are in the following ranges: <code>10.0.0.0/8</code>, <code>172.16.0.0/12</code>, <code>192.168.0.0/16</code>.</p>  These are IPv6 addresses starting with <code>FD</code> or <code>FC</code>.    <b><code>FILTER_FLAG_GLOBAL_RANGE</code></b> (<code>int</code>)    Only allow global addresses. These can be found in &#xBB;&#xA0;RFC 6890 where the <code>Global</code> attribute is <code>True</code>. Available as of PHP 8.2.0.
	 */
	define('FILTER_VALIDATE_IP', 275);

	/**
	 * Validates whether the value is a MAC address.   <b>Available options</b> <code>default</code>   Value to return in case the filter fails.
	 */
	define('FILTER_VALIDATE_MAC', 276);

	/**
	 * Validates value against the regular expression provided by the <code>regexp</code> option.   <b>Available options</b> <code>default</code>   Value to return in case the filter fails.   <code>regexp</code>   Perl-compatible regular expression.
	 */
	define('FILTER_VALIDATE_REGEXP', 272);

	/**
	 * Validates whether the URL name is valid according to &#xBB;&#xA0;RFC 2396.   <b>Available options</b> <code>default</code>   Value to return in case the filter fails.     <b>Optional Flags</b>  <b><code>FILTER_FLAG_SCHEME_REQUIRED</code></b> (<code>int</code>)    Requires the URL to contain a scheme part.  <p><b>Warning</b></p> <p><i>DEPRECATED</i> as of PHP 7.3.0 and <i>REMOVED</i> as of PHP 8.0.0. This is because it is always implied by the <b><code>FILTER_VALIDATE_URL</code></b> filter.</p>    <b><code>FILTER_FLAG_HOST_REQUIRED</code></b> (<code>int</code>)    Requires the URL to contain a host part.  <p><b>Warning</b></p> <p><i>DEPRECATED</i> as of PHP 7.3.0 and <i>REMOVED</i> as of PHP 8.0.0. This is because it is always implied by the <b><code>FILTER_VALIDATE_URL</code></b> filter.</p>    <b><code>FILTER_FLAG_PATH_REQUIRED</code></b> (<code>int</code>)    Requires the URL to contain a path part.    <b><code>FILTER_FLAG_QUERY_REQUIRED</code></b> (<code>int</code>)    Requires the URL to contain a query part.    <p><b>Warning</b></p> <p>A valid URL may not specify the HTTP protocol (<code>http://</code>). Therefore, further validation may be required to determine if the URL uses an expected protocol, e.g. <code>ssh://</code> or <code>mailto:</code>.</p>  <p><b>Warning</b></p> <p>This filter only works on ASCII URLs. This means that Internationalized Domain Names (IDN) will always be rejected.</p>
	 */
	define('FILTER_VALIDATE_URL', 273);

	/**
	 * COOKIE variables.
	 */
	define('INPUT_COOKIE', 2);

	/**
	 * ENV variables.
	 */
	define('INPUT_ENV', 4);

	/**
	 * GET variables.
	 */
	define('INPUT_GET', 1);

	/**
	 * POST variables.
	 */
	define('INPUT_POST', 0);

	/**
	 * REQUEST variables. (Removed as of PHP 8.0.0; was not implemented previously)
	 */
	define('INPUT_REQUEST', null);

	/**
	 * SERVER variables.
	 */
	define('INPUT_SERVER', 5);

	/**
	 * SESSION variables. (Removed as of PHP 8.0.0; was not implemented previously)
	 */
	define('INPUT_SESSION', null);

}
