/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;
import org.netbeans.modules.db.sql.history.SQLHistoryManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NotImplementedException;
import org.openide.util.RequestProcessor;

public class SQLHistoryPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(SQLHistoryPanel.class);
    private TableRowSorter<HistoryTableModel> rowSorter;
    private HistoryTableModel htm = new HistoryTableModel();
    public static final String SAVE_STATEMENTS_CLEARED = "";
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryPanel.class.getName());
    private JEditorPane editorPane;
    private final ListSelectionModel sqlTableSelektion;
    private final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
    private JComboBox connectionUrlComboBox;
    private JButton deleteAllSQLButton;
    private JButton deleteSQLButton;
    private JLabel inputWarningLabel;
    private JButton insertSQLButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel matchingRowsLabel;
    private JTextField searchTextField;
    private JTable sqlHistoryTable;
    private JButton sqlLimitButton;
    private JLabel sqlLimitLabel;
    private JTextField sqlLimitTextField;

    public SQLHistoryPanel(JEditorPane editorPane) {
        this.editorPane = editorPane;
        this.initComponents();
        this.rowSorter = new TableRowSorter<HistoryTableModel>(this.htm);
        this.sqlHistoryTable.setRowSorter(this.rowSorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.DESCENDING));
        this.rowSorter.setSortKeys(sortKeys);
        this.rowSorter.setSortsOnUpdates(true);
        this.rowSorter.sort();
        this.rowSorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                SQLHistoryPanel.this.updateRowCount();
            }
        });
        this.sqlTableSelektion = this.sqlHistoryTable.getSelectionModel();
        this.updateURLList();
        this.htm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SQLHistoryPanel.this.updateURLList();
                SQLHistoryPanel.this.updateRowCount();
            }
        });
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SQLHistoryPanel.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SQLHistoryPanel.this.updateFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SQLHistoryPanel.this.updateFilter();
            }
        });
        this.sqlHistoryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e)) {
                    SQLHistoryPanel.this.insertSQL();
                    e.consume();
                }
            }
        });
        this.sqlTableSelektion.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SQLHistoryPanel.this.sqlTableSelektion.isSelectionEmpty()) {
                    SQLHistoryPanel.this.insertSQLButton.setEnabled(false);
                    SQLHistoryPanel.this.deleteSQLButton.setEnabled(false);
                } else {
                    SQLHistoryPanel.this.insertSQLButton.setEnabled(true);
                    SQLHistoryPanel.this.deleteSQLButton.setEnabled(true);
                }
            }
        });
        this.connectionUrlComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLHistoryPanel.this.updateFilter();
            }
        });
        this.sqlHistoryTable.setTransferHandler(new TableTransferHandler());
    }

    private void updateRowCount() {
        this.matchingRowsLabel.setText(Integer.toString(this.sqlHistoryTable.getRowCount()));
    }

    private void updateFilter() {
        ArrayList<RowFilter> rowFilter = new ArrayList<RowFilter>();
        ConnectionHistoryItem connectionItem = (ConnectionHistoryItem)this.connectionUrlComboBox.getSelectedItem();
        String url = connectionItem.getUrl();
        if (url != null && !url.equals("*")) {
            rowFilter.add(new EqualsFilter(url, 0));
        }
        if (!this.searchTextField.getText().equals(SAVE_STATEMENTS_CLEARED)) {
            rowFilter.add(new ContainsInsensitiveFilter(this.searchTextField.getText(), 1));
        }
        if (rowFilter.size() > 0) {
            this.rowSorter.setRowFilter(RowFilter.andFilter(rowFilter));
        } else {
            this.rowSorter.setRowFilter(null);
        }
    }

    private void updateURLList() {
        ConnectionHistoryItem selectedItem = (ConnectionHistoryItem)this.connectionUrlComboBox.getSelectedItem();
        final String selectedUrl = selectedItem == null ? null : selectedItem.getUrl();
        final ArrayList<String> urls = new ArrayList<String>(this.htm.getJdbcURLs());
        urls.add(0, "*");
        RP.post(new Runnable(){

            @Override
            public void run() {
                int selectedIndex = 0;
                int w = urls.size();
                Object[] comboItems = new ConnectionHistoryItem[w];
                for (int i = 0; i < w; ++i) {
                    comboItems[i] = new ConnectionHistoryItem((String)urls.get(i));
                    if (urls.get(i) == null || !((String)urls.get(i)).equals(selectedUrl)) continue;
                    selectedIndex = i;
                }
                Arrays.sort(comboItems);
                int selectedIndexFinal = selectedIndex;
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ ConnectionHistoryItem[] val$comboItems;
                    final /* synthetic */ int val$selectedIndexFinal;
                    {
                        this.val$comboItems = connectionHistoryItemArray;
                        this.val$selectedIndexFinal = n;
                    }

                    @Override
                    public void run() {
                        SQLHistoryPanel.this.connectionUrlComboBox.setModel(new DefaultComboBoxModel<ConnectionHistoryItem>(this.val$comboItems));
                        SQLHistoryPanel.this.connectionUrlComboBox.setSelectedIndex(this.val$selectedIndexFinal);
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.connectionUrlComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.searchTextField = new JTextField();
        this.insertSQLButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sqlHistoryTable = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(SQLHistoryPanel.this.getSQLHistoryTooltipValue(SQLHistoryPanel.this.sqlHistoryTable, rowIndex, vColIndex));
                }
                return c;
            }
        };
        this.sqlLimitLabel = new JLabel();
        this.sqlLimitTextField = new JTextField();
        this.sqlLimitButton = new JButton();
        this.inputWarningLabel = new JLabel();
        this.deleteSQLButton = new JButton();
        this.deleteAllSQLButton = new JButton();
        this.matchingRowsLabel = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Connection"));
        this.jLabel2.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Match"));
        this.searchTextField.setMinimumSize(new Dimension(20, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.insertSQLButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Insert"));
        this.insertSQLButton.setToolTipText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Insert"));
        this.insertSQLButton.setEnabled(false);
        this.insertSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLHistoryPanel.this.insertSQLButtonActionPerformed(evt);
            }
        });
        this.sqlHistoryTable.setAutoCreateColumnsFromModel(false);
        this.sqlHistoryTable.setModel(this.htm);
        this.jScrollPane1.setViewportView(this.sqlHistoryTable);
        this.sqlHistoryTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_History"));
        this.sqlHistoryTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_History"));
        int dateColumnWidth1 = new JTextField((String)this.dateTimeFormat.format((Date)new Date())).getPreferredSize().width;
        int dateColumnWidth2 = new JTextField((String)new StringBuilder().append((String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DateTableTitle")).append((String)"XXXXX").toString()).getPreferredSize().width;
        int dateColumnWidth = Math.max(dateColumnWidth1, dateColumnWidth2);
        TableColumnModel sqlHistoryTableTCM = this.sqlHistoryTable.getColumnModel();
        TableColumn sqlHistoryTableColumn = new TableColumn(1);
        sqlHistoryTableColumn.setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SQLTableTitle"));
        sqlHistoryTableTCM.addColumn(sqlHistoryTableColumn);
        sqlHistoryTableColumn = new TableColumn(2);
        sqlHistoryTableColumn.setMinWidth(dateColumnWidth);
        sqlHistoryTableColumn.setPreferredWidth(dateColumnWidth);
        sqlHistoryTableColumn.setMaxWidth(dateColumnWidth);
        sqlHistoryTableColumn.setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DateTableTitle"));
        sqlHistoryTableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Date) {
                    value = SQLHistoryPanel.this.dateTimeFormat.format((Date)value);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        sqlHistoryTableTCM.addColumn(sqlHistoryTableColumn);
        this.sqlLimitLabel.setLabelFor(this.sqlLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.sqlLimitLabel, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SqlLimit"));
        this.sqlLimitTextField.setText(Integer.toString(SQLHistoryManager.getInstance().getListSize()));
        this.sqlLimitTextField.setMinimumSize(new Dimension(18, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.sqlLimitButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ApplyButton"));
        this.sqlLimitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLHistoryPanel.this.sqlLimitButtonActionPerformed(evt);
            }
        });
        this.inputWarningLabel.setForeground(Color.red);
        this.inputWarningLabel.setFocusable(false);
        this.inputWarningLabel.setRequestFocusEnabled(false);
        this.inputWarningLabel.setVerifyInputWhenFocusTarget(false);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteSQLButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Delete"));
        this.deleteSQLButton.setToolTipText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Delete"));
        this.deleteSQLButton.setEnabled(false);
        this.deleteSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLHistoryPanel.this.deleteSQLButtonActionPerformed(evt);
            }
        });
        this.deleteAllSQLButton.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DeleteAll"));
        this.deleteAllSQLButton.setToolTipText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_DeleteAll"));
        this.deleteAllSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLHistoryPanel.this.deleteAllSQLButtonActionPerformed(evt);
            }
        });
        this.matchingRowsLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"SQLHistoryPanel.matchingRowsLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.inputWarningLabel, -1, 174, Short.MAX_VALUE).addGap(493, 493, 493)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.sqlLimitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sqlLimitTextField, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sqlLimitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.matchingRowsLabel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 595, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.connectionUrlComboBox, 0, 218, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchTextField, -2, 147, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.insertSQLButton, -2, 102, -2).addComponent(this.deleteSQLButton, -2, 102, -2).addComponent(this.deleteAllSQLButton, -2, 102, -2)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.connectionUrlComboBox, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.insertSQLButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 141, Short.MAX_VALUE).addComponent(this.deleteAllSQLButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteSQLButton)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 228, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sqlLimitTextField, -2, -1, -2).addComponent(this.sqlLimitButton).addComponent(this.sqlLimitLabel).addComponent(this.matchingRowsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputWarningLabel, -2, 26, -2).addContainerGap()));
        this.connectionUrlComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ASCN_ConnectionCombo"));
        this.connectionUrlComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_ConnectionCombo"));
        this.searchTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Match"));
        this.searchTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Match"));
        this.insertSQLButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Insert"));
        this.insertSQLButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Insert"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Save"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Save"));
        this.sqlLimitTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JTextField tf = (JTextField)input;
                return tf.getText().matches("^\\d+$");
            }
        });
        this.sqlLimitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Apply"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Apply"));
    }

    private void insertSQLButtonActionPerformed(ActionEvent evt) {
        this.insertSQL();
    }

    private void sqlLimitButtonActionPerformed(ActionEvent evt) {
        this.verifySQLLimit();
    }

    private void deleteSQLButtonActionPerformed(ActionEvent evt) {
        this.deleteSQL();
    }

    private void deleteAllSQLButtonActionPerformed(ActionEvent evt) {
        this.deleteAllSQL();
    }

    private void insertSQL() {
        try {
            JEditorPane pane = (JEditorPane)EditorRegistry.lastFocusedComponent();
            String mime = pane.getContentType();
            if (mime.equals("text/x-sql")) {
                this.editorPane = pane;
            }
            int min = this.sqlTableSelektion.getMinSelectionIndex();
            int max = this.sqlTableSelektion.getMaxSelectionIndex();
            for (int i = min; i <= max; ++i) {
                if (!this.sqlHistoryTable.isRowSelected(i)) continue;
                int modelIndex = this.sqlHistoryTable.convertRowIndexToModel(i);
                String sql = ((String)this.htm.getValueAt(modelIndex, 1)).trim();
                this.insertIntoDocument(sql, this.editorPane);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void deleteSQL() {
        SQLHistoryManager shm = SQLHistoryManager.getInstance();
        SQLHistory history = shm.getSQLHistory();
        int min = this.sqlTableSelektion.getMinSelectionIndex();
        int max = this.sqlTableSelektion.getMaxSelectionIndex();
        for (int i = min; i <= max; ++i) {
            if (!this.sqlHistoryTable.isRowSelected(i)) continue;
            int modelIndex = this.sqlHistoryTable.convertRowIndexToModel(i);
            SQLHistoryEntry sql = (SQLHistoryEntry)this.htm.getValueAt(modelIndex, 3);
            history.remove(sql);
        }
        shm.save();
        this.htm.refresh();
    }

    private void deleteAllSQL() {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SQLHistoryPanel.class, (String)"DESC_DeleteAll"), NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DeleteAll"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            SQLHistoryManager shm = SQLHistoryManager.getInstance();
            SQLHistory history = shm.getSQLHistory();
            history.clear();
            shm.save();
            this.htm.refresh();
        }
    }

    private void verifySQLLimit() {
        String enteredLimitString = this.sqlLimitTextField.getText();
        String currentLimit = Integer.toString(SQLHistoryManager.getInstance().getListSize());
        String maxLimit = Integer.toString(10000);
        if (enteredLimitString.equals(SAVE_STATEMENTS_CLEARED)) {
            this.sqlLimitTextField.setText(currentLimit);
            return;
        }
        try {
            Integer enteredLimit = Integer.valueOf(enteredLimitString);
            if (enteredLimit > 10000) {
                this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_NumberInputWarningLabel"));
                this.sqlLimitTextField.setText(maxLimit);
                SQLHistoryManager.getInstance().setListSize(10000);
            } else {
                this.inputWarningLabel.setText(SAVE_STATEMENTS_CLEARED);
                SQLHistoryManager.getInstance().setListSize(enteredLimit);
            }
        }
        catch (NumberFormatException ex) {
            this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_NumberInputWarningLabel"));
            this.sqlLimitTextField.setText(currentLimit);
        }
        this.htm.refresh();
    }

    public String getSQLHistoryTooltipValue(JTable historyTable, int row, int col) {
        HistoryTableModel historyTableModel = (HistoryTableModel)historyTable.getModel();
        int modelColumn = historyTable.convertColumnIndexToModel(col);
        int modelRow = historyTable.convertRowIndexToModel(row);
        if (String.class.isAssignableFrom(historyTableModel.getColumnClass(modelColumn))) {
            String data = (String)historyTableModel.getValueAt(modelRow, modelColumn);
            return "<html>" + data.trim().replace("\n", "<br>") + "</html>";
        }
        if (Date.class.isAssignableFrom(historyTableModel.getColumnClass(modelColumn))) {
            Date data = (Date)historyTableModel.getValueAt(modelRow, modelColumn);
            return DateFormat.getInstance().format(data);
        }
        return null;
    }

    private int insertIntoDocument(String s, JEditorPane target) throws BadLocationException {
        Document doc = target.getDocument();
        if (s == null) {
            s = SAVE_STATEMENTS_CLEARED;
        }
        if (doc == null) {
            return -1;
        }
        int start = -1;
        try {
            Caret caret = target.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            doc.remove(p0, p1 - p0);
            start = caret.getDot();
            doc.insertString(start, s + ";\n", null);
        }
        catch (BadLocationException ble) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_InsertAtLocationError") + ble);
        }
        return start;
    }

    private static class ConnectionHistoryItem
    implements Comparable<ConnectionHistoryItem> {
        private static final String ALL_URLS = "*";
        private String url;
        private String name;

        public ConnectionHistoryItem(String url) {
            String string = this.url = url == null ? ALL_URLS : url;
            if (ALL_URLS.equals(url)) {
                this.name = NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem");
            } else {
                for (DatabaseConnection dc : ConnectionManager.getDefault().getConnections()) {
                    if (!dc.getDatabaseURL().equals(url)) continue;
                    this.name = dc.getDisplayName();
                    break;
                }
                if (this.name == null) {
                    this.name = url;
                }
            }
            assert (this.name != null);
            assert (this.url != null);
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(ConnectionHistoryItem o) {
            boolean o1IsAll = this.url.equals(ALL_URLS);
            boolean o2IsAll = o.url.equals(ALL_URLS);
            if (Objects.equals(o1IsAll, o2IsAll)) {
                return this.name.compareToIgnoreCase(o.name);
            }
            if (o1IsAll) {
                return -1;
            }
            return 1;
        }
    }

    private final class HistoryTableModel
    extends AbstractTableModel {
        private List<SQLHistoryEntry> sqlList;
        private List<String> jdbcURLs = new ArrayList<String>();
        private SQLHistoryManager shm = SQLHistoryManager.getInstance();

        public HistoryTableModel() {
            this.refresh();
        }

        public void refresh() {
            this.sqlList = new ArrayList<SQLHistoryEntry>(this.shm.getSQLHistory());
            for (SQLHistoryEntry sqe : this.sqlList) {
                String url = sqe.getUrl();
                if (this.jdbcURLs.contains(url)) continue;
                this.jdbcURLs.add(url);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.sqlList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Date.class;
                }
                case 3: {
                    return SQLHistoryEntry.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.sqlList.get(row).getUrl();
                }
                case 1: {
                    return this.sqlList.get(row).getSql();
                }
                case 2: {
                    return this.sqlList.get(row).getDate();
                }
                case 3: {
                    return this.sqlList.get(row);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            throw new NotImplementedException();
        }

        public List<String> getJdbcURLs() {
            return this.jdbcURLs;
        }
    }

    private final class TableTransferHandler
    extends TransferHandler {
        private TableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            StringBuilder sb = new StringBuilder();
            for (int id : SQLHistoryPanel.this.sqlHistoryTable.getSelectedRows()) {
                int modelIndex = SQLHistoryPanel.this.sqlHistoryTable.convertRowIndexToModel(id);
                if (sb.length() != 0) {
                    sb.append(System.lineSeparator());
                }
                String sql = (String)SQLHistoryPanel.this.htm.getValueAt(modelIndex, 1);
                sb.append(sql);
                sb.append(";");
            }
            return new StringSelection(sb.toString());
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class EqualsFilter
    extends RowFilter<HistoryTableModel, Integer> {
        private String referenz;
        private int referenzColumn;

        public EqualsFilter(String referenz, int referenzColumn) {
            this.referenz = referenz;
            this.referenzColumn = referenzColumn;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends HistoryTableModel, ? extends Integer> entry) {
            return ((String)entry.getModel().getValueAt(entry.getIdentifier(), this.referenzColumn)).equals(this.referenz);
        }
    }

    private class ContainsInsensitiveFilter
    extends RowFilter<HistoryTableModel, Integer> {
        private String referenz;
        private int referenzColumn;

        public ContainsInsensitiveFilter(String referenz, int referenzColumn) {
            this.referenz = referenz.toLowerCase();
            this.referenzColumn = referenzColumn;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends HistoryTableModel, ? extends Integer> entry) {
            return ((String)entry.getModel().getValueAt(entry.getIdentifier(), this.referenzColumn)).toLowerCase().contains(this.referenz);
        }
    }
}

