/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.openide.util.ChangeSupport;

public abstract class AbstractProjectChangeAdaptor {
    final Project project;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener propChange;

    public AbstractProjectChangeAdaptor(Project project) {
        this.project = project;
        this.propChange = evt -> {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.projectChanged();
            }
        };
    }

    protected void projectChanged() {
        this.cs.fireChange();
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.cs.hasListeners()) {
            NbGradleProject.addPropertyChangeListener(this.project, this.propChange);
        }
        this.cs.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.cs.removeChangeListener(cl);
        if (!this.cs.hasListeners()) {
            NbGradleProject.removePropertyChangeListener(this.project, this.propChange);
        }
    }
}

