/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanels;
import org.netbeans.modules.php.analysis.ui.options.AnalysisOptionsPanel;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class AnalysisOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String OPTIONS_SUB_PATH = "CodeAnalysis";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/CodeAnalysis";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private AnalysisOptionsPanel analysisOptionsPanel = null;
    private List<AnalysisCategoryPanel> categoryPanels = null;
    private volatile boolean changed = false;

    public void update() {
        assert (EventQueue.isDispatchThread());
        for (AnalysisCategoryPanel panel : this.getCategoryPanels()) {
            panel.update();
        }
        this.changed = false;
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (AnalysisCategoryPanel panel : AnalysisOptionsPanelController.this.getCategoryPanels()) {
                    panel.applyChanges();
                }
                AnalysisOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        AnalysisOptionsPanel panel = this.getAnalysisOptionsPanel();
        AnalysisCategoryPanel selectedPanel = panel.getSelectedPanel();
        if (selectedPanel != null) {
            ValidationResult result = selectedPanel.getValidationResult();
            if (result.hasErrors()) {
                panel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
                return false;
            }
            if (result.hasWarnings()) {
                panel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
                return true;
            }
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void fireChanged() {
        boolean isChanged = false;
        for (AnalysisCategoryPanel panel : this.getCategoryPanels()) {
            isChanged |= panel.isChanged();
        }
        this.changed = isChanged;
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getAnalysisOptionsPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.analysis.ui.options.AnalysisOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.fireChanged();
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private AnalysisOptionsPanel getAnalysisOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.analysisOptionsPanel == null) {
            this.analysisOptionsPanel = new AnalysisOptionsPanel();
            this.analysisOptionsPanel.addChangeListener(this);
            String firstPanelName = null;
            for (AnalysisCategoryPanel panel : this.getCategoryPanels()) {
                if (firstPanelName == null) {
                    firstPanelName = panel.getCategoryName();
                }
                panel.addChangeListener(this);
                this.analysisOptionsPanel.addCategoryPanel(panel);
            }
            if (firstPanelName != null) {
                this.analysisOptionsPanel.selectCategoryPanel(firstPanelName);
            }
        }
        return this.analysisOptionsPanel;
    }

    private Collection<AnalysisCategoryPanel> getCategoryPanels() {
        assert (EventQueue.isDispatchThread());
        if (this.categoryPanels == null) {
            this.categoryPanels = new ArrayList<AnalysisCategoryPanel>(AnalysisCategoryPanels.getCategoryPanels());
            final Collator collator = Collator.getInstance();
            this.categoryPanels.sort(new Comparator<AnalysisCategoryPanel>(){

                @Override
                public int compare(AnalysisCategoryPanel o1, AnalysisCategoryPanel o2) {
                    return collator.compare(o1.getCategoryName(), o2.getCategoryName());
                }
            });
        }
        return this.categoryPanels;
    }
}

