/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.java.hints.providers.spi.PositionRefresherHelper;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.PositionRefresher;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaHintsPositionRefresher
implements PositionRefresher {
    private static final Logger LOG = Logger.getLogger(JavaHintsPositionRefresher.class.getName());

    public Map<String, List<ErrorDescription>> getErrorDescriptionsAt(Context context, Document doc) {
        Collection col = MimeLookup.getLookup((String)"text/x-java").lookupAll(PositionRefresherHelper.class);
        ArrayList refreshers = new ArrayList(col);
        Iterator it = refreshers.iterator();
        while (it.hasNext()) {
            PositionRefresherHelper h = (PositionRefresherHelper)it.next();
            if (h.upToDateCheck(context, doc)) {
                LOG.log(Level.FINE, "Not computing warnings for {0}, results are up-to-date.", h.getKey());
                it.remove();
                continue;
            }
            LOG.log(Level.FINE, "Will compute warnings for {0}, results not up-to-date.", h.getKey());
        }
        if (refreshers.isEmpty()) {
            return Collections.emptyMap();
        }
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            LOG.log(Level.FINE, "No JavaSource associated to: {0}", new Object[]{doc, doc.getProperty("stream")});
            return Collections.emptyMap();
        }
        HashMap<String, List<ErrorDescription>> eds = new HashMap<String, List<ErrorDescription>>();
        Runnable r = () -> {
            try {
                js.runUserActionTask((Task)new RefreshTask(eds, refreshers, context), true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        BaseProgressUtils.runOffEventDispatchThread((Runnable)r, (String)NbBundle.getMessage(JavaHintsPositionRefresher.class, (String)"Refresh_hints"), (AtomicBoolean)context.getCancel(), (boolean)false);
        return eds;
    }

    private class RefreshTask
    implements Task<CompilationController> {
        private final Map<String, List<ErrorDescription>> eds;
        private final List<? extends PositionRefresherHelper<?>> refreshers;
        private final Context ctx;

        public RefreshTask(Map<String, List<ErrorDescription>> eds, List<? extends PositionRefresherHelper<?>> refreshers, Context ctx) {
            this.eds = eds;
            this.refreshers = refreshers;
            this.ctx = ctx;
        }

        public void run(CompilationController controller) throws Exception {
            if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            Document doc = controller.getDocument();
            if (doc == null) {
                return;
            }
            for (PositionRefresherHelper<?> h : this.refreshers) {
                if (this.ctx.isCanceled()) {
                    return;
                }
                List<ErrorDescription> errors = h.getErrorDescriptionsAt((CompilationInfo)controller, this.ctx, doc);
                if (errors == null) continue;
                this.eds.put(h.getKey(), errors);
            }
        }
    }
}

