/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.run;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.nette.tester.run.TestCaseVo;
import org.netbeans.modules.php.nette.tester.run.TestSuiteVo;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.openide.util.Pair;

public final class TapParser {
    private static final Pattern FILE_LINE_PATTERN_1 = Pattern.compile("(?:\\# )?in (?<FILE>[^(]+)\\((?<LINE>\\d+)\\).*");
    private static final Pattern FILE_LINE_PATTERN_2 = Pattern.compile("(?<FILE>\\S+)\\s+\\:\\s+(?<LINE>\\d+)$");
    private static final String OK_PREFIX = "ok ";
    private static final String NOT_OK_PREFIX = "not ok ";
    private static final String FAILED_PREFIX = "Failed: ";
    private static final String SKIP_MARK = " #skip";
    private static final String HELLIP = "... ";
    private static final String XDEBUG_CALLSTACK = "Call Stack";
    private static final String XDEBUG_HEADER = "#  Time  Memory  Function  Location";
    private static final Pattern DIFF_LINE_PATTERN = Pattern.compile("diff \"([^\"]+)\" \"([^\"]+)\"");
    private final TestSuiteVo testSuite = new TestSuiteVo();
    private final Set<String> commentLines = new LinkedHashSet<String>();
    private TestCaseVo testCase = null;
    private int testCaseCount = 0;
    private State state = null;

    public static boolean isTestCaseStart(String line) {
        return line.startsWith(OK_PREFIX) || line.startsWith(NOT_OK_PREFIX);
    }

    @CheckForNull
    public static Pair<String, Integer> getFileLine(String line) {
        Matcher matcher = FILE_LINE_PATTERN_1.matcher(line);
        boolean success = matcher.matches();
        if (!success) {
            matcher = FILE_LINE_PATTERN_2.matcher(line);
            success = matcher.find();
        }
        if (success) {
            return Pair.of((Object)matcher.group("FILE"), (Object)Integer.valueOf(matcher.group("LINE")));
        }
        return null;
    }

    public TestSuiteVo parse(String input, long runtime) {
        for (String line : input.split("\\r?\\n|\\r")) {
            if (!this.parseLine(line.trim())) break;
        }
        this.processComments();
        this.setTimes(runtime);
        return this.testSuite;
    }

    private boolean parseLine(String line) {
        if (line.startsWith("1..")) {
            return false;
        }
        if (line.startsWith("TAP version ")) {
            return true;
        }
        if (line.startsWith(OK_PREFIX)) {
            this.processComments();
            assert (this.state == null) : this.state;
            if (this.isSkippedTest(line = line.substring(OK_PREFIX.length()))) {
                List parts = StringUtils.explode((String)line, (String)SKIP_MARK);
                this.addSuiteTest((String)parts.get(0));
                if (parts.size() > 1) {
                    this.testCase.setMessage(((String)parts.get(1)).trim());
                }
                this.testCase.setStatus(TestCase.Status.SKIPPED);
                this.testCase = null;
            } else {
                this.addSuiteTest(line);
                this.testCase.setStatus(TestCase.Status.PASSED);
                this.testCase = null;
            }
        } else if (line.startsWith(NOT_OK_PREFIX)) {
            this.processComments();
            assert (this.state == null) : this.state;
            this.state = State.NOT_OK;
            this.addSuiteTest(line.substring(NOT_OK_PREFIX.length()));
            this.testCase.setStatus(TestCase.Status.FAILED);
        } else {
            this.processComment(line);
        }
        return true;
    }

    private boolean isSkippedTest(String line) {
        assert (this.state == null) : this.state;
        return line.contains(SKIP_MARK);
    }

    private void processComment(String line) {
        assert (line.startsWith("#")) : line;
        String processedline = line.substring(1).replaceAll("<[^>]+>", " ").trim();
        if (!StringUtils.hasText((String)processedline)) {
            return;
        }
        switch (this.state) {
            case NOT_OK: {
                this.commentLines.add(processedline);
                break;
            }
            default: {
                assert (false) : "Unknown state: " + (Object)((Object)this.state);
                break;
            }
        }
    }

    private void processComments() {
        if (this.commentLines.isEmpty()) {
            return;
        }
        assert (this.testCase != null);
        ArrayList<String> lines = new ArrayList<String>(this.commentLines);
        this.commentLines.clear();
        String lineWithFileLine = null;
        while (!lines.isEmpty()) {
            int lastIndex = lines.size() - 1;
            String line = (String)lines.get(lastIndex);
            lines.remove(lastIndex);
            Pair<String, Integer> fileLine = TapParser.getFileLine(line);
            if (fileLine == null) continue;
            lineWithFileLine = line;
            this.setFileLine(fileLine);
            break;
        }
        StringBuilder message = null;
        ArrayList<String> stackTrace = new ArrayList<String>();
        boolean lineSet = false;
        while (!lines.isEmpty()) {
            String line = (String)lines.get(0);
            lines.remove(0);
            if (XDEBUG_CALLSTACK.equals(line) || XDEBUG_HEADER.equals(line)) continue;
            Pair<String, Integer> fileLine = TapParser.getFileLine(line);
            if (fileLine != null) {
                stackTrace.add(line);
                stackTrace.addAll(this.processStackTrace(lines));
                lines.clear();
                continue;
            }
            if (line.startsWith("diff \"")) {
                this.processDiff(line);
                continue;
            }
            if (message == null) {
                message = new StringBuilder(200);
            }
            if (message.length() > 0) {
                if (line.startsWith(HELLIP)) {
                    line = line.substring(HELLIP.length());
                }
                message.append(" ");
            } else if (line.startsWith(FAILED_PREFIX)) {
                line = line.substring(FAILED_PREFIX.length());
            }
            message.append(line);
        }
        if (message != null) {
            this.testCase.setMessage(message.toString());
        }
        stackTrace.add(lineWithFileLine);
        this.testCase.setStackTrace(stackTrace);
        this.state = null;
    }

    private List<String> processStackTrace(List<String> lines) {
        ArrayList<String> stackTrace = new ArrayList<String>(lines.size());
        for (String line : lines) {
            stackTrace.add(line);
        }
        return stackTrace;
    }

    private void processDiff(String line) {
        Matcher matcher = DIFF_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            assert (false) : line;
            return;
        }
        this.testCase.setDiff(new TestCase.Diff((Callable)new DiffReader(matcher.group(1)), (Callable)new DiffReader(matcher.group(2))));
    }

    private void addSuiteTest(String line) {
        String testName = line;
        this.testCase = new TestCaseVo(testName);
        this.testSuite.addTestCase(this.testCase);
        ++this.testCaseCount;
    }

    private void setFileLine(Pair<String, Integer> fileLine) {
        assert (fileLine != null);
        assert (this.testCase != null);
        String file = (String)fileLine.first();
        Integer row = (Integer)fileLine.second();
        assert (file != null) : fileLine;
        assert (row != null) : fileLine;
        this.testCase.setFile(file);
        this.testCase.setLine(row);
    }

    private void setTimes(long runtime) {
        long time = 0L;
        if (this.testCaseCount > 0) {
            time = runtime / (long)this.testCaseCount;
        }
        for (TestCaseVo kase : this.testSuite.getTestCases()) {
            kase.setTime(time);
        }
    }

    private static enum State {
        NOT_OK;

    }

    private static final class DiffReader
    implements Callable<String> {
        private final String filePath;

        public DiffReader(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public String call() throws IOException {
            return new String(Files.readAllBytes(Paths.get(this.filePath, new String[0])), StandardCharsets.UTF_8);
        }
    }
}

