/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jdk.jshell.Snippet;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

final class EmbeddingProcessor {
    private final List<Embedding> embeddings = new ArrayList<Embedding>();
    private final ConsoleModel model;
    private final Snapshot snapshot;
    private final ShellSession session;
    private final ConsoleSection inputSection;
    private final ConsoleSection modelInputSection;
    private final ConsoleContents contents;
    private StringBuilder precedingImports = new StringBuilder();
    private ConsoleSection section;
    private int snippetIndex;
    private static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String CHANGED_CLASS_DECLARATION = "class $JSHELL$";
    private static final String JSHELL_CLASS_DECLARATION = "class $JShell$";

    public EmbeddingProcessor(ShellSession session, ConsoleContents contents, Snapshot snapshot, ConsoleSection snapshotInput) {
        this.session = session;
        this.contents = contents;
        this.model = contents.getSectionModel();
        this.snapshot = snapshot;
        this.modelInputSection = this.model.getInputSection();
        this.inputSection = snapshotInput != null ? snapshotInput : this.modelInputSection;
    }

    public List<Embedding> process() {
        this.model.getSections().stream().filter(s -> s.getType().java).forEach(this::processSection);
        return this.embeddings;
    }

    private void defineEmbedding(SnippetHandle info, Rng posInfo, boolean lastSnippet) {
        int x;
        int indexOfClass;
        FileObject snipFile;
        char c;
        int te;
        String contents = info.getWrappedCode();
        String source = info.getSource();
        int s = 0;
        int e = source.length();
        e = e > s ? --e : s;
        int ts = info.getWrappedPosition(s);
        int index = source.length() - 1;
        while ((te = info.getWrappedPosition(e)) <= ts && index >= 0 && (Character.isWhitespace(c = source.charAt(index--)) || c == ';')) {
            --index;
            --e;
        }
        if (ts == -1 || te == -1) {
            this.embeddings.add(this.snapshot.create(posInfo.start, posInfo.len(), JAVA_MIME_TYPE));
            return;
        }
        boolean lengthMismatch = te - ts != e - s;
        te = Math.min(contents.length(), te + 1);
        try {
            snipFile = info.getFile();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        if (snipFile == null) {
            return;
        }
        ConsoleSection activeInput = this.inputSection;
        Object prologText = contents.substring(0, ts);
        if (info.getKind() != Snippet.Kind.IMPORT && this.precedingImports.length() > 0 && (indexOfClass = ((String)prologText).indexOf(JSHELL_CLASS_DECLARATION)) > 0) {
            prologText = ((String)prologText).substring(0, indexOfClass) + this.precedingImports.toString() + ((String)prologText).substring(indexOfClass);
        }
        prologText = ((String)prologText).replace(JSHELL_CLASS_DECLARATION, CHANGED_CLASS_DECLARATION);
        Embedding prolog = this.snapshot.create((CharSequence)prologText, JAVA_MIME_TYPE);
        Embedding epilog = this.snapshot.create((CharSequence)contents.substring(te), JAVA_MIME_TYPE);
        ArrayList<Embedding> embs = new ArrayList<Embedding>();
        embs.add(prolog);
        boolean bl = info.getKind() == Snippet.Kind.VAR;
        int endSourceDeclPos = e - s + 1;
        String insertedText = null;
        if ((lengthMismatch &= bl) && (x = contents.indexOf(59, ts)) != -1) {
            int y;
            for (y = endSourceDeclPos = x - ts; y < source.length() && info.getWrappedPosition(y) - ts == y; ++y) {
            }
            if (y == source.length()) {
                throw new IllegalStateException();
            }
            int assignPos = info.getWrappedPosition(y);
            int equal = contents.indexOf(61, assignPos);
            if (equal == -1) {
                throw new IllegalStateException();
            }
            insertedText = contents.substring(x, equal);
        }
        int sourcePos = 0;
        int l = this.snapshot.getText().length();
        Rng[] fragments = info.getFragments();
        for (int i = 0; i < fragments.length; ++i) {
            Rng r = fragments[i];
            if (r.start > l) continue;
            int fragStart = r.start;
            int fragLen = r.len();
            if (activeInput != null && activeInput.getStart() == this.section.getStart() && lastSnippet && i == fragments.length - 1) {
                fragLen = this.snapshot.getText().length() - fragStart;
            } else if (r.end > l) continue;
            if (lengthMismatch && sourcePos <= endSourceDeclPos && sourcePos + fragLen >= endSourceDeclPos) {
                int xl = endSourceDeclPos - sourcePos;
                embs.add(this.snapshot.create(fragStart, xl, JAVA_MIME_TYPE));
                sourcePos += xl;
                embs.add(this.snapshot.create((CharSequence)insertedText, JAVA_MIME_TYPE));
                if (fragLen <= xl) continue;
                embs.add(this.snapshot.create(fragStart + xl, fragLen - xl, JAVA_MIME_TYPE));
                sourcePos += fragLen - xl;
                continue;
            }
            embs.add(this.snapshot.create(fragStart, fragLen, JAVA_MIME_TYPE));
            sourcePos += fragLen;
        }
        embs.add(epilog);
        Embedding emb = Embedding.create(embs);
        this.embeddings.add(emb);
    }

    private void processSection(ConsoleSection section) {
        this.precedingImports = new StringBuilder();
        this.section = section;
        this.snippetIndex = 0;
        List<SnippetHandle> snippets = this.contents.getHandles(section);
        Rng[] ranges = section.getAllSnippetBounds();
        if (snippets == null) {
            return;
        }
        int index = 0;
        for (SnippetHandle s : snippets) {
            if (s.getKind() == Snippet.Kind.IMPORT) {
                String text = s.getSource().trim();
                this.precedingImports.append(text);
                if (!text.endsWith(";")) {
                    this.precedingImports.append(";");
                }
            }
            this.defineEmbedding(s, ranges[index++], index == snippets.size());
        }
    }
}

