/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.formatting;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.AbstractIndenter;
import org.netbeans.modules.web.indent.api.support.IndentCommand;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;

public class ExpressionLanguageIndenter
extends AbstractIndenter<ELTokenId> {
    private boolean inExression;
    private int indent = -1;

    public ExpressionLanguageIndenter(Context context) {
        super(ELTokenId.language(), context);
    }

    protected int getFormatStableStart(JoinedTokenSequence<ELTokenId> ts, int startOffset, int endOffset, AbstractIndenter.OffsetRanges rangesToIgnore) throws BadLocationException {
        ts.move(startOffset, true);
        ts.moveNext();
        return LexUtilities.getTokenSequenceStartOffset(ts);
    }

    protected List<IndentCommand> getLineIndent(IndenterContextData<ELTokenId> context, List<IndentCommand> preliminaryNextLineIndent) throws BadLocationException {
        IndentCommand ic;
        ArrayList<IndentCommand> result = new ArrayList<IndentCommand>();
        if (context.isLanguageBlockStart()) {
            this.inExression = false;
        }
        if (this.inExression) {
            ic = new IndentCommand(IndentCommand.Type.CONTINUE, context.getLineStartOffset(), this.getIndentationSize());
            if (this.indent != -1) {
                ic.setFixedIndentSize(this.indent);
            }
        } else {
            ic = new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getLineStartOffset(), this.getIndentationSize());
            this.inExression = true;
            context.getJoinedTokenSequences().move(context.getLineStartOffset());
            int lineRealFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)this.getDocument(), (int)context.getLineStartOffset());
            if (lineRealFirstNonWhite != -1 && context.getLineStartOffset() > lineRealFirstNonWhite) {
                int start = context.getLineStartOffset();
                context.getJoinedTokenSequences().move(context.getLineStartOffset());
                context.getJoinedTokenSequences().moveNext();
                Token tok = context.getJoinedTokenSequences().token();
                if (tok != null && tok.id() == ELTokenId.STRING_LITERAL && tok.text().toString().startsWith("\"")) {
                    ++start;
                }
                this.indent = start - lineRealFirstNonWhite;
            } else {
                this.indent = -1;
            }
        }
        result.add(ic);
        if (context.getNextLineStartOffset() != -1) {
            ic = context.isLanguageBlockEnd() ? new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getNextLineStartOffset(), this.getIndentationSize()) : new IndentCommand(IndentCommand.Type.CONTINUE, context.getNextLineStartOffset(), this.getIndentationSize());
            preliminaryNextLineIndent.add(ic);
        }
        return result;
    }

    protected boolean isWhiteSpaceToken(Token<ELTokenId> token) {
        return token.id() == ELTokenId.WHITESPACE || token.id() == ELTokenId.STRING_LITERAL && token.text().toString().trim().length() == 0;
    }

    protected void reset() {
        this.inExression = false;
        this.indent = -1;
    }
}

