/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.client;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.client.WebServicesClientSupportAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class WebServicesClientSupport {
    public static final String WSCLIENTUPTODATE_CLASSPATH = "wsclientuptodate.classpath";
    private WebServicesClientSupportImpl impl;
    private static final Lookup.Result<WebServicesClientSupportProvider> implementations = Lookup.getDefault().lookupResult(WebServicesClientSupportProvider.class);

    private WebServicesClientSupport(WebServicesClientSupportImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static WebServicesClientSupport getWebServicesClientSupport(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to WebServicesClientSupport.getWebServicesClientSupport(FileObject)");
        }
        for (WebServicesClientSupportProvider impl : implementations.allInstances()) {
            WebServicesClientSupport wscs = impl.findWebServicesClientSupport(f);
            if (wscs == null) continue;
            return wscs;
        }
        return null;
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor) {
        this.impl.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor);
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor, String[] wscompileFeatures) {
        this.impl.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor, wscompileFeatures);
    }

    public void addServiceClientReference(String serviceName, String fqServiceName, String relativeWsdlPath, String mappingPath, String[] portSEIInfo) {
        this.impl.addServiceClientReference(serviceName, fqServiceName, relativeWsdlPath, mappingPath, portSEIInfo);
    }

    public void removeServiceClient(String serviceName) {
        this.impl.removeServiceClient(serviceName);
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        return this.impl.getWsdlFolder(create);
    }

    public FileObject getWsdlFolder() {
        FileObject result = null;
        try {
            result = this.impl.getWsdlFolder(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public List<ClientStubDescriptor> getStubDescriptors() {
        return this.impl.getStubDescriptors();
    }

    public List getServiceClients() {
        return this.impl.getServiceClients();
    }

    public String getWsdlSource(String serviceName) {
        return this.impl.getWsdlSource(serviceName);
    }

    public void setWsdlSource(String serviceName, String wsdlSource) {
        this.impl.setWsdlSource(serviceName, wsdlSource);
    }

    public void setProxyJVMOptions(String proxyHost, String proxyPort) {
        this.impl.setProxyJVMOptions(proxyHost, proxyPort);
    }

    public String getServiceRefName(String serviceName) {
        return this.impl.getServiceRefName(serviceName);
    }

    public static boolean isBroken(Project project) {
        try {
            return WebServicesClientSupport.hasJaxRpcClient(project) && WebServicesClientSupport.getWebServicesClientSupport(project.getProjectDirectory()) == null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void showBrokenAlert(Project project) {
        ProjectInformation pi = ProjectUtils.getInformation((Project)project);
        String projectName = null;
        if (pi != null) {
            projectName = pi.getDisplayName();
        }
        NotifyDescriptor.Message alert = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServicesClientSupport.class, (String)"ERR_NoJaxrpcPluginFound", (Object)projectName), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasJaxRpcClient(Project project) throws IOException {
        boolean found = false;
        FileObject projectXml = project.getProjectDirectory().getFileObject("nbproject/project.xml");
        if (projectXml != null) {
            try (BufferedReader br = null;){
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)projectXml)), StandardCharsets.UTF_8));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("<web-service-client>")) continue;
                    found = true;
                    break;
                }
            }
        }
        return found;
    }

    static {
        WebServicesClientSupportAccessor.DEFAULT = new WebServicesClientSupportAccessor(){

            @Override
            public WebServicesClientSupport createWebServicesClientSupport(WebServicesClientSupportImpl spiWebServicesClientSupport) {
                return new WebServicesClientSupport(spiWebServicesClientSupport);
            }

            @Override
            public WebServicesClientSupportImpl getWebServicesClientSupportImpl(WebServicesClientSupport wscs) {
                return wscs == null ? null : wscs.impl;
            }
        };
    }
}

