/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkActionResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="metadata")
    private final Map<String, String> metadata;

    @Deprecated
    @ConstructorProperties(value={"identifier", "entityType", "metadata"})
    public BulkActionResource(String identifier, String entityType, Map<String, String> metadata) {
        this.identifier = identifier;
        this.entityType = entityType;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkActionResource(");
        sb.append("super=").append(super.toString());
        sb.append("identifier=").append(String.valueOf(this.identifier));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkActionResource)) {
            return false;
        }
        BulkActionResource other = (BulkActionResource)((Object)o);
        return Objects.equals(this.identifier, other.identifier) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.metadata, other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="metadata")
        private Map<String, String> metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public BulkActionResource build() {
            BulkActionResource model = new BulkActionResource(this.identifier, this.entityType, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkActionResource model) {
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

