/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.hints;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;

public final class HintsUtils {
    private static final Logger LOGGER = Logger.getLogger(HintsUtils.class.getName());

    private HintsUtils() {
    }

    public static OffsetRange createLineBounds(int caretOffset, BaseDocument doc) {
        assert (doc != null);
        OffsetRange result = OffsetRange.NONE;
        if (caretOffset != -1) {
            try {
                int lineEnd;
                int lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) : -1;
                int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) : -1;
                if (lineBegin > -1 && lineEnd != -1 && lineBegin <= lineEnd) {
                    result = new OffsetRange(lineBegin, lineEnd);
                }
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return result;
    }
}

