/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetBackupDestinationRequest
extends BmcRequest<Void> {
    private String backupDestinationId;
    private String opcRequestId;

    public String getBackupDestinationId() {
        return this.backupDestinationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().backupDestinationId(this.backupDestinationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",backupDestinationId=").append(String.valueOf(this.backupDestinationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBackupDestinationRequest)) {
            return false;
        }
        GetBackupDestinationRequest other = (GetBackupDestinationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.backupDestinationId, other.backupDestinationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.backupDestinationId == null ? 43 : this.backupDestinationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBackupDestinationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String backupDestinationId = null;
        private String opcRequestId = null;

        public Builder backupDestinationId(String backupDestinationId) {
            this.backupDestinationId = backupDestinationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBackupDestinationRequest o) {
            this.backupDestinationId(o.getBackupDestinationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBackupDestinationRequest build() {
            GetBackupDestinationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetBackupDestinationRequest buildWithoutInvocationCallback() {
            GetBackupDestinationRequest request = new GetBackupDestinationRequest();
            request.backupDestinationId = this.backupDestinationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

