/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PatchDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="patchId")
    private final String patchId;
    @JsonProperty(value="databaseSoftwareImageId")
    private final String databaseSoftwareImageId;
    @JsonProperty(value="action")
    private final Action action;

    @Deprecated
    @ConstructorProperties(value={"patchId", "databaseSoftwareImageId", "action"})
    public PatchDetails(String patchId, String databaseSoftwareImageId, Action action) {
        this.patchId = patchId;
        this.databaseSoftwareImageId = databaseSoftwareImageId;
        this.action = action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPatchId() {
        return this.patchId;
    }

    public String getDatabaseSoftwareImageId() {
        return this.databaseSoftwareImageId;
    }

    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchDetails(");
        sb.append("super=").append(super.toString());
        sb.append("patchId=").append(String.valueOf(this.patchId));
        sb.append(", databaseSoftwareImageId=").append(String.valueOf(this.databaseSoftwareImageId));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchDetails)) {
            return false;
        }
        PatchDetails other = (PatchDetails)((Object)o);
        return Objects.equals(this.patchId, other.patchId) && Objects.equals(this.databaseSoftwareImageId, other.databaseSoftwareImageId) && Objects.equals((Object)this.action, (Object)other.action) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        result = result * 59 + (this.databaseSoftwareImageId == null ? 43 : this.databaseSoftwareImageId.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Apply("APPLY"),
        Precheck("PRECHECK");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="patchId")
        private String patchId;
        @JsonProperty(value="databaseSoftwareImageId")
        private String databaseSoftwareImageId;
        @JsonProperty(value="action")
        private Action action;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            this.__explicitlySet__.add("patchId");
            return this;
        }

        public Builder databaseSoftwareImageId(String databaseSoftwareImageId) {
            this.databaseSoftwareImageId = databaseSoftwareImageId;
            this.__explicitlySet__.add("databaseSoftwareImageId");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public PatchDetails build() {
            PatchDetails model = new PatchDetails(this.patchId, this.databaseSoftwareImageId, this.action);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchDetails model) {
            if (model.wasPropertyExplicitlySet("patchId")) {
                this.patchId(model.getPatchId());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageId")) {
                this.databaseSoftwareImageId(model.getDatabaseSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            return this;
        }
    }
}

